/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.bo.UccSearchOrderConfigBO;
import com.tydic.commodity.common.ability.api.UccOnloadChannelSchedulingService;
import com.tydic.commodity.common.ability.bo.UccOnloadChannelSchedulingReqBO;
import com.tydic.commodity.common.ability.bo.UccOnloadChannelSchedulingRspBO;
import com.tydic.commodity.dao.RelChannelSearchFieldOrderMapper;
import com.tydic.commodity.dao.UccChannelMapper;
import com.tydic.commodity.dao.UccChannelSearchOrderMapper;
import com.tydic.commodity.dao.UccSearchFieldOrderMapper;
import com.tydic.commodity.po.RelChannelSearchFieldOrderPO;
import com.tydic.commodity.po.UccChannelPO;
import com.tydic.commodity.po.UccChannelSearchOrderPO;
import com.tydic.commodity.po.UccSearchFieldOrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccOnloadChannelSchedulingServiceImpl
implements UccOnloadChannelSchedulingService {
    private static final Logger log = LoggerFactory.getLogger(UccOnloadChannelSchedulingServiceImpl.class);
    @Autowired
    private UccChannelSearchOrderMapper uccChannelSearchOrderMapper;
    @Autowired
    private RelChannelSearchFieldOrderMapper relChannelSearchFieldOrderMapper;
    @Autowired
    private UccSearchFieldOrderMapper uccSearchFieldOrderMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccChannelMapper uccChannelMapper;
    @Value(value="${HR.sysTenantId:305775845729763327}")
    private Long sysTenantIdHR;

    public UccOnloadChannelSchedulingRspBO onloadScheduling(UccOnloadChannelSchedulingReqBO reqBO) {
        UccOnloadChannelSchedulingRspBO rspBO = new UccOnloadChannelSchedulingRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty((Collection)reqBO.getChannelId())) {
            this.udpateScheduling(reqBO.getChannelId(), reqBO.getSysTenantId());
        } else {
            List channelPOList = this.uccChannelMapper.queryAll();
            List<Object> channelId = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)channelPOList)) {
                channelId = channelPOList.stream().map(UccChannelPO::getChannelId).collect(Collectors.toList());
            }
            UccChannelSearchOrderPO orderPO = new UccChannelSearchOrderPO();
            orderPO.setUniversal(Integer.valueOf(1));
            orderPO.setSysTenantId(reqBO.getSysTenantId());
            UccChannelSearchOrderPO uccChannelSearchOrderPO = this.uccChannelSearchOrderMapper.getModelBy(orderPO);
            if (uccChannelSearchOrderPO != null) {
                channelId.add(uccChannelSearchOrderPO.getChannelId());
            }
            this.udpateScheduling(channelId, reqBO.getSysTenantId());
        }
        return rspBO;
    }

    public void udpateScheduling(List<Long> channelId, Long sysTenantId) {
        if (!CollectionUtils.isEmpty(channelId)) {
            for (Long each : channelId) {
                UccChannelSearchOrderPO orderPO = new UccChannelSearchOrderPO();
                orderPO.setChannelId(each);
                orderPO.setSysTenantId(sysTenantId);
                UccChannelSearchOrderPO uccChannelSearchOrderPO = this.uccChannelSearchOrderMapper.getModelBy(orderPO);
                if (uccChannelSearchOrderPO == null) {
                    this.cacheClient.delete("UCC_SKU_SEARCH_ORDER_CONFIG" + each);
                    continue;
                }
                RelChannelSearchFieldOrderPO relChannelSearchFieldOrderPO = new RelChannelSearchFieldOrderPO();
                relChannelSearchFieldOrderPO.setChannelId(each);
                relChannelSearchFieldOrderPO.setSysTenantId(sysTenantId);
                List relList = this.relChannelSearchFieldOrderMapper.getList(relChannelSearchFieldOrderPO);
                if (CollectionUtils.isEmpty((Collection)relList)) {
                    if (sysTenantId != null && !this.sysTenantIdHR.equals(sysTenantId)) {
                        this.cacheClient.delete("UCC_SKU_SEARCH_ORDER_CONFIG" + each + "_" + sysTenantId);
                        continue;
                    }
                    this.cacheClient.delete("UCC_SKU_SEARCH_ORDER_CONFIG" + each);
                    continue;
                }
                List source = relList.stream().map(RelChannelSearchFieldOrderPO::getSearchId).collect(Collectors.toList());
                List uccSearchFieldOrderPOS = this.uccSearchFieldOrderMapper.getListByIds(source, sysTenantId);
                if (CollectionUtils.isEmpty((Collection)uccSearchFieldOrderPOS)) {
                    if (sysTenantId != null && !this.sysTenantIdHR.equals(sysTenantId)) {
                        this.cacheClient.delete("UCC_SKU_SEARCH_ORDER_CONFIG" + each + "_" + sysTenantId);
                        continue;
                    }
                    this.cacheClient.delete("UCC_SKU_SEARCH_ORDER_CONFIG" + each);
                    continue;
                }
                Map<Long, String> colum = uccSearchFieldOrderPOS.stream().collect(Collectors.toMap(UccSearchFieldOrderPO::getSearchId, UccSearchFieldOrderPO::getSearchField));
                ArrayList<UccSearchOrderConfigBO> searchOrderConfigBoList = new ArrayList<UccSearchOrderConfigBO>();
                for (RelChannelSearchFieldOrderPO rel : relList) {
                    UccSearchOrderConfigBO uccSearchOrderConfigBO = new UccSearchOrderConfigBO();
                    uccSearchOrderConfigBO.setId(Long.valueOf(rel.getViewOrder().longValue()));
                    uccSearchOrderConfigBO.setType(Long.valueOf(rel.getOrder().longValue()));
                    uccSearchOrderConfigBO.setStatus(Long.valueOf(rel.getStatus().longValue()));
                    if (colum.containsKey(rel.getSearchId())) {
                        uccSearchOrderConfigBO.setColName(colum.get(rel.getSearchId()));
                    }
                    searchOrderConfigBoList.add(uccSearchOrderConfigBO);
                }
                StringBuilder sb = new StringBuilder("UCC_SKU_SEARCH_ORDER_CONFIG");
                if (uccChannelSearchOrderPO.getUniversal() != 1) {
                    if (sysTenantId != null && !this.sysTenantIdHR.equals(sysTenantId)) {
                        sb.append(each).append("_").append(sysTenantId);
                    } else {
                        sb.append(each);
                    }
                    this.cacheClient.set(sb.toString(), (Object)JSONObject.toJSONString(searchOrderConfigBoList));
                    continue;
                }
                if (sysTenantId != null && !this.sysTenantIdHR.equals(sysTenantId)) {
                    sb.append("_").append(sysTenantId);
                }
                this.cacheClient.set(sb.toString(), (Object)JSONObject.toJSONString(searchOrderConfigBoList));
            }
        }
    }
}

