/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.api.UccStatisticsSupplierSystenantRelService;
import com.tydic.commodity.common.ability.bo.UccStatisticsSupplierSystenantRelBO;
import com.tydic.commodity.common.ability.bo.UccStatisticsSupplierSystenantRelReqBO;
import com.tydic.commodity.common.ability.bo.UccStatisticsSupplierSystenantRelRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.umc.supplier.ability.api.UmcSupplierSystenantRelSaveAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupplierSystenantRelBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierSystenantRelSaveAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierSystenantRelSaveAbilityRspBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccStatisticsSupplierSystenantRelService"})
public class UccStatisticsSupplierSystenantRelServiceImpl
implements UccStatisticsSupplierSystenantRelService {
    private static final Logger log = LoggerFactory.getLogger(UccStatisticsSupplierSystenantRelServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UmcSupplierSystenantRelSaveAbilityService umcSupplierSystenantRelSaveAbilityService;

    @PostMapping(value={"dealStatistics"})
    public UccStatisticsSupplierSystenantRelRspBO dealStatistics(@RequestBody UccStatisticsSupplierSystenantRelReqBO reqBO) {
        String queryString = this.excuteEsSql();
        String result = this.searchInfo(queryString);
        List<UccStatisticsSupplierSystenantRelBO> supplierSystenantRelBOList = this.dealSearchData(result);
        if (!CollectionUtils.isEmpty(supplierSystenantRelBOList)) {
            HashSet<String> onlyOneSet = new HashSet<String>();
            ArrayList<UmcSupplierSystenantRelBO> umcSupplierSystenantRelBOList = new ArrayList<UmcSupplierSystenantRelBO>();
            for (UccStatisticsSupplierSystenantRelBO bo : supplierSystenantRelBOList) {
                if (onlyOneSet.contains(bo.getSupplierId().toString() + bo.getTenantId().toString())) continue;
                onlyOneSet.add(bo.getSupplierId().toString() + bo.getTenantId().toString());
                UmcSupplierSystenantRelBO supplierSystenantRelBO = new UmcSupplierSystenantRelBO();
                supplierSystenantRelBO.setSupplierId(bo.getSupplierId());
                supplierSystenantRelBO.setSysTenantId(bo.getTenantId());
                umcSupplierSystenantRelBOList.add(supplierSystenantRelBO);
            }
            UmcSupplierSystenantRelSaveAbilityReqBO supplierSystenantRelSaveAbilityReqBO = new UmcSupplierSystenantRelSaveAbilityReqBO();
            supplierSystenantRelSaveAbilityReqBO.setSupplierSystenantRelBOList(umcSupplierSystenantRelBOList);
            UmcSupplierSystenantRelSaveAbilityRspBO umcSupplierSystenantRelSaveAbilityRspBO = this.umcSupplierSystenantRelSaveAbilityService.saveSupplierSystenantRel(supplierSystenantRelSaveAbilityReqBO);
        }
        UccStatisticsSupplierSystenantRelRspBO rspBO = new UccStatisticsSupplierSystenantRelRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccStatisticsSupplierSystenantRelBO> dealSearchData(String result) {
        JSONArray listObject;
        JSONObject supplierTenantPairsObj;
        ArrayList<UccStatisticsSupplierSystenantRelBO> commodityModels = new ArrayList<UccStatisticsSupplierSystenantRelBO>();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        if (null != aggregationsObj && null != (supplierTenantPairsObj = (JSONObject)aggregationsObj.get((Object)"supplier_tenant_pairs")) && null != (listObject = supplierTenantPairsObj.getJSONArray("buckets")) && listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject relObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)relObj.get((Object)"key");
                UccStatisticsSupplierSystenantRelBO commodity = new UccStatisticsSupplierSystenantRelBO();
                commodity = (UccStatisticsSupplierSystenantRelBO)JSON.toJavaObject((JSON)data, UccStatisticsSupplierSystenantRelBO.class);
                commodityModels.add(commodity);
            }
        }
        return commodityModels;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private String excuteEsSql() {
        String queryString = "";
        queryString = "uccaut-prod".equals(this.esConfig.getIndexName()) ? "{\"size\":0,\"aggs\":{\"supplier_tenant_pairs\":{\"composite\":{\"size\":10000,\"sources\":[{\"supplier_id\":{\"terms\":{\"field\":\"supplier_id\"}}},{\"tenant_id\":{\"terms\":{\"field\":\"sys_tenant_id.keyword\"}}}]}}}}" : "{\"size\":0,\"aggs\":{\"supplier_tenant_pairs\":{\"composite\":{\"size\":10000,\"sources\":[{\"supplier_id\":{\"terms\":{\"field\":\"supplier_id\"}}},{\"tenant_id\":{\"terms\":{\"field\":\"sys_tenant_id\"}}}]}}}}";
        JSONObject queryJson = JSONObject.parseObject((String)queryString);
        return queryJson.toString();
    }
}

