/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.atom.api.UccSendHttpAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSendHttpAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSendHttpAtomRspBO;
import com.tydic.commodity.common.busi.api.UccCallEbsMaterialDataGovernBusiService;
import com.tydic.commodity.common.busi.bo.UccCallEbsMaterialDataGovernBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccCallEbsMaterialDataGovernBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccCallEbsMaterialDataGovernReqBO;
import com.tydic.commodity.dao.UccSyncDataFailMapper;
import com.tydic.commodity.po.UccSyncDataFailPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccCallEbsMaterialDataGovernBusiServiceImpl
implements UccCallEbsMaterialDataGovernBusiService {
    @Value(value="${GOVERN_EBS_MATERIAL_DATA_SYNC_URL}")
    private String gocernEbsMaterialDataSyncUrl;
    @Value(value="${SNYC_GOVERN_SKU_POOLNAME}")
    private String gocernEbsMaterialDataSyncName;
    @Autowired
    private UccSendHttpAtomService uccSendHttpAtomService;
    @Autowired
    private UccSyncDataFailMapper uccSyncDataFailMapper;
    private Sequence sequenceUtil = Sequence.getInstance();

    @Override
    public UccCallEbsMaterialDataGovernBusiRspBO callEbsMaterialDataGovern(UccCallEbsMaterialDataGovernBusiReqBO reqBO) {
        UccCallEbsMaterialDataGovernBusiRspBO rspBO = new UccCallEbsMaterialDataGovernBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccCallEbsMaterialDataGovernReqBO callReqBO = (UccCallEbsMaterialDataGovernReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), UccCallEbsMaterialDataGovernReqBO.class);
        String serialNo = String.valueOf(this.sequenceUtil.nextId());
        UccSendHttpAtomReqBO sendHttpAtomReqBO = new UccSendHttpAtomReqBO();
        JSONObject reqJson = new JSONObject();
        reqJson.put("serialNo", (Object)serialNo);
        reqJson.put("poolName", (Object)reqBO.getSysCode());
        reqJson.put("data", (Object)callReqBO);
        sendHttpAtomReqBO.setParams(JSONObject.toJSONString((Object)reqJson));
        sendHttpAtomReqBO.setUrl(this.gocernEbsMaterialDataSyncUrl);
        UccSendHttpAtomRspBO uccSendHttpAtomRspBO = this.uccSendHttpAtomService.sendHttpRequst(sendHttpAtomReqBO);
        String remark = "url: " + this.gocernEbsMaterialDataSyncUrl + "\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqJson) + "\n\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)uccSendHttpAtomRspBO);
        if (!"0000".equals(uccSendHttpAtomRspBO.getRespCode())) {
            this.signLog(2, UccConstants.MaterialSyncType.EBS_MATERIAL, reqBO.getMaterialId(), remark, serialNo, reqBO.getSysTenantId(), reqBO.getSysTenantName());
        } else {
            this.signLog(1, UccConstants.MaterialSyncType.EBS_MATERIAL, reqBO.getMaterialId(), remark, serialNo, reqBO.getSysTenantId(), reqBO.getSysTenantName());
        }
        return rspBO;
    }

    private void signLog(Integer status, Integer type, Long source, String remark, String serialNo, Long sysTenantId, String sysTenantName) {
        UccSyncDataFailPO uccSyncDataFailPo = new UccSyncDataFailPO();
        uccSyncDataFailPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        uccSyncDataFailPo.setSource(source);
        uccSyncDataFailPo.setStatus(status);
        uccSyncDataFailPo.setType(type);
        uccSyncDataFailPo.setUpdateTime(new Date());
        uccSyncDataFailPo.setRemark(remark);
        uccSyncDataFailPo.setSerialNo(serialNo);
        uccSyncDataFailPo.setSysTenantId(sysTenantId);
        uccSyncDataFailPo.setSysTenantName(sysTenantName);
        this.uccSyncDataFailMapper.insert(uccSyncDataFailPo);
    }
}

