/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.GovernRspBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSendHttpAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSendHttpAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSendHttpAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccSyncDataFailBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSyncDataFailBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSyncDataFailBusiRspBO;
import com.tydic.commodity.common.busi.api.UccSnycGovernSkuBusiService;
import com.tydic.commodity.common.comb.api.UccSyncGovernCommodityBindCombService;
import com.tydic.commodity.common.comb.bo.UccSnycGovernSkuCombReqBO;
import com.tydic.commodity.common.comb.bo.UccSnycGovernSkuCombRspBO;
import com.tydic.commodity.common.comb.bo.UccSyncGovernCommodityBindCombReqBO;
import com.tydic.commodity.common.comb.bo.UccSyncGovernCommodityBindCombRspBO;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSyncGovernCommodityBindCombServiceImpl
implements UccSyncGovernCommodityBindCombService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncGovernCommodityBindCombServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSnycGovernSkuBusiService uccSnycGovernSkuBusiService;
    @Autowired
    private UccSendHttpAtomService uccSendHttpAtomService;
    @Autowired
    private UccSyncDataFailBusiService uccSyncDataFailBusiService;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    private Sequence sequenceUtil = Sequence.getInstance();
    @Value(value="${SNYC_GOVERN_COMMODITY_BIND_URL:http://10.200.192.9:8080/improxy/receive/iio-receive/iio2/813828/tydicApi/vCommodityBind}")
    private String snycGovernCommodityBindUrl;
    @Value(value="${SNYC_GOVERN_SKU_POOLNAME}")
    private String snycGovernSkupoolName;
    @Resource(name="lmBatchSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmBatchSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_BATCH_SYNC_TOPIC:LM_UCC_BATCH_SYNC_TOPIC}")
    private String lmUccSyncTopic;

    @Override
    public UccSyncGovernCommodityBindCombRspBO dealSyncCommodityBind(UccSyncGovernCommodityBindCombReqBO reqBO) {
        UccSyncGovernCommodityBindCombRspBO combRspBO = new UccSyncGovernCommodityBindCombRspBO();
        combRspBO.setRespCode("0000");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reqBO.getSkuId())) {
            return combRspBO;
        }
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuId());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            List skus = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            HashMap<Long, String> expand6Map = new HashMap<Long, String>();
            List expandPos = this.uccSkuExpandMapper.querySkuExpandBySkus(skus, null);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)expandPos)) {
                for (UccSkuExpandPo expandPo : expandPos) {
                    if (StringUtils.isEmpty((Object)expandPo.getExpand6())) continue;
                    expand6Map.put(expandPo.getSkuId(), expandPo.getExpand6());
                }
            }
            if (!CollectionUtils.isEmpty(expand6Map) && !org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPos = uccSkuPos.stream().filter(a -> expand6Map.containsKey(a.getSkuId())).collect(Collectors.toList()))) {
                Map<Long, List<UccSkuPo>> groupByType = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getCommodityTypeId));
                for (Long commType : groupByType.keySet()) {
                    List<UccSkuPo> typeSkus = groupByType.get(commType);
                    UccSnycGovernSkuCombReqBO governSkuCombReqBO = new UccSnycGovernSkuCombReqBO();
                    governSkuCombReqBO.setUccSkuPos(typeSkus);
                    governSkuCombReqBO.setExpand6Map(expand6Map);
                    UccSnycGovernSkuCombRspBO governSkuCombRspBO = this.uccSnycGovernSkuBusiService.syncGovernCommodityBind(governSkuCombReqBO);
                    if (!"0000".equals(governSkuCombRspBO.getRespCode()) || governSkuCombRspBO.getSkuBO() == null) continue;
                    String serialNo = String.valueOf(this.sequenceUtil.nextId());
                    UccSendHttpAtomReqBO sendHttpAtomReqBO = new UccSendHttpAtomReqBO();
                    sendHttpAtomReqBO.setUrl(this.snycGovernCommodityBindUrl);
                    JSONObject reqJson = new JSONObject();
                    reqJson.put("serialNo", (Object)serialNo);
                    reqJson.put("poolName", (Object)this.snycGovernSkupoolName);
                    reqJson.put("data", (Object)governSkuCombRspBO.getSkuBO());
                    sendHttpAtomReqBO.setParams(JSONObject.toJSONString((Object)reqJson));
                    log.info("sendHttpAtomReqBO,{}", (Object)JSON.toJSONString((Object)sendHttpAtomReqBO));
                    UccSendHttpAtomRspBO uccSendHttpAtomRspBO = this.uccSendHttpAtomService.sendHttpRequst(sendHttpAtomReqBO);
                    log.info("uccSendHttpAtomRspBO,{}", (Object)JSON.toJSONString((Object)uccSendHttpAtomRspBO));
                    if ("0000".equals(uccSendHttpAtomRspBO.getRespCode())) {
                        GovernRspBO governRspBO = (GovernRspBO)JSONObject.parseObject((String)uccSendHttpAtomRspBO.getResult(), GovernRspBO.class);
                        if ("0000".equals(governRspBO.getRespCode()) || "1111".equals(governRspBO.getRespCode()) || "4444".equals(governRspBO.getRespCode())) continue;
                        UccSyncDataFailBusiReqBO failBusiReqBO = new UccSyncDataFailBusiReqBO();
                        failBusiReqBO.setType(Integer.valueOf(5));
                        failBusiReqBO.setSerialNo(serialNo);
                        failBusiReqBO.setSource(governSkuCombRspBO.getSkus());
                        failBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
                        failBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
                        UccSyncDataFailBusiRspBO uccSyncDataFailBusiRspBO = this.uccSyncDataFailBusiService.addRecords(failBusiReqBO);
                        if ("0000".equals(uccSyncDataFailBusiRspBO.getRespCode())) continue;
                        log.error(uccSyncDataFailBusiRspBO.getRespDesc());
                        continue;
                    }
                    UccSyncDataFailBusiReqBO failBusiReqBO = new UccSyncDataFailBusiReqBO();
                    failBusiReqBO.setType(Integer.valueOf(5));
                    failBusiReqBO.setSerialNo(serialNo);
                    failBusiReqBO.setSource(governSkuCombRspBO.getSkus());
                    failBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
                    failBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
                    UccSyncDataFailBusiRspBO uccSyncDataFailBusiRspBO = this.uccSyncDataFailBusiService.addRecords(failBusiReqBO);
                    if ("0000".equals(uccSyncDataFailBusiRspBO.getRespCode())) continue;
                    log.error(uccSyncDataFailBusiRspBO.getRespDesc());
                }
                Map<Long, List<UccSkuPo>> groupShopMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
                for (Long shopId : groupShopMap.keySet()) {
                    List<UccSkuPo> shopSku = groupShopMap.get(shopId);
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(shopSku.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
                    syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    try {
                        this.lmBatchSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, "*", JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                        throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                    }
                }
            }
        }
        return combRspBO;
    }
}

