/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccQryXcHistoryListPageAbilityService;
import com.tydic.commodity.common.ability.bo.UccQryXcHistoryListPageAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQryXcHistoryListPageAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccXcFileBO;
import com.tydic.commodity.common.ability.bo.UccXcHistoryBO;
import com.tydic.commodity.dao.UccXcHistoryMapper;
import com.tydic.commodity.po.UccXcHistoryPO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccQryXcHistoryListPageAbilityService"})
public class UccQryXcHistoryListPageAbilityServiceImpl
implements UccQryXcHistoryListPageAbilityService {
    @Autowired
    private UccXcHistoryMapper uccXcHistoryMapper;

    @PostMapping(value={"qryXcHistoryListPage"})
    public UccQryXcHistoryListPageAbilityRspBO qryXcHistoryListPage(@RequestBody UccQryXcHistoryListPageAbilityReqBO reqBO) {
        UccQryXcHistoryListPageAbilityRspBO rspBO = new UccQryXcHistoryListPageAbilityRspBO();
        ArrayList<UccXcHistoryBO> list = new ArrayList<UccXcHistoryBO>();
        if (StringUtils.isBlank((CharSequence)reqBO.getOperatorTimeStart())) {
            ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault());
            ZonedDateTime previousMonth = now.minusMonths(1L);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            reqBO.setOperatorTimeStart(previousMonth.format(formatter));
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getOperatorTimeEnd())) {
            reqBO.setOperatorTimeEnd(this.toEndOfDayString(reqBO.getOperatorTimeEnd(), "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"));
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccXcHistoryPO uccXcHistoryPo = new UccXcHistoryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccXcHistoryPo);
        List uccXcHistoryPOS = this.uccXcHistoryMapper.getListPage(uccXcHistoryPo, page);
        if (!CollectionUtils.isEmpty((Collection)uccXcHistoryPOS)) {
            for (UccXcHistoryPO uccXcHistoryPO : uccXcHistoryPOS) {
                UccXcHistoryBO uccXcHistoryBO = new UccXcHistoryBO();
                BeanUtils.copyProperties((Object)uccXcHistoryPO, (Object)uccXcHistoryBO);
                if (StringUtils.isNotBlank((CharSequence)uccXcHistoryPO.getExpand1())) {
                    List uccXcFileBOS = JSONObject.parseArray((String)uccXcHistoryPO.getExpand1(), UccXcFileBO.class);
                    uccXcHistoryBO.setFileList(uccXcFileBOS);
                }
                list.add(uccXcHistoryBO);
            }
        }
        rspBO.setRows(list);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    public String toEndOfDayString(String dateString, String inputPattern, String outputPattern) {
        LocalDateTime endOfDay = this.toEndOfDay(dateString, inputPattern);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern(outputPattern);
        return endOfDay.format(outputFormatter);
    }

    public LocalDateTime toEndOfDay(String dateString, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        LocalDate localDate = LocalDate.parse(dateString, formatter);
        return localDate.atTime(23, 59, 59);
    }
}

