/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.api.AgrQrySupListByTenantAbilityService;
import com.tydic.agreement.ability.bo.AgrQrySupListByTenantAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQrySupListByTenantAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrSupBO;
import com.tydic.commodity.common.ability.api.UccSkuPoolVendorListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuPoolVendorListQryAbilityBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolVendorListQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolVendorListQryAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolVendorNumBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.po.UccCommodityPoolPO;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.po.UccVendorPo;
import com.tydic.commodity.utils.ValidatorUtil;
import com.tydic.umc.general.ability.api.UmcOrgQryListByTypeAbilityService;
import com.tydic.umc.general.ability.bo.UmcOrgBO;
import com.tydic.umc.general.ability.bo.UmcOrgQryListByTypeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcOrgQryListByTypeAbilityRspBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPoolVendorListQryAbilityService"})
public class UccSkuPoolVendorListQryAbilityServiceImpl
implements UccSkuPoolVendorListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPoolVendorListQryAbilityServiceImpl.class);
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UmcOrgQryListByTypeAbilityService umcOrgQryListByTypeAbilityService;
    @Autowired
    private AgrQrySupListByTenantAbilityService agrQrySupListByTenantAbilityService;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Value(value="${opertionOrgId:400000000000000032}")
    private Long opertionOrgId;

    @PostMapping(value={"qrySkuPoolVendorList"})
    public UccSkuPoolVendorListQryAbilityRspBo qrySkuPoolVendorList(@RequestBody UccSkuPoolVendorListQryAbilityReqBo reqBo) {
        List<Object> vendorIds;
        UccSkuPoolVendorListQryAbilityRspBo rspBo = new UccSkuPoolVendorListQryAbilityRspBo();
        try {
            ValidatorUtil.validator((Object)reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(e.getMessage());
            return rspBo;
        }
        if (null != reqBo.getSysTenantIdWeb() && CollectionUtils.isEmpty((Collection)reqBo.getCommodityTypeIds())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        UccCommodityPoolPO uccCommodityPoolPO = this.uccCommodityPoolMapper.selectByPrimaryKey(reqBo.getPoolId());
        ArrayList<UccSkuPoolVendorListQryAbilityBo> uccSkuPoolVendorListQryAbilityBos = new ArrayList<UccSkuPoolVendorListQryAbilityBo>();
        Page page = new Page();
        if (reqBo.getSearchType() == 0) {
            if (null != reqBo.getSysTenantIdWeb()) {
                vendorIds = new ArrayList();
                UmcOrgQryListByTypeAbilityReqBO umcOrgQryListByTypeAbilityReqBO = new UmcOrgQryListByTypeAbilityReqBO();
                umcOrgQryListByTypeAbilityReqBO.setOperType(Integer.valueOf(4));
                umcOrgQryListByTypeAbilityReqBO.setPageSize(Integer.valueOf(-1));
                umcOrgQryListByTypeAbilityReqBO.setSupplierType("1");
                UmcOrgQryListByTypeAbilityRspBO umcOrgQryListByTypeAbilityRspBO = this.umcOrgQryListByTypeAbilityService.qryListByType(umcOrgQryListByTypeAbilityReqBO);
                if (!"0000".equals(umcOrgQryListByTypeAbilityRspBO.getRespCode())) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc(umcOrgQryListByTypeAbilityRspBO.getRespDesc());
                    return rspBo;
                }
                for (UmcOrgBO row : umcOrgQryListByTypeAbilityRspBO.getRows()) {
                    vendorIds.add(row.getOrgId());
                }
                vendorIds.add(this.opertionOrgId);
                AgrQrySupListByTenantAbilityReqBO agrQrySupListByTenantAbilityReqBO = new AgrQrySupListByTenantAbilityReqBO();
                agrQrySupListByTenantAbilityReqBO.setSysTenantIdWeb(reqBo.getSysTenantIdWeb());
                AgrQrySupListByTenantAbilityRspBO agrQrySupListByTenantAbilityRspBO = this.agrQrySupListByTenantAbilityService.qrySupListByTenant(agrQrySupListByTenantAbilityReqBO);
                if (!"0000".equals(agrQrySupListByTenantAbilityRspBO.getRespCode())) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc(umcOrgQryListByTypeAbilityRspBO.getRespDesc());
                    return rspBo;
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)agrQrySupListByTenantAbilityRspBO.getAgrSupBOS())) {
                    for (AgrSupBO agrSupBO : agrQrySupListByTenantAbilityRspBO.getAgrSupBOS()) {
                        boolean exists = false;
                        for (Long l : vendorIds) {
                            if (!l.equals(agrSupBO.getSupId())) continue;
                            exists = true;
                            break;
                        }
                        if (exists) continue;
                        vendorIds.add(agrSupBO.getSupId());
                    }
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBo.getVendorIds())) {
                    List newVendorIds = reqBo.getVendorIds().stream().filter(vendorIds::contains).collect(Collectors.toList());
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(newVendorIds)) {
                        UccVendorPo vendorPo = new UccVendorPo();
                        vendorPo.setVendorIds(newVendorIds);
                        List pos = this.uccVendorMapper.queryVerdor(vendorPo);
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pos)) {
                            UccSkuPoolVendorListQryAbilityBo uccSkuPoolVendorListQryAbilityBo = new UccSkuPoolVendorListQryAbilityBo();
                            uccSkuPoolVendorListQryAbilityBo.setVendorId(((UccVendorPo)pos.get(0)).getVendorId());
                            uccSkuPoolVendorListQryAbilityBo.setVendorName(((UccVendorPo)pos.get(0)).getVendorName());
                            uccSkuPoolVendorListQryAbilityBos.add(uccSkuPoolVendorListQryAbilityBo);
                        }
                    }
                } else {
                    List cnncUccVendorPOS;
                    page.setPageNo(-1);
                    UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
                    cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
                    cnncRelPoolCommodityPo.setPoolRelated(Integer.valueOf(3));
                    List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
                    List<Object> vendorIds1 = new ArrayList();
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos)) {
                        vendorIds1 = cnncRelPoolCommodityPos.stream().map(a -> a.getSource()).collect(Collectors.toList());
                    }
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(cnncUccVendorPOS = this.uccVendorMapper.qryNotInPoolVendor(page = new Page(reqBo.getPageNo(), reqBo.getPageSize()), vendorIds1, reqBo.getVendorName(), vendorIds)))) {
                        cnncUccVendorPOS.forEach(each -> {
                            UccSkuPoolVendorListQryAbilityBo uccSkuPoolVendorListQryAbilityBo = new UccSkuPoolVendorListQryAbilityBo();
                            uccSkuPoolVendorListQryAbilityBo.setVendorId(each.getVendorId());
                            uccSkuPoolVendorListQryAbilityBo.setVendorName(each.getVendorName());
                            uccSkuPoolVendorListQryAbilityBos.add(uccSkuPoolVendorListQryAbilityBo);
                        });
                    }
                }
            } else if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBo.getVendorIds())) {
                UccVendorPo vendorPo = new UccVendorPo();
                vendorPo.setVendorIds(reqBo.getVendorIds());
                List pos = this.uccVendorMapper.queryVerdor(vendorPo);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pos)) {
                    Map<String, List<UccVendorPo>> collect = pos.stream().collect(Collectors.groupingBy(UccVendorPo::getVendorName));
                    for (String vendorName : collect.keySet()) {
                        UccSkuPoolVendorListQryAbilityBo uccSkuPoolVendorListQryAbilityBo = new UccSkuPoolVendorListQryAbilityBo();
                        uccSkuPoolVendorListQryAbilityBo.setVendorId(collect.get(vendorName).get(0).getVendorId());
                        uccSkuPoolVendorListQryAbilityBo.setVendorName(collect.get(vendorName).get(0).getVendorName());
                        uccSkuPoolVendorListQryAbilityBos.add(uccSkuPoolVendorListQryAbilityBo);
                    }
                }
            } else {
                List cnncUccVendorPOS;
                page.setPageNo(-1);
                UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
                cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
                cnncRelPoolCommodityPo.setPoolRelated(Integer.valueOf(3));
                List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
                List<Object> vendorIds2 = new ArrayList();
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos)) {
                    vendorIds2 = cnncRelPoolCommodityPos.stream().map(a -> a.getSource()).collect(Collectors.toList());
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(cnncUccVendorPOS = this.uccVendorMapper.qryNotInPoolVendor(page = new Page(reqBo.getPageNo(), reqBo.getPageSize()), vendorIds2, reqBo.getVendorName(), null)))) {
                    cnncUccVendorPOS.forEach(each -> {
                        UccSkuPoolVendorListQryAbilityBo uccSkuPoolVendorListQryAbilityBo = new UccSkuPoolVendorListQryAbilityBo();
                        uccSkuPoolVendorListQryAbilityBo.setVendorId(each.getVendorId());
                        uccSkuPoolVendorListQryAbilityBo.setVendorName(each.getVendorName());
                        uccSkuPoolVendorListQryAbilityBos.add(uccSkuPoolVendorListQryAbilityBo);
                    });
                }
            }
        } else {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
            List uccSkuPoolVendorListQryAbilityBoList = new ArrayList();
            List poolVendorListQryAbilityPOS = this.uccRelPoolCommodityMapper.getVendorListByPool(page, reqBo.getPoolId(), reqBo.getVendorIds(), reqBo.getVendorName());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)poolVendorListQryAbilityPOS)) {
                uccSkuPoolVendorListQryAbilityBoList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)poolVendorListQryAbilityPOS), UccSkuPoolVendorListQryAbilityBo.class);
                uccSkuPoolVendorListQryAbilityBos.addAll(uccSkuPoolVendorListQryAbilityBoList);
            }
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPoolVendorListQryAbilityBos)) {
            BoolQueryBuilder extBoolQueryBuilder;
            String queryString;
            String result;
            vendorIds = uccSkuPoolVendorListQryAbilityBos.stream().map(a -> a.getVendorId()).collect(Collectors.toList());
            Integer isTenantSkuPool = 0;
            if (null != reqBo.getIsTenantSkuPool() && reqBo.getIsTenantSkuPool() == 1) {
                isTenantSkuPool = 1;
            }
            if (!StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(extBoolQueryBuilder = this.buildEsSql(vendorIds, uccCommodityPoolPO.getPoolType(), isTenantSkuPool), isTenantSkuPool))))) {
                List<UccSkuPoolVendorNumBO> uccSkuPoolVendorNumBOS = this.dealSearchData(result);
                Map<Long, UccSkuPoolVendorNumBO> uccSkuPoolVendorNumBOMap = uccSkuPoolVendorNumBOS.stream().collect(Collectors.toMap(UccSkuPoolVendorNumBO::getVendorId, u -> u));
                uccSkuPoolVendorListQryAbilityBos.forEach(each -> {
                    if (uccSkuPoolVendorNumBOMap.containsKey(each.getVendorId())) {
                        each.setSkuNum(((UccSkuPoolVendorNumBO)uccSkuPoolVendorNumBOMap.get(each.getVendorId())).getSkuNum());
                        each.setSpuNum(((UccSkuPoolVendorNumBO)uccSkuPoolVendorNumBOMap.get(each.getVendorId())).getSpuNum());
                    } else {
                        each.setSkuNum(Long.valueOf(0L));
                        each.setSpuNum(Long.valueOf(0L));
                    }
                });
            }
        }
        this.dealVendorId(uccSkuPoolVendorListQryAbilityBos);
        rspBo.setRows(uccSkuPoolVendorListQryAbilityBos);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<UccSkuPoolVendorNumBO> dealSearchData(String result) {
        JSONArray listObject;
        JSONObject supplierTenantPairsObj;
        ArrayList<UccSkuPoolVendorNumBO> skuPoolVendorNumBOS = new ArrayList<UccSkuPoolVendorNumBO>();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        if (null != aggregationsObj && null != (supplierTenantPairsObj = (JSONObject)aggregationsObj.get((Object)"vendors")) && null != (listObject = supplierTenantPairsObj.getJSONArray("buckets")) && listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject relObj = listObject.getJSONObject(i);
                JSONObject skuNum = (JSONObject)relObj.get((Object)"sku_num");
                JSONObject spuNum = (JSONObject)relObj.get((Object)"spu_num");
                UccSkuPoolVendorNumBO skuPoolVendorNumBO = new UccSkuPoolVendorNumBO();
                skuPoolVendorNumBO.setVendorId(relObj.getLong("key"));
                skuPoolVendorNumBO.setSkuNum(skuNum.getLong("value"));
                skuPoolVendorNumBO.setSpuNum(spuNum.getLong("value"));
                skuPoolVendorNumBOS.add(skuPoolVendorNumBO);
            }
        }
        return skuPoolVendorNumBOS;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private String excuteEsSql(BoolQueryBuilder extBoolQueryBuilder, Integer isTenantSkuPool) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)0);
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String jsr = null;
        jsr = isTenantSkuPool == 1 ? "{\"vendors\":{\"terms\":{\"field\":\"new_vendor_id\",\"size\":10000},\"aggs\":{\"sku_num\":{\"value_count\":{\"field\":\"sku_id\"}},\"spu_num\":{\"cardinality\":{\"field\":\"commodity_id\"}}}},\"total_stats\":{\"stats_bucket\":{\"buckets_path\":\"vendors>sku_num\"}}}" : "{\"vendors\":{\"terms\":{\"field\":\"vendor_id\",\"size\":10000},\"aggs\":{\"sku_num\":{\"value_count\":{\"field\":\"sku_id\"}},\"spu_num\":{\"cardinality\":{\"field\":\"commodity_id\"}}}},\"total_stats\":{\"stats_bucket\":{\"buckets_path\":\"vendors>sku_num\"}}}";
        queryJson.put("aggs", (Object)JSONObject.parseObject((String)jsr));
        return queryJson.toString();
    }

    private BoolQueryBuilder buildEsSql(List<Long> vendorIds, Integer poolType, Integer isTenantSkuPool) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (isTenantSkuPool == 1) {
            if (!CollectionUtils.isEmpty(vendorIds)) {
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"new_vendor_id", vendorIds));
            }
        } else if (!CollectionUtils.isEmpty(vendorIds)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"vendor_id", vendorIds));
        }
        if (poolType != null) {
            BoolQueryBuilder poolTypeQuery = QueryBuilders.boolQuery();
            switch (poolType) {
                case 1: {
                    poolTypeQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"hr_agreement_type", (int)1)).should((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (int)2)).minimumShouldMatch(1);
                    break;
                }
                case 2: {
                    poolTypeQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"hr_agreement_type", (int)2)).must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_sign_supplier", (int)2));
                    break;
                }
                case 3: {
                    poolTypeQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"hr_agreement_type", (int)3)).must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_sign_supplier", (int)2));
                    break;
                }
                case 4: {
                    poolTypeQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_sign_supplier", (int)1));
                    break;
                }
                case 5: {
                    poolTypeQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"hr_agreement_type", (int)1)).should((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (int)2)).minimumShouldMatch(1);
                    break;
                }
            }
            boolQuery.must((QueryBuilder)poolTypeQuery);
        }
        return boolQuery;
    }

    private void dealVendorId(List<UccSkuPoolVendorListQryAbilityBo> rows) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(rows)) {
            return;
        }
        List vendorNameList = rows.stream().map(UccSkuPoolVendorListQryAbilityBo::getVendorName).collect(Collectors.toList());
        UccVendorPo uccVendorPo = new UccVendorPo();
        uccVendorPo.setVendorNames(vendorNameList);
        List uccVendorPos = this.uccVendorMapper.queryVerdor(uccVendorPo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccVendorPos)) {
            return;
        }
        Map<String, List<UccVendorPo>> vendorNameMap = uccVendorPos.stream().collect(Collectors.groupingBy(UccVendorPo::getVendorName));
        for (UccSkuPoolVendorListQryAbilityBo each : rows) {
            if (!vendorNameMap.containsKey(each.getVendorName())) continue;
            each.setVendorIds(vendorNameMap.get(each.getVendorName()).stream().map(UccVendorPo::getVendorId).collect(Collectors.toList()));
        }
    }
}

