/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSyncSameCountSpuPoolAbilityService;
import com.tydic.commodity.common.ability.bo.UccSyncSameCountSpuPoolAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSyncSameCountSpuPoolAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSyncSameCountSpuPoolBusiService;
import com.tydic.commodity.dao.UccCommodityPoolMapper;
import com.tydic.commodity.po.UccCommodityPoolPO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSyncSameCountSpuPoolAbilityService"})
public class UccSyncSameCountSpuPoolAbilityServiceImpl
implements UccSyncSameCountSpuPoolAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncSameCountSpuPoolAbilityServiceImpl.class);
    @Autowired
    private UccCommodityPoolMapper uccCommodityPoolMapper;
    @Autowired
    private UccSyncSameCountSpuPoolBusiService uccSyncSameCountSpuPoolBusiService;
    @Resource(name="lmBatchSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmBatchSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_BATCH_SYNC_TOPIC:LM_UCC_BATCH_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;

    @PostMapping(value={"syncSameCount"})
    public UccSyncSameCountSpuPoolAbilityRspBO syncSameCount(@RequestBody UccSyncSameCountSpuPoolAbilityReqBO reqBO) {
        UccSyncSameCountSpuPoolAbilityRspBO rspBO = new UccSyncSameCountSpuPoolAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List poolPOList = this.uccCommodityPoolMapper.qrySameCountPool(reqBO.getPools());
        if (CollectionUtils.isEmpty((Collection)poolPOList)) {
            return rspBO;
        }
        for (UccCommodityPoolPO uccCommodityPoolPO : poolPOList) {
            reqBO.setPoolId(uccCommodityPoolPO.getPoolId());
            reqBO.setSameSkuCount(uccCommodityPoolPO.getSameSkuCount());
            rspBO = this.uccSyncSameCountSpuPoolBusiService.syncSameCount(reqBO);
            if (!"0000".equals(rspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)rspBO.getSkuIds())) continue;
            log.info("size:{}", (Object)rspBO.getSkuIds().size());
            List skuList = rspBO.getSkuIds();
            int groupSize = 2000;
            List skus = IntStream.range(0, skuList.size()).boxed().collect(Collectors.groupingBy(index -> index / groupSize)).values().stream().map(indices -> indices.stream().map(skuList::get).collect(Collectors.toList())).collect(Collectors.toList());
            for (List skuIds : skus) {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmBatchSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }
}

