/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.api.UccUpdateEbsMaterialChangeExcelImportAbilityService;
import com.tydic.commodity.common.ability.bo.UccEbsMaterialChangeBO;
import com.tydic.commodity.common.ability.bo.UccUpdateEbsMaterialChangeExcelImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccUpdateEbsMaterialChangeExcelImportAbilityRspBO;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEbsMaterialChangeImportMapper;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.dao.UccEbsMaterialOperationMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEbsMaterialChangeImportPO;
import com.tydic.commodity.po.UccEbsMaterialOperationPO;
import com.tydic.commodity.po.UccEbsMaterialPO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.umc.general.ability.api.UmcOrgQryListByTypeAbilityService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccUpdateEbsMaterialChangeExcelImportAbilityService"})
public class UccUpdateEbsMaterialChangeExcelImportAbilityServiceImpl
implements UccUpdateEbsMaterialChangeExcelImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdateEbsMaterialChangeExcelImportAbilityServiceImpl.class);
    @Autowired
    private UccEbsMaterialChangeImportMapper uccEbsMaterialChangeImportMapper;
    @Autowired
    private UmcOrgQryListByTypeAbilityService umcOrgQryListByTypeAbilityService;
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEbsMaterialOperationMapper uccEbsMaterialOperationMapper;
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;

    @PostMapping(value={"updateEbsMaterialChangeExcelImport"})
    public UccUpdateEbsMaterialChangeExcelImportAbilityRspBO updateEbsMaterialChangeExcelImport(@RequestBody UccUpdateEbsMaterialChangeExcelImportAbilityReqBO reqBO) {
        Long currentSbuId;
        UccUpdateEbsMaterialChangeExcelImportAbilityRspBO rspBO = new UccUpdateEbsMaterialChangeExcelImportAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.vailidate(reqBO);
        List ebsMaterialOrg = this.uccDicDictionaryMapper.selectByPCodeAndSysTenant("EBS_MATERIAL_ORG", reqBO.getSysTenantId());
        if (ebsMaterialOrg == null || ebsMaterialOrg.isEmpty()) {
            throw new ZTBusinessException("\u67e5\u8be2\u4e1a\u52a1\u5355\u4f4d\u6570\u636e\u6570\u636e\u5f02\u5e38!");
        }
        Map<String, String> allSysCodeNameMap = ebsMaterialOrg.stream().collect(Collectors.toMap(DicDictionaryPo::getCode, DicDictionaryPo::getTitle, (key1, key2) -> key1));
        Map<String, String> allSysCode = ebsMaterialOrg.stream().collect(Collectors.toMap(DicDictionaryPo::getDescrip, DicDictionaryPo::getCode, (key1, key2) -> key1));
        HashMap<String, String> permissionSysCode = new HashMap<String, String>(allSysCode);
        if (!Objects.equals(reqBO.getIsProfessionalOrgExt(), "0") && (currentSbuId = reqBO.getSbuId()) != null) {
            permissionSysCode.keySet().removeIf(key -> !key.equals(String.valueOf(currentSbuId)));
        }
        reqBO.getRows().forEach(item -> {
            this.updateItem((UccEbsMaterialChangeBO)item, reqBO);
            if (!allSysCode.containsValue(item.getSysCode())) {
                this.updateError((UccEbsMaterialChangeBO)item, item.getSysCode() + "\u4e0d\u6b63\u786e", "sysCode", reqBO);
                return;
            }
            if (!permissionSysCode.containsValue(item.getSysCode())) {
                this.updateError((UccEbsMaterialChangeBO)item, "\u65e0\u6743\u5904\u7406'" + item.getSysCode() + "'\u7269\u6599\u4fe1\u606f\u6570\u636e!", "sysCode", reqBO);
                return;
            }
            item.setSysName((String)allSysCodeNameMap.get(item.getSysCode()));
            List<UccEbsMaterialPO> ebsMaterialPOList = this.checkEbsMaterialCode(item.getSysCode(), item.getEbsMaterialCode(), reqBO.getSysTenantId());
            if (ObjectUtils.isEmpty(ebsMaterialPOList) || CollectionUtils.isEmpty(ebsMaterialPOList)) {
                this.updateError((UccEbsMaterialChangeBO)item, "\u4e1a\u52a1\u5355\u5143\u7269\u6599\u7f16\u7801\u4e0d\u6b63\u786e!", "ebsMaterialCode", reqBO);
                return;
            }
            UccEbsMaterialPO uccEbsMaterialPO = ebsMaterialPOList.get(0);
            item.setEbsMaterialName(uccEbsMaterialPO.getEbsMaterialName());
            this.updateItem((UccEbsMaterialChangeBO)item, reqBO);
            if (!StringUtils.isEmpty((Object)item.getMaterialCode())) {
                UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByMaterialCode(item.getMaterialCode());
                if (ObjectUtils.isEmpty((Object)uccEMdmMaterialPO)) {
                    this.updateError((UccEbsMaterialChangeBO)item, "\u5173\u8054\u7269\u6599\u7f16\u7801\u4e0d\u6b63\u786e", "materialCode", reqBO);
                    return;
                }
                item.setMaterialName(uccEMdmMaterialPO.getMaterialName());
                this.updateItem((UccEbsMaterialChangeBO)item, reqBO);
            }
            log.info("\u6821\u9a8c\u5b8c\u6210\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)item));
            this.updateSuccess((UccEbsMaterialChangeBO)item, reqBO);
        });
        return rspBO;
    }

    private void updateItem(UccEbsMaterialChangeBO item, UccUpdateEbsMaterialChangeExcelImportAbilityReqBO reqBO) {
        UccEbsMaterialChangeImportPO where = new UccEbsMaterialChangeImportPO();
        where.setId(item.getId());
        where.setSysTenantId(reqBO.getSysTenantId());
        UccEbsMaterialChangeImportPO set = (UccEbsMaterialChangeImportPO)JUtil.js((Object)item, UccEbsMaterialChangeImportPO.class);
        this.uccEbsMaterialChangeImportMapper.updateBy(set, where);
    }

    private void updateSuccess(UccEbsMaterialChangeBO item, UccUpdateEbsMaterialChangeExcelImportAbilityReqBO reqBO) {
        UccEbsMaterialChangeImportPO where = new UccEbsMaterialChangeImportPO();
        where.setId(item.getId());
        where.setSysTenantId(reqBO.getSysTenantId());
        UccEbsMaterialChangeImportPO set = (UccEbsMaterialChangeImportPO)JUtil.js((Object)item, UccEbsMaterialChangeImportPO.class);
        set.setFailReason("\u6210\u529f");
        set.setStatus(Integer.valueOf(1));
        set.setUpdateLoginId(reqBO.getUserId());
        set.setUpdateTime(new Date());
        set.setUpdateLoginName(reqBO.getName());
        set.setErrorParam("");
        set.setCleanErrorParam(Integer.valueOf(1));
        this.uccEbsMaterialChangeImportMapper.updateBy(set, where);
    }

    private void ebsMaterialOperLogAdd(UccEbsMaterialOperationPO operationPO) {
        operationPO.setOperationId(Long.valueOf(Sequence.getInstance().nextId()));
        try {
            this.uccEbsMaterialOperationMapper.insert(operationPO);
        }
        catch (Exception e) {
            log.error("EBS\u7269\u6599\u6620\u5c04\u64cd\u4f5c\u65e5\u5fd7\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void updateError(UccEbsMaterialChangeBO item, String failReason, String errorParam, UccUpdateEbsMaterialChangeExcelImportAbilityReqBO reqBO) {
        UccEbsMaterialChangeImportPO where = new UccEbsMaterialChangeImportPO();
        where.setId(item.getId());
        where.setSysTenantId(reqBO.getSysTenantId());
        UccEbsMaterialChangeImportPO set = new UccEbsMaterialChangeImportPO();
        set.setFailReason(failReason);
        set.setStatus(Integer.valueOf(0));
        set.setUpdateLoginId(reqBO.getUserId());
        set.setUpdateTime(new Date());
        set.setUpdateLoginName(reqBO.getName());
        set.setErrorParam(errorParam);
        this.uccEbsMaterialChangeImportMapper.updateBy(set, where);
    }

    private List<UccEbsMaterialPO> checkEbsMaterialCode(String sysCode, String ebsMaterialCode, Long sysTenantId) {
        return this.uccEbsMaterialMapper.selectByMaterialCodeAndTenantId(sysCode, ebsMaterialCode, sysTenantId);
    }

    private void vailidate(UccUpdateEbsMaterialChangeExcelImportAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getRows() == null || reqBO.getRows().isEmpty()) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getRows().stream().findAny().ifPresent(item -> {
            if (item.getId() == null) {
                throw new ZTBusinessException("\u53c2\u6570Id\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        reqBO.getRows().stream().findAny().ifPresent(item -> {
            if (item.getSysCode() == null) {
                throw new ZTBusinessException("\u53c2\u6570\u4e1a\u52a1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        reqBO.getRows().stream().findAny().ifPresent(item -> {
            if (item.getEbsMaterialCode() == null) {
                throw new ZTBusinessException("\u53c2\u6570\u4e1a\u52a1\u5355\u4f4d\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        reqBO.getRows().stream().findAny().ifPresent(item -> {
            if (item.getEbsMaterialName() == null) {
                throw new ZTBusinessException("\u53c2\u6570\u4e1a\u52a1\u5355\u4f4d\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

