/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.busibase.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccEbsMaterialListQryBusiService;
import com.tydic.commodity.common.busi.bo.UccEbsMaterialBO;
import com.tydic.commodity.common.busi.bo.UccEbsMaterialListQryBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccEbsMaterialListQryBusiRspBO;
import com.tydic.commodity.dao.UccEbsMaterialMapper;
import com.tydic.commodity.po.UccEbsMaterialPO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UccEbsMaterialListQryBusiServiceImpl
implements UccEbsMaterialListQryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccEbsMaterialListQryBusiServiceImpl.class);
    @Autowired
    private UccEbsMaterialMapper uccEbsMaterialMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @Override
    public UccEbsMaterialListQryBusiRspBO ebsMaterialQryList(UccEbsMaterialListQryBusiReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccEbsMaterialPO uccEbsMaterialPO = new UccEbsMaterialPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccEbsMaterialPO);
        uccEbsMaterialPO.setOrderBy("e.EBS_INVALID,e.CREATE_TIME DESC");
        log.info("\u67e5\u8be2\u7269\u6599\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)uccEbsMaterialPO));
        int count = 0;
        count = reqBO.getRelationStatus() == null ? this.uccEbsMaterialMapper.getListPageRuleCount(uccEbsMaterialPO) : (0 == reqBO.getRelationStatus() ? this.uccEbsMaterialMapper.getListPageRuleCount(uccEbsMaterialPO) : this.uccEbsMaterialMapper.getListPageRuleRelationCount(uccEbsMaterialPO));
        if (reqBO.getPageNo() < 0) {
            uccEbsMaterialPO.setSize(10000);
            uccEbsMaterialPO.setStart(0);
        } else {
            uccEbsMaterialPO.setSize(reqBO.getPageSize());
            uccEbsMaterialPO.setStart((reqBO.getPageNo() - 1) * reqBO.getPageSize());
        }
        List uccEbsMaterialPOList = this.uccEbsMaterialMapper.getListPageRuleOrderBy(uccEbsMaterialPO);
        List ebsMaterialBOS = JSON.parseArray((String)JSON.toJSONString((Object)uccEbsMaterialPOList), UccEbsMaterialBO.class);
        if (!ObjectUtils.isEmpty((Object)ebsMaterialBOS)) {
            Map operationTypeDict = this.uccDictionaryAtomService.queryBypCodeBackMap("EBS_MATERIAL_INVALID");
            Map orgDict = this.uccDictionaryAtomService.queryBypCodeBackMap("EBS_MATERIAL_ORG");
            Map skuStatusDict = this.uccDictionaryAtomService.queryBypCodeBackMap("SKU_STATUS");
            Map limitOrderDict = this.uccDictionaryAtomService.queryBypCodeBackMap("LIMIT_ORDER");
            Map materialTypeDict = this.uccDictionaryAtomService.queryBypCodeBackMap("MATERIAL_TYPE");
            Map isIndividualOrderDict = this.uccDictionaryAtomService.queryBypCodeBackMap("IS_INDIVIDUAL_ORDER");
            ebsMaterialBOS.forEach(item -> {
                item.setEbsInvalidStr(ObjectUtils.isEmpty(operationTypeDict.get(item.getEbsInvalid())) ? "" : (String)operationTypeDict.get(item.getEbsInvalid()));
                if (!ObjectUtils.isEmpty((Object)item.getSkuStatus())) {
                    item.setSkuStatusStr(ObjectUtils.isEmpty(skuStatusDict.get(item.getSkuStatus().toString())) ? "" : (String)skuStatusDict.get(item.getSkuStatus().toString()));
                }
                if (!ObjectUtils.isEmpty((Object)item.getLimitOrder())) {
                    item.setLimitOrderStr(ObjectUtils.isEmpty(limitOrderDict.get(item.getLimitOrder().toString())) ? "" : (String)limitOrderDict.get(item.getLimitOrder().toString()));
                }
                item.setSysCodeStr(ObjectUtils.isEmpty(orgDict.get(item.getSysCode())) ? "" : (String)orgDict.get(item.getSysCode()));
                if (!ObjectUtils.isEmpty((Object)item.getMaterialType())) {
                    item.setMaterialTypeStr(ObjectUtils.isEmpty(materialTypeDict.get(item.getMaterialType().toString())) ? "" : (String)materialTypeDict.get(item.getMaterialType().toString()));
                }
                if (!ObjectUtils.isEmpty((Object)item.getIsIndividualOrder())) {
                    item.setIsIndividualOrderStr(ObjectUtils.isEmpty(isIndividualOrderDict.get(item.getIsIndividualOrder().toString())) ? "" : (String)isIndividualOrderDict.get(item.getIsIndividualOrder().toString()));
                }
            });
        }
        UccEbsMaterialListQryBusiRspBO rspBO = new UccEbsMaterialListQryBusiRspBO();
        rspBO.setRows(ebsMaterialBOS);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(count);
        rspBO.setTotal(count % reqBO.getPageSize() == 0 ? count / reqBO.getPageSize() : count / reqBO.getPageSize() + 1);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

