/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.estore.atom.api.UccApplyAddGoodsInterService;
import com.tydic.commodity.estore.atom.bo.UccApplyAddGoodsReqBO;
import com.tydic.commodity.estore.atom.bo.UccApplyAddGoodsRspBO;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import com.tydic.commodity.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccApplyAddGoodsInterServiceImpl
implements UccApplyAddGoodsInterService {
    private static final Logger log = LoggerFactory.getLogger(UccApplyAddGoodsInterServiceImpl.class);

    @Override
    public UccApplyAddGoodsRspBO applyAddGoods(UccApplyAddGoodsReqBO reqBo) {
        UccApplyAddGoodsRspBO rspBo = new UccApplyAddGoodsRspBO();
        try {
            String reqStr = this.initReqStr(reqBo);
            String reqEsbStr = ESBParamUtil.getEsbReqStr((String)reqStr, (String)reqBo.getSupplierCode(), (String)"BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(PropertiesUtil.getProperty((String)"ESP_APPLY_ADD_GOODS_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty((String)"ESP_APPLY_ADD_GOODS_URL") + "]");
                throw new RuntimeException("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1\u5931\u8d25");
            }
            log.info("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccApplyAddGoodsRspBO resolveRsp = this.resolveRsp(returnString);
            log.info("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + (Object)((Object)resolveRsp));
            return resolveRsp;
        }
        catch (Exception var9) {
            log.error("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + var9);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return rspBo;
        }
    }

    private String initReqStr(UccApplyAddGoodsReqBO reqBo) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)reqBo));
        jsonObject.remove((Object)"supplierCode");
        return JSON.toJSONString((Object)jsonObject);
    }

    private UccApplyAddGoodsRspBO resolveRsp(String returnString) {
        UccApplyAddGoodsRspBO rspBo = new UccApplyAddGoodsRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBo.setSuccess(rspJsonObject.getBooleanValue("success"));
            rspBo.setResultCode(rspJsonObject.getString("resultCode"));
            rspBo.setResultMessage(rspJsonObject.getString("resultMessage"));
            if (rspBo.isSuccess() && "0000".equals(rspBo.getResultCode())) {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
            } else {
                rspBo.setResultCode("8888");
                rspBo.setRespDesc(rspBo.getResultMessage());
            }
            return rspBo;
        }
        catch (Exception var10) {
            log.error("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

