/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccDefaultCoefficientMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.busi.api.UccAddSkuPriceSyncBusiService;
import com.tydic.commodity.estore.busi.bo.UccAddSkuPriceSyncReqBO;
import com.tydic.commodity.estore.busi.bo.UccAddSkuPriceSyncRspBO;
import com.tydic.commodity.po.UccAddCoefficientPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccDefaultCoefficientPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPriceLogPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAddSkuPriceSyncBusiServiceImpl
implements UccAddSkuPriceSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAddSkuPriceSyncBusiServiceImpl.class);
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccDefaultCoefficientMapper uccDefaultCoefficientMapper;

    @Override
    public UccAddSkuPriceSyncRspBO dealSyncPrice(UccAddSkuPriceSyncReqBO reqBO) {
        UccAddSkuPriceSyncRspBO rspBO = new UccAddSkuPriceSyncRspBO();
        rspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getSkuList())) {
            return rspBO;
        }
        if (reqBO.getOperType() == 1) {
            List uccSkuExpandPoList = this.uccSkuExpandMapper.querySkuExpandBySkus(reqBO.getSkuList(), Integer.valueOf(1));
            if (!CollectionUtils.isEmpty((Collection)uccSkuExpandPoList)) {
                List ignoreList = uccSkuExpandPoList.stream().map(UccSkuExpandPo::getSkuId).collect(Collectors.toList());
                reqBO.getSkuList().removeAll(ignoreList);
            }
            if (CollectionUtils.isEmpty(reqBO.getSkuList())) {
                return rspBO;
            }
            List uccSkuAddCoefficientPOList = this.uccSkuAddCoefficientMapper.selectBySkuIds(reqBO.getSkuList());
            if (CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOList)) {
                return rspBO;
            }
            List uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuList(), null);
            if (CollectionUtils.isEmpty((Collection)uccSkuPricePos)) {
                return rspBO;
            }
            Map skuAddCoefficientPOMap = uccSkuAddCoefficientPOList.stream().collect(Collectors.toMap(UccSkuAddCoefficientPO::getSkuId, Function.identity()));
            List uccSkuPriceLogPos = JSONObject.parseArray((String)JSON.toJSONString((Object)uccSkuPricePos), UccSkuPriceLogPo.class);
            for (Object each : uccSkuPricePos) {
                Long salePrice = null;
                if (!skuAddCoefficientPOMap.containsKey(each.getSkuId())) continue;
                if (((UccSkuAddCoefficientPO)skuAddCoefficientPOMap.get(each.getSkuId())).getRule() == 1 && ((UccSkuAddCoefficientPO)skuAddCoefficientPOMap.get(each.getSkuId())).getAddCoefficient() != null) {
                    BigDecimal bigDecimal = new BigDecimal("1").add(((UccSkuAddCoefficientPO)skuAddCoefficientPOMap.get(each.getSkuId())).getAddCoefficient().divide(new BigDecimal("100"), 6, 5));
                    salePrice = MoneyUtils.yuanToHaoToLongObj((BigDecimal)MoneyUtils.haoToYuan((Long)each.getAgreementPrice()).multiply(bigDecimal).setScale(2, 0));
                } else if (((UccSkuAddCoefficientPO)skuAddCoefficientPOMap.get(each.getSkuId())).getRule() == 2 && ((UccSkuAddCoefficientPO)skuAddCoefficientPOMap.get(each.getSkuId())).getAddPrice() != null) {
                    BigDecimal bigDecimal = ((UccSkuAddCoefficientPO)skuAddCoefficientPOMap.get(each.getSkuId())).getAddPrice().setScale(4);
                    salePrice = each.getAgreementPrice() + MoneyUtils.yuanToHaoToLongObj((BigDecimal)bigDecimal);
                }
                if (((UccSkuAddCoefficientPO)skuAddCoefficientPOMap.get(each.getSkuId())).getAllowMarketPrice() != null && ((UccSkuAddCoefficientPO)skuAddCoefficientPOMap.get(each.getSkuId())).getAllowMarketPrice() == 0 && salePrice.compareTo(each.getMarketPrice()) > 0) {
                    salePrice = each.getMarketPrice();
                }
                each.setSalePrice(salePrice);
            }
            try {
                this.uccSkuPriceMapper.batchUpdateSalePriceByprimary(uccSkuPricePos);
                this.uccSkuMapper.batchUpdateSkuPriceByprimary(uccSkuPricePos);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u5355\u54c1\u4ef7\u683c\u5f02\u5e38\uff1a " + e.getMessage());
            }
            Long barchId = this.sequence.nextId();
            for (UccSkuPriceLogPo each : uccSkuPriceLogPos) {
                each.setBatchId(barchId);
            }
            try {
                this.uccSkuPriceLogMapper.batchInsert(uccSkuPriceLogPos);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u5355\u54c1\u4ef7\u683c\u65e5\u5fd7\u8868\u5f02\u5e38\uff1a " + e.getMessage());
            }
        } else if (0 == reqBO.getOperType()) {
            List uccSkuExpandPoList = this.uccSkuExpandMapper.querySkuExpandBySkus(reqBO.getSkuList(), Integer.valueOf(1));
            if (!CollectionUtils.isEmpty((Collection)uccSkuExpandPoList)) {
                List ignoreList = uccSkuExpandPoList.stream().map(UccSkuExpandPo::getSkuId).collect(Collectors.toList());
                reqBO.getSkuList().removeAll(ignoreList);
            }
            if (CollectionUtils.isEmpty(reqBO.getSkuList())) {
                return rspBO;
            }
            List uccSkuPoList = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuList());
            List uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuList(), null);
            List typeIds = uccSkuPoList.stream().map(UccSkuPo::getCommodityTypeId).collect(Collectors.toList());
            List uccCommodityTypePoList = this.uccCommodityTypeMapper.queryPoByCommodityTypeIds(typeIds);
            List uccSkuPriceLogPos = JSONObject.parseArray((String)JSON.toJSONString((Object)uccSkuPricePos), UccSkuPriceLogPo.class);
            if (CollectionUtils.isEmpty((Collection)uccSkuPoList) || CollectionUtils.isEmpty((Collection)uccSkuPricePos) || CollectionUtils.isEmpty((Collection)uccCommodityTypePoList)) {
                return rspBO;
            }
            this.setCatalogId(uccSkuPoList, uccSkuPricePos, uccCommodityTypePoList);
            Map<Long, List<UccSkuPricePo>> vendorSkuListMap = uccSkuPricePos.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSupplierShopId));
            if (!vendorSkuListMap.isEmpty()) {
                for (Long l : vendorSkuListMap.keySet()) {
                    BigDecimal addPrice;
                    BigDecimal coefficient;
                    List catalogIds = vendorSkuListMap.get(l).stream().map(UccSkuPricePo::getCatalogId).collect(Collectors.toList());
                    List uccAddCoefficientPOList = this.uccAddCoefficientMapper.qryCoefficientByCatalogIds(catalogIds, l);
                    if (!CollectionUtils.isEmpty((Collection)uccAddCoefficientPOList)) {
                        Map addType = uccAddCoefficientPOList.stream().collect(Collectors.toMap(UccAddCoefficientPO::getCatalogId, Function.identity(), (key1, key2) -> key1));
                        Set<Long> typeSet = addType.keySet();
                        List typeAdd = vendorSkuListMap.get(l).stream().filter(a -> typeSet.contains(a.getCatalogId())).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(typeAdd)) {
                            Long salePrice = null;
                            for (UccSkuPricePo skuType : typeAdd) {
                                if (((UccAddCoefficientPO)addType.get(skuType.getCatalogId())).getRule() == 1 && ((UccAddCoefficientPO)addType.get(skuType.getCatalogId())).getAddCoefficient() != null) {
                                    coefficient = new BigDecimal("1").add(((UccAddCoefficientPO)addType.get(skuType.getCatalogId())).getAddCoefficient().divide(new BigDecimal("100"), 6, 5));
                                    salePrice = MoneyUtils.yuanToHaoToLongObj((BigDecimal)MoneyUtils.haoToYuan((Long)skuType.getAgreementPrice()).multiply(coefficient).setScale(2, 0));
                                } else if (((UccAddCoefficientPO)addType.get(skuType.getCatalogId())).getRule() == 2 && ((UccAddCoefficientPO)addType.get(skuType.getCatalogId())).getAddPrice() != null) {
                                    addPrice = ((UccAddCoefficientPO)addType.get(skuType.getCatalogId())).getAddPrice().setScale(4);
                                    salePrice = skuType.getAgreementPrice() + MoneyUtils.yuanToHaoToLongObj((BigDecimal)addPrice);
                                }
                                if (((UccAddCoefficientPO)addType.get(skuType.getCatalogId())).getAllowMarketPrice() != null && ((UccAddCoefficientPO)addType.get(skuType.getCatalogId())).getAllowMarketPrice() == 0 && salePrice.compareTo(skuType.getMarketPrice()) > 0) {
                                    salePrice = skuType.getMarketPrice();
                                }
                                skuType.setSalePrice(salePrice);
                            }
                            vendorSkuListMap.get(l).removeAll(typeAdd);
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)vendorSkuListMap.get(l))) continue;
                    UccDefaultCoefficientPO defaultCoefficientPO = new UccDefaultCoefficientPO();
                    defaultCoefficientPO.setSupplierId(l);
                    List poList = this.uccDefaultCoefficientMapper.getList(defaultCoefficientPO);
                    if (CollectionUtils.isEmpty((Collection)poList)) continue;
                    Integer rule = ((UccDefaultCoefficientPO)poList.get(0)).getRule();
                    for (UccSkuPricePo skuType : vendorSkuListMap.get(l)) {
                        Long salePrice = null;
                        if (1 == rule && ((UccDefaultCoefficientPO)poList.get(0)).getAddCoefficient() != null) {
                            coefficient = new BigDecimal("1").add(((UccDefaultCoefficientPO)poList.get(0)).getAddCoefficient().divide(new BigDecimal("100"), 6, 5));
                            salePrice = MoneyUtils.yuanToHaoToLongObj((BigDecimal)MoneyUtils.haoToYuan((Long)skuType.getAgreementPrice()).multiply(coefficient).setScale(2, 0));
                        }
                        if (2 == rule && ((UccDefaultCoefficientPO)poList.get(0)).getAddPrice() != null) {
                            addPrice = ((UccDefaultCoefficientPO)poList.get(0)).getAddPrice().setScale(4);
                            salePrice = skuType.getAgreementPrice() + MoneyUtils.yuanToHaoToLongObj((BigDecimal)addPrice);
                        }
                        if (((UccDefaultCoefficientPO)poList.get(0)).getAllowMarketPrice() != null && ((UccDefaultCoefficientPO)poList.get(0)).getAllowMarketPrice() == 0 && salePrice.compareTo(skuType.getMarketPrice()) > 0) {
                            salePrice = skuType.getMarketPrice();
                        }
                        if (salePrice == null) continue;
                        skuType.setSalePrice(salePrice);
                    }
                }
            }
            try {
                this.uccSkuPriceMapper.batchUpdateSalePriceByprimary(uccSkuPricePos);
                this.uccSkuMapper.batchUpdateSkuPriceByprimary(uccSkuPricePos);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u5355\u54c1\u4ef7\u683c\u5f02\u5e38\uff1a " + e.getMessage());
            }
            Long barchId = this.sequence.nextId();
            for (UccSkuPriceLogPo each : uccSkuPriceLogPos) {
                each.setBatchId(barchId);
            }
            try {
                this.uccSkuPriceLogMapper.batchInsert(uccSkuPriceLogPos);
            }
            catch (Exception exception) {
                log.error("\u66f4\u65b0\u5355\u54c1\u4ef7\u683c\u65e5\u5fd7\u8868\u5f02\u5e38\uff1a " + exception.getMessage());
            }
        }
        return rspBO;
    }

    private void setCatalogId(List<UccSkuPo> uccSkuPoList, List<UccSkuPricePo> uccSkuPricePos, List<UccCommodityTypePo> uccCommodityTypePoList) {
        Map<Long, Long> catalogMap = uccCommodityTypePoList.stream().collect(Collectors.toMap(UccCommodityTypePo::getCommodityTypeId, UccCommodityTypePo::getCatalogId, (key1, key2) -> key1));
        Map<Long, Long> skuMap = uccSkuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getCommodityTypeId, (key1, key2) -> key1));
        for (UccSkuPricePo each : uccSkuPricePos) {
            each.setCatalogId(catalogMap.get(skuMap.get(each.getSkuId())));
        }
    }
}

