/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.estore.busi.api.UccMqSyncCommdPriceBusiService;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceReqBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceRspBo;
import com.tydic.commodity.estore.comb.api.UccMqSyncCommdPriceCombService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMqSyncCommdPriceCombServiceImpl
implements UccMqSyncCommdPriceCombService {
    private static final Logger log = LoggerFactory.getLogger(UccMqSyncCommdPriceCombServiceImpl.class);
    @Autowired
    private UccMqSyncCommdPriceBusiService uccMqSyncCommdPriceBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="syncCommercePriceChangeProvider")
    private ProxyMessageProducer syncCommercePriceChangeProvider;
    @Resource(name="uccSyncGovernPriceMqProvider")
    private ProxyMessageProducer uccSyncGovernPriceMqProvider;
    @Value(value="${SYNC_GOVERN_PRICE_TOPIC:SYNC_GOVERN_PRICE_TOPIC}")
    private String syncGovernPriceTopic;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String lmUccSyncTopic;
    @Value(value="${COMMERCE_PRICE_UCC_SYNC_TOPIC}")
    private String commercePriceSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;

    @Override
    public MqSyncCommdPriceRspBo dealSync(MqSyncCommdPriceReqBo mqSyncCommdPriceReqBo) throws ZTBusinessException {
        MqSyncCommdPriceRspBo rspBo = this.uccMqSyncCommdPriceBusiService.dealSync(mqSyncCommdPriceReqBo);
        if ("0000".equals(rspBo.getRespCode()) && !CollectionUtils.isEmpty(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList())) {
            HashMap<Long, List> sendMq = new HashMap<Long, List>();
            for (MqSyncCommdPriceBo each : mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList()) {
                if (sendMq.containsKey(each.getSupplierShopId())) {
                    ((List)sendMq.get(each.getSupplierShopId())).add(each.getSkuId());
                    continue;
                }
                ArrayList<Long> senSkuList = new ArrayList<Long>();
                senSkuList.add(each.getSkuId());
                sendMq.put(each.getSupplierShopId(), senSkuList);
            }
            sendMq.forEach((t, u) -> {
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds(u);
                syncSceneCommodityToEsReqBO.setSupplierId(t);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001MQ\u6570\u636e" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO) + "\u5f02\u5e38\uff1a{}" + e.getMessage());
                    e.printStackTrace();
                }
            });
            JSONObject syncPric = new JSONObject();
            try {
                syncPric.put("skuList", mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList().stream().map(MqSyncCommdPriceBo::getSkuId).collect(Collectors.toList()));
                this.syncCommercePriceChangeProvider.send(new ProxyMessage(this.commercePriceSyncTopic, "*", JSON.toJSONString((Object)syncPric)));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001MQ\u6570\u636e" + JSON.toJSONString((Object)syncPric) + "\u5f02\u5e38\uff1a{}" + e.getMessage());
                e.printStackTrace();
            }
            for (MqSyncCommdPriceBo each : mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList()) {
                if (each.getAgreementPrice().compareTo(each.getOldAgreementPrice()) == 0) continue;
                JSONObject syncCoovern = new JSONObject();
                try {
                    syncCoovern.put("skuId", (Object)each.getSkuId());
                    this.uccSyncGovernPriceMqProvider.send(new ProxyMessage(this.syncGovernPriceTopic, "*", JSON.toJSONString((Object)syncCoovern)));
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001MQ\u6570\u636e" + JSON.toJSONString((Object)syncCoovern) + "\u5f02\u5e38\uff1a{}" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return rspBo;
    }
}

