/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccMsgPoolRunMapper;
import com.tydic.commodity.dao.XextSkuChangeMapper;
import com.tydic.commodity.estore.busi.api.UccExecuteEcommerceMsgService;
import com.tydic.commodity.estore.busi.bo.UccExecuteEcommerceMsgReqBo;
import com.tydic.commodity.estore.busi.bo.UccExecuteEcommerceMsgRspBo;
import com.tydic.commodity.po.UccMsgPoolRunPO;
import com.tydic.commodity.po.XextSkuChangePo;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccExecuteEcommerceMsgServiceImpl
implements UccExecuteEcommerceMsgService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccExecuteEcommerceMsgServiceImpl.class);
    @Autowired
    private XextSkuChangeMapper xextSkuChangeMapper;
    private Sequence uccExtSkuSequence = Sequence.getInstance();
    @Autowired
    private UccMsgPoolRunMapper uccMsgPoolRunMapper;
    @Value(value="${MSG_POOL_SUPPLIER:''}")
    private String suppliers;

    @Override
    public UccExecuteEcommerceMsgRspBo executeMsg(UccExecuteEcommerceMsgReqBo reqBo) {
        UccExecuteEcommerceMsgRspBo rspBo = new UccExecuteEcommerceMsgRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        XextSkuChangePo xextSkuChangePo = new XextSkuChangePo();
        xextSkuChangePo.setExtSkuId(reqBo.getSkuId());
        xextSkuChangePo.setExtSpuId(reqBo.getSpuId());
        xextSkuChangePo.setId(this.getSequence());
        xextSkuChangePo.setIsDelete(ModelRuleConstant.EXT_SKU_MESSAGE_IS_DELETE_NO);
        xextSkuChangePo.setSupplierShopId(reqBo.getSupplierShopId());
        xextSkuChangePo.setSupplierId(reqBo.getSupplierId());
        try {
            xextSkuChangePo.setMsgGetTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(reqBo.getGetTime()));
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u6d88\u606f\uff0c\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)e);
        }
        xextSkuChangePo.setMsgGetType(reqBo.getMsgType());
        xextSkuChangePo.setExtSkuState(ModelRuleConstant.EXT_SKU_STATE_NOT_PROCESSED);
        xextSkuChangePo.setMsgGetId(reqBo.getMsgId());
        xextSkuChangePo.setSkuPoolState(reqBo.getMsgState());
        xextSkuChangePo.setPageNum(reqBo.getPageNum());
        xextSkuChangePo.setSysTenantId(reqBo.getSysTenantId());
        xextSkuChangePo.setSysTenantName(reqBo.getSysTenantName());
        try {
            this.xextSkuChangeMapper.insertMsg(xextSkuChangePo);
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u6d88\u606f\u5931\u8d25:" + e.getMessage());
            throw new BusinessException("COMMEREE_MSG_ADD", "\u65b0\u589e\u6d88\u606f\u5931\u8d25:" + e.getMessage());
        }
        if ("2".equals(reqBo.getMsgType().toString()) || "4".equals(reqBo.getMsgType().toString()) || "6".equals(reqBo.getMsgType().toString()) || "16".equals(reqBo.getMsgType().toString())) {
            if (StringUtils.isEmpty((Object)this.suppliers)) {
                return rspBo;
            }
            List<String> supplierList = Arrays.asList(this.suppliers.split(","));
            if (CollectionUtils.isEmpty(supplierList) || !supplierList.contains(reqBo.getSupplierId().toString())) {
                return rspBo;
            }
            try {
                UccMsgPoolRunPO msgPoolRunPO = new UccMsgPoolRunPO();
                BeanUtils.copyProperties((Object)xextSkuChangePo, (Object)msgPoolRunPO);
                msgPoolRunPO.setResult(JSONObject.toJSONString((Object)reqBo.getResult()));
                msgPoolRunPO.setMsgId(xextSkuChangePo.getId());
                msgPoolRunPO.setMsgGetType(xextSkuChangePo.getMsgGetType().toString());
                msgPoolRunPO.setObjId(xextSkuChangePo.getExtSkuId());
                msgPoolRunPO.setSupplierCode(reqBo.getSupplierCode());
                this.uccMsgPoolRunMapper.insert(msgPoolRunPO);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u6d88\u606f\u5931\u8d25:" + e.getMessage());
                throw new BusinessException("COMMEREE_MSG_ADD", "\u65b0\u589e\u6d88\u606f\u5931\u8d25:" + e.getMessage());
            }
        }
        return rspBo;
    }

    public Long getSequence() {
        return this.uccExtSkuSequence.nextId();
    }
}

