/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.comb.impl.mq;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.busi.bo.UccCurrentPriceQryBO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class UccSyncPriceMqServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UccSyncPriceMqServiceConsumer.class);
    private static final Logger LOG = LoggerFactory.getLogger(UccSyncPriceMqServiceConsumer.class);
    private final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Value(value="${CURRNET_PRICE_UCC_SYNC_TOPIC:CURRNET_PRICE_UCC_SYNC_TOPIC}")
    private String uccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG:*}")
    private String uccSyncTag;
    @Resource(name="syncPriceMqServiceProvider")
    private ProxyMessageProducer uccSyncPriceServiceProvider;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        if (this.IS_DEBUG_ENABLED) {
            LOG.debug("---------------\u4ef7\u683c\u5f02\u6b65\u63d0\u4ea4\u6d88\u8d39\u8005\u5f00\u59cb---------------");
        }
        List batchSkuList = new ArrayList();
        try {
            batchSkuList = JSON.parseArray((String)proxyMessage.getContent(), UccBatchSkuBO.class);
        }
        catch (Exception e) {
            log.error("UccSyncChangePriceServiceConsumer  =  " + e.getMessage());
        }
        if (CollectionUtils.isEmpty(batchSkuList)) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        try {
            List skus = batchSkuList.stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List skuPoList = this.uccSkuMapper.qeryBatchSkus(skus);
            if (!CollectionUtils.isEmpty((Collection)skuPoList) && !CollectionUtils.isEmpty(skuPoList = skuPoList.stream().filter(a -> a.getSkuStatus() == 3 && a.getSkuSource() == 2).collect(Collectors.toList()))) {
                UccCurrentPriceQryBO uccCurrentPriceQryBO = null;
                for (UccSkuPo each : skuPoList) {
                    uccCurrentPriceQryBO = new UccCurrentPriceQryBO();
                    uccCurrentPriceQryBO.setSupplierShopId(each.getSupplierShopId());
                    uccCurrentPriceQryBO.setSkuIds(Arrays.asList(each.getSkuId()));
                    try {
                        this.uccSyncPriceServiceProvider.send(new ProxyMessage(this.uccSyncTopic, this.uccSyncTag, JSON.toJSONString((Object)uccCurrentPriceQryBO)));
                    }
                    catch (Exception e) {
                        log.error("\u5546\u54c1\u52a0\u4ef7\u53d1\u9001\u540c\u6b65\u5f02\u5e38:" + e.getMessage());
                    }
                }
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }
}

