/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.enumType.VendorEnum;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchImportService;
import com.tydic.commodity.estore.ability.bo.UccAddPriceInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchImportReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchImportRspBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertBO;
import com.tydic.commodity.estore.busi.api.UccSkuAddPriceBatchImportBusiService;
import com.tydic.commodity.estore.busi.api.UccSkuAddPriceBatchInsertBusiService;
import com.tydic.commodity.estore.busi.api.UccSkuAddPriceBatchUpdateBusiService;
import com.tydic.commodity.estore.busi.bo.UccAddSkuPriceSyncReqBO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.po.UccSkuAddPriceBatchInsertPO;
import com.tydic.commodity.utils.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccSkuAddPriceBatchImportService"})
public class UccSkuAddPriceBatchImportServiceimpl
implements UccSkuAddPriceBatchImportService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceBatchImportServiceimpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddPriceBatchInsertBusiService uccSkuAddPriceBatchInsertBusiService;
    @Autowired
    private UccSkuAddPriceBatchUpdateBusiService uccSkuAddPriceBatchUpdateBusiService;
    @Autowired
    private UccSkuAddPriceBatchImportBusiService uccSkuAddPriceBatchImportBusiService;
    @Resource(name="addPriceServiceProvider")
    private ProxyMessageProducer addPriceServiceProvider;
    @Value(value="${ADD_PRICE_UCC_SYNC_TOPIC:ADD_PRICE_UCC_SYNC_TOPIC}")
    private String uccSyncTopic;
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";
    private static final int startReadLine = 2;

    @PostMapping(value={"batchimportSkuAddPrice"})
    public UccSkuAddPriceBatchImportRspBO batchimportSkuAddPrice(@RequestBody UccSkuAddPriceBatchImportReqBO reqBO) {
        UccSkuAddPriceBatchImportRspBO uccSkuAddPriceBatchImportRspBO;
        UccSkuAddPriceBatchImportRspBO rspBO = new UccSkuAddPriceBatchImportRspBO();
        rspBO.setRespCode("0000");
        if (StringUtils.isEmpty((Object)reqBO.getUrl())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<UccSkuAddPriceBO> skuAddPriceBOList = this.getData(reqBO.getUrl());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuAddPriceBOList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        this.checkImportValue(skuAddPriceBOList, rspBO);
        if (!"0000".equals(rspBO.getImportCode())) {
            return rspBO;
        }
        ArrayList skuPoList = new ArrayList();
        Map<Long, List<UccSkuAddPriceBO>> groupByVendor = skuAddPriceBOList.stream().collect(Collectors.groupingBy(UccSkuAddPriceBO::getVendorId));
        Iterator<Long> iteratorSpu = groupByVendor.keySet().iterator();
        while (iteratorSpu.hasNext()) {
            List<UccSkuAddPriceBO> vendorList = groupByVendor.get(iteratorSpu.next());
            List extSku = vendorList.stream().map(UccSkuAddPriceBO::getExtSkuId).collect(Collectors.toList());
            List eachSkuPoList = this.uccSkuMapper.qeryAddPriceSkusByExtSkuIds(extSku, vendorList.get(0).getVendorId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eachSkuPoList)) {
                int i = 2;
                ArrayList<String> failReason = new ArrayList<String>();
                for (UccSkuAddPriceBO each : skuAddPriceBOList) {
                    ++i;
                    failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u5728\u5546\u57ce\u4e0d\u5b58\u5728");
                }
                rspBO.setFailReason(failReason);
                rspBO.setImportCode("8888");
                return rspBO;
            }
            List extSkuList = eachSkuPoList.stream().map(UccSkuAddPriceBatchInsertPO::getExtSkuId).collect(Collectors.toList());
            List duplicates = extSkuList.stream().distinct().filter(element -> extSkuList.indexOf(element) != extSkuList.lastIndexOf(element)).collect(Collectors.toList());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(duplicates)) {
                int i = 2;
                ArrayList<String> failReason = new ArrayList<String>();
                for (UccSkuAddPriceBO each : skuAddPriceBOList) {
                    if (!duplicates.contains(each.getExtSkuId())) continue;
                    ++i;
                    failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u5728\u5546\u57ce\u4e0d\u5b58\u5728");
                }
                rspBO.setFailReason(failReason);
                rspBO.setImportCode("8888");
                return rspBO;
            }
            if (vendorList.size() != extSkuList.size()) {
                int i = 2;
                ArrayList<String> failReason = new ArrayList<String>();
                for (UccSkuAddPriceBO each : skuAddPriceBOList) {
                    if (extSkuList.contains(each.getExtSkuId())) continue;
                    ++i;
                    failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u5728\u5546\u57ce\u4e0d\u5b58\u5728");
                }
                rspBO.setFailReason(failReason);
                rspBO.setImportCode("8888");
                return rspBO;
            }
            skuPoList.addAll(eachSkuPoList);
        }
        Map uccSkuAddPriceBOMap = skuAddPriceBOList.stream().collect(Collectors.toMap(UccSkuAddPriceBO::getExtSkuId, Function.identity()));
        for (UccSkuAddPriceBatchInsertPO each : skuPoList) {
            if (!uccSkuAddPriceBOMap.containsKey(each.getExtSkuId())) continue;
            if (((UccSkuAddPriceBO)uccSkuAddPriceBOMap.get(each.getExtSkuId())).getAddCoefficient() != null) {
                each.setSkuAddCoefficient(((UccSkuAddPriceBO)uccSkuAddPriceBOMap.get(each.getExtSkuId())).getAddCoefficient());
                each.setAddPrice(null);
            }
            if (((UccSkuAddPriceBO)uccSkuAddPriceBOMap.get(each.getExtSkuId())).getAddPrice() != null) {
                each.setAddPrice(((UccSkuAddPriceBO)uccSkuAddPriceBOMap.get(each.getExtSkuId())).getAddPrice());
                each.setSkuAddCoefficient(null);
            }
            each.setRule(((UccSkuAddPriceBO)uccSkuAddPriceBOMap.get(each.getExtSkuId())).getRule());
            each.setAllowMarketPrice(((UccSkuAddPriceBO)uccSkuAddPriceBOMap.get(each.getExtSkuId())).getAllow());
        }
        List<Long> skus = skuPoList.stream().map(UccSkuAddPriceBatchInsertPO::getSkuId).collect(Collectors.toList());
        rspBO.setSkuList(skus);
        List skuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(skus);
        List addpriceReq = new ArrayList();
        List editpriceReq = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)skuAddCoefficientPOS)) {
            addpriceReq = JSONObject.parseArray((String)JSON.toJSONString(skuPoList), UccSkuAddPriceBatchInsertBO.class);
        } else {
            List alreadyInsert = skuAddCoefficientPOS.stream().map(UccSkuAddCoefficientPO::getSkuId).collect(Collectors.toList());
            List needInsert = skuPoList.stream().filter(a -> !alreadyInsert.contains(a.getSkuId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(needInsert)) {
                addpriceReq = JSONObject.parseArray((String)JSON.toJSONString(needInsert), UccSkuAddPriceBatchInsertBO.class);
                skuPoList.removeAll(needInsert);
                if (!CollectionUtils.isEmpty(skuPoList)) {
                    editpriceReq = JSONObject.parseArray((String)JSON.toJSONString(skuPoList), UccAddPriceInfoBO.class);
                }
            } else {
                editpriceReq = JSONObject.parseArray((String)JSON.toJSONString(skuPoList), UccAddPriceInfoBO.class);
            }
        }
        UccSkuAddPriceBatchImportReqBO uccSkuAddPriceBatchImportReqBO = new UccSkuAddPriceBatchImportReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuAddPriceBatchImportReqBO);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(addpriceReq)) {
            uccSkuAddPriceBatchImportReqBO.setAddpriceReq(addpriceReq);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(editpriceReq)) {
            uccSkuAddPriceBatchImportReqBO.setEditpriceReq(editpriceReq);
        }
        if (!"0000".equals((uccSkuAddPriceBatchImportRspBO = this.uccSkuAddPriceBatchImportBusiService.batchimportSkuAddPrice(uccSkuAddPriceBatchImportReqBO)).getRespCode())) {
            BeanUtils.copyProperties((Object)uccSkuAddPriceBatchImportRspBO, (Object)rspBO);
            return rspBO;
        }
        UccAddSkuPriceSyncReqBO uccAddSkuPriceSyncReqBO = new UccAddSkuPriceSyncReqBO();
        uccAddSkuPriceSyncReqBO.setSkuList(skus);
        uccAddSkuPriceSyncReqBO.setOperType(1);
        try {
            log.info("es\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)uccAddSkuPriceSyncReqBO));
            this.addPriceServiceProvider.send(new ProxyMessage(this.uccSyncTopic, PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)uccAddSkuPriceSyncReqBO)));
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u52a0\u4ef7\u53d1\u9001\u540c\u6b65\u5f02\u5e38:" + e.getMessage());
        }
        log.info("\u65b0\u589e\u5bfc\u5165\u8fd4\u56de\u6570\u636e\uff1a " + JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private UccSkuAddPriceBatchImportRspBO checkImportValue(List<UccSkuAddPriceBO> skuAddPriceBOList, UccSkuAddPriceBatchImportRspBO rspBO) {
        int i = 2;
        ArrayList<String> extSku = new ArrayList<String>();
        ArrayList<String> failReason = new ArrayList<String>();
        String decimalPattern = "^\\d+(\\.\\d{1,2})?$";
        for (UccSkuAddPriceBO each : skuAddPriceBOList) {
            ++i;
            if (StringUtils.isEmpty((Object)each.getExtSkuId())) {
                failReason.add("\u7b2c" + i + "\u884c\u6570\u636e\u65e0\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a");
                continue;
            }
            if (StringUtils.isEmpty((Object)each.getVendorName())) {
                failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            VendorEnum vendorEnum = VendorEnum.getVendor((String)each.getVendorName());
            if (vendorEnum == null) {
                failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
                continue;
            }
            each.setVendorId(vendorEnum.getVendorId());
            if (extSku.contains(each.getExtSkuId() + each.getVendorId())) {
                failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u91cd\u590d\u4e86");
                continue;
            }
            extSku.add(each.getExtSkuId() + each.getVendorId());
            if (StringUtils.isEmpty((Object)each.getAddCoefficientStr()) && StringUtils.isEmpty((Object)each.getAddPriceStr())) {
                failReason.add("\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a" + each.getExtSkuId() + "\uff0c\u52a0\u4ef7\u7cfb\u6570\u3001\u52a0\u4ef7\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u6216\u8005\u201c0\u201d");
                continue;
            }
            if (!StringUtils.isEmpty((Object)each.getAddCoefficientStr()) && !StringUtils.isEmpty((Object)each.getAddPriceStr())) {
                failReason.add("\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a" + each.getExtSkuId() + "\uff0c\u201c\u5355\u54c1\u52a0\u4ef7\u7cfb\u6570\u201d\u548c\u201c\u5355\u54c1\u52a0\u4ef7\u91d1\u989d\u201d\u4ec5\u5141\u8bb8\u7ef4\u62a4\u4e00\u9879");
                continue;
            }
            if (!StringUtils.isEmpty((Object)each.getAddCoefficientStr())) {
                if (!each.getAddCoefficientStr().matches(decimalPattern)) {
                    failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u52a0\u4ef7\u7cfb\u6570\u6700\u591a\u4e24\u4f4d\u5c0f\u6570");
                    continue;
                }
                each.setAddCoefficient(new BigDecimal(each.getAddCoefficientStr()));
                if (each.getAddCoefficient().compareTo(new BigDecimal(0)) < 1) {
                    failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u52a0\u4ef7\u7cfb\u6570\u5fc5\u987b\u662f\u5927\u4e8e0");
                    continue;
                }
                each.setRule(Integer.valueOf(1));
            }
            if (!StringUtils.isEmpty((Object)each.getAddPriceStr())) {
                if (!each.getAddPriceStr().matches(decimalPattern)) {
                    failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a" + each.getExtSkuId() + "\uff0c\u52a0\u4ef7\u91d1\u989d\u6700\u591a\u4e24\u4f4d\u5c0f\u6570");
                    continue;
                }
                each.setAddPrice(new BigDecimal(each.getAddPriceStr()));
                if (each.getAddPrice().compareTo(new BigDecimal(0)) < 1) {
                    failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a" + each.getExtSkuId() + "\uff0c\u52a0\u4ef7\u91d1\u989d\u5fc5\u987b\u662f\u5927\u4e8e0");
                    continue;
                }
                each.setRule(Integer.valueOf(2));
            }
            if ("1".equals(each.getAllowStr()) || "0".equals(each.getAllowStr())) {
                each.setAllow(Integer.valueOf(each.getAllowStr()));
                continue;
            }
            failReason.add("\u5916\u90e8\u7535\u5546\u5355\u54c1\u7f16\u7801\uff1a " + each.getExtSkuId() + "\uff0c\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7\u8bf7\u8f93\u5165\u6b63\u786e\u503c");
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(failReason)) {
            rspBO.setImportCode("8888");
            rspBO.setFailReason(failReason);
        } else {
            rspBO.setImportCode("0000");
        }
        return rspBO;
    }

    private List<UccSkuAddPriceBO> getData(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            throw new ZTBusinessException("\u8bf7\u4f20\u5165\u8def\u5f84\u4fe1\u606f");
        }
        List<Object> data = new ArrayList();
        try {
            data = this.dealEcxel(url);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        ArrayList<UccSkuAddPriceBO> uccImportInfos = new ArrayList<UccSkuAddPriceBO>();
        int rowNum = 1;
        try {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    int i = 0;
                    UccSkuAddPriceBO uccImportInfo = new UccSkuAddPriceBO();
                    uccImportInfo.setExtSkuId((String)list.get(i++));
                    uccImportInfo.setVendorName((String)list.get(i++));
                    uccImportInfo.setAddCoefficientStr((String)list.get(i++));
                    uccImportInfo.setAddPriceStr((String)list.get(i++));
                    uccImportInfo.setAllowStr((String)list.get(i++));
                    uccImportInfos.add(uccImportInfo);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return uccImportInfos;
    }

    private List<List<String>> dealEcxel(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            this.getExcelDate(url, lines, 2);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u5bfc\u5165\u6587\u6863\u4e0e\u5bfc\u51fa\u6a21\u677f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5148\u4e0b\u8f7d\u5bfc\u51fa\u6a21\u677f");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void getExcelDate(String path, List<List<String>> data, Integer readLine) throws Exception {
        URL url = new URL(path);
        File file = new File(url.getFile());
        InputStream inputStream = url.openStream();
        UccSkuAddPriceBatchImportServiceimpl.checkExcelVaild(file);
        Workbook workbook = UccSkuAddPriceBatchImportServiceimpl.getWorkbok(file, inputStream);
        int count = 2;
        Sheet sheet = workbook.getSheetAt(0);
        for (int rowNum = 2; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            ArrayList<String> c = new ArrayList<String>();
            if (sheet.getRow(rowNum).getPhysicalNumberOfCells() == 0) continue;
            int end = sheet.getRow(rowNum).getLastCellNum();
            for (int i = 0; i < end; ++i) {
                Cell cell = sheet.getRow(rowNum).getCell(i);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = UccSkuAddPriceBatchImportServiceimpl.getValue(cell);
                if (count < readLine) continue;
                c.add(String.valueOf(obj).trim());
            }
            ++count;
            if (c.size() <= 0) continue;
            data.add(c);
        }
    }

    private static void checkExcelVaild(File file) throws Exception {
        if (!file.getName().endsWith(EXCEL_XLS) && !file.getName().endsWith(EXCEL_XLSX)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Workbook getWorkbok(File file, InputStream inputStream) throws IOException {
        HSSFWorkbook wb = null;
        if (file.getName().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (file.getName().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        cell.setCellType(CellType.STRING);
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }
}

