/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccPricePreventMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.estore.atom.api.SyncECommercePriceToEsAtomService;
import com.tydic.commodity.estore.atom.bo.SnycECommercePriceEsBO;
import com.tydic.commodity.estore.atom.bo.SyncECommercePriceToEsAtomReqBo;
import com.tydic.commodity.estore.atom.bo.SyncECommercePriceToEsAtomRspBO;
import com.tydic.commodity.po.SupplierShopPo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccPriUpQryRspVOPO;
import com.tydic.commodity.po.UccPricePreventPO;
import com.tydic.commodity.po.UccVendorPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SyncECommercePriceToEsAtomServiceImpl
implements SyncECommercePriceToEsAtomService {
    private static final Logger log = LoggerFactory.getLogger(SyncECommercePriceToEsAtomServiceImpl.class);
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private UccPricePreventMapper uccPricePreventMapper;

    @Override
    public SyncECommercePriceToEsAtomRspBO syncEs(SyncECommercePriceToEsAtomReqBo reqBo) {
        SyncECommercePriceToEsAtomRspBO rspBO = new SyncECommercePriceToEsAtomRspBO();
        rspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBo.getSkuList())) {
            return rspBO;
        }
        List eCommercePriceSkuList = this.eCommercePriceChangeMapper.selectECommercePriceBySku(reqBo.getSkuList());
        if (CollectionUtils.isEmpty((Collection)eCommercePriceSkuList)) {
            return rspBO;
        }
        List vendorIds = eCommercePriceSkuList.stream().map(UccPriUpQryRspVOPO::getVendorId).collect(Collectors.toList());
        List catalogIds = eCommercePriceSkuList.stream().map(UccPriUpQryRspVOPO::getCatalogId).collect(Collectors.toList());
        List shops = eCommercePriceSkuList.stream().map(UccPriUpQryRspVOPO::getSupplierShopId).collect(Collectors.toList());
        ArrayList<UccEMdmCatalogPO> uccEMdmCatalogPOList = new ArrayList();
        ArrayList<UccVendorPo> vendorPOList = new ArrayList();
        ArrayList<SupplierShopPo> supplierShopPos = new ArrayList();
        if (!CollectionUtils.isEmpty(catalogIds)) {
            uccEMdmCatalogPOList = this.uccEMdmCatalogMapper.queryByCatIds(catalogIds);
        }
        if (!CollectionUtils.isEmpty(vendorIds)) {
            vendorPOList = this.uccVendorMapper.batchSelectByVendors(vendorIds);
        }
        if (!CollectionUtils.isEmpty(shops)) {
            supplierShopPos = this.supplierShopMapper.batchqueryShopByShopId(shops);
        }
        List skus = eCommercePriceSkuList.stream().map(UccPriUpQryRspVOPO::getSkuId).collect(Collectors.toList());
        List uccPricePreventPOS = this.uccPricePreventMapper.getListBySku(skus);
        ArrayList<SnycECommercePriceEsBO> esBOList = new ArrayList<SnycECommercePriceEsBO>();
        this.assembleData(esBOList, eCommercePriceSkuList, uccPricePreventPOS, uccEMdmCatalogPOList, vendorPOList, supplierShopPos);
        this.syncCommodityInfoToEs(esBOList);
        return rspBO;
    }

    private void assembleData(List<SnycECommercePriceEsBO> esBOList, List<UccPriUpQryRspVOPO> eCommercePriceSkuList, List<UccPricePreventPO> uccPricePreventPOS, List<UccEMdmCatalogPO> uccEMdmCatalogPOList, List<UccVendorPo> vendorPOList, List<SupplierShopPo> supplierShopPos) {
        Map<Object, Object> vendorMap = new HashMap();
        if (!CollectionUtils.isEmpty(vendorPOList)) {
            vendorMap = vendorPOList.stream().collect(Collectors.toMap(UccVendorPo::getVendorId, UccVendorPo::getVendorName));
        }
        Map<Object, Object> catalogMap = new HashMap();
        if (!CollectionUtils.isEmpty(uccEMdmCatalogPOList)) {
            catalogMap = uccEMdmCatalogPOList.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogId, UccEMdmCatalogPO::getCatalogName));
        }
        Map<Object, Object> supplierMap = new HashMap();
        if (!CollectionUtils.isEmpty(supplierShopPos)) {
            supplierMap = supplierShopPos.stream().collect(Collectors.toMap(SupplierShopPo::getSupplierShopId, Function.identity()));
        }
        Map<Object, Object> pricePreventPOMap = new HashMap();
        if (!CollectionUtils.isEmpty(uccPricePreventPOS)) {
            pricePreventPOMap = uccPricePreventPOS.stream().collect(Collectors.toMap(UccPricePreventPO::getSkuId, Function.identity()));
        }
        SnycECommercePriceEsBO esBO = null;
        for (UccPriUpQryRspVOPO each : eCommercePriceSkuList) {
            esBO = new SnycECommercePriceEsBO();
            esBO.setAverage_price(each.getAveragePrice());
            esBO.setBrand_id(each.getBrandId());
            esBO.setBrand_name(each.getBrandName());
            esBO.setCommodity_code(each.getCommodityCode());
            esBO.setCommodity_id(Long.valueOf(each.getCommodityId()));
            esBO.setCommodity_name(each.getCommodityName());
            esBO.setCommodity_type_id(each.getCommodityTypeId());
            esBO.setCommodity_type_name(each.getCommodityTypeName());
            esBO.setSku_code(each.getSkuCode());
            esBO.setSku_id(each.getSkuId());
            esBO.setSku_name(each.getSkuName());
            esBO.setExt_sku_id(each.getExtSkuId());
            esBO.setExt_spu_id(each.getExtSpuId());
            esBO.setFloating_rate(each.getFloatingRate());
            esBO.setFrequency(each.getFrequency());
            esBO.setCatalog_id(each.getCatalogId());
            esBO.setVendor_id(each.getVendorId());
            esBO.setUpdate_time(each.getUpdateTime().getTime());
            esBO.setPrice(each.getPrice());
            esBO.setSupplier_shop_id(each.getSupplierShopId());
            if (each.getOnShelveTime() != null) {
                esBO.setOn_shelve_time(each.getOnShelveTime().getTime());
            }
            if (catalogMap.containsKey(each.getCatalogId())) {
                esBO.setCatalog_name((String)catalogMap.get(each.getCatalogId()));
            }
            if (vendorMap.containsKey(each.getVendorId())) {
                esBO.setVendor_name((String)vendorMap.get(each.getVendorId()));
            }
            if (supplierMap.containsKey(each.getSupplierShopId())) {
                esBO.setSupplier_id(((SupplierShopPo)supplierMap.get(each.getSupplierShopId())).getSupplierId());
                esBO.setSupplier_name(((SupplierShopPo)supplierMap.get(each.getSupplierShopId())).getSupplierName());
                esBO.setSupplier_shop_name(((SupplierShopPo)supplierMap.get(each.getSupplierShopId())).getShopName());
            }
            if (pricePreventPOMap.containsKey(each.getSkuId())) {
                esBO.setBefore_price(((UccPricePreventPO)pricePreventPOMap.get(each.getSkuId())).getBeforePrice());
                esBO.setMax_price(((UccPricePreventPO)pricePreventPOMap.get(each.getSkuId())).getMaxPrice());
                esBO.setMin_price(((UccPricePreventPO)pricePreventPOMap.get(each.getSkuId())).getMinPrice());
                esBO.setPercentage(((UccPricePreventPO)pricePreventPOMap.get(each.getSkuId())).getPercentage());
                esBO.setPrevent(1);
                esBO.setPrevent_price(((UccPricePreventPO)pricePreventPOMap.get(each.getSkuId())).getPrice());
                esBO.setIs_down(((UccPricePreventPO)pricePreventPOMap.get(each.getSkuId())).getIsDown());
                esBO.setPrevent_time(((UccPricePreventPO)pricePreventPOMap.get(each.getSkuId())).getUpdateTime().getTime());
                esBO.setIs_down(((UccPricePreventPO)pricePreventPOMap.get(each.getSkuId())).getIsDown());
            }
            esBOList.add(esBO);
        }
    }

    private void syncCommodityInfoToEs(List<SnycECommercePriceEsBO> esBOList) {
        if (CollectionUtils.isEmpty(esBOList)) {
            return;
        }
        for (SnycECommercePriceEsBO esStorageSpuInfoBO : esBOList) {
            String jsonStr = JSONObject.toJSONString((Object)esStorageSpuInfoBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = String.valueOf(esStorageSpuInfoBO.getSku_id());
            String id = this.elasticsearchUtil.addData(this.esConfig.getCommerceIndexName(), this.esConfig.getCommerceIndexType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            log.error("\u5546\u54c1\u4fe1\u606f[" + esStorageSpuInfoBO.getSku_id() + "|" + esStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }
}

