/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsRspBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.busi.api.UccAddSkuPriceSyncBusiService;
import com.tydic.commodity.estore.busi.bo.UccAddSkuPriceSyncReqBO;
import com.tydic.commodity.estore.busi.bo.UccAddSkuPriceSyncRspBO;
import com.tydic.commodity.estore.comb.api.UccAddSkuPriceSyncCombService;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAddSkuPriceSyncCombServiceImpl
implements UccAddSkuPriceSyncCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAddSkuPriceSyncCombServiceImpl.class);
    @Autowired
    private UccAddSkuPriceSyncBusiService uccAddSkuPriceSyncBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${SYNC_GOVERN_PRICE_TOPIC:SYNC_GOVERN_PRICE_TOPIC}")
    private String syncGovernPriceTopic;
    @Resource(name="uccSyncGovernPriceMqProvider")
    private ProxyMessageProducer uccSyncGovernPriceMqProvider;

    @Override
    public UccAddSkuPriceSyncRspBO dealSyncPrice(UccAddSkuPriceSyncReqBO reqBO) {
        List uccSkuPos;
        UccAddSkuPriceSyncRspBO rspBO = this.uccAddSkuPriceSyncBusiService.dealSyncPrice(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getSkuList()) && !CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuList())))) {
            Map<Long, List<UccSkuPo>> gourpShop = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            for (Long supplierShopId : gourpShop.keySet()) {
                List skus = gourpShop.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                SyncSceneCommodityToEsRspBO syncSceneCommodityToEsRspBO = this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                if ("0000".equals(syncSceneCommodityToEsRspBO.getRespCode())) continue;
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
        if ("0000".equals(rspBO.getRespCode()) && !CollectionUtils.isEmpty(rspBO.getChangeSku())) {
            for (Long each : rspBO.getChangeSku()) {
                JSONObject syncCoovern = new JSONObject();
                try {
                    syncCoovern.put("skuId", (Object)each);
                    this.uccSyncGovernPriceMqProvider.send(new ProxyMessage(this.syncGovernPriceTopic, "*", JSON.toJSONString((Object)syncCoovern)));
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001MQ\u6570\u636e" + JSON.toJSONString((Object)syncCoovern) + "\u5f02\u5e38\uff1a{}" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return rspBO;
    }
}

