/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommdQueryDealMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuQueryDealMapper;
import com.tydic.commodity.estore.atom.api.UccCommodityAtomService;
import com.tydic.commodity.estore.atom.bo.BatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.estore.atom.bo.BatchUpdateCommodityStatusRspBO;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuBO;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuStatusReqBO;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuStatusRspBO;
import com.tydic.commodity.po.BatchUpdateCommodityPO;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuQueryPO;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uccCommodityAtomService")
public class UccCommodityAtomServiceImpl
implements UccCommodityAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityAtomServiceImpl.class);
    @Autowired
    private UccCommdQueryDealMapper uccCommdQueryDealMapper;
    @Autowired
    private UccSkuQueryDealMapper skuMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public BatchUpdateCommodityStatusRspBO batchUpdateCommodityByCommodityId(BatchUpdateCommodityStatusReqBo reqBo) {
        BatchUpdateCommodityStatusRspBO batchUpdateCommodityStatusRspBO = new BatchUpdateCommodityStatusRspBO();
        try {
            List batchUpdateCommodityBOS = JSONObject.parseArray((String)JSONObject.toJSONString(reqBo.getBoList()), BatchUpdateCommodityPO.class);
            this.uccCommdQueryDealMapper.batchUpdateCommodityByCommodityId(batchUpdateCommodityBOS, reqBo.getSupplierShopId());
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_COMMODITY_ERROR", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5f02\u5e38");
        }
        batchUpdateCommodityStatusRspBO.setRespCode("0000");
        batchUpdateCommodityStatusRspBO.setRespDesc("\u6210\u529f");
        return batchUpdateCommodityStatusRspBO;
    }

    @Override
    public BatchUpdateSkuStatusRspBO batchUpdateSkuInStatusByCommodityId(BatchUpdateSkuStatusReqBO reqBO) {
        BatchUpdateSkuStatusRspBO batchUpdateSkuStatusRspBO = new BatchUpdateSkuStatusRspBO();
        try {
            List<BatchUpdateSkuBO> batchUpdateSkuBOList = reqBO.getBoList();
            for (BatchUpdateSkuBO batchUpdateSkuBO : batchUpdateSkuBOList) {
                List skuQueryPO = this.skuMapper.selectSkuInfoByCommodityId(batchUpdateSkuBO.getCommodityId());
                UccSkuPo queryUccSkuPo = new UccSkuPo();
                for (UccSkuQueryPO SkuPo : skuQueryPO) {
                    Long batchId = this.uccBatchSequence.nextId();
                    queryUccSkuPo.setSkuId(SkuPo.getSkuId());
                    List uccSkuPos = this.uccSkuMapper.qerySku(queryUccSkuPo);
                    UccSkuPo uccSkuPo = (UccSkuPo)uccSkuPos.get(0);
                    UccSkuLogPo po = new UccSkuLogPo();
                    BeanUtils.copyProperties((Object)uccSkuPo, (Object)po);
                    po.setBatchId(batchId);
                    po.setSkuSource(uccSkuPo.getSkuSource());
                    try {
                        this.uccSkuLogMapper.insert(po);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u63d2\u5165\u5355\u54c1\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
                    }
                }
                this.skuMapper.batchUpdateSkuStatusBySkuId(skuQueryPO, reqBO.getStatus(), batchUpdateSkuBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_SKU_ERROR", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u5931\u8d25");
        }
        batchUpdateSkuStatusRspBO.setRespCode("0000");
        batchUpdateSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return batchUpdateSkuStatusRspBO;
    }

    @Override
    public BatchUpdateSkuStatusRspBO batchSkuInStatus(BatchUpdateSkuStatusReqBO reqBO) {
        BatchUpdateSkuStatusRspBO batchUpdateSkuStatusRspBO = new BatchUpdateSkuStatusRspBO();
        try {
            List<BatchUpdateSkuBO> batchUpdateSkuBOList = reqBO.getBoList();
            for (BatchUpdateSkuBO batchUpdateSkuBO : batchUpdateSkuBOList) {
                List skuQueryPO = this.skuMapper.selectSkuInfoByCommodityId(batchUpdateSkuBO.getCommodityId());
                this.skuMapper.batchUpdateSkuStatusBySkuId(skuQueryPO, reqBO.getStatus(), batchUpdateSkuBO.getSupplierShopId());
                if (reqBO.getStatus() == null || CollectionUtils.isEmpty((Collection)skuQueryPO) || !SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(reqBO.getStatus()) && !SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(reqBO.getStatus()) && !SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(reqBO.getStatus()) && !SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(reqBO.getStatus())) continue;
                for (UccSkuQueryPO each : skuQueryPO) {
                    UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
                    uccSkuPutCirPo.setSkuId(each.getSkuId());
                    uccSkuPutCirPo.setSupplierShopId(batchUpdateSkuBO.getSupplierShopId());
                    uccSkuPutCirPo.setDownType(Integer.valueOf(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(reqBO.getStatus()) ? 1 : 2));
                    uccSkuPutCirPo.setRealDownTime((Date)new Timestamp(System.currentTimeMillis()));
                    this.uccSkuPutCirMapper.updateSkuPutCir(uccSkuPutCirPo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("BATCH_UPDATE_SKU_ERROR", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u5931\u8d25");
        }
        batchUpdateSkuStatusRspBO.setRespCode("0000");
        batchUpdateSkuStatusRspBO.setRespDesc("\u6210\u529f");
        return batchUpdateSkuStatusRspBO;
    }
}

