/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.enumType.SkuSourceEnum;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccApplyShelvesSubmitAbilityService;
import com.tydic.commodity.estore.ability.bo.SupplierSignTypeBO;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesDetailSplitBO;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesSkuInfoBO;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesSplitBO;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesSubmitAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesSubmitAbilityRspBO;
import com.tydic.commodity.estore.busi.api.UccApplyShelvesSubmitBusiService;
import com.tydic.commodity.po.SupplierShopPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccApplyShelvesSubmitAbilityService"})
public class UccApplyShelvesSubmitAbilityServiceImpl
implements UccApplyShelvesSubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccApplyShelvesSubmitAbilityServiceImpl.class);
    @Autowired
    private UccApplyShelvesSubmitBusiService uccApplyShelvesSubmitBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Resource(name="applyShelvesVendorServiceProvider")
    private ProxyMessageProducer applyShelvesVendorServiceProvider;
    @Value(value="${SHELVES_UCC_SYNC_VENDOR_TOPIC:SHELVES_UCC_SYNC_VENDOR_TOPIC}")
    private String uccSyncTopic;
    @Value(value="${SUPPLEMENT_SHOP_LIMIT:''}")
    private String supplementLimit;

    @PostMapping(value={"dealApplyShelvesSubmit"})
    public UccApplyShelvesSubmitAbilityRspBO dealApplyShelvesSubmit(@RequestBody UccApplyShelvesSubmitAbilityReqBO reqBO) {
        UccApplyShelvesSubmitAbilityRspBO rspBO = new UccApplyShelvesSubmitAbilityRspBO();
        if (reqBO == null || !StringUtils.hasText((String)reqBO.getApplyNo())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u7533\u8bf7\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (!StringUtils.hasText((String)reqBO.getApplyType())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u7533\u8bf7\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getOperOrgId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u91c7\u8d2d\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getOperUserId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u63d0\u4ea4\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (!StringUtils.hasText((String)reqBO.getOperOrgName())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u91c7\u8d2d\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (!StringUtils.hasText((String)reqBO.getOperUserName())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u63d0\u4ea4\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuList())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5546\u54c1\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<UccApplyShelvesSkuInfoBO> passList = new ArrayList<UccApplyShelvesSkuInfoBO>();
        if ("2".equals(reqBO.getApplyType())) {
            List<String> limtList;
            if (reqBO.getSkuList().size() > 1) {
                rspBO.setRespCode("0000");
                rspBO.setSuccess(false);
                rspBO.setErrorMsg("\u8865\u5145\u5e93\u5b58\u6bcf\u6b21\u53ea\u80fd\u7533\u8bf7\u4e00\u4e2a\u5546\u54c1");
                rspBO.setRespDesc("\u8865\u5145\u5e93\u5b58\u6bcf\u6b21\u53ea\u80fd\u7533\u8bf7\u4e00\u4e2a\u5546\u54c1");
                return rspBO;
            }
            if (((UccApplyShelvesSkuInfoBO)reqBO.getSkuList().get(0)).getNum() == null) {
                rspBO.setRespCode("0000");
                rspBO.setSuccess(false);
                rspBO.setErrorMsg("\u8865\u5145\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                rspBO.setRespDesc("\u8865\u5145\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (!StringUtils.hasText((String)((UccApplyShelvesSkuInfoBO)reqBO.getSkuList().get(0)).getUseDate())) {
                rspBO.setRespCode("0000");
                rspBO.setSuccess(false);
                rspBO.setErrorMsg("\u8865\u5145\u5e93\u5b58\u9884\u8ba1\u4f7f\u7528\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                rspBO.setRespDesc("\u8865\u5145\u5e93\u5b58\u9884\u8ba1\u4f7f\u7528\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (!StringUtils.hasText((String)((UccApplyShelvesSkuInfoBO)reqBO.getSkuList().get(0)).getExtSkuId()) || null == reqBO.getSkuList().get(0)) {
                rspBO.setRespCode("0000");
                rspBO.setSuccess(false);
                rspBO.setErrorMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                rspBO.setRespDesc("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(reqBO.getSkuList().stream().map(UccApplyShelvesSkuInfoBO::getSkuId).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                rspBO.setRespCode("0000");
                rspBO.setSuccess(false);
                rspBO.setErrorMsg("\u672a\u67e5\u8be2\u5230\u8be5\u7533\u8bf7\u5355\u4e0b\u5546\u54c1\u4fe1\u606f");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u7533\u8bf7\u5355\u4e0b\u5546\u54c1\u4fe1\u606f");
                return rspBO;
            }
            List collect = uccSkuPos.stream().filter(po -> !SkuSourceEnum.ELECTRONIC_SUPERMARKET_SOURCE.getSource().equals(po.getSkuSource())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                rspBO.setRespCode("0000");
                rspBO.setSuccess(false);
                rspBO.setErrorMsg("\u4ec5\u5141\u8bb8\u7533\u8bf7\u7535\u5546\u7c7b\u5546\u54c1");
                rspBO.setRespDesc("\u4ec5\u5141\u8bb8\u7533\u8bf7\u7535\u5546\u7c7b\u5546\u54c1");
                return rspBO;
            }
            if (!StringUtils.isEmpty((Object)this.supplementLimit) && (limtList = Arrays.asList(this.supplementLimit.split(","))).contains(((UccSkuPo)uccSkuPos.get(0)).getSupplierShopId().toString())) {
                rspBO.setRespCode("0000");
                rspBO.setSuccess(false);
                rspBO.setErrorMsg("\u6b64\u4f9b\u5e94\u5546\u4e0d\u63a5\u53d7\u5728\u7ebf\u63d0\u4ea4\u5e93\u5b58\u7533\u8bf7\uff0c\u8bf7\u8054\u7cfb\u4f9b\u5e94\u5546\u7684\u5728\u7ebf\u5ba2\u670d\u8fdb\u884c\u5904\u7406\u3002");
                rspBO.setRespDesc("\u6b64\u4f9b\u5e94\u5546\u4e0d\u63a5\u53d7\u5728\u7ebf\u63d0\u4ea4\u5e93\u5b58\u7533\u8bf7\uff0c\u8bf7\u8054\u7cfb\u4f9b\u5e94\u5546\u7684\u5728\u7ebf\u5ba2\u670d\u8fdb\u884c\u5904\u7406\u3002");
                return rspBO;
            }
            SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(((UccSkuPo)uccSkuPos.get(0)).getSupplierShopId());
            ArrayList<SupplierSignTypeBO> supplierSignTypeBos = new ArrayList<SupplierSignTypeBO>();
            SupplierSignTypeBO bo = new SupplierSignTypeBO();
            bo.setSupplierId(supplierShopPo.getSupplierId());
            bo.setSupplierName(supplierShopPo.getSupplierName());
            bo.setTypeList(Collections.singletonList(((UccSkuPo)uccSkuPos.get(0)).getCommodityTypeId()));
            supplierSignTypeBos.add(bo);
            reqBO.setSupplierSignTypeList(supplierSignTypeBos);
        } else {
            for (UccApplyShelvesSkuInfoBO sku : reqBO.getSkuList()) {
                if (sku.getNum() == null) {
                    if (reqBO.getPartCheck() == 1) continue;
                    rspBO.setRespCode("0001");
                    rspBO.setRespDesc("\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                if (StringUtils.isEmpty((Object)sku.getSpec())) {
                    if (reqBO.getPartCheck() == 1) continue;
                    rspBO.setRespCode("0001");
                    rspBO.setRespDesc("\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                if (StringUtils.isEmpty((Object)sku.getUseDate())) {
                    if (reqBO.getPartCheck() == 1) continue;
                    rspBO.setRespCode("0001");
                    rspBO.setRespDesc("\u9884\u8ba1\u4f7f\u7528\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                passList.add(sku);
            }
            reqBO.setSkuList(passList);
            int maxApplyAddNum = 500;
            if (reqBO.getSkuList().size() > 500) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u6bcf\u6b21\u4e0d\u80fd\u8d85\u8fc7500\u79cd");
                return rspBO;
            }
        }
        UccApplyShelvesSubmitAbilityRspBO abilityRspBO = this.uccApplyShelvesSubmitBusiService.dealApplyShelvesSubmit(reqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            if ("2".equals(reqBO.getApplyType())) {
                rspBO.setRespCode("0000");
                rspBO.setSuccess(false);
                rspBO.setErrorMsg("\u6b64\u4f9b\u5e94\u5546\u4e0d\u63a5\u53d7\u5728\u7ebf\u63d0\u4ea4\u5e93\u5b58\u7533\u8bf7\uff0c\u8bf7\u8054\u7cfb\u4f9b\u5e94\u5546\u7684\u5728\u7ebf\u5ba2\u670d\u8fdb\u884c\u5904\u7406\u3002");
                rspBO.setRespDesc("\u6b64\u4f9b\u5e94\u5546\u4e0d\u63a5\u53d7\u5728\u7ebf\u63d0\u4ea4\u5e93\u5b58\u7533\u8bf7\uff0c\u8bf7\u8054\u7cfb\u4f9b\u5e94\u5546\u7684\u5728\u7ebf\u5ba2\u670d\u8fdb\u884c\u5904\u7406\u3002");
                return rspBO;
            }
            return abilityRspBO;
        }
        if (abilityRspBO.getShevles().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)abilityRspBO.getUccApplyShelvesDetailSplitPOList()) || CollectionUtils.isEmpty((Collection)abilityRspBO.getUccApplyShelvesSplitPOList())) {
                return abilityRspBO;
            }
            this.applyGoods(abilityRspBO.getUccApplyShelvesSplitPOList(), abilityRspBO.getUccApplyShelvesDetailSplitPOList(), abilityRspBO.getApplyNo());
        }
        if (!CollectionUtils.isEmpty(passList)) {
            rspBO.setPassSkuList(passList);
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void applyGoods(List<UccApplyShelvesSplitBO> uccApplyShelvesSplitBOList, List<UccApplyShelvesDetailSplitBO> uccApplyShelvesDetailSplitBOList, String applyNo) {
        log.info("laialialaila");
        for (UccApplyShelvesSplitBO applyPo : uccApplyShelvesSplitBOList) {
            List detailSplitPoList = uccApplyShelvesDetailSplitBOList.stream().filter(po -> po.getApplyId().equals(applyPo.getId())).collect(Collectors.toList());
            applyPo.setDetailSplitPoList(detailSplitPoList);
            applyPo.setApplyNo(applyNo);
            try {
                log.info("\u7533\u8bf7\u4e0a\u67b6\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)applyPo));
                this.applyShelvesVendorServiceProvider.send(new ProxyMessage(this.uccSyncTopic, "*", JSON.toJSONString((Object)applyPo)));
            }
            catch (Exception e) {
                log.error("\u7533\u8bf7\u4e0a\u67b6\u540c\u6b65\u5165\u53c2\u540c\u6b65\u5f02\u5e38:" + e.getMessage());
            }
        }
    }
}

