/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrQryAgreementListByIdsAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementListByIdsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementListByIdsAbilityRspBO;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.atom.api.DuplicateCommitLimit;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.ability.api.UccEstoreSkubatchapplicationsAbilityService;
import com.tydic.commodity.estore.ability.bo.UccEstoreSkubatchapplicationsAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccEstoreSkubatchapplicationsAbilityRspBO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccEstoreSkubatchapplicationsAbilityService"})
public class UccEstoreSkubatchapplicationsAbilityServiceImpl
implements UccEstoreSkubatchapplicationsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccEstoreSkubatchapplicationsAbilityServiceImpl.class);
    @Autowired
    private UccUpAndOffApplyBusiService uccUpAndOffApplyBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Value(value="ESTORE_ON_SHELF_PROCESS")
    private String process;
    @Autowired
    private AgrQryAgreementListByIdsAbilityService agrQryAgreementListByIdsAbilityService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Value(value="${PRICE_UCC_SYNC_MQ_TOPIC:PRICE_UCC_SYNC_MQ_TOPIC}")
    private String uccSyncTopic;
    @Value(value="${PRICE_UCC_SYNC_MQ_TAG:*}")
    private String uccSyncTag;
    @Resource(name="syncPriceMqServiceProvider")
    private ProxyMessageProducer uccSyncPriceMqServiceProvider;

    @DuplicateCommitLimit
    @PostMapping(value={"dealPutOnSelf"})
    public UccEstoreSkubatchapplicationsAbilityRspBO dealPutOnSelf(@RequestBody UccEstoreSkubatchapplicationsAbilityReqBO reqBO) {
        List skuPoList;
        Set agreementIds;
        UccEstoreSkubatchapplicationsAbilityRspBO rspBO = new UccEstoreSkubatchapplicationsAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u4e0a\u67b6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSameLevel() == 1) {
            List skus = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
            ArrayList<Integer> excludeApprovalStatus = new ArrayList<Integer>();
            excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO);
            excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO);
            List sameLevelOtrherSku = this.uccSkuMapper.queySameLevelOtrherSku(skus, null, skuStatus, null, excludeApprovalStatus);
            if (!CollectionUtils.isEmpty((Collection)sameLevelOtrherSku)) {
                sameLevelOtrherSku.stream().forEach(a -> {
                    UccBatchSkuBO bo = new UccBatchSkuBO();
                    bo.setSkuId(a.getSkuId());
                    bo.setSupplierShopId(a.getSupplierShopId());
                    reqBO.getBatchSkuList().add(bo);
                });
            }
        }
        if (!CollectionUtils.isEmpty(agreementIds = (skuPoList = this.uccSkuMapper.batchQrySku(reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList()), null)).stream().map(UccSkuPo::getAgreementId).collect(Collectors.toSet()))) {
            agreementIds.removeIf(Objects::isNull);
            if (!CollectionUtils.isEmpty(agreementIds)) {
                AgrQryAgreementListByIdsAbilityReqBO agrQryAgreementListByIdsAbilityReqBO = new AgrQryAgreementListByIdsAbilityReqBO();
                agrQryAgreementListByIdsAbilityReqBO.setAgreementIds(new ArrayList(agreementIds));
                log.info("\u5165\u53c2agrQryAgreementListByIdsAbilityReqBO:{}" + JSONObject.toJSONString((Object)agrQryAgreementListByIdsAbilityReqBO));
                AgrQryAgreementListByIdsAbilityRspBO agrQryAgreementListByIdsAbilityRspBO = this.agrQryAgreementListByIdsAbilityService.qryAgreementListByIds(agrQryAgreementListByIdsAbilityReqBO);
                log.info("\u51fa\u53c2agrQryAgreementListByIdsAbilityRspBO:{}" + JSONObject.toJSONString((Object)agrQryAgreementListByIdsAbilityRspBO));
                if (!CollectionUtils.isEmpty((Collection)agrQryAgreementListByIdsAbilityRspBO.getAgrAgreementBOList())) {
                    if (agrQryAgreementListByIdsAbilityRspBO.getAgrAgreementBOList().size() != agreementIds.size()) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u534f\u8bae\u67e5\u8be2\u4e3a\u7a7a");
                        return rspBO;
                    }
                    List collect = agrQryAgreementListByIdsAbilityRspBO.getAgrAgreementBOList().stream().filter(e -> e.getAgreementStatus() != 4 && e.getAgreementStatus() != 10).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(collect)) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u4e0d\u80fd\u5bf9\u5546\u54c1\u6240\u5c5e\u534f\u8bae\u672a\u751f\u6548/\u5df2\u5931\u6548\u7684\u5546\u54c1\u8fdb\u884c\u4e0a\u67b6");
                        return rspBO;
                    }
                } else {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u534f\u8bae\u67e5\u8be2\u4e3a\u7a7a");
                    return rspBO;
                }
            }
        }
        List skuIds = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        List skuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
        Map<String, List<UccSkuPo>> splitMapSku = skuPos.stream().collect(Collectors.groupingBy(e -> e.getSupplierShopId() + "-" + e.getSysTenantId()));
        for (String strKey : splitMapSku.keySet()) {
            UccUpAndOffApplyAbilityReqBO busiReqBO = new UccUpAndOffApplyAbilityReqBO();
            UccUpAndOffApplyAbilityRspBO busiRspBO = new UccUpAndOffApplyAbilityRspBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
            List uccBatchSkuBOS = JSON.parseArray((String)JSON.toJSONString(splitMapSku.get(strKey)), UccBatchSkuBO.class);
            busiReqBO.setBatchSkuList(uccBatchSkuBOS);
            ExtReqBO extReqBO = new ExtReqBO();
            extReqBO.setProcess(this.process);
            extReqBO.setAuditObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
            ArrayList<Integer> oldStatus = new ArrayList<Integer>();
            oldStatus.add(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
            extReqBO.setStatusOld(oldStatus);
            extReqBO.setStatusApproval(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
            extReqBO.setStatusApply(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
            extReqBO.setAuditStatusApply(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.toString());
            extReqBO.setOperate(Integer.valueOf(1));
            extReqBO.setRemark("\u624b\u5de5\u4e0a\u67b6");
            try {
                busiRspBO = this.uccUpAndOffApplyBusiService.dealUpAndOffApply(busiReqBO, extReqBO);
                BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
            }
            catch (Exception e2) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e2.getMessage());
                return rspBO;
            }
            if (!"0000".equals(rspBO.getRespCode())) {
                return rspBO;
            }
            Map<Long, List<UccBatchSkuBO>> mapSku = busiReqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
            for (Long supplierShopId : mapSku.keySet()) {
                List skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
                SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e3) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
            if (CollectionUtils.isEmpty((Collection)busiReqBO.getBatchSkuList())) continue;
            try {
                this.uccSyncPriceMqServiceProvider.send(new ProxyMessage(this.uccSyncTopic, this.uccSyncTag, JSON.toJSONString((Object)busiReqBO.getBatchSkuList())));
            }
            catch (Exception e4) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25: " + e4.getMessage());
            }
        }
        return rspBO;
    }
}

