/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.SnowFlake;
import com.tydic.commodity.dao.AbilityProvideOauthMapper;
import com.tydic.commodity.estore.ability.bo.Oauth2ModifyUserReqBo;
import com.tydic.commodity.estore.ability.bo.Oauth2ModifyUserRspBo;
import com.tydic.commodity.estore.ability.bo.Oauth2addUserReqBo;
import com.tydic.commodity.estore.ability.bo.Oauth2addUserRspBo;
import com.tydic.commodity.estore.ability.bo.RefreshTokenReqBo;
import com.tydic.commodity.estore.ability.bo.RefreshTokenRspBo;
import com.tydic.commodity.estore.busi.api.Oauth2PluginUserService;
import com.tydic.commodity.estore.utils.CnncUccOauth2DateUtil;
import com.tydic.commodity.po.AbilityProvideOauthPo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class Oauth2PluginUserServiceImpl
implements Oauth2PluginUserService {
    private static final Logger log = LoggerFactory.getLogger(Oauth2PluginUserServiceImpl.class);
    @Resource
    private AbilityProvideOauthMapper abilityProvideOauthMapper;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${ability.oauth.add.enabled:true}")
    private Boolean addUserEnabled;
    @Value(value="${ability.oauth.refresh.offset:60}")
    private int refreshOffset;
    @Value(value="${ability.oauth.refresh.stand.time:30}")
    private int reqRefreshStandTime;

    @Override
    public Oauth2addUserRspBo addUser(Oauth2addUserReqBo reqBo) {
        try {
            if (Boolean.FALSE.equals(this.addUserEnabled)) {
                throw new ZTBusinessException("\u7528\u6237\u521b\u5efa\u5f02\u5e38");
            }
            AbilityProvideOauthPo addPo = new AbilityProvideOauthPo();
            SnowFlake sequence = new SnowFlake(30L, 29L);
            addPo.setOauthId(String.valueOf(sequence.nextId()));
            addPo.setUsername(reqBo.getUsername());
            addPo.setClientId(reqBo.getClientId());
            addPo.setClusterId(reqBo.getClusterId());
            int randInt = RandomUtil.randomInt((int)9, (int)11);
            String clientSecret = RandomUtil.randomString((int)randInt);
            String clientSecretReal = StringUtils.leftPad((String)StringUtils.left((String)(clientSecret + reqBo.getClusterId() + reqBo.getUsername()), (int)16), (int)16, (String)"@");
            SymmetricCrypto sm4 = SmUtil.sm4((byte[])clientSecretReal.getBytes(CharsetUtil.CHARSET_UTF_8));
            String password = sm4.encryptHex(reqBo.getPassword());
            addPo.setPassword(password);
            addPo.setClientSecret(clientSecret);
            addPo.setAccessTokenValidity(String.valueOf(86400));
            addPo.setStartSwitch(Integer.valueOf(1));
            AbilityProvideOauthPo judgePo = new AbilityProvideOauthPo();
            judgePo.setUsername(reqBo.getUsername());
            judgePo.setClientId(reqBo.getClientId());
            judgePo.setClusterId(reqBo.getClusterId());
            judgePo = this.abilityProvideOauthMapper.selectByAllOne(judgePo);
            if (!ObjectUtils.isEmpty((Object)judgePo)) {
                throw new ZTBusinessException("\u7528\u6237\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            this.abilityProvideOauthMapper.insert(addPo);
            Oauth2addUserRspBo rspBo = new Oauth2addUserRspBo();
            rspBo.setSuccess(Boolean.TRUE.booleanValue());
            rspBo.setResultCode("0000");
            rspBo.setResultMessage("\u7528\u6237\u521b\u5efa\u6210\u529f");
            rspBo.setResult(clientSecret);
            return rspBo;
        }
        catch (Exception e) {
            Oauth2addUserRspBo rspBo = new Oauth2addUserRspBo();
            rspBo.setSuccess(Boolean.FALSE.booleanValue());
            rspBo.setResultCode("9999");
            rspBo.setResultMessage("\u521b\u5efa\u5931\u8d25");
            rspBo.setResult(e.getMessage());
            return rspBo;
        }
    }

    private static JSONObject getAddAppUser(Oauth2addUserReqBo reqBo) {
        JSONObject addAppUserJson = new JSONObject();
        addAppUserJson.put("appCode", (Object)reqBo.getClientId());
        addAppUserJson.put("appContact", (Object)"Oauth2\u63d2\u4ef6");
        addAppUserJson.put("appName", (Object)reqBo.getUsername());
        addAppUserJson.put("appPhone", (Object)"12345678900");
        addAppUserJson.put("isProvider", (Object)"0");
        addAppUserJson.put("remark", (Object)"\u521b\u5efa\u8ba2\u8d2d\u7528\u6237");
        JSONObject appExtColumnReqBo = new JSONObject();
        appExtColumnReqBo.put("appFive", (Object)"\u9ed8\u8ba4");
        appExtColumnReqBo.put("appFour", (Object)"\u9ed8\u8ba4");
        appExtColumnReqBo.put("appOne", (Object)"\u9ed8\u8ba4");
        appExtColumnReqBo.put("appThree", (Object)"\u9ed8\u8ba4");
        appExtColumnReqBo.put("appTwo", (Object)"\u9ed8\u8ba4");
        addAppUserJson.put("appExtColumnReqBO", (Object)appExtColumnReqBo);
        return addAppUserJson;
    }

    @Override
    public RefreshTokenRspBo accessToken(RefreshTokenReqBo reqBo) {
        try {
            if (Boolean.FALSE.equals(this.checkTime(reqBo))) {
                throw new ZTBusinessException("\u65f6\u95f4\u6233\u5df2\u8fc7\u671f\uff01");
            }
            AbilityProvideOauthPo abilityProvideOauthPo = new AbilityProvideOauthPo();
            abilityProvideOauthPo.setUsername(reqBo.getUserName());
            abilityProvideOauthPo.setClientId(reqBo.getClientId());
            abilityProvideOauthPo.setStartSwitch(Integer.valueOf(1));
            String timeFormat = reqBo.getTimestamp().replace(":", "").replace(" ", "");
            SymmetricCrypto sm4 = SmUtil.sm4((byte[])timeFormat.getBytes(CharsetUtil.CHARSET_UTF_8));
            String clientSecret = sm4.decryptStr(reqBo.getClientSecret(), CharsetUtil.CHARSET_UTF_8);
            abilityProvideOauthPo.setClientSecret(clientSecret);
            abilityProvideOauthPo = this.abilityProvideOauthMapper.selectByAllOne(abilityProvideOauthPo);
            if (ObjectUtils.isEmpty((Object)abilityProvideOauthPo)) {
                RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
                rspBo.setSuccess(Boolean.FALSE.booleanValue());
                rspBo.setResultCode("9999");
                rspBo.setResultMessage("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
                return rspBo;
            }
            String password = sm4.decryptStr(reqBo.getUserPassword(), CharsetUtil.CHARSET_UTF_8);
            String clientSecretReal = StringUtils.leftPad((String)StringUtils.left((String)(clientSecret + abilityProvideOauthPo.getClusterId() + reqBo.getUserName()), (int)16), (int)16, (String)"@");
            SymmetricCrypto clientSecretSm4 = SmUtil.sm4((byte[])clientSecretReal.getBytes(CharsetUtil.CHARSET_UTF_8));
            if (!abilityProvideOauthPo.getPassword().equals(clientSecretSm4.encryptHex(password, CharsetUtil.CHARSET_UTF_8))) {
                RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
                rspBo.setSuccess(Boolean.FALSE.booleanValue());
                rspBo.setResultCode("9999");
                rspBo.setResultMessage("\u9274\u6743\u5931\u8d25\uff01");
                return rspBo;
            }
            ArrayList<String> roles = new ArrayList<String>();
            roles.add(reqBo.getClientId());
            String token = this.createToken(reqBo.getUserName(), clientSecret, roles, Long.parseLong(abilityProvideOauthPo.getAccessTokenValidity()) * 1000L);
            AbilityProvideOauthPo tokenPo = new AbilityProvideOauthPo();
            tokenPo.setOauthId(abilityProvideOauthPo.getOauthId());
            tokenPo.setAccessToken(token);
            this.abilityProvideOauthMapper.updateByPrimaryKeySelective(tokenPo);
            String oldToken = "Mall-OAuth-" + reqBo.getHsn().toUpperCase() + "-" + abilityProvideOauthPo.getAccessToken();
            Object obj = this.cacheClient.get(oldToken);
            if (!ObjectUtils.isEmpty((Object)obj)) {
                this.cacheClient.expire(oldToken, this.refreshOffset);
                log.info("\u7528\u6237\uff1a{} \u5386\u53f2token\uff1a{}  {}s\u540e\u5931\u6548...", new Object[]{reqBo.getUserName(), abilityProvideOauthPo.getAccessToken(), this.refreshOffset});
            }
            String tokenKey = "Mall-OAuth-" + reqBo.getHsn().toUpperCase() + "-" + token;
            this.cacheClient.set(tokenKey, (Object)reqBo.getClientId(), Integer.parseInt(abilityProvideOauthPo.getAccessTokenValidity()));
            RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
            rspBo.setSuccess(Boolean.TRUE.booleanValue());
            rspBo.setResultCode("0000");
            rspBo.setResultMessage("\u5237\u65b0\u6210\u529f");
            RefreshTokenRspBo.TokenRspBO tokenRspBo = new RefreshTokenRspBo.TokenRspBO();
            tokenRspBo.setAccess_token(token);
            tokenRspBo.setRefresh_token(token);
            tokenRspBo.setTime(CnncUccOauth2DateUtil.getCurrentDateTime());
            tokenRspBo.setExpires_in(Long.valueOf(Long.parseLong(abilityProvideOauthPo.getAccessTokenValidity())));
            rspBo.setResult(tokenRspBo);
            return rspBo;
        }
        catch (ZTBusinessException zte) {
            log.error(zte.getMessage(), (Throwable)zte);
            RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
            rspBo.setSuccess(Boolean.FALSE.booleanValue());
            rspBo.setResultCode("9999");
            rspBo.setResultMessage(zte.getMessage());
            return rspBo;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
            rspBo.setSuccess(Boolean.FALSE.booleanValue());
            rspBo.setResultCode("9999");
            rspBo.setResultMessage("\u9a8c\u7b7e\u5931\u8d25!");
            return rspBo;
        }
    }

    @Override
    public Oauth2ModifyUserRspBo modifyUserPassword(Oauth2ModifyUserReqBo reqBo) {
        AbilityProvideOauthPo judgePo = this.checkAuthId(reqBo.getOauthId());
        String clientSecretReal = StringUtils.leftPad((String)StringUtils.left((String)(judgePo.getClientSecret() + judgePo.getClusterId() + judgePo.getUsername()), (int)16), (int)16, (String)"@");
        SymmetricCrypto sm4 = SmUtil.sm4((byte[])clientSecretReal.getBytes(CharsetUtil.CHARSET_UTF_8));
        String password = sm4.encryptHex(reqBo.getOldPassword());
        if (!Objects.equals(password, judgePo.getPassword())) {
            throw new ZTBusinessException("\u5386\u53f2\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
        }
        password = sm4.encryptHex(reqBo.getNewPassword());
        AbilityProvideOauthPo modifyPo = new AbilityProvideOauthPo();
        modifyPo.setOauthId(reqBo.getOauthId());
        modifyPo.setPassword(password);
        this.abilityProvideOauthMapper.updateByPrimaryKeySelective(modifyPo);
        Oauth2ModifyUserRspBo rspBo = new Oauth2ModifyUserRspBo();
        rspBo.setSuccess(Boolean.TRUE.booleanValue());
        rspBo.setResultCode("0000");
        rspBo.setResultMessage("\u5bc6\u7801\u4fee\u6539\u6210\u529f");
        return rspBo;
    }

    private String createToken(String username, String secretKey, List<String> roles, long validityInMs) {
        Claims claims = Jwts.claims().setSubject(username);
        claims.put((Object)"roles", roles);
        Date now = new Date();
        Date validity = new Date(now.getTime() + validityInMs);
        return Jwts.builder().setClaims(claims).setIssuedAt(now).setExpiration(validity).signWith(SignatureAlgorithm.HS256, secretKey).compact();
    }

    private Boolean checkTime(RefreshTokenReqBo reqBo) {
        DateTime reqTime = DateUtil.parse((CharSequence)reqBo.getTimestamp());
        Date nowTime = new Date();
        long day = DateUtil.between((Date)reqTime, (Date)nowTime, (DateUnit)DateUnit.DAY);
        long minute = DateUtil.between((Date)reqTime, (Date)nowTime, (DateUnit)DateUnit.MINUTE) - day * 24L * 60L;
        return minute > (long)this.reqRefreshStandTime ? Boolean.FALSE : Boolean.TRUE;
    }

    private AbilityProvideOauthPo checkAuthId(String oauthId) {
        AbilityProvideOauthPo judgePo = new AbilityProvideOauthPo();
        judgePo.setOauthId(oauthId);
        judgePo = this.abilityProvideOauthMapper.selectByAllOne(judgePo);
        if (ObjectUtils.isEmpty((Object)judgePo)) {
            throw new ZTBusinessException("\u8d26\u53f7\u67e5\u8be2\u5f02\u5e38\uff01");
        }
        return judgePo;
    }
}

