/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.AddCoefficientBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.busibase.busi.api.UccMasterDataCategoryQryBusiService;
import com.tydic.commodity.busibase.busi.bo.UccMasterDataAllCategoryBO;
import com.tydic.commodity.busibase.busi.bo.UccMasterDataCategoryQryReqBO;
import com.tydic.commodity.busibase.busi.bo.UccMasterDataCategoryQryRspBO;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.estore.busi.api.UccCommdAddCoefficientQryBusiService;
import com.tydic.commodity.estore.busi.bo.UccCommdAddCoefficientQryReqBO;
import com.tydic.commodity.estore.busi.bo.UccCommdAddCoefficientQryRspBO;
import com.tydic.commodity.po.UccAddCoefficientPO;
import com.tydic.commodity.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccCommdAddCoefficientQryBusiServiceImpl
implements UccCommdAddCoefficientQryBusiService {
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccMasterDataCategoryQryBusiService uccMasterDataCategoryQryBusiService;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommdAddCoefficientQryBusiServiceImpl.class);

    @Override
    public UccCommdAddCoefficientQryRspBO qryCoefficient(UccCommdAddCoefficientQryReqBO reqBO) {
        UccCommdAddCoefficientQryRspBO rspBO = new UccCommdAddCoefficientQryRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        try {
            UccAddCoefficientPO uccAddCoefficientPO = new UccAddCoefficientPO();
            uccAddCoefficientPO.setMinAddPrice(reqBO.getAddPriceStar());
            uccAddCoefficientPO.setMaxAddPrice(reqBO.getAddPriceEnd());
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccAddCoefficientPO);
            List uccAddCoefficientPOList = this.uccAddCoefficientMapper.qryAddCoefficient(uccAddCoefficientPO, page);
            if (uccAddCoefficientPOList != null && uccAddCoefficientPOList.size() > 0) {
                ArrayList<AddCoefficientBO> addCoefficientBOList = new ArrayList<AddCoefficientBO>();
                Map ruleMap = this.uccDictionaryAtomService.queryBypCodeBackMap("ADD_COEFFICIENT_RULE");
                for (UccAddCoefficientPO po : uccAddCoefficientPOList) {
                    AddCoefficientBO addCoefficientBO = new AddCoefficientBO();
                    BeanUtils.copyProperties((Object)po, (Object)addCoefficientBO);
                    addCoefficientBO.setCatalogAddCoefficient(po.getAddCoefficient());
                    if (po.getUpdateTime() != null) {
                        addCoefficientBO.setUpdateTime(DateUtils.dateToStr((Date)po.getUpdateTime()));
                    }
                    if (po.getAllowMarketPrice() == 0) {
                        addCoefficientBO.setAllowMarketPriceText("\u5426");
                    }
                    if (po.getAllowMarketPrice() == 1) {
                        addCoefficientBO.setAllowMarketPriceText("\u662f");
                    }
                    if (ruleMap.containsKey(po.getRule().toString())) {
                        addCoefficientBO.setRuleDesc((String)ruleMap.get(po.getRule().toString()));
                    }
                    UccMasterDataCategoryQryReqBO uccMasterDataCategoryQryReqBO = new UccMasterDataCategoryQryReqBO();
                    uccMasterDataCategoryQryReqBO.setCatalogId(po.getCatalogId());
                    UccMasterDataCategoryQryRspBO uccMasterDataCategoryQryRspBO = this.uccMasterDataCategoryQryBusiService.qryAllParentCataById(uccMasterDataCategoryQryReqBO);
                    if ("0000".equals(uccMasterDataCategoryQryRspBO.getRespCode())) {
                        String catalogAllName = "";
                        UccMasterDataAllCategoryBO uccMasterDataAllCategoryBO = uccMasterDataCategoryQryRspBO.getAllCategoryInfo();
                        if (uccMasterDataAllCategoryBO.getGuideCatalogName1() != null) {
                            catalogAllName = catalogAllName + uccMasterDataAllCategoryBO.getGuideCatalogName1();
                        }
                        if (uccMasterDataAllCategoryBO.getGuideCatalogName2() != null) {
                            catalogAllName = catalogAllName + "/" + uccMasterDataAllCategoryBO.getGuideCatalogName2();
                        }
                        if (uccMasterDataAllCategoryBO.getGuideCatalogName3() != null) {
                            catalogAllName = catalogAllName + "/" + uccMasterDataAllCategoryBO.getGuideCatalogName3();
                        }
                        if (uccMasterDataAllCategoryBO.getGuideCatalogName4() != null) {
                            catalogAllName = catalogAllName + "/" + uccMasterDataAllCategoryBO.getGuideCatalogName4();
                        }
                        addCoefficientBO.setCatalogName(catalogAllName);
                    }
                    addCoefficientBOList.add(addCoefficientBO);
                }
                rspBO.setRows(addCoefficientBOList);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u5f02\u5e38");
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

