/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.comb.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.GovernRspBO;
import com.tydic.commodity.busibase.atom.api.UccSendHttpAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSendHttpAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSendHttpAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccSyncDataFailBusiService;
import com.tydic.commodity.busibase.busi.bo.UccSyncDataFailBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccSyncDataFailBusiRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.estore.comb.api.UccSyncGovernPriceCombService;
import com.tydic.commodity.estore.comb.bo.UccSyncGovernPriceCombReqBO;
import com.tydic.commodity.estore.comb.bo.UccSyncGovernPriceCombRspBO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.DateUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSyncGovernPriceCombServiceImpl
implements UccSyncGovernPriceCombService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncGovernPriceCombServiceImpl.class);
    @Autowired
    private UccSendHttpAtomService uccSendHttpAtomService;
    @Autowired
    private UccSyncDataFailBusiService uccSyncDataFailBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    private Sequence sequenceUtil = Sequence.getInstance();
    @Value(value="${SNYC_GOVERN_PRICE_URL}")
    private String syncGovernPriceUrl;
    @Value(value="${SNYC_GOVERN_SKU_POOLNAME}")
    private String snycGovernSkupoolName;

    @Override
    public UccSyncGovernPriceCombRspBO syncGovernPrice(UccSyncGovernPriceCombReqBO reqBO) {
        UccSyncGovernPriceCombRspBO rspBO = new UccSyncGovernPriceCombRspBO();
        rspBO.setRespCode("0000");
        if (reqBO.getSkuId() == null) {
            return rspBO;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBO.getSkuId());
        List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            return rspBO;
        }
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(reqBO.getSkuId());
        uccSkuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (uccSkuPricePo == null) {
            return rspBO;
        }
        JSONArray array = new JSONArray();
        JSONObject purchase = new JSONObject();
        purchase.put("skuId", (Object)((UccSkuPo)uccSkuPoList.get(0)).getSkuId().toString());
        purchase.put("extSkuId", (Object)((UccSkuPo)uccSkuPoList.get(0)).getExtSkuId());
        purchase.put("changeTime", (Object)DateUtils.dateToStr((Date)uccSkuPricePo.getUpdateTime()));
        purchase.put("priceType", (Object)"purchase");
        purchase.put("priceValue", (Object)uccSkuPricePo.getAgreementPrice());
        array.add((Object)purchase);
        JSONObject market = new JSONObject();
        market.put("skuId", (Object)((UccSkuPo)uccSkuPoList.get(0)).getSkuId().toString());
        market.put("extSkuId", (Object)((UccSkuPo)uccSkuPoList.get(0)).getExtSkuId());
        market.put("changeTime", (Object)DateUtils.dateToStr((Date)uccSkuPricePo.getUpdateTime()));
        market.put("priceType", (Object)"market");
        market.put("priceValue", (Object)uccSkuPricePo.getMarketPrice());
        array.add((Object)market);
        JSONObject sales = new JSONObject();
        sales.put("skuId", (Object)((UccSkuPo)uccSkuPoList.get(0)).getSkuId().toString());
        sales.put("extSkuId", (Object)((UccSkuPo)uccSkuPoList.get(0)).getExtSkuId());
        sales.put("changeTime", (Object)DateUtils.dateToStr((Date)uccSkuPricePo.getUpdateTime()));
        sales.put("priceType", (Object)"sales");
        sales.put("priceValue", (Object)uccSkuPricePo.getSalePrice());
        array.add((Object)sales);
        JSONObject skuPricelist = new JSONObject();
        skuPricelist.put("skuPricelist", (Object)array);
        String serialNo = String.valueOf(this.sequenceUtil.nextId());
        JSONObject reqJson = new JSONObject();
        reqJson.put("serialNo", (Object)serialNo);
        reqJson.put("poolName", (Object)this.snycGovernSkupoolName);
        reqJson.put("data", (Object)skuPricelist);
        UccSendHttpAtomReqBO sendHttpAtomReqBO = new UccSendHttpAtomReqBO();
        sendHttpAtomReqBO.setUrl(this.syncGovernPriceUrl);
        sendHttpAtomReqBO.setParams(JSONObject.toJSONString((Object)reqJson));
        UccSendHttpAtomRspBO uccSendHttpAtomRspBO = this.uccSendHttpAtomService.sendHttpRequst(sendHttpAtomReqBO);
        if ("0000".equals(uccSendHttpAtomRspBO.getRespCode())) {
            GovernRspBO governRspBO = (GovernRspBO)JSONObject.parseObject((String)uccSendHttpAtomRspBO.getResult(), GovernRspBO.class);
            if (!("0000".equals(governRspBO.getRespCode()) || "1111".equals(governRspBO.getRespCode()) || "4444".equals(governRspBO.getRespCode()))) {
                UccSyncDataFailBusiReqBO failBusiReqBO = new UccSyncDataFailBusiReqBO();
                failBusiReqBO.setType(Integer.valueOf(2));
                failBusiReqBO.setSerialNo(serialNo);
                failBusiReqBO.setSource(Arrays.asList(reqBO.getSkuId()));
                failBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
                failBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
                UccSyncDataFailBusiRspBO uccSyncDataFailBusiRspBO = this.uccSyncDataFailBusiService.addRecords(failBusiReqBO);
                if (!"0000".equals(uccSyncDataFailBusiRspBO.getRespCode())) {
                    log.error(uccSyncDataFailBusiRspBO.getRespDesc());
                }
            }
        } else {
            UccSyncDataFailBusiReqBO failBusiReqBO = new UccSyncDataFailBusiReqBO();
            failBusiReqBO.setType(Integer.valueOf(2));
            failBusiReqBO.setSerialNo(serialNo);
            failBusiReqBO.setSource(Arrays.asList(reqBO.getSkuId()));
            failBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
            failBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
            UccSyncDataFailBusiRspBO uccSyncDataFailBusiRspBO = this.uccSyncDataFailBusiService.addRecords(failBusiReqBO);
            if (!"0000".equals(uccSyncDataFailBusiRspBO.getRespCode())) {
                log.error(uccSyncDataFailBusiRspBO.getRespDesc());
            }
        }
        return rspBO;
    }
}

