/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import com.tydic.commodity.common.ability.api.UccSkuManagementListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.dao.UccApplyShelvesDetailSplitMapper;
import com.tydic.commodity.estore.ability.api.PurchaseQryShelvesSkuListAbilityService;
import com.tydic.commodity.estore.ability.bo.PurchaseQryShelvesSkuListAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.PurchaseQryShelvesSkuListAbilityRspBO;
import com.tydic.commodity.estore.ability.bo.PurchaseQryShelvesSkuListBo;
import com.tydic.commodity.po.UccApplyShelvesDetailSplitPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.PurchaseQryShelvesSkuListAbilityService"})
public class PurchaseQryShelvesSkuListAbilityServiceImpl
implements PurchaseQryShelvesSkuListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseQryShelvesSkuListAbilityServiceImpl.class);
    @Autowired
    private UccApplyShelvesDetailSplitMapper uccApplyShelvesDetailSplitMapper;
    @Autowired
    private UccSkuManagementListQryAbilityService uccSkuManagementListQryAbilityService;

    @PostMapping(value={"qryShelvesSkuList"})
    public PurchaseQryShelvesSkuListAbilityRspBO qryShelvesSkuList(@RequestBody PurchaseQryShelvesSkuListAbilityReqBO reqBO) {
        PurchaseQryShelvesSkuListAbilityRspBO abilityRspBO = new PurchaseQryShelvesSkuListAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty((Collection)reqBO.getDemandList())) {
            return abilityRspBO;
        }
        List shelvesDetailSplitPOS = this.uccApplyShelvesDetailSplitMapper.qryDemandSku(reqBO.getDemandList());
        if (CollectionUtils.isEmpty((Collection)shelvesDetailSplitPOS)) {
            return abilityRspBO;
        }
        List skus = shelvesDetailSplitPOS.stream().filter(a -> a.getSkuId() != null).map(UccApplyShelvesDetailSplitPO::getSkuId).collect(Collectors.toList());
        UccSkuManagementListQryAbilityReqBO abilityReqBO = new UccSkuManagementListQryAbilityReqBO();
        abilityReqBO.setExportSkuIds(skus);
        UccSkuManagementListQryAbilityRspBO skuManagementListQryAbilityRspBO = this.uccSkuManagementListQryAbilityService.getSkuManagementListQry(abilityReqBO);
        if (!"0000".equals(skuManagementListQryAbilityRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)skuManagementListQryAbilityRspBO, (Object)abilityRspBO);
            return abilityRspBO;
        }
        Map skuMap = skuManagementListQryAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccSkuManagementListQryBO::getSkuId, Function.identity()));
        ArrayList rows = new ArrayList();
        shelvesDetailSplitPOS.stream().forEach(a -> {
            PurchaseQryShelvesSkuListBo bo = new PurchaseQryShelvesSkuListBo();
            bo.setDemandId(a.getPurchaseDemandId());
            bo.setVendorId(a.getSupplierId());
            bo.setVendorName(a.getSupplierName());
            bo.setSkuId(a.getSkuId());
            if (skuMap.containsKey(a.getSkuId())) {
                bo.setSkuName(((UccSkuManagementListQryBO)skuMap.get(a.getSkuId())).getSkuName());
                bo.setSkuStatus(((UccSkuManagementListQryBO)skuMap.get(a.getSkuId())).getSkuStatus());
            }
            rows.add(bo);
        });
        abilityRspBO.setRows(rows);
        return abilityRspBO;
    }
}

