/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.UccApplyShelvesDetailSplitMapper;
import com.tydic.commodity.dao.UccApplyShelvesSplitMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.estore.ability.bo.UccApplyShelvesDetailSplitBO;
import com.tydic.commodity.estore.atom.api.UccApplyAddGoodsInterService;
import com.tydic.commodity.estore.atom.bo.UccApplyAddGoodsReqBO;
import com.tydic.commodity.estore.atom.bo.UccApplyAddGoodsRspBO;
import com.tydic.commodity.estore.atom.bo.UccApplyAddSkuSpecBO;
import com.tydic.commodity.estore.busi.api.UccApplyShelvesVendorBusiService;
import com.tydic.commodity.estore.busi.bo.UccApplyShelvesVendorBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccApplyShelvesVendorBusiRspBO;
import com.tydic.commodity.po.SupplierBusiPo;
import com.tydic.commodity.po.UccApplyShelvesDetailSplitPO;
import com.tydic.commodity.po.UccApplyShelvesSplitPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UccApplyShelvesVendorBusiServiceImpl
implements UccApplyShelvesVendorBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccApplyShelvesVendorBusiServiceImpl.class);
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccApplyAddGoodsInterService uccApplyAddGoodsInterService;
    @Autowired
    private UccApplyShelvesSplitMapper uccApplyShelvesSplitMapper;
    @Autowired
    private UccApplyShelvesDetailSplitMapper uccApplyShelvesDetailSplitMapper;

    @Override
    public UccApplyShelvesVendorBusiRspBO dealSnycVendor(UccApplyShelvesVendorBusiReqBO reqBO) {
        UccApplyShelvesVendorBusiRspBO rspBO = new UccApplyShelvesVendorBusiRspBO();
        rspBO.setRespCode("0000");
        if (reqBO.getSplitBO() == null) {
            return rspBO;
        }
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(reqBO.getSplitBO().getSupplierId());
        if (null == supplierBusiPo || !StringUtils.hasText((String)supplierBusiPo.getSupplierCode())) {
            log.error("{}\uff0c\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u4fe1\u606f", (Object)reqBO.getSplitBO().getSupplierId());
        }
        Long commodityTypeId = ((UccApplyShelvesDetailSplitBO)reqBO.getSplitBO().getDetailSplitPoList().get(0)).getCommodityTypeId();
        ArrayList<String> catalogCode = new ArrayList<String>();
        if (commodityTypeId != null) {
            UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(commodityTypeId);
            if (null == uccCommodityTypePo || null == uccCommodityTypePo.getCatalogId()) {
                log.error("{}\uff0c\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u672a\u67e5\u8be2\u5230\u5546\u54c1\u7c7b\u578b\u4fe1\u606f", (Object)commodityTypeId);
            }
            UccEMdmCatalogPO uccEMdmCatalogPo = this.uccEMdmCatalogMapper.queryByCatId(uccCommodityTypePo.getCatalogId());
            while (null != uccEMdmCatalogPo) {
                catalogCode.add(uccEMdmCatalogPo.getCatalogId().toString());
                if (null == uccEMdmCatalogPo.getParentCatalogId()) break;
                uccEMdmCatalogPo = this.uccEMdmCatalogMapper.queryByCatId(uccEMdmCatalogPo.getParentCatalogId());
            }
            Collections.reverse(catalogCode);
        }
        ArrayList<UccApplyAddSkuSpecBO> spuSpec = new ArrayList<UccApplyAddSkuSpecBO>();
        reqBO.getSplitBO().getDetailSplitPoList().forEach(applyDetailPo -> {
            UccApplyAddSkuSpecBO bo = new UccApplyAddSkuSpecBO();
            bo.setSkuName(applyDetailPo.getSkuName());
            bo.setSpec(applyDetailPo.getSpec());
            bo.setModel(applyDetailPo.getModel());
            BigDecimal finalNum = applyDetailPo.getNum().subtract(new BigDecimal(applyDetailPo.getNum().intValue()));
            bo.setNum(finalNum.compareTo(BigDecimal.ZERO) == 0 ? String.valueOf(applyDetailPo.getNum().intValue()) : applyDetailPo.getNum().toPlainString());
            bo.setTime(applyDetailPo.getUseDate());
            bo.setAnnex(applyDetailPo.getAnnex());
            bo.setReference(applyDetailPo.getReference());
            bo.setProvince(applyDetailPo.getProvinceName());
            bo.setCity(applyDetailPo.getCityName());
            bo.setArea(applyDetailPo.getAreaName());
            bo.setTowns(applyDetailPo.getTownsName());
            bo.setReqMobile(applyDetailPo.getOperMobile());
            bo.setReqName(applyDetailPo.getOperUserName());
            bo.setImage(applyDetailPo.getImage());
            bo.setImageName(applyDetailPo.getImageName());
            spuSpec.add(bo);
        });
        UccApplyAddGoodsReqBO uccApplyAddGoodsReqBo = new UccApplyAddGoodsReqBO();
        uccApplyAddGoodsReqBo.setSpuSpec(spuSpec);
        uccApplyAddGoodsReqBo.setMainApplyNo(reqBO.getSplitBO().getApplyNo());
        uccApplyAddGoodsReqBo.setApplyNo(reqBO.getSplitBO().getId().toString());
        uccApplyAddGoodsReqBo.setCatalog(catalogCode);
        uccApplyAddGoodsReqBo.setSupplierCode(supplierBusiPo.getSupplierCode());
        uccApplyAddGoodsReqBo.setProvince(reqBO.getSplitBO().getProvinceName());
        uccApplyAddGoodsReqBo.setCity(reqBO.getSplitBO().getCityName());
        uccApplyAddGoodsReqBo.setArea(reqBO.getSplitBO().getAreaName());
        uccApplyAddGoodsReqBo.setTowns(reqBO.getSplitBO().getTownsName());
        uccApplyAddGoodsReqBo.setMobile(reqBO.getSplitBO().getOperMobile());
        uccApplyAddGoodsReqBo.setName(reqBO.getSplitBO().getOperUserName());
        UccApplyAddGoodsRspBO uccApplyAddGoodsRspBo = this.uccApplyAddGoodsInterService.applyAddGoods(uccApplyAddGoodsReqBo);
        if (!"0000".equals(uccApplyAddGoodsRspBo.getRespCode())) {
            log.error("\u5411\u4f9b\u5e94\u5546\u63d0\u4ea4\u7533\u8bf7\u65b0\u589e\u5546\u54c1\u5931\u8d25\uff01" + uccApplyAddGoodsRspBo.getResultMessage());
            UccApplyShelvesSplitPO uccApplyShelvesSplitPo = new UccApplyShelvesSplitPO();
            uccApplyShelvesSplitPo.setId(reqBO.getSplitBO().getId());
            this.uccApplyShelvesSplitMapper.deleteBy(uccApplyShelvesSplitPo);
            UccApplyShelvesDetailSplitPO uccApplyShelvesDetailSplitPo = new UccApplyShelvesDetailSplitPO();
            uccApplyShelvesDetailSplitPo.setApplyId(reqBO.getSplitBO().getId());
            this.uccApplyShelvesDetailSplitMapper.deleteBy(uccApplyShelvesDetailSplitPo);
            BeanUtils.copyProperties((Object)((Object)uccApplyAddGoodsRspBo), (Object)((Object)rspBO));
        }
        return rspBO;
    }
}

