/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.base.bo.SkuPriceBo;
import com.tydic.commodity.base.enumType.CommodityStatusEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCyclePircePercentageMapper;
import com.tydic.commodity.dao.UccIntervalPircePercentageMapper;
import com.tydic.commodity.dao.UccPricePreventLogMapper;
import com.tydic.commodity.dao.UccPricePreventMapper;
import com.tydic.commodity.dao.UccSkuAutoDownMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.estore.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.estore.busi.api.UccMqSyncCommdPriceBusiService;
import com.tydic.commodity.estore.busi.api.UccSkuAdjustPriceBusiService;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceReqBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceRspBo;
import com.tydic.commodity.estore.busi.bo.UccSkuAdjustPriceReqBO;
import com.tydic.commodity.estore.comb.bo.UccExecuteCommdMsgCombRspBO;
import com.tydic.commodity.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.po.ECommercePriceChangePO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCyclePircePercentagePO;
import com.tydic.commodity.po.UccPricePreventPO;
import com.tydic.commodity.po.UccSkuAutoDownPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.UmcQrySupSignTypeListAbilityService;
import com.tydic.umc.general.ability.bo.UmcQrySupSignTypeBO;
import com.tydic.umc.general.ability.bo.UmcQrySupSignTypeListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQrySupSignTypeListAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMqSyncCommdPriceBusiServiceImpl
implements UccMqSyncCommdPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMqSyncCommdPriceBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuAutoDownMapper uccSkuAutoDownMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private UccSkuAdjustPriceBusiService uccSkuAdjustPriceBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    private Sequence coefficientSequence = Sequence.getInstance();
    @Autowired
    private UccIntervalPircePercentageMapper uccIntervalPircePercentageMapper;
    @Autowired
    private UccCyclePircePercentageMapper uccCyclePircePercentageMapper;
    @Autowired
    private BatchUpdateCommoStatusForMarketService batchUpdateCommoStatusForMarket;
    @Autowired
    private UccPricePreventMapper uccPricePreventMapper;
    @Autowired
    private UccPricePreventLogMapper uccPricePreventLogMapper;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UmcQrySupSignTypeListAbilityService umcQrySupSignTypeListAbilityService;

    @Override
    public MqSyncCommdPriceRspBo dealSync(MqSyncCommdPriceReqBo mqSyncCommdPriceReqBo) throws ZTBusinessException {
        MqSyncCommdPriceRspBo rspBo = new MqSyncCommdPriceRspBo();
        if (CollectionUtils.isEmpty(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List skuIds = mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList().stream().map(MqSyncCommdPriceBo::getSkuId).collect(Collectors.toList());
        UccSkuPo qryPO = new UccSkuPo();
        qryPO.setSkuIds(skuIds);
        List skuPoList = this.uccSkuMapper.qerySku(qryPO);
        Map<Long, UccSkuPo> skuPOMap = skuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, Function.identity()));
        for (MqSyncCommdPriceBo each : mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList()) {
            UccSkuAdjustPriceReqBO uccSkuAdjustPriceReqBO = new UccSkuAdjustPriceReqBO();
            uccSkuAdjustPriceReqBO.setSkuId(each.getSkuId());
            uccSkuAdjustPriceReqBO.setSupplierShopId(each.getSupplierShopId());
            SkuPriceBo skuPriceBo = new SkuPriceBo();
            uccSkuAdjustPriceReqBO.setUpdateSkuPriceInfo(skuPriceBo);
            uccSkuAdjustPriceReqBO.setSysTenantId(mqSyncCommdPriceReqBo.getSysTenantId());
            uccSkuAdjustPriceReqBO.setSysTenantName(mqSyncCommdPriceReqBo.getSysTenantName());
            skuPriceBo.setSalePrice(each.getSalePrice());
            skuPriceBo.setAgreementPrice(each.getAgreementPrice());
            skuPriceBo.setMarketPrice(each.getMarketPrice());
            try {
                this.uccSkuAdjustPriceBusiService.dealSkuAdjustPrice(uccSkuAdjustPriceReqBO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
        }
        this.checkSingle(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList(), skuPOMap, mqSyncCommdPriceReqBo.getSysTenantName());
        List mqSyncCommdPriceBoList = mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList().stream().filter(a -> a.getDown() == false).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(mqSyncCommdPriceBoList)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        try {
            this.dealUpFloatNew(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList(), skuPOMap, mqSyncCommdPriceReqBo.getSysTenantName());
        }
        catch (Exception e) {
            log.error("\u4ef7\u683c\u9884\u8b66\u5f02\u5e38\uff1a" + e.getMessage());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<UccExecuteCommdMsgCombRspBO> dealUpFloatNew(List<MqSyncCommdPriceBo> bos, Map<Long, UccSkuPo> skuPOMap, String sysTenantName) {
        ArrayList<UccExecuteCommdMsgCombRspBO> listRsp = new ArrayList<UccExecuteCommdMsgCombRspBO>();
        if (!CollectionUtils.isEmpty(bos)) {
            boolean flag = false;
            ArrayList<Long> commoditys = new ArrayList<Long>();
            ArrayList<UccPricePreventPO> uccPricePreventPOS = new ArrayList<UccPricePreventPO>();
            ArrayList<ECommercePriceChangePO> eCommercePriceChangePOList = new ArrayList<ECommercePriceChangePO>();
            ArrayList<ECommercePriceChangeLogPO> eCommercePriceChangeLogPOS = new ArrayList<ECommercePriceChangeLogPO>();
            for (MqSyncCommdPriceBo bo : bos) {
                BigDecimal agreementPrice = MoneyUtils.haoToYuan((Long)bo.getAgreementPrice());
                BigDecimal oldAgreementPrice = MoneyUtils.haoToYuan((Long)bo.getOldAgreementPrice());
                UccPricePreventPO uccPricePreventPO = new UccPricePreventPO();
                uccPricePreventPO.setBeforePrice(new BigDecimal(bo.getOldAgreementPrice().toString()));
                uccPricePreventPO.setPrice(new BigDecimal(bo.getAgreementPrice().toString()));
                uccPricePreventPO.setSupplierShopId(bo.getSupplierShopId());
                uccPricePreventPO.setUpdateTime(new Date());
                uccPricePreventPO.setSkuId(bo.getSkuId());
                uccPricePreventPO.setSkuName(bo.getSkuName());
                uccPricePreventPO.setBrandId(bo.getBrandId());
                uccPricePreventPO.setExtSkuId(bo.getExtSkuId());
                uccPricePreventPO.setOnShelveTime(bo.getOnShelveTime());
                uccPricePreventPO.setIsDown(Integer.valueOf(0));
                if (skuPOMap.containsKey(bo.getSkuId())) {
                    uccPricePreventPO.setSysTenantId(skuPOMap.get(bo.getSkuId()).getSysTenantId());
                }
                uccPricePreventPO.setSysTenantName(sysTenantName);
                if (!flag) {
                    UccCyclePircePercentagePO modelBy;
                    List list;
                    Map<Long, List<UccCyclePircePercentagePO>> collect;
                    log.info("\u8fdb\u5165\u4ef7\u683c\u5468\u671f\u9884\u8b66\u5224\u65ad---------------------------------------");
                    UccCyclePircePercentagePO uccCyclePircePercentagePO = new UccCyclePircePercentagePO();
                    if (skuPOMap.containsKey(bo.getSkuId())) {
                        uccCyclePircePercentagePO.setSysTenantId(skuPOMap.get(bo.getSkuId()).getSysTenantId());
                    }
                    if ((collect = (list = this.uccCyclePircePercentageMapper.getList(uccCyclePircePercentagePO)).stream().collect(Collectors.groupingBy(UccCyclePircePercentagePO::getVendorID))).containsKey(bo.getSupplierShopId())) {
                        modelBy = collect.get(bo.getSupplierShopId()).get(0);
                        log.info(bo.getSupplierShopId() + "\u4f9b\u5e94\u5546\u7684\u4f8b\u5916\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)modelBy));
                    } else {
                        modelBy = collect.get(0L).get(0);
                        log.info("\u6ca1\u6709\u4f8b\u5916\u914d\u7f6e\uff0c\u8fd9\u662f'\u5168\u90e8'\u7684\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)modelBy));
                    }
                    if (modelBy != null) {
                        BigDecimal downPrevent;
                        ECommercePriceChangeLogPO eCommercePriceChangePO = new ECommercePriceChangeLogPO();
                        eCommercePriceChangePO.setSkuId(bo.getSkuId());
                        eCommercePriceChangePO.setSupplierShopId(bo.getSupplierShopId());
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
                        Calendar calendar1 = Calendar.getInstance();
                        calendar1.add(5, 0 - modelBy.getDate());
                        Date updateTime = calendar1.getTime();
                        eCommercePriceChangePO.setUpdateTime(updateTime);
                        List poList = this.eCommercePriceChangeLogMapper.queryCountNew(eCommercePriceChangePO);
                        BigDecimal lowestPrice = null;
                        if (!CollectionUtils.isEmpty((Collection)poList)) {
                            BigDecimal sum = poList.stream().map(ECommercePriceChangeLogPO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                            oldAgreementPrice = sum.add(((ECommercePriceChangeLogPO)poList.get(0)).getOldPrice()).divide(new BigDecimal(poList.size()).add(new BigDecimal(1)), 2, 4);
                            lowestPrice = ((ECommercePriceChangeLogPO)poList.get(0)).getPrice();
                            for (ECommercePriceChangeLogPO each : poList) {
                                if (each.getPrice().compareTo(lowestPrice) >= 0) continue;
                                lowestPrice = each.getPrice();
                            }
                        }
                        if (agreementPrice.compareTo(oldAgreementPrice) == -1 && (downPrevent = (oldAgreementPrice = oldAgreementPrice.compareTo(new BigDecimal(0)) == 0 ? new BigDecimal("0.00001") : oldAgreementPrice).subtract(agreementPrice).divide(oldAgreementPrice, 4)).compareTo(modelBy.getDownPercentage().divide(new BigDecimal("100"))) > -1) {
                            uccPricePreventPO.setPercentage(downPrevent);
                            uccPricePreventPOS.add(uccPricePreventPO);
                            flag = true;
                        }
                        if (agreementPrice.compareTo(oldAgreementPrice) == 1) {
                            oldAgreementPrice = oldAgreementPrice.compareTo(new BigDecimal(0)) == 0 ? new BigDecimal("0.00001") : oldAgreementPrice;
                            BigDecimal upPrevent = agreementPrice.subtract(oldAgreementPrice).divide(oldAgreementPrice, 2, 4);
                            BigDecimal lowestUpPrevent = null;
                            if (lowestPrice != null) {
                                lowestPrice = lowestPrice.compareTo(new BigDecimal(0)) == 0 ? new BigDecimal("0.00001") : lowestPrice;
                                lowestUpPrevent = agreementPrice.subtract(lowestPrice).divide(lowestPrice, 2, 4);
                            }
                            if (upPrevent.compareTo(modelBy.getUpperPercentage().divide(new BigDecimal("100"), 2, 4)) > -1) {
                                uccPricePreventPO.setPercentage(upPrevent);
                                uccPricePreventPOS.add(uccPricePreventPO);
                                flag = true;
                            }
                            log.info("upPrevent:" + upPrevent + ",offShelfPercentage:" + modelBy.getOffShelfPercentage().divide(new BigDecimal("100"), 2, 4) + "upPrevent\u6bd4\u8f83offShelfPercentage:" + upPrevent.compareTo(modelBy.getOffShelfPercentage().divide(new BigDecimal("100"), 2, 4)));
                            if (upPrevent.compareTo(modelBy.getOffShelfPercentage().divide(new BigDecimal("100"), 2, 4)) > -1) {
                                uccPricePreventPO.setIsDown(Integer.valueOf(1));
                                commoditys.add(bo.getCommodityId());
                            } else if (lowestUpPrevent != null) {
                                log.info("\u6700\u4f4e\u4ef7\u6da8\u5e45\u4e0e\u4e0b\u67b6\u9608\u503c\u5bf9\u6bd4,lowestUpPrevent:" + lowestUpPrevent);
                                if (lowestUpPrevent.compareTo(modelBy.getOffShelfPercentage().divide(new BigDecimal("100"), 2, 4)) > -1) {
                                    uccPricePreventPO.setIsDown(Integer.valueOf(1));
                                    commoditys.add(bo.getCommodityId());
                                }
                            }
                        }
                    }
                }
                ECommercePriceChangePO eCommercePriceChangePO = new ECommercePriceChangePO();
                eCommercePriceChangePO.setSkuId(bo.getSkuId());
                eCommercePriceChangePO.setSupplierShopId(bo.getSupplierShopId());
                List eCommercePriceChangePOS = this.eCommercePriceChangeMapper.qryECommercePriceChange(eCommercePriceChangePO);
                if (eCommercePriceChangePOS == null || eCommercePriceChangePOS.size() == 0) {
                    eCommercePriceChangePO.setId(Long.valueOf(this.coefficientSequence.nextId()));
                    eCommercePriceChangePO.setPrice(agreementPrice);
                    eCommercePriceChangePO.setCurrentPrice(agreementPrice);
                    eCommercePriceChangePO.setOldPrice(uccPricePreventPO.getBeforePrice().divide(new BigDecimal(10000), 2, 4));
                    eCommercePriceChangePO.setAveragePrice(agreementPrice.add(bo.getOrgSalePrice()).divide(new BigDecimal(2), 2, 4));
                    eCommercePriceChangePO.setUpdateTime(new Date());
                    eCommercePriceChangePO.setFrequency(Integer.valueOf(1));
                    eCommercePriceChangePO.setIsDown(uccPricePreventPO.getIsDown());
                    eCommercePriceChangePO.setFloatingRate(uccPricePreventPO.getPercentage());
                    eCommercePriceChangePO.setExtSkuId(bo.getExtSkuId());
                    if (skuPOMap.containsKey(bo.getSkuId())) {
                        eCommercePriceChangePO.setSysTenantId(skuPOMap.get(bo.getSkuId()).getSysTenantId());
                    }
                    eCommercePriceChangePO.setSysTenantName(sysTenantName);
                    eCommercePriceChangePOList.add(eCommercePriceChangePO);
                } else {
                    BigDecimal avgprice = ((ECommercePriceChangePO)eCommercePriceChangePOS.get(0)).getAveragePrice().add(bo.getOrgSalePrice()).divide(new BigDecimal(2), 2, 4);
                    eCommercePriceChangePO = (ECommercePriceChangePO)eCommercePriceChangePOS.get(0);
                    eCommercePriceChangePO.setPrice(agreementPrice);
                    eCommercePriceChangePO.setCurrentPrice(agreementPrice);
                    eCommercePriceChangePO.setOldPrice(uccPricePreventPO.getBeforePrice().divide(new BigDecimal(10000), 2, 4));
                    eCommercePriceChangePO.setAveragePrice(avgprice);
                    eCommercePriceChangePO.setUpdateTime(new Date());
                    eCommercePriceChangePO.setFrequency(Integer.valueOf(eCommercePriceChangePO.getFrequency() + 1));
                    eCommercePriceChangePO.setIsDown(uccPricePreventPO.getIsDown());
                    eCommercePriceChangePO.setFloatingRate(uccPricePreventPO.getPercentage());
                    eCommercePriceChangePO.setExtSkuId(bo.getExtSkuId());
                    this.eCommercePriceChangeMapper.modifyECommercePriceChange(eCommercePriceChangePO);
                }
                ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
                BeanUtils.copyProperties((Object)eCommercePriceChangePO, (Object)eCommercePriceChangeLogPO);
                eCommercePriceChangeLogPO.setBatchId(Long.valueOf(this.coefficientSequence.nextId()));
                eCommercePriceChangeLogPO.setId(Long.valueOf(this.coefficientSequence.nextId()));
                eCommercePriceChangeLogPO.setOnShelveTime(bo.getOnShelveTime());
                if (skuPOMap.containsKey(bo.getSkuId())) {
                    eCommercePriceChangeLogPO.setSysTenantId(skuPOMap.get(bo.getSkuId()).getSysTenantId());
                }
                eCommercePriceChangeLogPO.setSysTenantName(sysTenantName);
                eCommercePriceChangeLogPOS.add(eCommercePriceChangeLogPO);
            }
            if (!CollectionUtils.isEmpty(commoditys)) {
                BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                Long[] longs = new Long[commoditys.size()];
                for (int i = 0; i < commoditys.size(); ++i) {
                    longs[i] = (Long)commoditys.get(i);
                }
                batchUpdateCommoStatusForMarketBO.setBusinessId(longs);
                batchUpdateCommoStatusForMarketBO.setReason("\u4ef7\u683c\u9884\u8b66\u8d85\u8fc7\u9608\u503c\uff0c\u5546\u54c1\u81ea\u52a8\u4e0b\u67b6");
                this.batchUpdateCommoStatusForMarket.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.FROZEN_STATUS, SkuStatusEnum.WARN_DOWN_STATUS);
            }
            try {
                if (!CollectionUtils.isEmpty(uccPricePreventPOS)) {
                    for (UccPricePreventPO po : uccPricePreventPOS) {
                        UccPricePreventPO preventPO = new UccPricePreventPO();
                        preventPO.setSkuId(po.getSkuId());
                        po.setPreventLogId(Long.valueOf(this.coefficientSequence.nextId()));
                        List list = this.uccPricePreventMapper.getList(preventPO);
                        if (list.size() != 0) {
                            this.uccPricePreventMapper.updateBy(po, (UccPricePreventPO)list.get(0));
                            continue;
                        }
                        po.setPreventId(Long.valueOf(this.coefficientSequence.nextId()));
                        this.uccPricePreventMapper.insert(po);
                    }
                    String json = JSONObject.toJSONString(uccPricePreventPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                    List logPOS = (List)JSON.parseObject((String)json, List.class);
                    this.uccPricePreventLogMapper.insertBatch(logPOS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u6dfb\u52a0\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u6dfb\u52a0\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25");
            }
            try {
                if (eCommercePriceChangePOList.size() > 0) {
                    this.eCommercePriceChangeMapper.insertPriceChange(eCommercePriceChangePOList);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u5931\u8d25");
            }
            try {
                if (eCommercePriceChangeLogPOS.size() > 0) {
                    this.eCommercePriceChangeLogMapper.insertECommercePriceChangeLogs(eCommercePriceChangeLogPOS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
            }
        }
        UccExecuteCommdMsgCombRspBO rspBO = new UccExecuteCommdMsgCombRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        listRsp.add(rspBO);
        return listRsp;
    }

    private List<UccExecuteCommdMsgCombRspBO> checkSingle(List<MqSyncCommdPriceBo> bos, Map<Long, UccSkuPo> skuPOMap, String sysTenantName) {
        List uccSkuPoList = this.uccSkuMapper.qrySkuCatalog(bos.stream().map(MqSyncCommdPriceBo::getSkuId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
            ArrayList<UccExecuteCommdMsgCombRspBO> listRsp = new ArrayList<UccExecuteCommdMsgCombRspBO>();
            UccExecuteCommdMsgCombRspBO rspBO = new UccExecuteCommdMsgCombRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            listRsp.add(rspBO);
            return listRsp;
        }
        Map skuMap = uccSkuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, Function.identity()));
        bos.stream().forEach(a -> {
            if (skuMap.containsKey(a.getSkuId())) {
                a.setCommodityId(((UccSkuPo)skuMap.get(a.getSkuId())).getCommodityId());
                a.setCatalogId(((UccSkuPo)skuMap.get(a.getSkuId())).getCatalogId());
            }
            if (skuPOMap.containsKey(a.getSkuId())) {
                a.setSysTenantId(((UccSkuPo)skuPOMap.get(a.getSkuId())).getSysTenantId());
            }
        });
        ArrayList<UccExecuteCommdMsgCombRspBO> listRspBO = new ArrayList<UccExecuteCommdMsgCombRspBO>();
        Map<Long, List<MqSyncCommdPriceBo>> sysTenantSkuMap = bos.stream().collect(Collectors.groupingBy(MqSyncCommdPriceBo::getSysTenantId));
        for (Long sysTenantId : sysTenantSkuMap.keySet()) {
            List<MqSyncCommdPriceBo> eachBos = sysTenantSkuMap.get(sysTenantId);
            Boolean isSign = true;
            UmcQrySupSignTypeListAbilityReqBO signTypeListReqBO = new UmcQrySupSignTypeListAbilityReqBO();
            signTypeListReqBO.setSupplierId(eachBos.get(0).getSupplierShopId());
            signTypeListReqBO.setCatalogIds(eachBos.stream().map(MqSyncCommdPriceBo::getCatalogId).collect(Collectors.toList()));
            signTypeListReqBO.setSysTenantId(sysTenantId);
            UmcQrySupSignTypeListAbilityRspBO abilityRspBO = this.umcQrySupSignTypeListAbilityService.qrySupSignTypeList(signTypeListReqBO);
            if (!"0000".equals(abilityRspBO.getRespCode())) {
                throw new BusinessException("\u5904\u7406\u5546\u54c1\u4ef7\u683c\u8ba1\u7b97\u5931\u8d25:", abilityRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)abilityRspBO.getUmcQrySupSignTypeBOS())) {
                List skuIs = eachBos.stream().map(MqSyncCommdPriceBo::getSkuId).collect(Collectors.toList());
                for (Long skuI : skuIs) {
                    this.downSkuInfo(Arrays.asList(skuI), "\u4f9b\u5e94\u5546\u4fee\u8d2d\u4ef7\u683c\u8d85\u51fa\u7b7e\u7ea6\u6298\u6263-\u672a\u7b7e\u7ea6\u54c1\u7c7b", eachBos, skuPOMap, sysTenantName);
                }
                eachBos.stream().forEach(a -> a.setDown(true));
            }
            Map signTypeBOMap = abilityRspBO.getUmcQrySupSignTypeBOS().stream().collect(Collectors.toMap(UmcQrySupSignTypeBO::getItemCatId, Function.identity()));
            ArrayList noSignType = new ArrayList();
            ArrayList overInfoList = new ArrayList();
            ArrayList noPrice = new ArrayList();
            for (MqSyncCommdPriceBo each : eachBos) {
                String reason;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date currentDate = new Date();
                String formattedDate = format.format(currentDate);
                if (signTypeBOMap.containsKey(each.getCatalogId())) {
                    if (each.getAgreementPrice() != null && each.getAgreementPrice().compareTo(0L) > 0) {
                        BigDecimal discount = MoneyUtils.haoToYuan((Long)each.getAgreementPrice()).divide(MoneyUtils.haoToYuan((Long)each.getMarketPrice()), 2, RoundingMode.UP).multiply(new BigDecimal(100));
                        if (discount.compareTo(new BigDecimal(((UmcQrySupSignTypeBO)signTypeBOMap.get(each.getCatalogId())).getDiscountRate())) > 0) {
                            String reason2 = String.format("\u4e0b\u67b6\u65f6\u95f4\uff1a%s\n\u4e0b\u67b6\u539f\u56e0\uff1a\u8d85\u6298\u6263\u81ea\u52a8\u4e0b\u67b6\n\u4e0b\u67b6\u65f6\u6298\u6263\u7387\uff1a%.2f%%\n\u5e02\u573a\u4ef7\uff1a%s\u5143\n\u4f9b\u8d27\u4ef7\uff1a%s\u5143\n\u8d38\u6613\u9500\u552e\u4ef7\uff1a%s\u5143\n", formattedDate, new BigDecimal(each.getAgreementPrice()).divide(new BigDecimal(each.getMarketPrice()), 4, 0).multiply(new BigDecimal(100)), MoneyUtils.haoToYuan((Long)each.getMarketPrice()).toString(), MoneyUtils.haoToYuan((Long)each.getAgreementPrice()).toString(), MoneyUtils.haoToYuan((Long)each.getSalePrice()).toString());
                            this.downSkuInfo(Arrays.asList(each.getSkuId()), reason2, eachBos, skuPOMap, sysTenantName);
                            each.setDown(true);
                        }
                    } else {
                        reason = String.format("\u4e0b\u67b6\u65f6\u95f4\uff1a%s\n\u4e0b\u67b6\u539f\u56e0\uff1a\u4f9b\u5e94\u5546\u4fee\u8d2d\u4ef7\u683c\u8d85\u51fa\u7b7e\u7ea6\u6298\u6263-\u534f\u8bae\u4ef7\u4e3a\u7a7a\n\u4e0b\u67b6\u65f6\u6298\u6263\u7387\uff1a%.2f%%\n\u5e02\u573a\u4ef7\uff1a%s\u5143\n\u4f9b\u8d27\u4ef7\uff1a%s\u5143\n\u8d38\u6613\u9500\u552e\u4ef7\uff1a%s\u5143\n", formattedDate, null, null, null, null);
                        this.downSkuInfo(Arrays.asList(each.getSkuId()), reason, eachBos, skuPOMap, sysTenantName);
                        each.setDown(true);
                    }
                    UccSkuPo skuPo = new UccSkuPo();
                    skuPo.setSkuId(each.getSkuId());
                    List uccSkuPoList1 = this.uccSkuMapper.qerySku(skuPo);
                    log.info("\u7b7e\u7ea6\u6298\u6263\u7387\uff1a{},{}", (Object)each.getSkuId(), (Object)((UccSkuPo)uccSkuPoList1.get(0)).getSignDiscount());
                    log.info("\u7b7e\u7ea6\u6298\u6263\u7387\uff1a{},{}", (Object)each.getSkuId(), (Object)((UmcQrySupSignTypeBO)signTypeBOMap.get(each.getCatalogId())).getDiscountRate());
                    if (!isSign.booleanValue() || ((UccSkuPo)uccSkuPoList1.get(0)).getSignDiscount() == null || ((UccSkuPo)uccSkuPoList1.get(0)).getSignDiscount().compareTo(new BigDecimal(((UmcQrySupSignTypeBO)signTypeBOMap.get(each.getCatalogId())).getDiscountRate())) == 0) continue;
                    log.info("\u4fee\u6539\u7b7e\u7ea6\u6298\u6263\u7387");
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSkuId(each.getSkuId());
                    uccSkuPo.setSupplierShopId(each.getSupplierShopId());
                    uccSkuPo.setSignDiscount(new BigDecimal(((UmcQrySupSignTypeBO)signTypeBOMap.get(each.getCatalogId())).getDiscountRate()));
                    log.info("\u4fee\u6539\u7b7e\u7ea6\u6298\u6263\u7387\uff1a{}", (Object)uccSkuPo);
                    this.uccSkuMapper.updateSku(uccSkuPo);
                    continue;
                }
                reason = String.format("\u4e0b\u67b6\u65f6\u95f4\uff1a%s\n\u4e0b\u67b6\u539f\u56e0\uff1a\u4f9b\u5e94\u5546\u4fee\u8d2d\u4ef7\u683c\u8d85\u51fa\u7b7e\u7ea6\u6298\u6263-\u672a\u7b7e\u7ea6\u54c1\u7c7b\n\u4e0b\u67b6\u65f6\u6298\u6263\u7387\uff1a%.2f%%\n\u5e02\u573a\u4ef7\uff1a%s\u5143\n\u4f9b\u8d27\u4ef7\uff1a%s\u5143\n\u8d38\u6613\u9500\u552e\u4ef7\uff1a%s\u5143\n", formattedDate, new BigDecimal(each.getAgreementPrice()).divide(new BigDecimal(each.getMarketPrice()), 4, 0).multiply(new BigDecimal(100)), MoneyUtils.haoToYuan((Long)each.getMarketPrice()).toString(), MoneyUtils.haoToYuan((Long)each.getAgreementPrice()).toString(), MoneyUtils.haoToYuan((Long)each.getSalePrice()).toString());
                this.downSkuInfo(Arrays.asList(each.getSkuId()), reason, eachBos, skuPOMap, sysTenantName);
                each.setDown(true);
            }
        }
        UccExecuteCommdMsgCombRspBO rspBO = new UccExecuteCommdMsgCombRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        listRspBO.add(rspBO);
        return listRspBO;
    }

    private void downSkuInfo(List<Long> sku, String reason, List<MqSyncCommdPriceBo> bos, Map<Long, UccSkuPo> skuPOMap, String sysTenantName) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuIds(sku);
        List skuPos = this.uccSkuMapper.qerySku(uccSkuPo);
        List spus = bos.stream().filter(a -> sku.contains(a.getSkuId())).map(MqSyncCommdPriceBo::getCommodityId).collect(Collectors.toList());
        this.uccSkuMapper.updateBatchStatus(sku, null, Integer.valueOf(17));
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityStatus(Integer.valueOf(5));
        this.uccCommodityMapper.batchUpdateById(spus, uccCommodityPo);
        UccSkuAutoDownPO uccSkuAutoDownPO = new UccSkuAutoDownPO();
        uccSkuAutoDownPO.setSkuIds(sku);
        List skuExpandPos = this.uccSkuAutoDownMapper.getList(uccSkuAutoDownPO);
        if (!CollectionUtils.isEmpty((Collection)skuExpandPos)) {
            List expSku = skuExpandPos.stream().map(UccSkuAutoDownPO::getSkuId).collect(Collectors.toList());
            sku.removeAll(expSku);
            ArrayList<UccSkuAutoDownPO> updateAutoDown = new ArrayList<UccSkuAutoDownPO>();
            for (UccSkuAutoDownPO each : skuExpandPos) {
                uccSkuAutoDownPO = new UccSkuAutoDownPO();
                uccSkuAutoDownPO.setSkuId(each.getSkuId());
                reason = String.format("%s\n%s", reason, each.getDownReason());
                uccSkuAutoDownPO.setDownReason(reason);
                uccSkuAutoDownPO.setUpdateTime(new Date());
                updateAutoDown.add(uccSkuAutoDownPO);
            }
            this.uccSkuAutoDownMapper.batchupdateReason(updateAutoDown);
        }
        if (!CollectionUtils.isEmpty(sku)) {
            Map map = bos.stream().collect(Collectors.toMap(MqSyncCommdPriceBo::getSkuId, Function.identity()));
            ArrayList<UccSkuAutoDownPO> list = new ArrayList<UccSkuAutoDownPO>();
            for (Long extEach : sku) {
                UccSkuAutoDownPO expandPo = new UccSkuAutoDownPO();
                expandPo.setSkuId(((MqSyncCommdPriceBo)map.get(extEach)).getSkuId());
                expandPo.setCommodityId(((MqSyncCommdPriceBo)map.get(extEach)).getCommodityId());
                expandPo.setDownReason(reason);
                expandPo.setUpdateTime(new Date());
                expandPo.setSupplierShopId(((MqSyncCommdPriceBo)map.get(extEach)).getSupplierShopId());
                expandPo.setCommodityId(((MqSyncCommdPriceBo)map.get(extEach)).getCommodityId());
                if (skuPOMap.containsKey(extEach)) {
                    expandPo.setSysTenantId(skuPOMap.get(extEach).getSysTenantId());
                }
                expandPo.setSysTenantName(sysTenantName);
                list.add(expandPo);
            }
            this.uccSkuAutoDownMapper.insertBatch(list);
        }
        ArrayList<UccSkuPutCirPo> uccSkuPutCirPos = new ArrayList<UccSkuPutCirPo>();
        for (UccSkuPo each : skuPos) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setSkuId(each.getSkuId());
            uccSkuPutCirPo.setState(Integer.valueOf(1));
            List uccSkuPutCirPos1 = this.uccSkuPutCirMapper.querySkuPutCir(uccSkuPutCirPo);
            uccSkuPutCirPo.setSupplierShopId(each.getSupplierShopId());
            uccSkuPutCirPo.setDownType(Integer.valueOf(2));
            uccSkuPutCirPo.setRealDownTime(new Date(System.currentTimeMillis()));
            uccSkuPutCirPo.setRemark("\u4ef7\u683c\u53d8\u52a8\u8d85\u6298\u6263");
            if (!CollectionUtils.isEmpty((Collection)uccSkuPutCirPos1)) {
                uccSkuPutCirPo.setId(((UccSkuPutCirPo)uccSkuPutCirPos1.get(0)).getId());
                uccSkuPutCirPo.setUpdateOperId("1");
                uccSkuPutCirPo.setUpdateTime(uccSkuPutCirPo.getRealDownTime());
                this.uccSkuPutCirMapper.modifyBySkuId(uccSkuPutCirPo);
                continue;
            }
            uccSkuPutCirPo.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuPutCirPo.setCreateOperId("1");
            uccSkuPutCirPo.setCreateTime(uccSkuPutCirPo.getRealDownTime());
            uccSkuPutCirPo.setSysTenantId(each.getSysTenantId());
            uccSkuPutCirPo.setSysTenantName(each.getSysTenantName());
            uccSkuPutCirPos.add(uccSkuPutCirPo);
        }
        if (!CollectionUtils.isEmpty(uccSkuPutCirPos)) {
            this.uccSkuPutCirMapper.batchInsert(uccSkuPutCirPos);
        }
    }
}

