/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccSkuAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.estore.ability.bo.UccAddPriceInfoBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchImportReqBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchImportRspBO;
import com.tydic.commodity.estore.ability.bo.UccSkuAddPriceBatchInsertBO;
import com.tydic.commodity.estore.busi.api.UccSkuAddPriceBatchImportBusiService;
import com.tydic.commodity.po.UccSkuAddCoefficientLogPO;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSkuAddPriceBatchImportBusiServiceImpl
implements UccSkuAddPriceBatchImportBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuAddPriceBatchImportBusiServiceImpl.class);
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientLogMapper uccSkuAddCoefficientLogMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccSkuAddPriceBatchImportRspBO batchimportSkuAddPrice(UccSkuAddPriceBatchImportReqBO reqBO) {
        try {
            this.addSkuPrice(reqBO);
            this.editSkuPrice(reqBO);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u51fa\u9519:------------------------------------------------------", (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
        UccSkuAddPriceBatchImportRspBO rspBO = new UccSkuAddPriceBatchImportRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void addSkuPrice(UccSkuAddPriceBatchImportReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAddpriceReq())) {
            return;
        }
        ArrayList uccSkuAddCoefficientPOS = new ArrayList();
        reqBO.getAddpriceReq().forEach(skuPriceInfo -> {
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            BeanCopier beanCopier = BeanCopier.create(UccSkuAddPriceBatchInsertBO.class, UccSkuAddCoefficientPO.class, (boolean)false);
            beanCopier.copy(skuPriceInfo, (Object)uccSkuAddCoefficientPO, null);
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setAddCoefficient(skuPriceInfo.getSkuAddCoefficient());
            uccSkuAddCoefficientPO.setCatelogId(skuPriceInfo.getCatalogId());
            uccSkuAddCoefficientPO.setSysTenantId(reqBO.getSysTenantId());
            uccSkuAddCoefficientPO.setSysTenantName(reqBO.getSysTenantName());
            uccSkuAddCoefficientPOS.add(uccSkuAddCoefficientPO);
        });
        try {
            this.uccSkuAddCoefficientMapper.batchInsert(uccSkuAddCoefficientPOS);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a" + e);
            throw new ZTBusinessException("\u90e8\u5206\u5355\u54c1\u65b0\u589e\u52a0\u4ef7\u5931\u8d25\uff01");
        }
        ArrayList<UccSkuAddCoefficientLogPO> uccSkuAddCoefficientLogPOS = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanCopier beanCopier = BeanCopier.create(UccSkuAddCoefficientPO.class, UccSkuAddCoefficientLogPO.class, (boolean)false);
            beanCopier.copy((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO, null);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uccSkuAddCoefficientLogPO.setSkuPriceId(uccSkuAddCoefficientPO.getSkuId());
            uccSkuAddCoefficientLogPO.setCreateTime(new Date());
            uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUsername());
            uccSkuAddCoefficientLogPOS.add(uccSkuAddCoefficientLogPO);
        }
        try {
            this.uccSkuAddCoefficientLogMapper.batchInsert(uccSkuAddCoefficientLogPOS);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u65e5\u5fd7\u5931\u8d25\uff1a" + e);
            throw new ZTBusinessException("\u6279\u91cf\u65b0\u589e\u65e5\u5fd7\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void editSkuPrice(UccSkuAddPriceBatchImportReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getEditpriceReq())) {
            return;
        }
        List addPriceInfoList = reqBO.getEditpriceReq();
        List skuIds = addPriceInfoList.stream().map(UccAddPriceInfoBO::getSkuId).collect(Collectors.toList());
        List uccSkuAddCoefficientPOS = this.uccSkuAddCoefficientMapper.selectBySkuIds(skuIds);
        try {
            this.uccSkuAddCoefficientLogMapper.batchUpdateTime(skuIds);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5904\u7406\u66f4\u65b0\u52a0\u4ef7\u7cfb\u6570\u65e5\u5fd7\u5f02\u5e38" + e);
            throw new ZTBusinessException("\u6279\u91cf\u5904\u7406\u66f4\u65b0\u52a0\u4ef7\u7cfb\u6570\u65e5\u5fd7\u5f02\u5e38 \uff1a " + e.getMessage());
        }
        List<UccSkuAddCoefficientPO> updateListBO = this.createUpdateListBO(addPriceInfoList, reqBO);
        List<UccSkuAddCoefficientLogPO> batchInsertLogBO = this.createBatchInsertLogBO(updateListBO, reqBO, uccSkuAddCoefficientPOS);
        try {
            this.uccSkuAddCoefficientLogMapper.batchInsert(batchInsertLogBO);
            this.uccSkuAddCoefficientMapper.batchUpdateAddPrice(updateListBO);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5904\u7406\u66f4\u65b0\u52a0\u4ef7\u7cfb\u6570\u5f02\u5e38" + e);
            throw new ZTBusinessException("\u6279\u91cf\u5904\u7406\u66f4\u65b0\u52a0\u4ef7\u7cfb\u6570\u5f02\u5e38 \uff1a " + e.getMessage());
        }
    }

    private List<UccSkuAddCoefficientPO> createUpdateListBO(List<UccAddPriceInfoBO> addPriceInfoList, UccSkuAddPriceBatchImportReqBO reqBO) {
        ArrayList<UccSkuAddCoefficientPO> list = new ArrayList<UccSkuAddCoefficientPO>();
        for (UccAddPriceInfoBO uccAddPriceInfoBO : addPriceInfoList) {
            if (uccAddPriceInfoBO.getRule() == null) {
                throw new ZTBusinessException("\u8bf7\u8f93\u5165\u52a0\u4ef7\u7c7b\u578b\uff01");
            }
            if (uccAddPriceInfoBO.getRule() == 1) {
                if (uccAddPriceInfoBO.getSkuAddCoefficient() == null) {
                    throw new ZTBusinessException("\u52a0\u4ef7\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                uccAddPriceInfoBO.setAddPrice(null);
            }
            if (uccAddPriceInfoBO.getRule() == 2) {
                if (uccAddPriceInfoBO.getAddPrice() == null) {
                    throw new ZTBusinessException("\u52a0\u4ef7\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                uccAddPriceInfoBO.setSkuAddCoefficient(null);
            }
            UccSkuAddCoefficientPO uccSkuAddCoefficientPO = new UccSkuAddCoefficientPO();
            uccSkuAddCoefficientPO.setSkuId(uccAddPriceInfoBO.getSkuId());
            uccSkuAddCoefficientPO.setAddCoefficient(uccAddPriceInfoBO.getSkuAddCoefficient());
            uccSkuAddCoefficientPO.setAllowMarketPrice(uccAddPriceInfoBO.getAllowMoreMarket());
            uccSkuAddCoefficientPO.setAddPrice(uccAddPriceInfoBO.getAddPrice());
            uccSkuAddCoefficientPO.setRule(uccAddPriceInfoBO.getRule());
            uccSkuAddCoefficientPO.setUpdateTime(new Date());
            uccSkuAddCoefficientPO.setUpdateOperId(reqBO.getName());
            list.add(uccSkuAddCoefficientPO);
        }
        return list;
    }

    private List<UccSkuAddCoefficientLogPO> createBatchInsertLogBO(List<UccSkuAddCoefficientPO> uccSkuAddCoefficientPOS, UccSkuAddPriceBatchImportReqBO reqBO, List<UccSkuAddCoefficientPO> beforeData) {
        ArrayList<UccSkuAddCoefficientLogPO> list = new ArrayList<UccSkuAddCoefficientLogPO>();
        for (UccSkuAddCoefficientPO uccSkuAddCoefficientPO : uccSkuAddCoefficientPOS) {
            UccSkuAddCoefficientLogPO uccSkuAddCoefficientLogPO = new UccSkuAddCoefficientLogPO();
            BeanUtils.copyProperties((Object)uccSkuAddCoefficientPO, (Object)uccSkuAddCoefficientLogPO);
            uccSkuAddCoefficientLogPO.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuAddCoefficientLogPO.setCreateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setAccountNumber(reqBO.getUsername());
            uccSkuAddCoefficientLogPO.setUpdateOperId(reqBO.getName());
            uccSkuAddCoefficientLogPO.setUpdateTime(new Date());
            uccSkuAddCoefficientLogPO.setCreateTime(new Date());
            uccSkuAddCoefficientLogPO.setSysTenantId(reqBO.getSysTenantId());
            uccSkuAddCoefficientLogPO.setSysTenantName(reqBO.getSysTenantName());
            List collect = beforeData.stream().filter(s -> s.getSkuId().equals(uccSkuAddCoefficientPO.getSkuId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                UccSkuAddCoefficientPO beforeBO = (UccSkuAddCoefficientPO)collect.get(0);
                uccSkuAddCoefficientLogPO.setSupplierShopId(beforeBO.getSupplierShopId());
                uccSkuAddCoefficientLogPO.setShopName(beforeBO.getShopName());
                uccSkuAddCoefficientLogPO.setSkuPriceId(beforeBO.getSkuId());
            }
            list.add(uccSkuAddCoefficientLogPO);
        }
        return list;
    }
}

