/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallCurrentPriceQryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallEstoreSkuPriceChangeAutoAbilityService;
import com.tydic.commodity.mall.ability.bo.SkuInfomationBo;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallEstoreSkuPriceChangeAutoAbilityRspBO;
import com.tydic.commodity.mall.dao.UccMallAddCoefficientMapper;
import com.tydic.commodity.mall.dao.UccMallSkuAddCoefficientMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccAddCoefficientPO;
import com.tydic.commodity.mall.po.UccMallSkuAddCoefficientPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallEstoreSkuPriceChangeAutoAbilityService"})
public class UccMallEstoreSkuPriceChangeAutoAbilityServiceImpl
implements UccMallEstoreSkuPriceChangeAutoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallEstoreSkuPriceChangeAutoAbilityServiceImpl.class);
    @Autowired
    private UccMallCurrentPriceQryAbilityService uccMallCurrentPriceQryAbilityService;
    @Autowired
    private UccMallSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccMallAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @PostMapping(value={"dealEstoreSkuPriceChange"})
    public UccMallEstoreSkuPriceChangeAutoAbilityRspBO dealEstoreSkuPriceChange() {
        UccMallEstoreSkuPriceChangeAutoAbilityRspBO rspBO = new UccMallEstoreSkuPriceChangeAutoAbilityRspBO();
        List<SkuInfomationBo> needChangePirceSku = this.getNeedChangePirceSku();
        if (!CollectionUtils.isEmpty(needChangePirceSku)) {
            Map<Long, List<SkuInfomationBo>> collect = needChangePirceSku.stream().collect(Collectors.groupingBy(SkuInfomationBo::getSupplierShopId));
            for (Long supplierShopId : collect.keySet()) {
                UccMallCurrentPriceQryReqBO uccMallCurrentPriceQryReqBO = new UccMallCurrentPriceQryReqBO();
                ArrayList skuIds = new ArrayList(collect.get(supplierShopId).stream().map(SkuInfomationBo::getSkuId).collect(Collectors.toSet()));
                uccMallCurrentPriceQryReqBO.setSkuIds(skuIds);
                uccMallCurrentPriceQryReqBO.setSupplierShopId(supplierShopId);
                uccMallCurrentPriceQryReqBO.setIsprofess("1");
                try {
                    this.uccMallCurrentPriceQryAbilityService.changeCommdCurrentPrice(uccMallCurrentPriceQryReqBO);
                }
                catch (Exception e) {
                    log.error("\u5546\u54c1\u4e2d\u5fc3\u7535\u5546\u5546\u54c1\u52a0\u4ef7\u6bd4\u7387\u53d8\u66f4\u540e\uff0c\u4ef7\u683c\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u62a5\u9519:" + e.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<SkuInfomationBo> getNeedChangePirceSku() {
        List<UccAddCoefficientPO> addCoefficientPOS;
        ArrayList<SkuInfomationBo> needChangePirceSku = new ArrayList<SkuInfomationBo>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        c.add(5, -1);
        Date yesterday = c.getTime();
        String yesterdayStr = format.format(yesterday);
        try {
            yesterday = format.parse(yesterdayStr);
        }
        catch (ParseException e) {
            throw new BusinessException("8888", "\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
        }
        List<UccMallSkuAddCoefficientPO> uccSkuAddCoefficientPOList = this.uccSkuAddCoefficientMapper.selectByTime(yesterday, null);
        if (!CollectionUtils.isEmpty(uccSkuAddCoefficientPOList)) {
            for (UccMallSkuAddCoefficientPO each : uccSkuAddCoefficientPOList) {
                SkuInfomationBo skuInfomationBo = new SkuInfomationBo();
                skuInfomationBo.setSkuId(each.getSkuId());
                skuInfomationBo.setSupplierShopId(each.getSupplierShopId());
                needChangePirceSku.add(skuInfomationBo);
            }
        }
        if (!CollectionUtils.isEmpty(addCoefficientPOS = this.uccAddCoefficientMapper.selectByTime(yesterday, null))) {
            List<Long> commodityTypeId = addCoefficientPOS.stream().map(UccAddCoefficientPO::getCatalogId).collect(Collectors.toList());
            List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.querySkuByCommTypeIds(commodityTypeId, null);
            for (UccSkuPo each : uccSkuPos) {
                SkuInfomationBo skuInfomationBo = new SkuInfomationBo();
                skuInfomationBo.setSkuId(each.getSkuId());
                skuInfomationBo.setSupplierShopId(each.getSupplierShopId());
                needChangePirceSku.add(skuInfomationBo);
            }
        }
        return needChangePirceSku;
    }
}

