/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.mall.ability.api.UccMallGetJDaddrInfoAbilityService;
import com.tydic.commodity.mall.ability.bo.AddrAreaBO;
import com.tydic.commodity.mall.ability.bo.AddrCityBO;
import com.tydic.commodity.mall.ability.bo.AddrProvinceBO;
import com.tydic.commodity.mall.ability.bo.AddrTownsBO;
import com.tydic.commodity.mall.ability.bo.UccMallGetJDaddrInfoBusiReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallGetJDaddrInfoBusiRspBO;
import com.tydic.commodity.mall.busi.api.UccMallGetJDaddrInfoBusiService;
import com.tydic.commodity.mall.utils.HttpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallGetJDaddrInfoAbilityServiceImpl
implements UccMallGetJDaddrInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallGetJDaddrInfoAbilityServiceImpl.class);
    @Value(value="${JD.PROVINCE.ADDR:https://api-iop.jd.com/api/area/getProvince}")
    private String jdProvinceAddr;
    @Value(value="${JD.CITY.ADDR:https://api-iop.jd.com/api/area/getCity}")
    private String jdCityAddr;
    @Value(value="${JD.AREA.ADDR:https://api-iop.jd.com/api/area/getCounty}")
    private String jdAreaAddr;
    @Value(value="${JD.TOWNS.ADDR:https://api-iop.jd.com/api/area/getTown}")
    private String jdTownsAddr;
    @Value(value="${JD.TOKEN:SiIuzMZE9STuQiZJVHtlhUpP3}")
    private String jdToken;
    @Autowired
    private UccMallGetJDaddrInfoBusiService uccMallGetJDaddrInfoBusiService;
    @Resource(name="getAddrMqServiceProvider")
    private ProxyMessageProducer getAddrMqServiceProvider;
    @Value(value="${GET_ADDR_SYNC_TOPIC:GET_ADDR_SYNC_TOPIC}")
    private String getAddrSyncTopic;

    public UccMallGetJDaddrInfoBusiRspBO dealJdAddr(UccMallGetJDaddrInfoBusiReqBO reqBO) {
        ArrayList<AddrProvinceBO> provinceBOList = new ArrayList<AddrProvinceBO>();
        ArrayList<AddrCityBO> cityBOList = new ArrayList<AddrCityBO>();
        ArrayList<AddrAreaBO> areaBOList = new ArrayList<AddrAreaBO>();
        ArrayList<AddrTownsBO> townBOList = new ArrayList<AddrTownsBO>();
        Map<String, String> reqStr = this.initProvinceReqStr();
        try {
            String returnString = HttpUtil.http(this.jdProvinceAddr, reqStr);
            if (StringUtils.isEmpty((Object)returnString)) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01" + reqStr.toString());
            } else {
                JSONObject proviceJson = JSONObject.parseObject((String)returnString);
                if (proviceJson.getBoolean("success").booleanValue()) {
                    Map proviceMap = proviceJson.getJSONObject("result").getInnerMap();
                    Set keys = proviceMap.keySet();
                    AddrProvinceBO addrProvinceBO = null;
                    for (String eachKey : keys) {
                        if (StringUtils.isEmpty((Object)reqBO.getProvinceCode())) {
                            UccMallGetJDaddrInfoBusiReqBO mqMsg = new UccMallGetJDaddrInfoBusiReqBO();
                            mqMsg.setProvinceCode(eachKey);
                            mqMsg.setSysTenantId(reqBO.getSysTenantId());
                            mqMsg.setSysTenantName(reqBO.getSysTenantName());
                            this.getAddrMqServiceProvider.send(new ProxyMessage(this.getAddrSyncTopic, "*", JSON.toJSONString((Object)mqMsg)));
                            continue;
                        }
                        if (!reqBO.getProvinceCode().equals(eachKey)) continue;
                        addrProvinceBO = new AddrProvinceBO();
                        addrProvinceBO.setCode(proviceMap.get(eachKey).toString());
                        addrProvinceBO.setName(eachKey);
                        provinceBOList.add(addrProvinceBO);
                        reqStr = this.initCityReqStr(addrProvinceBO.getCode());
                        String cityString = HttpUtil.http(this.jdCityAddr, reqStr);
                        if (StringUtils.isEmpty((Object)returnString)) {
                            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01" + reqStr.toString());
                            continue;
                        }
                        JSONObject cityJson = JSONObject.parseObject((String)cityString);
                        if (!cityJson.getBoolean("success").booleanValue()) continue;
                        Map cityMap = cityJson.getJSONObject("result").getInnerMap();
                        Set citykeys = cityMap.keySet();
                        AddrCityBO addrCityBO = null;
                        for (String cityKey : citykeys) {
                            addrCityBO = new AddrCityBO();
                            addrCityBO.setCode(cityMap.get(cityKey).toString());
                            addrCityBO.setName(cityKey);
                            addrCityBO.setProvinceCode(addrProvinceBO.getCode());
                            cityBOList.add(addrCityBO);
                            reqStr = this.initCityReqStr(addrCityBO.getCode());
                            String areaString = HttpUtil.http(this.jdAreaAddr, reqStr);
                            if (StringUtils.isEmpty((Object)areaString)) {
                                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01" + reqStr.toString());
                                continue;
                            }
                            JSONObject areaJson = JSONObject.parseObject((String)areaString);
                            if (!cityJson.getBoolean("success").booleanValue()) continue;
                            Map areaMap = areaJson.getJSONObject("result").getInnerMap();
                            Set areakeys = areaMap.keySet();
                            AddrAreaBO addrAreaBO = null;
                            for (String areaKey : areakeys) {
                                addrAreaBO = new AddrAreaBO();
                                addrAreaBO.setCode(areaMap.get(areaKey).toString());
                                addrAreaBO.setName(areaKey);
                                addrAreaBO.setCityCode(addrCityBO.getCode());
                                areaBOList.add(addrAreaBO);
                                reqStr = this.initCityReqStr(addrAreaBO.getCode());
                                String townsString = HttpUtil.http(this.jdTownsAddr, reqStr);
                                if (StringUtils.isEmpty((Object)townsString)) {
                                    log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01" + reqStr.toString());
                                    continue;
                                }
                                JSONObject townJson = JSONObject.parseObject((String)townsString);
                                if (!townJson.getBoolean("success").booleanValue()) continue;
                                Map townMap = townJson.getJSONObject("result").getInnerMap();
                                Set townkeys = townMap.keySet();
                                AddrTownsBO addrTownsBO = null;
                                for (String townKey : townkeys) {
                                    addrTownsBO = new AddrTownsBO();
                                    addrTownsBO.setCode(townMap.get(townKey).toString());
                                    addrTownsBO.setName(townKey);
                                    addrTownsBO.setAreaCode(addrAreaBO.getCode());
                                    townBOList.add(addrTownsBO);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5931\u8d25 \uff1a" + e.getMessage());
        }
        if (!CollectionUtils.isEmpty(provinceBOList)) {
            reqBO.setProvinceBOList(provinceBOList);
        }
        if (!CollectionUtils.isEmpty(cityBOList)) {
            reqBO.setCityBOList(cityBOList);
        }
        if (!CollectionUtils.isEmpty(areaBOList)) {
            reqBO.setAreaBOList(areaBOList);
        }
        if (!CollectionUtils.isEmpty(townBOList)) {
            reqBO.setTownBOList(townBOList);
        }
        return this.uccMallGetJDaddrInfoBusiService.dealJdAddr(reqBO);
    }

    private Map<String, String> initProvinceReqStr() {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("token", this.jdToken);
        return jsonObject;
    }

    private Map<String, String> initCityReqStr(String province) {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("token", this.jdToken);
        jsonObject.put("id", province);
        return jsonObject;
    }

    private Map<String, String> initAreaReqStr(String city) {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("token", this.jdToken);
        jsonObject.put("id", city);
        return jsonObject;
    }

    private Map<String, String> initTownsReqStr(String area) {
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        jsonObject.put("token", this.jdToken);
        jsonObject.put("id", area);
        return jsonObject;
    }
}

