/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccSpuItemSpecInfodetailsAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallFilterSkuSpecBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuSpecListBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuSpecPropValueListBo;
import com.tydic.commodity.mall.ability.bo.UccSpuItemSpecInfodetailsAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccSpuItemSpecInfodetailsAbilityRspBO;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccSkuSpecMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuSpecPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccSpuItemSpecInfodetailsAbilityService"})
public class UccSpuItemSpecInfodetailsAbilityServiceImpl
implements UccSpuItemSpecInfodetailsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuItemSpecInfodetailsAbilityServiceImpl.class);
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @PostMapping(value={"dealItemSpecInfo"})
    public UccSpuItemSpecInfodetailsAbilityRspBO dealItemSpecInfo(@RequestBody UccSpuItemSpecInfodetailsAbilityReqBO reqBO) {
        UccSpuItemSpecInfodetailsAbilityRspBO rspBO = new UccSpuItemSpecInfodetailsAbilityRspBO();
        if (reqBO == null || reqBO.getCommodityId() == null && reqBO.getSkuId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u67e5\u8be2\u6570\u636e\u5185\u5bb9");
            return rspBO;
        }
        rspBO.setCommodityId(reqBO.getCommodityId());
        if (reqBO.getCommodityId() == null && reqBO.getSkuId() != null) {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(reqBO.getSkuId());
            List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty(uccSkuPos)) {
                log.error("\u5546\u54c1\u8be6\u60c5\u67e5\u8be2\uff0c\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f" + JSONObject.toJSONString((Object)reqBO));
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            reqBO.setCommodityId(uccSkuPos.get(0).getCommodityId());
            rspBO.setCommodityId(uccSkuPos.get(0).getCommodityId());
        }
        ArrayList<Long> commodityPropDefIds = new ArrayList<Long>();
        ArrayList<Long> propValueListIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQryInfoList())) {
            reqBO.getQryInfoList().stream().forEach(item -> {
                commodityPropDefIds.add(item.getCommodityPropDefId());
                propValueListIds.add(item.getPropValueListId());
            });
        }
        if (commodityPropDefIds.size() != propValueListIds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7b5b\u9009\u5185\u5bb9\u4e0d\u5339\u914d");
            return rspBO;
        }
        List<UccMallFilterSkuSpecBO> filterSkuSpecBOList = this.uccSkuSpecMapper.filterSkuSpec(reqBO.getCommodityId(), commodityPropDefIds, propValueListIds, reqBO.getSkuName(), reqBO.getSysTenantId());
        if (!CollectionUtils.isEmpty(filterSkuSpecBOList)) {
            Map<Long, List<UccMallFilterSkuSpecBO>> groubyDefId = filterSkuSpecBOList.stream().collect(Collectors.groupingBy(UccMallFilterSkuSpecBO::getCommodityPropDefId));
            Iterator<Map.Entry<Long, List<UccMallFilterSkuSpecBO>>> iterator = groubyDefId.entrySet().iterator();
            ArrayList<UccMallSkuSpecListBo> skuspecList = new ArrayList<UccMallSkuSpecListBo>();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<UccMallFilterSkuSpecBO>> entry = iterator.next();
                UccMallSkuSpecListBo uccSkuSpecListBo = new UccMallSkuSpecListBo();
                uccSkuSpecListBo.setCommodityPropDefId(entry.getKey());
                uccSkuSpecListBo.setPropName(entry.getValue().get(0).getPropName());
                ArrayList<UccMallSkuSpecPropValueListBo> valueListBos = new ArrayList<UccMallSkuSpecPropValueListBo>();
                List mallFilterSkuSpecBOS = entry.getValue().stream().distinct().collect(Collectors.toList());
                for (UccMallFilterSkuSpecBO each : mallFilterSkuSpecBOS) {
                    UccMallSkuSpecPropValueListBo bo = new UccMallSkuSpecPropValueListBo();
                    bo.setPropValueListId(each.getPropValueListId());
                    bo.setPropValue(each.getPropValue());
                    valueListBos.add(bo);
                }
                uccSkuSpecListBo.setSkuSpecList(valueListBos);
                skuspecList.add(uccSkuSpecListBo);
            }
            rspBO.setSkuspecList(skuspecList);
            if (reqBO.isNeedChoose() && reqBO.getSkuId() != null) {
                UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
                uccSkuSpecPo.setSkuId(reqBO.getSkuId());
                List<UccSkuSpecPo> uccSkuSpecPos = this.uccSkuSpecMapper.querySpec(uccSkuSpecPo);
                if (!CollectionUtils.isEmpty(uccSkuSpecPos)) {
                    List choose = JSONObject.parseArray((String)JSON.toJSONString(uccSkuSpecPos), UccMallSkuSpecPropValueListBo.class);
                    rspBO.setChoose(choose);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAllSpec())) {
            rspBO.setAllSpec(reqBO.getAllSpec());
        } else {
            rspBO.setAllSpec(rspBO.getSkuspecList());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

