/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.tydic.commodity.mall.ability.bo.UccMallFreightBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallSkuNumBO_busi;
import com.tydic.commodity.mall.atom.api.InterfaceFreightQryService;
import com.tydic.commodity.mall.atom.api.UccMallFreightQryAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceFreightQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceFreightQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuNumBO;
import com.tydic.commodity.mall.atom.bo.UccMallFreightQryAtomReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallFreightQryAtomRspBO;
import com.tydic.commodity.mall.config.CommdProPertiesVo;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallFreightQryAtomServiceImpl
implements UccMallFreightQryAtomService {
    @Autowired
    private InterfaceFreightQryService interfaceFreightQryService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private CommdProPertiesVo commdProPertiesVo;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallFreightQryAtomServiceImpl.class);

    @Override
    public UccMallFreightQryAtomRspBO qryFreight(UccMallFreightQryAtomReqBO reqBO) {
        UccMallFreightQryAtomRspBO rspBO = new UccMallFreightQryAtomRspBO();
        try {
            String supplierCode;
            Long supplierId;
            InterfaceFreightQryReqBO uccFreightQryReqBO = new InterfaceFreightQryReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccFreightQryReqBO);
            if (reqBO.getSupplierShopId() == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId(), reqBO.getSysTenantId());
                if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                    rspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                    rspBO.setRespCode("8888");
                    return rspBO;
                }
                supplierId = supplierShopPo.getSupplierId();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            try {
                SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId, reqBO.getSysTenantId());
                if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                    rspBO.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                    rspBO.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
                    return rspBO;
                }
                supplierCode = supplierBusiPo.getSupplierCode();
                if ("jd".equals(supplierCode) && reqBO.getPaymentType() == null) {
                    rspBO.setRespDesc("\u4eac\u4e1c\u5546\u54c1\u8bf7\u8f93\u5165\u4eac\u4e1c\u652f\u4ed8\u65b9\u5f0f");
                    rspBO.setRespCode(UccMallConstantsEnums.BUSINESS_RESTRICTIONS.code());
                    return rspBO;
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            ArrayList<InterfaceSkuNumBO> skuNumBOS = new ArrayList<InterfaceSkuNumBO>();
            if (reqBO.getSku() == null || reqBO.getSku().size() == 0) {
                rspBO.setRespDesc("\u8bf7\u8f93\u5165\u5355\u54c1\u4fe1\u606f");
                rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                return rspBO;
            }
            for (UccMallSkuNumBO_busi skuNumBO : reqBO.getSku()) {
                if (skuNumBO.getSkuId() == null || skuNumBO.getNum() == null) {
                    rspBO.setRespDesc("\u8bf7\u8f93\u5165\u5355\u54c1ID\u548c\u6570\u91cf");
                    rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                    return rspBO;
                }
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuId(skuNumBO.getSkuId());
                uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPo.setSysTenantId(reqBO.getSysTenantId());
                List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
                if (uccSkuPoList == null || uccSkuPoList.size() != 1) continue;
                String extSkuId = uccSkuPoList.get(0).getExtSkuId();
                InterfaceSkuNumBO skuNumBO1 = new InterfaceSkuNumBO();
                skuNumBO1.setSkuId(extSkuId);
                skuNumBO1.setNum(skuNumBO.getNum());
                skuNumBOS.add(skuNumBO1);
            }
            if (skuNumBOS.size() > 0) {
                if ("jd".equals(supplierCode)) {
                    InterfaceSkuNumBO skuNumBO;
                    List repeatkuIds = skuNumBOS.stream().collect(Collectors.groupingBy(cmm -> cmm.getSkuId(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
                    Iterator iterator = skuNumBOS.iterator();
                    HashMap<String, Long> IntMapSku = new HashMap<String, Long>();
                    while (iterator.hasNext()) {
                        skuNumBO = (InterfaceSkuNumBO)iterator.next();
                        if (!repeatkuIds.contains(skuNumBO.getSkuId())) continue;
                        if (IntMapSku.containsKey(skuNumBO.getSkuId())) {
                            Long cumber = (Long)IntMapSku.get(skuNumBO.getSkuId());
                            IntMapSku.put(skuNumBO.getSkuId(), cumber + skuNumBO.getNum());
                        } else {
                            IntMapSku.put(skuNumBO.getSkuId(), skuNumBO.getNum());
                        }
                        iterator.remove();
                    }
                    for (Map.Entry stringLongEntry : IntMapSku.entrySet()) {
                        skuNumBO = new InterfaceSkuNumBO();
                        skuNumBO.setNum((Long)stringLongEntry.getValue());
                        skuNumBO.setSkuId((String)stringLongEntry.getKey());
                        skuNumBOS.add(skuNumBO);
                    }
                }
            } else {
                rspBO.setRespDesc("\u8bf7\u68c0\u67e5\u5355\u54c1ID\u8f93\u5165");
                rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                return rspBO;
            }
            uccFreightQryReqBO.setSku(skuNumBOS);
            uccFreightQryReqBO.setSupplierCode(supplierCode);
            uccFreightQryReqBO.setSupplierId(supplierId);
            InterfaceFreightQryRspBO uccFreightQryRspBO = null;
            uccFreightQryRspBO = this.interfaceFreightQryService.qryFreight(uccFreightQryReqBO);
            if (!"0000".equals(uccFreightQryRspBO.getRespCode())) {
                rspBO.setRespCode(uccFreightQryRspBO.getRespCode());
                rspBO.setRespDesc(uccFreightQryRspBO.getRespDesc());
                return rspBO;
            }
            if (uccFreightQryRspBO.getFreightBO() != null) {
                UccMallFreightBO_busi freightBO = new UccMallFreightBO_busi();
                BeanUtils.copyProperties((Object)uccFreightQryRspBO.getFreightBO(), (Object)freightBO);
                rspBO.setFreightBO(freightBO);
            }
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            rspBO.setRespCode("0000");
            return rspBO;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }
}

