/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.mall.atom.api.UccMallSyncSceneCommodityToEsAtomService;
import com.tydic.commodity.mall.busi.api.UccMallSearchCommodityService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityCategoryForEsBO;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityForEsBO;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallCommoditySpecForEsBO;
import com.tydic.commodity.mall.busi.bo.UccMallDeleteSpuInfoFromEsBO;
import com.tydic.commodity.mall.busi.bo.UccMallEsStorageSpuAttrInfoBO;
import com.tydic.commodity.mall.busi.bo.UccMallEsStorageSpuInfoBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSkuForEsBO;
import com.tydic.commodity.mall.busi.bo.UccMallSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallSyncSceneCommodityToEsRspBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallCatRCommdTypeMapper;
import com.tydic.commodity.mall.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallSaleNumMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuStockMapper;
import com.tydic.commodity.mall.dao.UccMallSpuSpecMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccCatalogDealPO;
import com.tydic.commodity.mall.po.UccCatalogLevelPo;
import com.tydic.commodity.mall.po.UccSaleNumPo;
import com.tydic.commodity.mall.po.UccSkuPicPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.po.UccSkuStockPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallSyncSceneCommodityToEsAtomServiceImpl
implements UccMallSyncSceneCommodityToEsAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallSyncSceneCommodityToEsAtomServiceImpl.class);
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSkuStockMapper uccMallSkuStockMapper;
    @Autowired
    private UccMallSaleNumMapper uccMallSaleNumMapper;
    @Autowired
    private UccMallSkuPicMapper uccMallSkuPicMapper;
    @Autowired
    private UccMallSpuSpecMapper uccMallSpuSpecMapper;
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private UccMallCatRCommdTypeMapper uccMallCatRCommdTypeMapper;
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private UccMallSearchCommodityService uccMallSearchCommodityService;

    @Override
    public UccMallSyncSceneCommodityToEsRspBO syncSceneCommodityToEs(UccMallSyncSceneCommodityToEsReqBO uccMallSyncSceneCommodityToEsReqBO) {
        UccMallSyncSceneCommodityToEsRspBO rspBO = new UccMallSyncSceneCommodityToEsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u6210\u529f!");
        if (uccMallSyncSceneCommodityToEsReqBO.getSupplierId() == null && uccMallSyncSceneCommodityToEsReqBO.getRootOrgIdIn() != null) {
            uccMallSyncSceneCommodityToEsReqBO.setSupplierId(uccMallSyncSceneCommodityToEsReqBO.getRootOrgIdIn());
        }
        this.validateReqParams(uccMallSyncSceneCommodityToEsReqBO);
        if (ModelRuleConstant.OPER_ES_ADD_TYPE.equals(uccMallSyncSceneCommodityToEsReqBO.getOperType())) {
            this.syncCommodityToEs(uccMallSyncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_DELETE_TYPE.equals(uccMallSyncSceneCommodityToEsReqBO.getOperType())) {
            this.deleteCommodityInfoFromEs(uccMallSyncSceneCommodityToEsReqBO);
        } else if (ModelRuleConstant.OPER_ES_UPDATE_TYPE.equals(uccMallSyncSceneCommodityToEsReqBO.getOperType())) {
            this.updateCommodityToEs(uccMallSyncSceneCommodityToEsReqBO);
        } else {
            rspBO.setRespCode(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code());
            rspBO.setRespDesc("\u573a\u666fES\u540c\u6b65\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b[" + uccMallSyncSceneCommodityToEsReqBO.getOperType() + "]\u6682\u4e0d\u652f\u6301!");
        }
        return rspBO;
    }

    private void syncCommodityToEs(UccMallSyncSceneCommodityToEsReqBO reqBO) {
        List<UccMallCommodityForEsBO> uccMallCommodityForEsBOS = this.qryCommodityList(reqBO);
        if (uccMallCommodityForEsBOS == null || uccMallCommodityForEsBOS.isEmpty()) {
            LOGGER.error("ES \u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a \u4e3a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f->{}" + JSONObject.toJSONString((Object)((Object)reqBO)));
            return;
        }
        List<Long> commodityIds = uccMallCommodityForEsBOS.stream().map(UccMallCommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<UccMallEsStorageSpuInfoBO> uccMallEsStorageSpuInfoBOS = new ArrayList<UccMallEsStorageSpuInfoBO>();
        this.assemblyEsSkuInfo(reqBO, commodityIds, uccMallEsStorageSpuInfoBOS);
        this.assemblyEsCommodityAndCategoryInfo(reqBO, commodityIds, uccMallEsStorageSpuInfoBOS, uccMallCommodityForEsBOS);
        this.syncCommodityInfoToEs(uccMallEsStorageSpuInfoBOS);
        List<UccMallEsStorageSpuAttrInfoBO> attrInfoBOS = this.assemblyCommodityAttrInfo(commodityIds, reqBO.getSysTenantId());
        this.syncCommodityAttrToEs(attrInfoBOS);
    }

    private void deleteCommodityInfoFromEs(UccMallSyncSceneCommodityToEsReqBO reqBO) {
        List<UccMallCommodityForEsBO> uccMallCommodityForEsBOS = this.qryCommodityList(reqBO);
        if (uccMallCommodityForEsBOS == null || uccMallCommodityForEsBOS.isEmpty()) {
            LOGGER.error("\u4eceES\u5220\u9664\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
            return;
        }
        List commodityIds = uccMallCommodityForEsBOS.stream().map(UccMallCommodityForEsBO::getCommodityId).collect(Collectors.toList());
        ArrayList<UccMallDeleteSpuInfoFromEsBO> uccMallDeleteSpuInfoFromEsBOS = new ArrayList<UccMallDeleteSpuInfoFromEsBO>();
        Long sceneId = reqBO.getSceneId();
        for (Long commodityId : commodityIds) {
            UccMallDeleteSpuInfoFromEsBO uccMallDeleteSpuInfoFromEsBO = new UccMallDeleteSpuInfoFromEsBO();
            uccMallDeleteSpuInfoFromEsBO.setSceneId(sceneId);
            uccMallDeleteSpuInfoFromEsBO.setCommodityId(commodityId);
            uccMallDeleteSpuInfoFromEsBOS.add(uccMallDeleteSpuInfoFromEsBO);
        }
        this.deleteSpuInfoFromEs(uccMallDeleteSpuInfoFromEsBOS);
    }

    private void updateCommodityToEs(UccMallSyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getSingleType() == 0) {
            List<UccMallCommodityForEsBO> uccMallCommodityForEsBOS = this.qryCommodityList(reqBO);
            if (uccMallCommodityForEsBOS == null || uccMallCommodityForEsBOS.isEmpty()) {
                LOGGER.error("\u66f4\u65b0ES\u4e0b\u7684\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u573a\u666f[" + reqBO.getSceneId() + "]\u4e0b\u5173\u8054\u7684\u5546\u54c1\u6570\u636e!");
                return;
            }
            List<Long> commodityIds = uccMallCommodityForEsBOS.stream().map(UccMallCommodityForEsBO::getCommodityId).collect(Collectors.toList());
            UccMallSearchEsReqBO uccMallSearchEsReqBO = new UccMallSearchEsReqBO();
            uccMallSearchEsReqBO.setCommdIds(commodityIds);
            uccMallSearchEsReqBO.setSceneId(reqBO.getSceneId());
            uccMallSearchEsReqBO.setSysTenantId(reqBO.getSysTenantId());
            UccMallSearchEsRspBo uccMallSearchEsRspBo = this.uccMallSearchCommodityService.queryByMatch(uccMallSearchEsReqBO);
            List<Long> esExistCommodityIds = null;
            if (uccMallSearchEsRspBo != null && uccMallSearchEsRspBo.getUccMallCommodityRspBos() != null && !uccMallSearchEsRspBo.getUccMallCommodityRspBos().isEmpty()) {
                List<UccMallCommodityRspBo> uccMallCommodityRspBos = uccMallSearchEsRspBo.getUccMallCommodityRspBos();
                esExistCommodityIds = uccMallCommodityRspBos.stream().map(UccMallCommodityRspBo::getCommodity_id).collect(Collectors.toList());
            }
            if (esExistCommodityIds == null || esExistCommodityIds.isEmpty()) {
                return;
            }
            ArrayList<UccMallCommodityForEsBO> newUccMallCommodityForEsBOS = new ArrayList<UccMallCommodityForEsBO>();
            for (UccMallCommodityForEsBO uccMallCommodityForEsBO : uccMallCommodityForEsBOS) {
                if (!esExistCommodityIds.contains(uccMallCommodityForEsBO.getCommodityId())) continue;
                newUccMallCommodityForEsBOS.add(uccMallCommodityForEsBO);
            }
            ArrayList<UccMallEsStorageSpuInfoBO> uccMallEsStorageSpuInfoBOS = new ArrayList<UccMallEsStorageSpuInfoBO>();
            this.assemblyEsSkuInfo(reqBO, esExistCommodityIds, uccMallEsStorageSpuInfoBOS);
            this.assemblyEsCommodityAndCategoryInfo(reqBO, esExistCommodityIds, uccMallEsStorageSpuInfoBOS, newUccMallCommodityForEsBOS);
            this.syncCommodityInfoToEs(uccMallEsStorageSpuInfoBOS);
        } else {
            this.searchSku(reqBO);
            if (reqBO.getSingleType() != 1) {
                if (reqBO.getSingleType() == 2) {
                    List<UccSkuPo> poList = this.uccMallSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId(), reqBO.getSysTenantId());
                    if (!CollectionUtils.isEmpty(poList)) {
                        for (UccSkuPo each : poList) {
                            JSONObject object = new JSONObject();
                            object.put("sku_status", (Object)each.getSkuStatus());
                            this.mallElasticsearchUtil.updateData(this.mallEsConfig.getIndexName(), this.mallEsConfig.getEsType(), reqBO.getSceneId() == null ? each.getSkuId().toString() : reqBO.getSceneId() + "" + each.getSkuId(), object);
                        }
                    }
                } else if (reqBO.getSingleType() == 3) {
                    List<UccSkuPricePo> pricePos = this.uccMallSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuIds(), reqBO.getSupplierId(), reqBO.getSysTenantId());
                    if (!CollectionUtils.isEmpty(pricePos)) {
                        for (UccSkuPricePo each : pricePos) {
                            JSONObject object = new JSONObject();
                            object.put("sale_price", (Object)each.getSalePrice());
                            object.put("agreement_price", (Object)each.getAgreementPrice());
                            object.put("market_price", (Object)each.getMarketPrice());
                            object.put("member_price1", (Object)each.getMemberPrice1());
                            object.put("member_price2", (Object)each.getMemberPrice2());
                            object.put("member_price3", (Object)each.getMemberPrice3());
                            object.put("member_price4", (Object)each.getMemberPrice4());
                            object.put("member_price5", (Object)each.getMemberPrice5());
                            object.put("discounts", (Object)(each.getSalePrice() / each.getAgreementPrice()));
                            this.mallElasticsearchUtil.updateData(this.mallEsConfig.getIndexName(), this.mallEsConfig.getEsType(), reqBO.getSceneId() == null ? each.getSkuId().toString() : reqBO.getSceneId() + "" + each.getSkuId(), object);
                        }
                    }
                } else {
                    LOGGER.error("\u672a\u77e5\u540c\u6b65\u7c7b\u578b");
                }
            }
        }
    }

    private List<UccMallCommodityForEsBO> qryCommodityList(UccMallSyncSceneCommodityToEsReqBO reqBO) {
        List<Long> commodityTypeIds;
        List<UccMallCommodityForEsBO> uccMallCommodityForEsBOS = null;
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccMallCommodityTypeMapper.qryCommodityTypeIdsByCategorys(reqBO.getCategoryIds(), reqBO.getSysTenantId());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            uccMallCommodityForEsBOS = this.uccMallCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getRootOrgIdIn(), reqBO.getSceneId(), reqBO.getSysTenantId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType())) {
            commodityTypeIds = this.uccMallCatRCommdTypeMapper.queryTypeByGuideCatalogIds(reqBO.getGuiCategoryIds(), reqBO.getSysTenantId());
            if (commodityTypeIds == null || commodityTypeIds.isEmpty()) {
                throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u7c7b\u76ee\u5173\u8054\u7684\u5546\u54c1\u7c7b\u578b\u6570\u636e!");
            }
            uccMallCommodityForEsBOS = this.uccMallCommodityMapper.qrySpusBySpuTypeIdOrSupId(commodityTypeIds, null, reqBO.getSupplierId(), reqBO.getSceneId(), reqBO.getSysTenantId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType())) {
            uccMallCommodityForEsBOS = this.uccMallCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, reqBO.getCommodityIds(), reqBO.getSupplierId(), reqBO.getSceneId(), reqBO.getSysTenantId());
        }
        if (ModelRuleConstant.SYNC_ES_BY_SKU_ID.equals(reqBO.getSyncType())) {
            List<UccSkuPo> skuPoList = this.uccMallSkuMapper.queryBatchSkusLessCloum(reqBO.getSkuIds(), reqBO.getSupplierId(), reqBO.getSysTenantId());
            if (CollectionUtils.isEmpty(skuPoList)) {
                return uccMallCommodityForEsBOS;
            }
            ArrayList<Long> commodityIds = new ArrayList<Long>();
            for (UccSkuPo uccSkuPo : skuPoList) {
                if (commodityIds.contains(uccSkuPo.getCommodityId())) continue;
                commodityIds.add(uccSkuPo.getCommodityId());
            }
            uccMallCommodityForEsBOS = this.uccMallCommodityMapper.qrySpusBySpuTypeIdOrSupId(null, commodityIds, reqBO.getSupplierId(), reqBO.getSceneId(), reqBO.getSysTenantId());
        }
        if (!CollectionUtils.isEmpty(uccMallCommodityForEsBOS)) {
            ArrayList mergeSameB0s = new ArrayList();
            HashedMap mergeSameMap = new HashedMap();
            for (UccMallCommodityForEsBO uccMallCommodityForEsBO : uccMallCommodityForEsBOS) {
                UccMallCommodityForEsBO bo;
                if (uccMallCommodityForEsBO.getGuideCataLogId() == null) {
                    bo = new UccMallCommodityForEsBO();
                    BeanUtils.copyProperties((Object)uccMallCommodityForEsBO, (Object)bo);
                    mergeSameMap.put(uccMallCommodityForEsBO.getCommodityId(), bo);
                    continue;
                }
                if (mergeSameMap.containsKey(uccMallCommodityForEsBO.getCommodityId())) {
                    ((UccMallCommodityForEsBO)mergeSameMap.get(uccMallCommodityForEsBO.getCommodityId())).getGuideCataLogIds().add(uccMallCommodityForEsBO.getGuideCataLogId());
                    continue;
                }
                bo = new UccMallCommodityForEsBO();
                BeanUtils.copyProperties((Object)uccMallCommodityForEsBO, (Object)bo);
                bo.setGuideCataLogIds(new ArrayList<Long>(Arrays.asList(uccMallCommodityForEsBO.getGuideCataLogId())));
                mergeSameMap.put(uccMallCommodityForEsBO.getCommodityId(), bo);
            }
            uccMallCommodityForEsBOS = new ArrayList<UccMallCommodityForEsBO>();
            for (Map.Entry entry : mergeSameMap.entrySet()) {
                uccMallCommodityForEsBOS.add((UccMallCommodityForEsBO)entry.getValue());
            }
            uccMallCommodityForEsBOS.addAll(mergeSameB0s);
        }
        return uccMallCommodityForEsBOS;
    }

    private void assemblyEsSkuInfo(UccMallSyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<UccMallEsStorageSpuInfoBO> uccMallEsStorageSpuInfoBOS) {
        List<UccMallSkuForEsBO> uccMallSkuForEsBOS = this.uccMallSkuMapper.qrySkuAndLowPriceList(reqBO.getSupplierId(), commodityIds, reqBO.getSysTenantId());
        if (uccMallSkuForEsBOS == null || uccMallSkuForEsBOS.isEmpty()) {
            throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4e0b\u5173\u8054\u7684\u5355\u54c1\u6570\u636e!");
        }
        List<Long> skuIds = uccMallSkuForEsBOS.stream().map(UccMallSkuForEsBO::getSkuId).collect(Collectors.toList());
        List<UccSkuStockPo> skuStockPos = this.uccMallSkuStockMapper.batchQryById(skuIds, reqBO.getSupplierId(), reqBO.getSysTenantId());
        Map<Long, UccSkuStockPo> skuStockPoMap = skuStockPos.stream().collect(Collectors.toMap(UccSkuStockPo::getSkuId, uccSkuStockPo -> uccSkuStockPo));
        List<UccSaleNumPo> saleNumPos = this.uccMallSaleNumMapper.qryBySkuIds(skuIds, reqBO.getSysTenantId());
        Map<Long, UccSaleNumPo> saleNumPoMap = saleNumPos.stream().collect(Collectors.toMap(UccSaleNumPo::getSkuId, uccSaleNumPo -> uccSaleNumPo));
        List<UccSkuPicPo> skuPicPos = this.uccMallSkuPicMapper.qeurySkuPicBySkuId(skuIds, reqBO.getSysTenantId());
        Map<Long, UccSkuPicPo> skuPicPoMap = skuPicPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, uccSkuPicPo -> uccSkuPicPo));
        this.buildEsSku(uccMallEsStorageSpuInfoBOS, uccMallSkuForEsBOS, skuStockPoMap, saleNumPoMap, skuPicPoMap);
    }

    private void buildEsSku(List<UccMallEsStorageSpuInfoBO> uccMallEsStorageSpuInfoBOS, List<UccMallSkuForEsBO> uccMallSkuForEsBOS, Map<Long, UccSkuStockPo> skuStockPoMap, Map<Long, UccSaleNumPo> saleNumPoMap, Map<Long, UccSkuPicPo> skuPicPoMap) {
        for (UccMallSkuForEsBO uccMallSkuForEsBO : uccMallSkuForEsBOS) {
            UccSkuPicPo uccSkuPicPo;
            UccSaleNumPo uccSaleNumPo;
            UccSkuStockPo uccSkuStockPo;
            UccMallEsStorageSpuInfoBO uccMallEsStorageSpuInfoBO = new UccMallEsStorageSpuInfoBO();
            uccMallEsStorageSpuInfoBO.setCommodity_id(uccMallSkuForEsBO.getCommodityId());
            uccMallEsStorageSpuInfoBO.setSku_id(uccMallSkuForEsBO.getSkuId());
            uccMallEsStorageSpuInfoBO.setSku_name(uccMallSkuForEsBO.getSkuName());
            uccMallEsStorageSpuInfoBO.setSearch_name(uccMallSkuForEsBO.getSkuName());
            uccMallEsStorageSpuInfoBO.setExt_sku_id(uccMallSkuForEsBO.getExtSkuId());
            uccMallEsStorageSpuInfoBO.setBrand_id(uccMallSkuForEsBO.getBrandId());
            uccMallEsStorageSpuInfoBO.setBrand_name(uccMallSkuForEsBO.getBrandName());
            uccMallEsStorageSpuInfoBO.setSku_status(uccMallSkuForEsBO.getSkuStatus());
            uccMallEsStorageSpuInfoBO.setSku_source(uccMallSkuForEsBO.getSkuSource());
            uccMallEsStorageSpuInfoBO.setMfgsku(uccMallSkuForEsBO.getMfgsku());
            uccMallEsStorageSpuInfoBO.setUpc(uccMallSkuForEsBO.getUpcCode());
            uccMallEsStorageSpuInfoBO.setType_id(uccMallSkuForEsBO.getCommodityTypeId());
            uccMallEsStorageSpuInfoBO.setType_name(uccMallSkuForEsBO.getCommodityTypeName());
            if (uccMallSkuForEsBO.getOnShelveTime() != null) {
                uccMallEsStorageSpuInfoBO.setOn_shelve_time(DateUtils.strToDateLong((String)uccMallSkuForEsBO.getOnShelveTime()).getTime());
            }
            uccMallEsStorageSpuInfoBO.setAgreement_id(uccMallSkuForEsBO.getAgreementId());
            uccMallEsStorageSpuInfoBO.setSale_price(uccMallSkuForEsBO.getSalePrice() == null ? 0.0 : (double)uccMallSkuForEsBO.getSalePrice().longValue());
            uccMallEsStorageSpuInfoBO.setAgreement_price(uccMallSkuForEsBO.getAgreementPrice() == null ? 0.0 : (double)uccMallSkuForEsBO.getAgreementPrice().longValue());
            uccMallEsStorageSpuInfoBO.setMarket_price(uccMallSkuForEsBO.getMarketPrice() == null ? 0.0 : (double)uccMallSkuForEsBO.getMarketPrice().longValue());
            if (uccMallSkuForEsBO.getMemberPrice1() != null) {
                uccMallEsStorageSpuInfoBO.setMember_price1(uccMallSkuForEsBO.getMemberPrice1() == null ? 0.0 : (double)uccMallSkuForEsBO.getMemberPrice1().longValue());
            }
            if (uccMallSkuForEsBO.getMemberPrice2() != null) {
                uccMallEsStorageSpuInfoBO.setMember_price2(uccMallSkuForEsBO.getMemberPrice2() == null ? 0.0 : (double)uccMallSkuForEsBO.getMemberPrice2().longValue());
            }
            uccMallEsStorageSpuInfoBO.setMember_price3(uccMallSkuForEsBO.getMemberPrice3() == null ? 0.0 : (double)uccMallSkuForEsBO.getMemberPrice3().longValue());
            uccMallEsStorageSpuInfoBO.setMember_price4(uccMallSkuForEsBO.getMemberPrice4() == null ? 0.0 : (double)uccMallSkuForEsBO.getMemberPrice4().longValue());
            uccMallEsStorageSpuInfoBO.setMember_price5(uccMallSkuForEsBO.getMemberPrice5() == null ? 0.0 : (double)uccMallSkuForEsBO.getMemberPrice5().longValue());
            uccMallEsStorageSpuInfoBO.setSupplier_id(uccMallSkuForEsBO.getSupplierId());
            uccMallEsStorageSpuInfoBO.setSupplier_shop_id(uccMallSkuForEsBO.getSupplierShopId());
            uccMallEsStorageSpuInfoBO.setShop_name(uccMallSkuForEsBO.getShopName());
            uccMallEsStorageSpuInfoBO.setSupplier_name(uccMallSkuForEsBO.getSupplierName());
            String discount = "0";
            if (uccMallSkuForEsBO.getSalePrice() != null && uccMallSkuForEsBO.getMarketPrice() != null && uccMallSkuForEsBO.getMarketPrice() != 0L) {
                discount = String.format("%.2f", (double)uccMallSkuForEsBO.getSalePrice().longValue() / (double)uccMallSkuForEsBO.getMarketPrice().longValue());
            }
            uccMallEsStorageSpuInfoBO.setDiscounts(Double.valueOf(discount));
            uccMallEsStorageSpuInfoBO.setComment_number(null);
            if (skuStockPoMap.size() > 0 && (uccSkuStockPo = skuStockPoMap.get(uccMallSkuForEsBO.getSkuId())) != null) {
                uccMallEsStorageSpuInfoBO.setComment_number(uccSkuStockPo.getStockNum().longValue());
            }
            uccMallEsStorageSpuInfoBO.setSold_number(null);
            uccMallEsStorageSpuInfoBO.setEcommerce_sale(null);
            if (saleNumPoMap.size() > 0 && (uccSaleNumPo = saleNumPoMap.get(uccMallSkuForEsBO.getSkuId())) != null) {
                if (uccSaleNumPo.getSoldNumber() != null) {
                    uccMallEsStorageSpuInfoBO.setSold_number(uccSaleNumPo.getSoldNumber().longValue());
                }
                if (uccSaleNumPo.getEcommerceSale() != null) {
                    uccMallEsStorageSpuInfoBO.setEcommerce_sale(uccSaleNumPo.getEcommerceSale().longValue());
                }
            }
            if (skuPicPoMap.size() > 0 && (uccSkuPicPo = skuPicPoMap.get(uccMallSkuForEsBO.getSkuId())) != null) {
                uccMallEsStorageSpuInfoBO.setPicture_url(uccSkuPicPo.getSkuPicUrl());
            }
            uccMallEsStorageSpuInfoBO.setChannel_id(null);
            uccMallEsStorageSpuInfoBO.setBrand_id_name(null);
            uccMallEsStorageSpuInfoBO.setDescription(null);
            uccMallEsStorageSpuInfoBO.setSupplier_id_name(null);
            uccMallEsStorageSpuInfoBO.setProperties(null);
            uccMallEsStorageSpuInfoBO.setL4mg_category_id(uccMallSkuForEsBO.getMgCatalogId());
            uccMallEsStorageSpuInfoBO.setL4mg_category_name(uccMallSkuForEsBO.getMgCatalogName());
            uccMallEsStorageSpuInfoBO.setMaterial_id(uccMallSkuForEsBO.getMaterialId());
            uccMallEsStorageSpuInfoBO.setMaterial_name(uccMallSkuForEsBO.getMaterialName());
            uccMallEsStorageSpuInfoBO.setManufacturer(uccMallSkuForEsBO.getManufacturer());
            uccMallEsStorageSpuInfoBO.setFigure(uccMallSkuForEsBO.getFigure());
            uccMallEsStorageSpuInfoBO.setModel(uccMallSkuForEsBO.getModel());
            uccMallEsStorageSpuInfoBOS.add(uccMallEsStorageSpuInfoBO);
        }
    }

    private void assemblyEsCommodityAndCategoryInfo(UccMallSyncSceneCommodityToEsReqBO reqBO, List<Long> commodityIds, List<UccMallEsStorageSpuInfoBO> uccMallEsStorageSpuInfoBOS, List<UccMallCommodityForEsBO> uccMallCommodityForEsBOS) {
        Map<Long, UccMallCommodityForEsBO> commodityEsBOMap = uccMallCommodityForEsBOS.stream().collect(Collectors.toMap(UccMallCommodityForEsBO::getCommodityId, uccMallCommodityForEsBO -> uccMallCommodityForEsBO));
        ArrayList<Long> guiCataLog = new ArrayList<Long>();
        for (UccMallCommodityForEsBO each : uccMallCommodityForEsBOS) {
            if (CollectionUtils.isEmpty(each.getGuideCataLogIds())) continue;
            guiCataLog.addAll(each.getGuideCataLogIds());
        }
        if (!CollectionUtils.isEmpty(guiCataLog)) {
            LinkedHashSet hashSet = new LinkedHashSet(guiCataLog);
            guiCataLog = new ArrayList(hashSet);
        }
        List<UccCatalogLevelPo> catalogLevelPos = this.uccMallCatalogDealMapper.quryCatalogLevel(reqBO.getSceneId(), null, guiCataLog, reqBO.getSysTenantId());
        Object catalogDealPOMap = new HashedMap();
        if (!CollectionUtils.isEmpty(catalogLevelPos)) {
            catalogDealPOMap = catalogLevelPos.stream().collect(Collectors.toMap(UccCatalogLevelPo::getL3GuideCatalogId, UccCatalogLevelPo2 -> UccCatalogLevelPo2));
        }
        List<UccMallCommoditySpecForEsBO> uccMallCommoditySpecForEsBOS = this.uccMallSpuSpecMapper.qrySpuSpecList(commodityIds, reqBO.getSupplierId(), reqBO.getSysTenantId());
        Map<Long, UccMallCommoditySpecForEsBO> commoditySpecForEsBOMap = uccMallCommoditySpecForEsBOS.stream().collect(Collectors.toMap(UccMallCommoditySpecForEsBO::getCommodityId, uccMallCommoditySpecForEsBO -> uccMallCommoditySpecForEsBO));
        for (UccMallEsStorageSpuInfoBO uccMallEsStorageSpuInfoBO : uccMallEsStorageSpuInfoBOS) {
            UccMallCommoditySpecForEsBO uccMallCommoditySpecForEsBO2;
            UccMallCommodityForEsBO uccMallCommodityForEsBO2 = commodityEsBOMap.get(uccMallEsStorageSpuInfoBO.getCommodity_id());
            uccMallEsStorageSpuInfoBO.setScene_id(reqBO.getSceneId());
            uccMallEsStorageSpuInfoBO.setCommodity_name(uccMallCommodityForEsBO2.getCommodityName());
            uccMallEsStorageSpuInfoBO.setCommd_pic_url(uccMallCommodityForEsBO2.getCommodityPicUrl());
            if (!CollectionUtils.isEmpty(uccMallCommodityForEsBO2.getGuideCataLogIds())) {
                uccMallEsStorageSpuInfoBO.setL3_category_id(uccMallCommodityForEsBO2.getGuideCataLogIds().stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
            uccMallEsStorageSpuInfoBO.setVendor_id(uccMallCommodityForEsBO2.getVendorId());
            uccMallEsStorageSpuInfoBO.setVendor_name(uccMallCommodityForEsBO2.getVendorName());
            if (StringUtils.isEmpty((CharSequence)uccMallEsStorageSpuInfoBO.getPicture_url())) {
                uccMallEsStorageSpuInfoBO.setPicture_url(uccMallCommodityForEsBO2.getCommodityPicUrl());
            }
            uccMallEsStorageSpuInfoBO.setView_order(uccMallCommodityForEsBO2.getViewOrder());
            uccMallEsStorageSpuInfoBO.setShow_prop_json(null);
            if (catalogDealPOMap.size() > 0 && !CollectionUtils.isEmpty(uccMallEsStorageSpuInfoBO.getL3_category_id())) {
                for (String l3_category_id : uccMallEsStorageSpuInfoBO.getL3_category_id()) {
                    if (!catalogDealPOMap.containsKey(Long.valueOf(l3_category_id))) continue;
                    if (((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1GuideCatalogId() != null) {
                        if (CollectionUtils.isEmpty(uccMallEsStorageSpuInfoBO.getL1_category_id())) {
                            uccMallEsStorageSpuInfoBO.setL1_category_id(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1GuideCatalogId()))));
                        } else {
                            uccMallEsStorageSpuInfoBO.getL1_category_id().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1GuideCatalogId()));
                        }
                    }
                    if (((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2GuideCatalogId() != null) {
                        if (CollectionUtils.isEmpty(uccMallEsStorageSpuInfoBO.getL2_category_id())) {
                            uccMallEsStorageSpuInfoBO.setL2_category_id(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2GuideCatalogId()))));
                        } else {
                            uccMallEsStorageSpuInfoBO.getL2_category_id().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2GuideCatalogId()));
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1CatalogName())) {
                        if (CollectionUtils.isEmpty(uccMallEsStorageSpuInfoBO.getL1_category_name())) {
                            uccMallEsStorageSpuInfoBO.setL1_category_name(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1CatalogName()))));
                        } else {
                            uccMallEsStorageSpuInfoBO.getL1_category_name().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL1CatalogName()));
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2CatalogName())) {
                        if (CollectionUtils.isEmpty(uccMallEsStorageSpuInfoBO.getL2_category_name())) {
                            uccMallEsStorageSpuInfoBO.setL2_category_name(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2CatalogName()))));
                        } else {
                            uccMallEsStorageSpuInfoBO.getL2_category_name().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL2CatalogName()));
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL3CatalogName())) {
                        if (CollectionUtils.isEmpty(uccMallEsStorageSpuInfoBO.getL3_category_name())) {
                            uccMallEsStorageSpuInfoBO.setL3_category_name(new ArrayList<String>(Arrays.asList(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL3CatalogName()))));
                        } else {
                            uccMallEsStorageSpuInfoBO.getL3_category_name().add(String.valueOf(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getL3CatalogName()));
                        }
                    }
                    if (((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getChannelId() == null) continue;
                    if (CollectionUtils.isEmpty(uccMallEsStorageSpuInfoBO.getChannel_id())) {
                        uccMallEsStorageSpuInfoBO.setChannel_id(new ArrayList<Long>(Arrays.asList(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getChannelId())));
                        continue;
                    }
                    uccMallEsStorageSpuInfoBO.getChannel_id().add(((UccCatalogLevelPo)catalogDealPOMap.get(Long.valueOf(l3_category_id))).getChannelId());
                }
            }
            if (commoditySpecForEsBOMap.size() > 0 && (uccMallCommoditySpecForEsBO2 = commoditySpecForEsBOMap.get(uccMallEsStorageSpuInfoBO.getCommodity_id())) != null) {
                uccMallEsStorageSpuInfoBO.setShow_prop_json(uccMallCommoditySpecForEsBO2.getPropJson());
            }
            String properties = this.uccMallSpuSpecMapper.getSpuSpecProperties(uccMallEsStorageSpuInfoBO.getSku_id(), reqBO.getSysTenantId());
            uccMallEsStorageSpuInfoBO.setProperties(properties);
            uccMallEsStorageSpuInfoBO.setUnuse_suppliershop_list(null);
        }
    }

    private UccMallCommodityCategoryForEsBO assemblyCategoryInfo(UccMallCommodityCategoryForEsBO categoryForEsBO, Map<Long, UccCatalogDealPO> upperCatalogDealPOMap) {
        UccMallCommodityCategoryForEsBO finalSpuCategoryForEsBO = new UccMallCommodityCategoryForEsBO();
        for (int i = 0; i < upperCatalogDealPOMap.size(); ++i) {
            UccCatalogDealPO uccCatalogDealPO;
            if (i == 0 && categoryForEsBO.getUpperGatalogId() == 0L) {
                return categoryForEsBO;
            }
            if (i == 0 && categoryForEsBO.getUpperGatalogId() != 0L) {
                uccCatalogDealPO = upperCatalogDealPOMap.get(categoryForEsBO.getUpperGatalogId());
                finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(categoryForEsBO, uccCatalogDealPO);
                continue;
            }
            if (finalSpuCategoryForEsBO.getUpperGatalogId() == 0L) {
                return finalSpuCategoryForEsBO;
            }
            uccCatalogDealPO = upperCatalogDealPOMap.get(finalSpuCategoryForEsBO.getUpperGatalogId());
            finalSpuCategoryForEsBO = this.mergeChildAndParentCategory(finalSpuCategoryForEsBO, uccCatalogDealPO);
        }
        return finalSpuCategoryForEsBO;
    }

    private UccMallCommodityCategoryForEsBO mergeChildAndParentCategory(UccMallCommodityCategoryForEsBO childCategory, UccCatalogDealPO parentCategory) {
        UccMallCommodityCategoryForEsBO finalCategory = new UccMallCommodityCategoryForEsBO();
        finalCategory.setGuideCatalogId(parentCategory.getGuideCatalogId());
        finalCategory.setUpperGatalogId(parentCategory.getUpperCatalogId());
        finalCategory.setCatalogName(parentCategory.getCatalogName());
        finalCategory.setChildCatalog(childCategory);
        return finalCategory;
    }

    private void syncCommodityInfoToEs(List<UccMallEsStorageSpuInfoBO> uccMallEsStorageSpuInfoBOS) {
        for (UccMallEsStorageSpuInfoBO uccMallEsStorageSpuInfoBO : uccMallEsStorageSpuInfoBOS) {
            String jsonStr = JSONObject.toJSONString((Object)uccMallEsStorageSpuInfoBO);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            String esId = "";
            esId = uccMallEsStorageSpuInfoBO.getScene_id() == null ? String.valueOf(uccMallEsStorageSpuInfoBO.getSku_id()) : uccMallEsStorageSpuInfoBO.getScene_id() + String.valueOf(uccMallEsStorageSpuInfoBO.getSku_id());
            String id = this.mallElasticsearchUtil.addData(this.mallEsConfig.getIndexName(), this.mallEsConfig.getEsType(), esId, jsonObject);
            if (!StringUtils.isBlank((CharSequence)id)) continue;
            LOGGER.error("\u5546\u54c1\u4fe1\u606f[" + uccMallEsStorageSpuInfoBO.getScene_id() == null ? "" : uccMallEsStorageSpuInfoBO.getScene_id() + "|" + uccMallEsStorageSpuInfoBO.getCommodity_id() + "]\u540c\u6b65\u5931\u8d25!");
        }
    }

    private void syncCommodityAttrToEs(List<UccMallEsStorageSpuAttrInfoBO> attrInfoBOS) {
        if (CollectionUtils.isEmpty(attrInfoBOS)) {
            return;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (UccMallEsStorageSpuAttrInfoBO each : attrInfoBOS) {
            JSONObject map = JSONObject.parseObject((String)JSON.toJSONString((Object)each));
            list.add((Map<String, Object>)map);
        }
        this.mallElasticsearchUtil.bulkPutIndex(this.mallEsConfig.getPropIndexName(), this.mallEsConfig.getPropIndexType(), list, "spec_id");
    }

    private void deleteSpuInfoFromEs(List<UccMallDeleteSpuInfoFromEsBO> uccMallDeleteSpuInfoFromEsBOS) {
        for (UccMallDeleteSpuInfoFromEsBO uccMallDeleteSpuInfoFromEsBO : uccMallDeleteSpuInfoFromEsBOS) {
            JSONObject delConditionOrderJson = new JSONObject();
            delConditionOrderJson.put("commodity_id", (Object)String.valueOf(uccMallDeleteSpuInfoFromEsBO.getCommodityId()));
            JSONObject termOrderJson = new JSONObject();
            termOrderJson.put("term", (Object)delConditionOrderJson);
            JSONObject delConditionAfsJson = new JSONObject();
            delConditionAfsJson.put("scene_id", (Object)String.valueOf(uccMallDeleteSpuInfoFromEsBO.getSceneId()));
            JSONObject termAfsJson = new JSONObject();
            termAfsJson.put("term", (Object)delConditionAfsJson);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)termOrderJson);
            jsonArray.add((Object)termAfsJson);
            JSONObject mustJson = new JSONObject();
            mustJson.put("must", (Object)jsonArray);
            JSONObject boolJson = new JSONObject();
            boolJson.put("bool", (Object)mustJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)boolJson);
            String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_delete_by_query";
            Boolean deleteResult = this.mallElasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (deleteResult.booleanValue()) continue;
            LOGGER.error("\u573a\u666f\u4e0b\u7684\u5546\u54c1\u4fe1\u606f[" + uccMallDeleteSpuInfoFromEsBO.getSceneId() + "|" + uccMallDeleteSpuInfoFromEsBO.getCommodityId() + "]\u5220\u9664\u5931\u8d25!");
        }
    }

    public void searchSku(UccMallSyncSceneCommodityToEsReqBO reqBO) {
        if (!CollectionUtils.isEmpty(reqBO.getSkuIds())) {
            return;
        }
        List<Object> skuPoList = new ArrayList();
        if (!CollectionUtils.isEmpty(reqBO.getGuiCategoryIds())) {
            skuPoList = this.uccMallSkuMapper.qrySkuByGuiCataLogs(reqBO.getGuiCategoryIds(), reqBO.getSupplierId(), reqBO.getSysTenantId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getCategoryIds())) {
            skuPoList = this.uccMallSkuMapper.qrySkuByCataLogs(reqBO.getCategoryIds(), reqBO.getSupplierId(), reqBO.getSysTenantId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getCommodityIds())) {
            skuPoList = this.uccMallSkuMapper.qrySkuByCommoditys(reqBO.getCommodityIds(), reqBO.getSupplierId(), reqBO.getSysTenantId());
        }
        if (!CollectionUtils.isEmpty(skuPoList)) {
            reqBO.setSkuIds(skuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList()));
        }
    }

    private List<UccMallEsStorageSpuAttrInfoBO> assemblyCommodityAttrInfo(List<Long> commodityIds, Long sysTenantId) {
        if (CollectionUtils.isEmpty(commodityIds)) {
            return new ArrayList<UccMallEsStorageSpuAttrInfoBO>();
        }
        return this.uccMallSpuSpecMapper.qryEsAttrList(commodityIds, sysTenantId);
    }

    private void validateReqParams(UccMallSyncSceneCommodityToEsReqBO reqBO) {
        if (reqBO.getOperType() == null) {
            throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1aES\u64cd\u4f5c\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBO.getSyncType() == null) {
            throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u540c\u6b65\u7c7b\u578b\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getCategoryIds() == null || reqBO.getCategoryIds().isEmpty())) {
            throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_GUI_CATEGORY_ID.equals(reqBO.getSyncType()) && (reqBO.getGuiCategoryIds() == null || reqBO.getGuiCategoryIds().isEmpty())) {
            throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5173\u8054\u7c7b\u76ee\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID.equals(reqBO.getSyncType()) && (reqBO.getCommodityIds() == null || reqBO.getCommodityIds().isEmpty())) {
            throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u5546\u54c1\u5230ES\u5931\u8d25\uff1a\u5546\u54c1ID\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ModelRuleConstant.SYNC_ES_BY_ACTIVITY_CONTENT.equals(reqBO.getSyncType()) && (reqBO.getUccMallSpuEsForActivityBOS() == null || reqBO.getUccMallSpuEsForActivityBOS().isEmpty())) {
            throw new BusinessException(UccMallConstantsEnums.ES_SYNCHRONIZATION_FAILED.code(), "\u540c\u6b65\u573a\u666f\u4e0b\u7684\u6d3b\u52a8\u4fe1\u606f\u5230ES\u5931\u8d25\uff1a\u6d3b\u52a8\u76f8\u5173\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

