/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.ability.bo.UccMallPropEntityBo;
import com.tydic.commodity.mall.ability.bo.UccMallPropEntityValue;
import com.tydic.commodity.mall.ability.bo.UccMallSkuBo;
import com.tydic.commodity.mall.ability.bo.UccMallSpecBo;
import com.tydic.commodity.mall.ability.bo.UccMallSpuSpecBo;
import com.tydic.commodity.mall.atom.api.UccMallDictionaryAtomService;
import com.tydic.commodity.mall.atom.api.UccQryCommdDetailAtomService;
import com.tydic.commodity.mall.atom.api.UccQrySkuInfoAtomService;
import com.tydic.commodity.mall.atom.bo.UccQrySkuDetailReqBO;
import com.tydic.commodity.mall.atom.bo.UccQrySkuDetailRspBO;
import com.tydic.commodity.mall.busi.api.UccQryCommodityDetailBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityBo;
import com.tydic.commodity.mall.busi.bo.UccQryCommdDetailReqBO;
import com.tydic.commodity.mall.busi.bo.UccQryCommdDetailRspBO;
import com.tydic.commodity.mall.constants.CommodityEnum;
import com.tydic.commodity.mall.constants.SkuEnum;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccCommodityDetailMapper;
import com.tydic.commodity.mall.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.mall.dao.UccMallBrandDealMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.dao.UccSkuSpecMapper;
import com.tydic.commodity.mall.po.DicDictionaryPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccBrandDealPO;
import com.tydic.commodity.mall.po.UccCommodityDetailPO;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccCommodityPropGrpPo;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.DateUtils;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccQryCommodityDetailBusiServiceImpl
implements UccQryCommodityDetailBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommodityDetailBusiServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccSkuMapper;
    @Autowired
    private UccMallCommodityMapper uccCommodityMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccQrySkuInfoAtomService uccQrySkuInfoAtomService;
    @Autowired
    private UccQryCommdDetailAtomService uccQryCommdDetailAtomService;
    @Autowired
    private UccMallDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccMallSupplierShopMapper supplierShopMapper;
    @Autowired
    private UccMallBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;

    @Override
    public UccQryCommdDetailRspBO qryCommodityDetail(UccQryCommdDetailReqBO reqBO) {
        SupplierShopPo supplierShopPo;
        UccCommodityTypePo uccCommodityTypePo;
        UccQryCommdDetailRspBO rspBO = new UccQryCommdDetailRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccSkuPo qryCommd = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryCommd);
        List<UccSkuPo> listSku = this.uccSkuMapper.qerySku(qryCommd);
        if (listSku == null || listSku.size() == 0) {
            rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        reqBO.setCommodityId(listSku.get(0).getCommodityId());
        UccCommodityPo commdPo = this.uccCommodityMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId(), reqBO.getSysTenantId());
        if (commdPo == null) {
            rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccMallCommodityBo commodityBo = new UccMallCommodityBo();
        BeanUtils.copyProperties((Object)commdPo, (Object)commodityBo);
        UccCommodityDetailPO uccCommodityDetailPO = new UccCommodityDetailPO();
        uccCommodityDetailPO.setCommodityId(commodityBo.getCommodityId());
        uccCommodityDetailPO.setSupplierShopId(commodityBo.getSupplierShopId());
        uccCommodityDetailPO.setSysTenantId(reqBO.getSysTenantId());
        UccCommodityDetailPO uccCommodityDetailrsp = this.uccCommodityDetailMapper.getModelBy(uccCommodityDetailPO);
        if (uccCommodityDetailrsp != null) {
            commodityBo.setCommodityPcDetailChar(uccCommodityDetailrsp.getCommodityPcDetailChar());
            commodityBo.setCommodityPcDetailUrl(uccCommodityDetailrsp.getCommodityPcDetailUrl());
            commodityBo.setCommodityPhoneDetailChar(uccCommodityDetailrsp.getCommodityPhoneDetailChar());
            commodityBo.setCommodityPhoneDetailUrl(uccCommodityDetailrsp.getCommodityPhoneDetailChar());
        }
        if ((uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(commdPo.getCommodityTypeId(), reqBO.getSysTenantId())) != null) {
            commodityBo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
        }
        if ((supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId(), reqBO.getSysTenantId())) != null) {
            commodityBo.setShopName(supplierShopPo.getShopName());
        }
        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
        uccBrandDealPO.setBrandId(commodityBo.getBrandId());
        uccBrandDealPO.setSysTenantId(reqBO.getSysTenantId());
        uccBrandDealPO = this.uccBrandDealMapper.selectById(uccBrandDealPO);
        if (uccBrandDealPO != null) {
            commodityBo.setBrandName(uccBrandDealPO.getBrandName());
        }
        if (commdPo.getCreateTime() != null) {
            commodityBo.setCreateTime(DateUtils.dateToStr(commdPo.getCreateTime()));
        }
        if (commdPo.getUpdateTime() != null) {
            commodityBo.setUpdateTime(DateUtils.dateToStr(commdPo.getUpdateTime()));
        }
        DicDictionaryPo po = null;
        if (commdPo.getCommodityStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getCommodityStatus().toString(), CommodityEnum.COMMODITY_STATUS.toString(), reqBO.getSysTenantId())) != null) {
            commodityBo.setCommodityStatusDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getCommoditySource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getCommoditySource().toString(), CommodityEnum.COMMODITY_SOURCE.toString(), reqBO.getSysTenantId())) != null) {
            commodityBo.setCommoditySourceDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getStoreGetType() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getStoreGetType().toString(), CommodityEnum.COMMODITY_STORE_GET_TYPE.toString(), reqBO.getSysTenantId())) != null) {
            commodityBo.setStoreGetTypeDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getServenRejectAllow() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getServenRejectAllow().toString(), CommodityEnum.COMMODITY_SERVEN_REJECT_ALLOW.toString(), reqBO.getSysTenantId())) != null) {
            commodityBo.setServenRejectAllowDesc(po.getTitle());
            po = null;
        }
        com.tydic.commodity.mall.atom.bo.UccQryCommdDetailReqBO atomCommdReqBo = new com.tydic.commodity.mall.atom.bo.UccQryCommdDetailReqBO();
        BeanUtils.copyProperties((Object)commdPo, (Object)atomCommdReqBo);
        com.tydic.commodity.mall.atom.bo.UccQryCommdDetailRspBO atomCommdRspBo = this.uccQryCommdDetailAtomService.queryInfomation(atomCommdReqBo);
        if (atomCommdRspBo != null) {
            if (atomCommdRspBo.getCommdImageInfo() != null && atomCommdRspBo.getCommdImageInfo().size() > 0) {
                commodityBo.setCommdImages(atomCommdRspBo.getCommdImageInfo());
            }
            if (atomCommdRspBo.getCommdSpecInfo() != null && atomCommdRspBo.getCommdSpecInfo().size() > 0) {
                commodityBo.setSpuSpecInfoList(atomCommdRspBo.getCommdSpecInfo());
                this.formatSpec(atomCommdRspBo.getCommdSpecInfo(), commodityBo, reqBO.getSysTenantId());
            }
            if (atomCommdRspBo.getCommodPageckeInfo() != null) {
                commodityBo.setCommodityPackageInfo(atomCommdRspBo.getCommodPageckeInfo());
            }
            if (atomCommdRspBo.getSaleParaInfo() != null && atomCommdRspBo.getSaleParaInfo().size() > 0) {
                commodityBo.setSaleParamEntityList(atomCommdRspBo.getSaleParaInfo());
            }
            if (atomCommdRspBo.getSpuServiceBO() != null) {
                commodityBo.setSpuServiceBO(atomCommdRspBo.getSpuServiceBO());
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSaleParams()) && reqBO.getSkuId() == null) {
            JSONObject keyParas = null;
            try {
                keyParas = JSONObject.parseObject((String)reqBO.getSaleParams());
            }
            catch (JSONException e) {
                LOGGER.error("can not cast to JSONObject");
                throw new ZTBusinessException("can not cast to JSONObject");
            }
            if (!keyParas.isEmpty()) {
                Set keys = keyParas.entrySet();
                List<Long> skuIds = null;
                for (Map.Entry each : keys) {
                    skuIds = this.filterSkuId(reqBO.getCommodityId(), Long.parseLong((String)each.getKey()), Long.parseLong(each.getValue().toString()), reqBO.getSupplierShopId(), skuIds, reqBO.getSysTenantId());
                    if (skuIds != null && skuIds.size() != 0) continue;
                    rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1\u4fe1\u606f");
                    return rspBO;
                }
                if (skuIds.size() > 1) {
                    rspBO.setRespCode(UccMallConstantsEnums.NON_SPECIFICATIONS.code());
                    rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5c5e\u6027\u4fe1\u606f\u6216\u5219\u5546\u54c1\u521b\u5efa\u4fe1\u606f\u9519\u8bef\u8bf7\u68c0\u67e5\u5546\u54c1\u4fe1\u606f\u662f\u5426\u6b63\u786e\uff01\uff01");
                    return rspBO;
                }
                reqBO.setSkuId((Long)skuIds.get(0));
            }
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuPo);
        List<UccSkuPo> listSkuInfo = this.uccSkuMapper.qerySku(uccSkuPo);
        ArrayList<UccMallSkuBo> listBo = new ArrayList<UccMallSkuBo>();
        UccMallSkuBo bo = null;
        UccQrySkuDetailReqBO uccQrySkuDetailReqBO = new UccQrySkuDetailReqBO();
        uccQrySkuDetailReqBO.setSysTenantId(reqBO.getSysTenantId());
        if (listSkuInfo != null && listSkuInfo.size() > 0) {
            for (UccSkuPo each : listSkuInfo) {
                UccQrySkuDetailRspBO skuDetail;
                bo = new UccMallSkuBo();
                uccQrySkuDetailReqBO.setSkuId(each.getSkuId());
                uccQrySkuDetailReqBO.setSupplierShopId(each.getSupplierShopId());
                BeanUtils.copyProperties((Object)each, (Object)bo);
                bo.setBrandName(commodityBo.getBrandName());
                bo.setShopName(commodityBo.getShopName());
                if (each.getSkuStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuStatus().toString(), SkuEnum.SKU_STATUS.toString(), reqBO.getSysTenantId())) != null) {
                    bo.setSkuStatusDesc(po.getTitle());
                    po = null;
                }
                if (each.getSkuSource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuSource().toString(), SkuEnum.SKU_SOURCE.toString(), reqBO.getSysTenantId())) != null) {
                    bo.setSkuSourceDesc(po.getTitle());
                    po = null;
                }
                if (each.getOnShelveWay() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getOnShelveWay().toString(), SkuEnum.SKU_ON_SHELVE_WAY.toString(), reqBO.getSysTenantId())) != null) {
                    bo.setOnShelveWayDec(po.getTitle());
                    po = null;
                }
                if (each.getCreateTime() != null) {
                    bo.setCreateTime(DateUtils.dateToStr(each.getCreateTime()));
                }
                if (each.getUpdateTime() != null) {
                    bo.setUpdateTime(DateUtils.dateToStr(each.getUpdateTime()));
                }
                if ("0000".equals((skuDetail = this.uccQrySkuInfoAtomService.queryInfomation(uccQrySkuDetailReqBO)).getRespCode())) {
                    UccMallLadderPriceBo uccMallLadderPriceBo;
                    bo.setSkuStockInfo(skuDetail.getSkuStock());
                    bo.setSkuPutCirInfo(skuDetail.getSkuPutCir());
                    bo.setSkuPicInfoList(skuDetail.getSkuPic());
                    bo.setSkuSaleNumInfo(skuDetail.getSkuSaleNum());
                    bo.setSkuSpecInfoList(skuDetail.getSkuSpec());
                    bo.setSkuPriceInfo(skuDetail.getSkuprice());
                    if (!CollectionUtils.isEmpty(skuDetail.getLadderPrice())) {
                        ArrayList<UccMallLadderPriceBo> ladderPriceBos = new ArrayList<UccMallLadderPriceBo>();
                        for (UccLadderPricePO each2 : skuDetail.getLadderPrice()) {
                            uccMallLadderPriceBo = new UccMallLadderPriceBo();
                            if (each2.getStart() != null) {
                                uccMallLadderPriceBo.setStartPrice(MoneyUtils.haoToYuan(each2.getStart()));
                            }
                            if (each2.getStop() != null) {
                                uccMallLadderPriceBo.setStopPrice(MoneyUtils.haoToYuan(each2.getStop()));
                            }
                            if (each2.getPrice() != null) {
                                uccMallLadderPriceBo.setPrice(MoneyUtils.haoToYuan(each2.getPrice()));
                            }
                            if (each2.getDiscount() != null) {
                                uccMallLadderPriceBo.setDiscount(each2.getDiscount());
                            }
                            ladderPriceBos.add(uccMallLadderPriceBo);
                        }
                        bo.setUccMallLadderPriceBos(ladderPriceBos);
                    }
                    bo.setChannels(skuDetail.getChannels());
                    if (!CollectionUtils.isEmpty(skuDetail.getLadderPrice())) {
                        ArrayList<UccMallLadderPriceBo> uccMallLadderPriceBos = new ArrayList<UccMallLadderPriceBo>();
                        for (UccLadderPricePO ladderPrice : skuDetail.getLadderPrice()) {
                            uccMallLadderPriceBo = new UccMallLadderPriceBo();
                            uccMallLadderPriceBo.setPrice(MoneyUtils.haoToYuan(ladderPrice.getPrice()));
                            uccMallLadderPriceBo.setStartPrice(MoneyUtils.haoToYuan(ladderPrice.getStart()));
                            uccMallLadderPriceBo.setDiscount(ladderPrice.getDiscount());
                            if (ladderPrice.getStop() != null) {
                                uccMallLadderPriceBo.setStopPrice(MoneyUtils.haoToYuan(ladderPrice.getStop()));
                            }
                            uccMallLadderPriceBos.add(uccMallLadderPriceBo);
                        }
                        bo.setUccMallLadderPriceBos(uccMallLadderPriceBos);
                    }
                }
                listBo.add(bo);
            }
            commodityBo.setSkuInfoList(listBo);
        }
        rspBO.setCommodity(commodityBo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    public List<Long> filterSkuId(Long commodityId, Long commodityPropDefId, Long propvaluelistid, Long supplierShopId, List<Long> skuIds, Long sysTenantId) {
        return this.uccSkuSpecMapper.filterSkuIdByProp(commodityId, commodityPropDefId, propvaluelistid, supplierShopId, skuIds, sysTenantId);
    }

    private String verify(UccQryCommdDetailReqBO reqBO) {
        if (reqBO.getSupplierShopId() == null || reqBO.getSupplierShopId() == 0L) {
            return "\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u8be2\u7684\u5e97\u94fa";
        }
        if (reqBO.getCommodityId() == null && reqBO.getSkuId() == null) {
            return "\u8bf7\u9009\u62e9\u67e5\u8be2\u7684\u5546\u54c1\u4fe1\u606f";
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(UccQryCommdDetailReqBO reqBO) {
        Map<String, String> enumMap;
        if (!(reqBO.getSkuStatus() == null || (enumMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString(), reqBO.getSysTenantId())) != null && enumMap.containsKey(reqBO.getSkuStatus().toString()))) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u54c1\u72b6\u6001";
        }
        return "";
    }

    public void formatSpec(List<UccMallSpuSpecBo> specBos, UccMallCommodityBo commodityBo, Long sysTenantId) {
        if (specBos.isEmpty()) {
            return;
        }
        HashMap group = new HashMap();
        for (UccMallSpuSpecBo each : specBos) {
            if (group.containsKey(each.getCommodityPropGrpId())) {
                ((List)group.get(each.getCommodityPropGrpId())).add(each);
                continue;
            }
            ArrayList<UccMallSpuSpecBo> spuSpecBos = new ArrayList<UccMallSpuSpecBo>();
            spuSpecBos.add(each);
            group.put(each.getCommodityPropGrpId(), spuSpecBos);
        }
        ArrayList<UccMallSpecBo> specBoList = new ArrayList<UccMallSpecBo>();
        UccMallSpecBo bo = new UccMallSpecBo();
        Iterator iterator = group.entrySet().iterator();
        while (iterator.hasNext()) {
            bo = new UccMallSpecBo();
            Map.Entry map = iterator.next();
            UccCommodityPropGrpPo grpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId((Long)map.getKey(), sysTenantId);
            if (grpPo == null) {
                throw new ZTBusinessException("\u5c5e\u6027\u7ec4\u5df2\u4e0d\u5b58\u5728");
            }
            bo.setCommodityPropGrpId(grpPo.getCommodityPropGrpId());
            bo.setCommodityPropGrpCode(grpPo.getCommodityPropGrpCode());
            bo.setCommodityPropGrpName(grpPo.getCommodityPropGrpName());
            bo.setCommodityPropGrpType(grpPo.getCommodityPropGrpType());
            ArrayList commodityProps = new ArrayList();
            UccMallPropEntityBo propEntityBo = null;
            HashedMap defMap = new HashedMap();
            for (UccMallSpuSpecBo spec : (List)map.getValue()) {
                UccMallPropEntityValue value = new UccMallPropEntityValue();
                if (defMap.containsKey(spec.getCommodityPropDefId())) {
                    value.setPropValue(spec.getPropValue());
                    value.setPropValueListId(spec.getPropValueListId());
                    ((UccMallPropEntityBo)defMap.get(spec.getCommodityPropDefId())).getSaleUccMallPropEntityValue().add(value);
                    continue;
                }
                ArrayList<UccMallPropEntityValue> salePropEntityValue = new ArrayList<UccMallPropEntityValue>();
                UccMallPropEntityValue propEntityValue = new UccMallPropEntityValue();
                propEntityValue.setPropValueListId(spec.getPropValueListId());
                propEntityValue.setPropValue(spec.getPropValue());
                salePropEntityValue.add(propEntityValue);
                propEntityBo = new UccMallPropEntityBo();
                propEntityBo.setCommodityPropDefId(spec.getCommodityPropDefId());
                propEntityBo.setPropName(spec.getPropName());
                propEntityBo.setShowName(spec.getPropShowName());
                propEntityBo.setSaleUccMallPropEntityValue(salePropEntityValue);
                defMap.put(spec.getCommodityPropDefId(), propEntityBo);
            }
            commodityProps.addAll(defMap.values());
            bo.setCommodityDefs(commodityProps);
            specBoList.add(bo);
        }
        commodityBo.setCommodityProps(specBoList);
    }
}

