/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.atom.api.UccMallDictionaryAtomService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.comb.api.UccMallSkuManagementListQryCombService;
import com.tydic.commodity.mall.comb.bo.UccMallSkuManagementListCombQryBO;
import com.tydic.commodity.mall.comb.bo.UccMallSkuManagementListQryCombReqBO;
import com.tydic.commodity.mall.comb.bo.UccMallSkuManagementListQryCombRspBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.constants.CommodityEnum;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.constants.SkuEnum;
import com.tydic.commodity.mall.constants.SkuStatusEnum;
import com.tydic.commodity.mall.dao.UccMallLadderPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.dao.UccSkuExpandMapper;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccSkuExpandPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallSkuManagementListQryCombServiceImpl
implements UccMallSkuManagementListQryCombService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSkuManagementListQryCombServiceImpl.class);
    @Autowired
    private MallEsConfig esConfig;
    @Autowired
    private MallElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccMallDictionaryAtomService uccMallDictionaryAtomService;
    @Autowired
    private UccMallSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccMallLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    private Long userId;
    @Value(value="${xc_tenat_list:305775845729763327}")
    private String xcTenatList;

    @Override
    public UccMallSkuManagementListQryCombRspBO getSkuManagementListQry(UccMallSkuManagementListQryCombReqBO reqBO) {
        this.userId = reqBO.getUserId();
        UccMallSkuManagementListQryCombRspBO rspBo = new UccMallSkuManagementListQryCombRspBO();
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List<UccSkuPricePo> pricePos;
            List<UccLadderPricePO> ladderPricePOS;
            Map<Integer, List<UccSkuPricePo>> groupBySwitch;
            List<Long> skus = rspBo.getRows().stream().map(UccMallSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPricePo> bathPrice = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null, reqBO.getSysTenantId());
            if (!CollectionUtils.isEmpty((Collection)rspBo.getRows()) && (groupBySwitch = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSwitchOn))).containsKey(1) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectBySkuIds(skus = (pricePos = groupBySwitch.get(1)).stream().map(UccSkuPricePo::getSkuId).collect(Collectors.toList()), null))) {
                Map<Long, List<UccLadderPricePO>> ladderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                Iterator<Long> iterator = ladderMap.keySet().iterator();
                HashMap<Long, List> longListMap = new HashMap<Long, List>();
                while (iterator.hasNext()) {
                    Long key = iterator.next();
                    List<UccLadderPricePO> mapPos = ladderMap.get(key);
                    List eachBo = JSONObject.parseArray((String)JSONObject.toJSONString(mapPos), UccMallLadderPriceBo.class);
                    eachBo.sort(new Comparator<UccMallLadderPriceBo>(){

                        @Override
                        public int compare(UccMallLadderPriceBo o1, UccMallLadderPriceBo o2) {
                            return o2.getStart().compareTo(o1.getStart());
                        }
                    });
                    for (UccMallLadderPriceBo each : eachBo) {
                        if (each.getStart() != null) {
                            each.setStart(MoneyUtils.haoToYuan(each.getStart()));
                        }
                        if (each.getStop() != null) {
                            each.setStop(MoneyUtils.haoToYuan(each.getStop()));
                        }
                        if (each.getPrice() == null) continue;
                        each.setPrice(MoneyUtils.haoToYuan(each.getPrice()));
                    }
                    longListMap.put(key, eachBo);
                }
                if (!longListMap.isEmpty()) {
                    for (UccMallSkuManagementListCombQryBO each : rspBo.getRows()) {
                        if (!longListMap.containsKey(each.getSkuId())) continue;
                        each.setLadderPriceInfo((List)longListMap.get(each.getSkuId()));
                    }
                }
            }
        }
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccMallSkuManagementListQryCombReqBO reqBo) {
        RangeQueryBuilder saleQb;
        RangeQueryBuilder priceUpdateTimeQb;
        RangeQueryBuilder createTimeQb;
        BoolQueryBuilder boolQueryBuilderIn2;
        ExistsQueryBuilder sexQueryBuilder;
        BoolQueryBuilder boolQueryBuilderIn;
        WildcardQueryBuilder wildcardQuery;
        ExistsQueryBuilder sexQueryBuilder2;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)reqBo.getCodeQry())) {
            BoolQueryBuilder shouldCodeBuilder = QueryBuilders.boolQuery();
            shouldCodeBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"commodity_code.keyword", (String)reqBo.getCodeQry()));
            shouldCodeBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"sku_code.keyword", (String)reqBo.getCodeQry()));
            shouldCodeBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"ext_spu_id.keyword", (String)reqBo.getCodeQry()));
            shouldCodeBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id.keyword", (String)reqBo.getCodeQry()));
            shouldCodeBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"material_code.keyword", (String)reqBo.getCodeQry()));
            boolQueryBuilder.must((QueryBuilder)shouldCodeBuilder);
        }
        if (reqBo.getActivityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"activitity_ids", (Object)reqBo.getActivityId()));
        }
        if (reqBo.getId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"activitity_change_ids", (Object)reqBo.getId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", reqBo.getCommodityIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getPurchaseTypeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchase_type", reqBo.getPurchaseTypeList()));
        } else {
            ArrayList<Integer> purchaseTypeList = new ArrayList<Integer>();
            purchaseTypeList.add(ModelRuleConstant.SPU_PURCHASE_TYPE_DIRECT);
            purchaseTypeList.add(ModelRuleConstant.SPU_PURCHASE_TYPE_INQUIRY);
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchase_type", purchaseTypeList));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityPurchaseTypeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodityPurchaseType", reqBo.getCommodityPurchaseTypeList()));
        } else {
            ArrayList<Integer> commodityPurchaseTypeList = new ArrayList<Integer>();
            commodityPurchaseTypeList.add(ModelRuleConstant.COMMODITY_PURCHASE_TYPE_NORMAL);
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodityPurchaseType", commodityPurchaseTypeList));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityTypeIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", reqBo.getCommodityTypeIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getVendorIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"vendor_id", reqBo.getVendorIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getAgreementIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"agreement_id", reqBo.getAgreementIds()));
        }
        if (reqBo.getPoolId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuPoolIds", (Object)reqBo.getPoolId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExportSkuIds()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_approval_status", (Object)reqBo.getApprovalStatus()));
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (reqBo.getMaterialId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_id", (Object)reqBo.getMaterialId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getMaterialIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_id", reqBo.getMaterialIds()));
        }
        if (reqBo.getQryMaterialId() != null) {
            if (reqBo.getQryMaterialId() == 0) {
                sexQueryBuilder2 = QueryBuilders.existsQuery((String)"material_id");
                boolQueryBuilder.must((QueryBuilder)sexQueryBuilder2);
            }
            if (reqBo.getQryMaterialId() == 1) {
                sexQueryBuilder2 = QueryBuilders.existsQuery((String)"material_id");
                boolQueryBuilder.mustNot((QueryBuilder)sexQueryBuilder2);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operOrgIds", reqBo.getOperOrgIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperRoleIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operRoleIds", reqBo.getOperRoleIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperStationCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operStationCodes", reqBo.getOperStationCodes()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (reqBo.getMeasureId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"measure_id", (Object)reqBo.getMeasureId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSysTenantIdByPools())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sysTenantIdByPools", reqBo.getSysTenantIdByPools()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)("*" + reqBo.getExtSpuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityTypeName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"type_name", (String)("*" + reqBo.getCommodityTypeName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSerialNo())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"serial_no", (String)("*" + reqBo.getSerialNo() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)("*" + reqBo.getExtSkuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreSkuList())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getIgnoreSkuList()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreshop())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_shop_id", reqBo.getIgnoreshop()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreshop())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"vendor_name", reqBo.getIgnoreshopName()));
        }
        if (reqBo.getUserId() == null || reqBo.getUserId() != null && reqBo.getUserId() != 1L) {
            boolQueryBuilderIn = QueryBuilders.boolQuery();
            sexQueryBuilder = QueryBuilders.existsQuery((String)"whitelist");
            boolQueryBuilderIn2 = QueryBuilders.boolQuery();
            boolQueryBuilderIn2.mustNot((QueryBuilder)sexQueryBuilder);
            boolQueryBuilderIn.should((QueryBuilder)boolQueryBuilderIn2);
            if (!CollectionUtils.isEmpty(reqBo.getWhitelist())) {
                boolQueryBuilderIn.should((QueryBuilder)QueryBuilders.termsQuery((String)"whitelist", reqBo.getWhitelist()));
            } else {
                boolQueryBuilderIn.should((QueryBuilder)QueryBuilders.termsQuery((String)"whitelist", new ArrayList()));
            }
            if (reqBo.getUserId() != null && reqBo.getUserId() != 1L && !reqBo.getNoPerson().booleanValue()) {
                boolQueryBuilderIn.should((QueryBuilder)QueryBuilders.termQuery((String)"personWhite", (Object)reqBo.getUserId()));
            }
            if (reqBo.getOrgId() != null) {
                boolQueryBuilderIn.should((QueryBuilder)QueryBuilders.termQuery((String)"orgWhite", (Object)reqBo.getOrgId()));
            }
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilderIn);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (reqBo.getIsMaterCode() != null) {
                if (reqBo.getIsMaterCode() == 1) {
                    boolQueryBuilderIn = QueryBuilders.boolQuery();
                    boolQueryBuilderIn.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_code.keyword", (String[])new String[]{reqBo.getMaterialCode()}));
                    sexQueryBuilder = QueryBuilders.existsQuery((String)"material_code");
                    boolQueryBuilderIn2 = QueryBuilders.boolQuery();
                    boolQueryBuilderIn2.mustNot((QueryBuilder)sexQueryBuilder);
                    boolQueryBuilderIn.should((QueryBuilder)boolQueryBuilderIn2);
                    boolQueryBuilder.must((QueryBuilder)boolQueryBuilderIn);
                } else {
                    sexQueryBuilder2 = QueryBuilders.existsQuery((String)"material_code");
                    boolQueryBuilder.mustNot((QueryBuilder)sexQueryBuilder2);
                }
            } else {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMeasureName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"measure_name.keyword", (String)("*" + reqBo.getMeasureName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountStar())) {
            RangeQueryBuilder discountQbStar = QueryBuilders.rangeQuery((String)"discount").gte((Object)reqBo.getDiscountStar());
            boolQueryBuilder.must((QueryBuilder)discountQbStar);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountEnd())) {
            RangeQueryBuilder discountQbEnd = QueryBuilders.rangeQuery((String)"discount").lte((Object)reqBo.getDiscountEnd());
            boolQueryBuilder.must((QueryBuilder)discountQbEnd);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountDifferenceStar())) {
            RangeQueryBuilder discountDifferenceQbStar = QueryBuilders.rangeQuery((String)"discount_difference").gte((Object)reqBo.getDiscountDifferenceStar());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbStar);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountDifferenceEnd())) {
            RangeQueryBuilder discountDifferenceQbEnd = QueryBuilders.rangeQuery((String)"discount_difference").lte((Object)reqBo.getDiscountDifferenceEnd());
            boolQueryBuilder.must((QueryBuilder)discountDifferenceQbEnd);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOverToleranceDifferenceStar())) {
            RangeQueryBuilder overToleranceDifferenceQbStar = QueryBuilders.rangeQuery((String)"over_tolerance_difference").gte((Object)reqBo.getOverToleranceDifferenceStar());
            boolQueryBuilder.must((QueryBuilder)overToleranceDifferenceQbStar);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOverToleranceDifferenceEnd())) {
            RangeQueryBuilder overToleranceDifferenceQbEnd = QueryBuilders.rangeQuery((String)"over_tolerance_difference").lte((Object)reqBo.getOverToleranceDifferenceEnd());
            boolQueryBuilder.must((QueryBuilder)overToleranceDifferenceQbEnd);
        }
        if (reqBo.getHrAgreementType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"hr_agreement_type", (Object)reqBo.getHrAgreementType()));
        }
        if (reqBo.getIsOverDiscount() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_over_discount", (Object)reqBo.getIsOverDiscount()));
        }
        if (reqBo.getIsOverTolerance() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_over_tolerance", (Object)reqBo.getIsOverTolerance()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getLimitOrderList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"limit_order", reqBo.getLimitOrderList()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeStar())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").gte((Object)reqBo.getCreateTimeStar().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").lte((Object)reqBo.getCreateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPriceUpdateTimeStar())) {
            priceUpdateTimeQb = QueryBuilders.rangeQuery((String)"price_update_time").gte((Object)reqBo.getPriceUpdateTimeStar().getTime());
            boolQueryBuilder.must((QueryBuilder)priceUpdateTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPriceUpdateTimeEnd())) {
            priceUpdateTimeQb = QueryBuilders.rangeQuery((String)"price_update_time").lte((Object)reqBo.getPriceUpdateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)priceUpdateTimeQb);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (reqBo.getSalePriceStar() != null) {
            saleQb = null;
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (reqBo.getSalePriceEnd() != null) {
            saleQb = null;
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (reqBo.getMemberPrice2() != null) {
            saleQb = null;
            saleQb = QueryBuilders.rangeQuery((String)"member_price2").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMemberPrice2()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (reqBo.getMemberPrice1() != null) {
            saleQb = null;
            saleQb = QueryBuilders.rangeQuery((String)"member_price1").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMemberPrice1()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!CollectionUtils.isEmpty(reqBo.getSysTenantIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sys_tenant_id", reqBo.getSysTenantIds()));
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccMallSkuManagementListQryCombReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        FieldSortBuilder sortQuery;
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        SortOrder orderPriceType = SortOrder.DESC;
        if (reqBo.getOrderPriceType() != null && reqBo.getOrderPriceType() == 1) {
            orderPriceType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            }
        }
        String sortPriceField = "";
        if (reqBo.getOrderPriceByColumn() != null) {
            if (reqBo.getOrderPriceByColumn() == 0) {
                sortPriceField = "create_time";
            } else if (reqBo.getOrderPriceByColumn() == 1) {
                sortPriceField = "sold_number";
            } else if (reqBo.getOrderPriceByColumn() == 2) {
                sortPriceField = "on_shelve_time";
            } else if (reqBo.getOrderPriceByColumn() == 3) {
                sortPriceField = "sale_price";
                sortField = "";
            } else if (reqBo.getOrderPriceByColumn() == 4) {
                sortPriceField = "discounts";
            } else if (reqBo.getOrderPriceByColumn() == 5) {
                sortPriceField = "comment_number";
            }
        }
        JSONArray jsonArray = new JSONArray();
        if (!StringUtils.isEmpty((Object)sortField)) {
            sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            jsonArray.add((Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        if (!StringUtils.isEmpty((Object)sortPriceField)) {
            sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortPriceField).order(orderPriceType);
            jsonArray.add((Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        queryJson.put("sort", (Object)jsonArray);
        return queryJson.toString();
    }

    private UccMallSkuManagementListQryCombRspBO dealSearchData(String result, UccMallSkuManagementListQryCombReqBO reqBo) {
        UccMallSkuManagementListQryCombRspBO rspBo = new UccMallSkuManagementListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccMallCommodityRspBo> commodityModels = new ArrayList<UccMallCommodityRspBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccMallCommodityRspBo commodity = new UccMallCommodityRspBo();
                try {
                    commodity = (UccMallCommodityRspBo)JSON.toJavaObject((JSON)data, UccMallCommodityRspBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize(), reqBo.getSysTenantId());
        return rspBo;
    }

    private UccMallSkuManagementListQryCombRspBO copyData(List<UccMallCommodityRspBo> commodityModels, Integer totalNum, int pageNo, int pageSize, Long sysTenantId) {
        UccMallSkuManagementListQryCombRspBO rspBo = new UccMallSkuManagementListQryCombRspBO();
        ArrayList<UccMallSkuManagementListCombQryBO> uccSkuManagementListQryBOs = new ArrayList<UccMallSkuManagementListCombQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            if (!CollectionUtils.isEmpty(commodityModels)) {
                Map<String, String> isOverDiscountMap = this.uccMallDictionaryAtomService.queryBypCodeBackMap("IS_OVER_DISCOUNT", sysTenantId);
                Map<String, String> isOverToleranceMap = this.uccMallDictionaryAtomService.queryBypCodeBackMap("IS_OVER_TOLERANCE", sysTenantId);
                Map<String, String> limitOrderMap = this.uccMallDictionaryAtomService.queryBypCodeBackMap("LIMIT_ORDER", sysTenantId);
                Map<String, String> hrAgreementTypeMap = this.uccMallDictionaryAtomService.queryBypCodeBackMap("HR_AGREEMENT_TYPE", sysTenantId);
                Map<String, String> commodityStatusMap = this.uccMallDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS.toString(), sysTenantId);
                Map<String, String> skuStatusMap = this.uccMallDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString(), sysTenantId);
                Map<String, String> skuApprovalStatusMap = this.uccMallDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_APPROVAL_STATUS.toString(), sysTenantId);
                Map<String, String> skuSourceMap = this.uccMallDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_SOURCE.toString(), sysTenantId);
                for (UccMallCommodityRspBo cnncEsCommodityBo : commodityModels) {
                    UccMallSkuManagementListCombQryBO uccSkuManagementListQryBO = new UccMallSkuManagementListCombQryBO();
                    uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
                    uccSkuManagementListQryBO.setCommodityId(cnncEsCommodityBo.getCommodity_id());
                    uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
                    uccSkuManagementListQryBO.setSkuId(cnncEsCommodityBo.getSku_id());
                    uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
                    uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
                    uccSkuManagementListQryBO.setSkuSource(cnncEsCommodityBo.getSku_source());
                    uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
                    uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    uccSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
                    uccSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setCatalogName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setSkuStatus(cnncEsCommodityBo.getSku_status());
                    uccSkuManagementListQryBO.setAgreementId(cnncEsCommodityBo.getAgreement_id());
                    if (cnncEsCommodityBo.getSold_number() != null) {
                        uccSkuManagementListQryBO.setSoldNumber(new BigDecimal(cnncEsCommodityBo.getSold_number()));
                    } else {
                        uccSkuManagementListQryBO.setSoldNumber(new BigDecimal(0));
                    }
                    uccSkuManagementListQryBO.setOnShelveTimeStr(cnncEsCommodityBo.getOn_shelve_time());
                    if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
                        uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
                    }
                    if (uccSkuManagementListQryBO.getCommodityStatus() != null && commodityStatusMap != null && commodityStatusMap.containsKey(uccSkuManagementListQryBO.getCommodityStatus().toString())) {
                        uccSkuManagementListQryBO.setCommodityStatusDesc(commodityStatusMap.get(uccSkuManagementListQryBO.getCommodityStatus().toString()));
                    }
                    if (uccSkuManagementListQryBO.getSkuStatus() != null && skuStatusMap != null && skuStatusMap.containsKey(uccSkuManagementListQryBO.getSkuStatus().toString())) {
                        uccSkuManagementListQryBO.setSkuStatusDesc(skuStatusMap.get(uccSkuManagementListQryBO.getSkuStatus().toString()));
                        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.AUTO_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                            uccSkuManagementListQryBO.setSkuStatusDesc("\u5df2\u4e0b\u67b6");
                            uccSkuManagementListQryBO.setDownTypeDesc(skuStatusMap.get(uccSkuManagementListQryBO.getSkuStatus().toString()));
                            try {
                                UccSkuExpandPo eacRuTaskPO = new UccSkuExpandPo();
                                eacRuTaskPO.setSkuId(uccSkuManagementListQryBO.getSkuId());
                                eacRuTaskPO.setSysTenantId(sysTenantId);
                                List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(eacRuTaskPO);
                                if (!CollectionUtils.isEmpty(uccSkuExpandPos)) {
                                    uccSkuManagementListQryBO.setDownReason(uccSkuExpandPos.get(0).getExpand16());
                                }
                            }
                            catch (Exception e) {
                                log.error("\u67e5\u8be2\u4e0b\u67b6\u539f\u56e0\u5931\u8d25", (Object)e.getMessage());
                            }
                        }
                    }
                    if (cnncEsCommodityBo.getSku_approval_status() != null && skuApprovalStatusMap != null && skuApprovalStatusMap.containsKey(cnncEsCommodityBo.getSku_approval_status().toString())) {
                        uccSkuManagementListQryBO.setApprovalStatusDesc(skuApprovalStatusMap.get(cnncEsCommodityBo.getSku_approval_status().toString()));
                    }
                    if (uccSkuManagementListQryBO.getSkuSource() != null && skuSourceMap != null && skuSourceMap.containsKey(uccSkuManagementListQryBO.getSkuSource().toString())) {
                        uccSkuManagementListQryBO.setSkuSourceDesc(skuSourceMap.get(uccSkuManagementListQryBO.getSkuSource().toString()));
                    }
                    uccSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
                    uccSkuManagementListQryBO.setBrandId(cnncEsCommodityBo.getOrigin_brand_id());
                    uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getOrigin_brand_name());
                    uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
                    uccSkuManagementListQryBO.setMaterialId(cnncEsCommodityBo.getMaterial_id());
                    uccSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
                    uccSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
                    uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
                    uccSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
                    uccSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
                    uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
                    uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
                    if (cnncEsCommodityBo.getDown_time() != null) {
                        uccSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
                    }
                    if (cnncEsCommodityBo.getUp_time() != null) {
                        uccSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
                    }
                    if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
                        uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
                    }
                    uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
                    uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
                    uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
                    if (cnncEsCommodityBo.getMember_price1() != null) {
                        uccSkuManagementListQryBO.setMemberPrice1(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMember_price1()));
                    }
                    if (cnncEsCommodityBo.getMember_price2() != null) {
                        uccSkuManagementListQryBO.setMemberPrice2(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMember_price2()));
                    }
                    uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccSkuManagementListQryBO.setSell(cnncEsCommodityBo.getSell());
                    uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
                    uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
                    } else {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getCommd_pic_url());
                    }
                    uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
                    uccSkuManagementListQryBO.setPreDeliverDay(cnncEsCommodityBo.getPre_deliver_day());
                    uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
                    if (cnncEsCommodityBo.getMincrement() != null) {
                        uccSkuManagementListQryBO.setMincrement(cnncEsCommodityBo.getMincrement());
                    }
                    uccSkuManagementListQryBO.setSalesUnitId(cnncEsCommodityBo.getSales_unit_id());
                    uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
                    uccSkuManagementListQryBO.setSwitchOn(cnncEsCommodityBo.getSwitch_on());
                    uccSkuManagementListQryBO.setOtherSourceCode(cnncEsCommodityBo.getOther_source_code());
                    uccSkuManagementListQryBO.setOtherSourceName(cnncEsCommodityBo.getOther_source_name());
                    uccSkuManagementListQryBO.setCommodityExpand1(cnncEsCommodityBo.getCommodity_expand1());
                    uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
                    if (cnncEsCommodityBo.getComment_number() != null) {
                        uccSkuManagementListQryBO.setTotalNum(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
                    } else {
                        uccSkuManagementListQryBO.setTotalNum(new BigDecimal("0"));
                    }
                    uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
                    uccSkuManagementListQryBO.setExtSpuId(cnncEsCommodityBo.getExt_spu_id());
                    uccSkuManagementListQryBO.setExtSkuId(cnncEsCommodityBo.getExt_sku_id());
                    uccSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
                    if (cnncEsCommodityBo.getPrice_update_time() != null) {
                        uccSkuManagementListQryBO.setPriceUpdateTime(new Date(cnncEsCommodityBo.getPrice_update_time()));
                    }
                    uccSkuManagementListQryBO.setDiscount(cnncEsCommodityBo.getDiscount());
                    uccSkuManagementListQryBO.setSignDiscount(cnncEsCommodityBo.getSign_discount());
                    uccSkuManagementListQryBO.setDiscountDifference(cnncEsCommodityBo.getDiscount_difference());
                    uccSkuManagementListQryBO.setOverToleranceDifference(cnncEsCommodityBo.getOver_tolerance_difference());
                    uccSkuManagementListQryBO.setTolerance(cnncEsCommodityBo.getTolerance());
                    uccSkuManagementListQryBO.setIsOverDiscount(cnncEsCommodityBo.getIs_over_discount());
                    uccSkuManagementListQryBO.setIsOverTolerance(cnncEsCommodityBo.getIs_over_tolerance());
                    uccSkuManagementListQryBO.setLimitOrder(cnncEsCommodityBo.getLimit_order());
                    uccSkuManagementListQryBO.setAttachmentUrl(cnncEsCommodityBo.getAttachment_url());
                    uccSkuManagementListQryBO.setAttachmentName(cnncEsCommodityBo.getAttachment_name());
                    uccSkuManagementListQryBO.setReason(cnncEsCommodityBo.getReason());
                    uccSkuManagementListQryBO.setHrAgreementType(cnncEsCommodityBo.getHr_agreement_type());
                    uccSkuManagementListQryBO.setBatchCreate(cnncEsCommodityBo.getBatch_create());
                    uccSkuManagementListQryBO.setSysCode(cnncEsCommodityBo.getSys_code());
                    uccSkuManagementListQryBO.setEntAgreementCode(cnncEsCommodityBo.getEnt_agreement_code());
                    uccSkuManagementListQryBO.setSerialNo(cnncEsCommodityBo.getSerial_no());
                    uccSkuManagementListQryBO.setActivityIds(cnncEsCommodityBo.getActivitity_ids());
                    uccSkuManagementListQryBO.setActivityChangeIds(cnncEsCommodityBo.getActivitity_change_ids());
                    uccSkuManagementListQryBO.setPurchaseType(cnncEsCommodityBo.getPurchase_type());
                    if (sysTenantId == null || !this.xcTenatList.contains(sysTenantId.toString())) {
                        uccSkuManagementListQryBO.setXcCategor("0");
                        uccSkuManagementListQryBO.setXcSku("0");
                    } else {
                        uccSkuManagementListQryBO.setXcCategor(cnncEsCommodityBo.getSkuExpand8());
                        uccSkuManagementListQryBO.setXcSku(cnncEsCommodityBo.getSkuExpand9());
                    }
                    if (uccSkuManagementListQryBO.getIsOverDiscount() != null && isOverDiscountMap != null && isOverDiscountMap.containsKey(uccSkuManagementListQryBO.getIsOverDiscount().toString())) {
                        uccSkuManagementListQryBO.setIsOverDiscountDesc(isOverDiscountMap.get(uccSkuManagementListQryBO.getIsOverDiscount().toString()));
                    }
                    if (uccSkuManagementListQryBO.getIsOverTolerance() != null && isOverToleranceMap != null && isOverToleranceMap.containsKey(uccSkuManagementListQryBO.getIsOverTolerance().toString())) {
                        uccSkuManagementListQryBO.setIsOverToleranceDesc(isOverToleranceMap.get(uccSkuManagementListQryBO.getIsOverTolerance().toString()));
                    }
                    if (uccSkuManagementListQryBO.getLimitOrder() != null && limitOrderMap != null && limitOrderMap.containsKey(uccSkuManagementListQryBO.getLimitOrder().toString())) {
                        uccSkuManagementListQryBO.setLimitOrderDesc(limitOrderMap.get(uccSkuManagementListQryBO.getLimitOrder().toString()));
                    }
                    if (uccSkuManagementListQryBO.getHrAgreementType() != null && hrAgreementTypeMap != null && hrAgreementTypeMap.containsKey(uccSkuManagementListQryBO.getHrAgreementType().toString())) {
                        uccSkuManagementListQryBO.setHrAgreementTypeDesc(hrAgreementTypeMap.get(uccSkuManagementListQryBO.getHrAgreementType().toString()));
                    }
                    if (cnncEsCommodityBo.getAudit_time() != null) {
                        uccSkuManagementListQryBO.setAuditTime(new Date(cnncEsCommodityBo.getAudit_time()));
                    }
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

