/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.mall.ability.api.UccMallAgrGoodListQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallAgrGoodListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallAgrGoodListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallCommodityPackBO;
import com.tydic.commodity.mall.ability.bo.UccMallCommodityRecordBO;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.constants.ApprovalTypeEnum;
import com.tydic.commodity.mall.constants.AuditResultStatusEnum;
import com.tydic.commodity.mall.constants.SkuStatusEnum;
import com.tydic.commodity.mall.constants.YesNoEnum;
import com.tydic.commodity.mall.dao.UccMallBrandRelMapper;
import com.tydic.commodity.mall.dao.UccMallCatRCommdTypeMapper;
import com.tydic.commodity.mall.dao.UccMallCatalogDealMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMeasureMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityPicMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallExamineEditInfoMapper;
import com.tydic.commodity.mall.dao.UccMallLadderPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPicMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.CommodityRecordPO;
import com.tydic.commodity.mall.po.CommodityRecordVO;
import com.tydic.commodity.mall.po.UccCatalogDealPO;
import com.tydic.commodity.mall.po.UccCommodityMeasurePo;
import com.tydic.commodity.mall.po.UccCommodityPicPo;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccMallBrandRelPO;
import com.tydic.commodity.mall.po.UccSkuPicPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallAgrGoodListQueryAbilityService"})
public class UccMallAgrGoodListQueryAbilityServiceImpl
implements UccMallAgrGoodListQueryAbilityService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallCatalogDealMapper uccMallCatalogDealMapper;
    @Autowired
    private UccMallCatRCommdTypeMapper uccMallCatRCommdTypeMapper;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private UccMallExamineEditInfoMapper uccMallExamineEditInfoMapper;
    @Autowired
    private UccMallLadderPriceMapper uccMallLadderPriceMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccMallCommodityPicMapper uccMallCommodityPicMapper;
    @Autowired
    private UccMallSkuPicMapper uccMallSkuPicMapper;
    @Autowired
    private UccMallCommodityMeasureMapper uccMallCommodityMeasureMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    private static final String DateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallAgrGoodListQueryAbilityServiceImpl.class);

    @PostMapping(value={"getUccAgrGoodListQuery"})
    public UccMallAgrGoodListQueryAbilityRspBO getUccAgrGoodListQuery(@RequestBody UccMallAgrGoodListQueryAbilityReqBO reqBO) {
        UccMallAgrGoodListQueryAbilityRspBO rspBO = new UccMallAgrGoodListQueryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (!StringUtils.isEmpty((Object)reqBO.getSkuCode())) {
            reqBO.setSkuId(Long.valueOf(Long.parseLong(reqBO.getSkuCode())));
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        if (reqBO.getSkuId() != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            if (!reqBO.getSkuIds().contains(reqBO.getSkuId())) {
                return rspBO;
            }
            reqBO.setSkuId(null);
        }
        CommodityRecordVO commodityRecordVO = this.dealReq(reqBO);
        commodityRecordVO.setSysTenantId(reqBO.getSysTenantId());
        if (null == commodityRecordVO) {
            rspBO.setRows(new ArrayList());
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        List<Object> commodityRecordPOS = new ArrayList();
        if (!StringUtils.isEmpty((Object)reqBO.getUccOperCode())) {
            if ("uadCode".equals(reqBO.getUccOperCode())) {
                commodityRecordVO.setExtField1(Lists.newArrayList((Object[])new String[]{"upCode", "downCode"}));
            } else {
                commodityRecordVO.setExtField1(Lists.newArrayList((Object[])new String[]{reqBO.getUccOperCode()}));
            }
        }
        try {
            if (reqBO.getType() == 4) {
                Boolean isPage = false;
                if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                    commodityRecordPOS = this.uccMallSkuMapper.qryOtherCommdList(commodityRecordVO);
                } else {
                    UccSkuPo skuPo = new UccSkuPo();
                    skuPo.setSkuId(reqBO.getSkuId());
                    skuPo.setSysTenantId(reqBO.getSysTenantId());
                    List<UccSkuPo> mallsku = this.uccMallSkuMapper.qerySku(skuPo);
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(mallsku)) {
                        commodityRecordVO.setIgrAgreementSkuId(mallsku.get(0).getAgreementDetailsId());
                        commodityRecordPOS = this.uccMallSkuMapper.qryOtherCommdList(commodityRecordVO);
                    }
                }
                if (reqBO.getIsShowSpu().booleanValue()) {
                    commodityRecordPOS = commodityRecordPOS.stream().collect(Collectors.toMap(CommodityRecordPO::getCommodityId, Function.identity(), (k1, k2) -> k1)).values().stream().collect(Collectors.toList());
                    commodityRecordPOS.forEach(each -> each.setSkuName(each.getSkuName()));
                    commodityRecordPOS.forEach(each -> each.setCommodityName(each.getCommodityName()));
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(commodityRecordPOS)) {
                    List<UccCommodityMeasurePo> measurePoList = this.uccMallCommodityMeasureMapper.queryAll(reqBO.getSysTenantId());
                    Map<Long, UccCommodityMeasurePo> measureMap = null;
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(measurePoList)) {
                        measureMap = measurePoList.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, UccCommodityMeasurePo2 -> UccCommodityMeasurePo2));
                    }
                    for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
                        if (commodityRecordPO.getMeasure() == null || measureMap.isEmpty()) continue;
                        if (measureMap.containsKey(commodityRecordPO.getMeasureId())) {
                            commodityRecordPO.setMeasureType(measureMap.get(commodityRecordPO.getMeasureId()).getMeasureType());
                            continue;
                        }
                        LOGGER.error("\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5f02\u5e38->{}" + commodityRecordPO.getMeasureId());
                    }
                }
            } else {
                throw new BusinessException("8888", "\u6ca1\u6709\u8be5\u67e5\u8be2\u7c7b\u578b");
            }
            this.getBrandInfo(commodityRecordPOS, reqBO.getSysTenantId());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(commodityRecordPOS)) {
            return rspBO;
        }
        ArrayList<UccMallCommodityRecordBO> commodityRecordBOS = new ArrayList<UccMallCommodityRecordBO>();
        List<Long> skuIds = commodityRecordPOS.stream().map(CommodityRecordPO::getSkuId).collect(Collectors.toList());
        List<UccLadderPricePO> uccLadderPricePOList = this.uccMallLadderPriceMapper.selectBySkuIds(skuIds, null);
        List<Long> commodityTypeIds = commodityRecordPOS.stream().map(CommodityRecordPO::getCommodityTypeId).collect(Collectors.toList());
        List<UccCommodityTypePo> list = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeIds(commodityTypeIds, reqBO.getSysTenantId());
        for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
            UccMallCommodityRecordBO commodityRecordBO = new UccMallCommodityRecordBO();
            commodityRecordBOS.add(commodityRecordBO);
            commodityRecordBO.setLimitOrder(commodityRecordPO.getLimitOrder());
            commodityRecordBO.setCommodityId(commodityRecordPO.getCommodityId());
            commodityRecordBO.setSalesUnitName(commodityRecordPO.getSalesUnitName());
            commodityRecordBO.setSalesUnitRate(commodityRecordPO.getSalesUnitRate());
            commodityRecordBO.setPackageSpec(commodityRecordPO.getPackageSpec());
            commodityRecordBO.setSettlementUnit(commodityRecordPO.getSettlementUnit());
            commodityRecordBO.setUpdateTime(commodityRecordPO.getUpdateTime());
            commodityRecordBO.setSkuId(commodityRecordPO.getSkuId());
            commodityRecordBO.setSkuCode(commodityRecordPO.getSkuCode());
            commodityRecordBO.setSkuStatus(commodityRecordPO.getSkuStatus());
            if (commodityRecordPO.getSkuStatus() != null) {
                commodityRecordBO.setSkuStatusDesc(SkuStatusEnum.getStatusDesc(commodityRecordPO.getSkuStatus()).getStatusDesc());
            }
            commodityRecordBO.setCatalogName(commodityRecordPO.getCatalogName());
            commodityRecordBO.setSkuPicUrl(commodityRecordPO.getSkuPicUrl());
            commodityRecordBO.setSkuName(commodityRecordPO.getSkuName());
            commodityRecordBO.setBrandName(commodityRecordPO.getBrandName());
            commodityRecordBO.setSupplierName(commodityRecordPO.getSupplierName());
            commodityRecordBO.setSupplierId(commodityRecordPO.getSupplierId());
            commodityRecordBO.setMiniOrderNum(commodityRecordPO.getMiniOrderNum());
            commodityRecordBO.setReleaseTime(commodityRecordPO.getCreateTime());
            commodityRecordBO.setSkuDesc(commodityRecordPO.getSkuDesc());
            commodityRecordBO.setSupplierShopName(commodityRecordPO.getShopName());
            commodityRecordBO.setDownReason(commodityRecordPO.getDownReason());
            commodityRecordBO.setDownTime(commodityRecordPO.getDownTime());
            commodityRecordBO.setRestoreUpTime(commodityRecordPO.getRestoreUpTime());
            commodityRecordBO.setMeasure(commodityRecordPO.getMeasure());
            commodityRecordBO.setOrgName(commodityRecordPO.getOrgName());
            commodityRecordBO.setDeliveryCycle(commodityRecordPO.getDeliveryCycle());
            commodityRecordBO.setGuaranteePeriod(commodityRecordPO.getGuaranteePeriod());
            commodityRecordBO.setAuditType(commodityRecordPO.getAuditType());
            commodityRecordBO.setMaterialCode(commodityRecordPO.getMaterialCode());
            if (commodityRecordPO.getAuditType() != null) {
                commodityRecordBO.setAuditTypeDesc(ApprovalTypeEnum.findByStep(commodityRecordPO.getAuditType().toString()).getMessage());
            }
            commodityRecordBO.setDealResult(commodityRecordPO.getDealResult());
            if (commodityRecordPO.getDealResult() != null) {
                commodityRecordBO.setDealResultDesc(AuditResultStatusEnum.getByStatus(commodityRecordPO.getDealResult()).getMessage());
            }
            commodityRecordBO.setDealName(commodityRecordPO.getDealName());
            commodityRecordBO.setAuditTime(commodityRecordPO.getAuditTime());
            commodityRecordBO.setSpec(commodityRecordPO.getSpec());
            commodityRecordBO.setModel(commodityRecordPO.getModel());
            commodityRecordBO.setFigure(commodityRecordPO.getFigure());
            commodityRecordBO.setTexture(commodityRecordPO.getTexture());
            commodityRecordBO.setSupplierShopId(commodityRecordPO.getSupplierShopId());
            commodityRecordBO.setShowPack(commodityRecordPO.getShowPack());
            commodityRecordBO.setMaterialName(commodityRecordPO.getMeterialName());
            if (commodityRecordPO.getShowPack() != null) {
                commodityRecordBO.setShowPackDesc(YesNoEnum.getTypeDesc(commodityRecordPO.getShowPack()));
            }
            commodityRecordBO.setCreateTime(commodityRecordPO.getCreateTime());
            if (commodityRecordPO.getSalePrice() != null) {
                commodityRecordBO.setSalePrice(MoneyUtils.haoToYuan(commodityRecordPO.getSalePrice()));
            }
            if (commodityRecordPO.getMarketPrice() != null) {
                commodityRecordBO.setMarketPrice(MoneyUtils.haoToYuan(commodityRecordPO.getMarketPrice()));
            }
            commodityRecordBO.setTaxCategoryCode(commodityRecordPO.getTaxCategoryCode());
            commodityRecordBO.setBelongCategory(commodityRecordPO.getBelongCategory());
            commodityRecordBO.setAgreementDetailsId(commodityRecordPO.getAgreementDetailsId());
            commodityRecordBO.setVendorName(commodityRecordPO.getVendorName());
            commodityRecordBO.setVendorId(commodityRecordPO.getVendorId());
            commodityRecordBO.setManufacturer(commodityRecordPO.getManufacturer());
            UccMallCommodityPackBO commodityPackBO = new UccMallCommodityPackBO();
            ArrayList<UccMallCommodityPackBO> commodityPackBOS = new ArrayList<UccMallCommodityPackBO>();
            commodityPackBOS.add(commodityPackBO);
            commodityPackBO.setCommodityId(commodityRecordPO.getCommodityId());
            commodityPackBO.setWeight(commodityRecordPO.getWeight());
            commodityPackBO.setHeight(commodityRecordPO.getHeight());
            commodityPackBO.setLength(commodityRecordPO.getLength());
            commodityPackBO.setWidth(commodityRecordPO.getWidth());
            commodityPackBO.setList(commodityRecordPO.getList());
            commodityRecordBO.setCommodityPackInfo(commodityPackBOS);
            List<UccMallLadderPriceBo> ladderPriceBOS = new ArrayList();
            if (reqBO.getAuditType() != null && ApprovalTypeEnum.APPROVAL_EDIT.getStep().equals(reqBO.getAuditType().toString())) {
                String ladderPrice = commodityRecordPO.getLadderPrice();
                if (!StringUtils.isEmpty((Object)ladderPrice)) {
                    ladderPriceBOS = JSONObject.parseArray((String)ladderPrice, UccMallLadderPriceBo.class);
                }
            } else {
                try {
                    List uccLadderPricePOS;
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccLadderPricePOList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(uccLadderPricePOS = uccLadderPricePOList.stream().filter(s -> s.getSkuId().equals(commodityRecordBO.getSkuId())).collect(Collectors.toList()))) {
                        for (UccLadderPricePO uccLadderPricePO : uccLadderPricePOS) {
                            UccMallLadderPriceBo ladderPriceBO = new UccMallLadderPriceBo();
                            if (uccLadderPricePO.getStart() != null) {
                                ladderPriceBO.setStartPrice(MoneyUtils.haoToYuan(uccLadderPricePO.getStart()));
                            }
                            if (uccLadderPricePO.getStop() != null) {
                                ladderPriceBO.setStopPrice(MoneyUtils.haoToYuan(uccLadderPricePO.getStop()));
                            }
                            if (uccLadderPricePO.getPrice() != null) {
                                ladderPriceBO.setPrice(MoneyUtils.haoToYuan(uccLadderPricePO.getPrice()));
                            }
                            ladderPriceBOS.add(ladderPriceBO);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new BusinessException("8888", "\u67e5\u8be2\u9636\u68af\u4ef7\u683c\u5931\u8d25");
                }
            }
            if (reqBO.getExportType() != null && reqBO.getExportType() != 1 && reqBO.getType() == 0) {
                List approvalObjInfoMQBO;
                UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
                uacQryAuditLogReqBO.setObjId(commodityRecordPO.getCommodityId().toString());
                uacQryAuditLogReqBO.setObjType(Integer.valueOf(Integer.parseInt(ApprovalTypeEnum.APPROVAL_UP_SHELF.getStep())));
                UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLog(uacQryAuditLogReqBO);
                if ("0000".equals(uacQryAuditLogRspBO.getRespCode()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(approvalObjInfoMQBO = uacQryAuditLogRspBO.getRows()))) {
                    commodityRecordBO.setAuditMsg(((ApprovalLogBO)approvalObjInfoMQBO.get(0)).getAuditAdvice());
                }
            }
            commodityRecordBO.setLadderPrice(ladderPriceBOS);
            Long catalogId = null;
            if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) continue;
            List catalogIds = list.stream().filter(s -> s.getCommodityTypeId().equals(commodityRecordPO.getCommodityTypeId())).collect(Collectors.toList());
            if (catalogIds != null && catalogIds.size() > 0) {
                UccCommodityTypePo uccCommodityTypePo = (UccCommodityTypePo)catalogIds.get(0);
                catalogId = uccCommodityTypePo.getCatalogId();
            }
            commodityRecordBO.setCatalogId(catalogId);
        }
        this.getComPic(commodityRecordBOS, reqBO.getSysTenantId());
        int count = commodityRecordBOS.size();
        int n = reqBO.getPageSize();
        ArrayList pageList = new ArrayList();
        for (int i = 0; i < count; i += n) {
            int j;
            ArrayList temp = new ArrayList();
            if (count - i >= n) {
                for (j = 0; j < n; ++j) {
                    temp.add(commodityRecordBOS.get(i + j));
                }
            } else {
                for (j = 0; j < count - i; ++j) {
                    temp.add(commodityRecordBOS.get(i + j));
                }
            }
            pageList.add(temp);
        }
        rspBO.setRows((List)pageList.get(reqBO.getPageNo() - 1));
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(commodityRecordBOS.size() % reqBO.getPageSize() == 0 ? commodityRecordBOS.size() / reqBO.getPageSize() : commodityRecordBOS.size() / reqBO.getPageSize() + 1);
        rspBO.setRecordsTotal(commodityRecordBOS.size());
        return rspBO;
    }

    private List<Long> getCommodityTypeIds(Long catalogId, Long sysTenantId) {
        List<UccCatalogDealPO> uccCatalogDealPOS;
        if (catalogId == null) {
            return null;
        }
        List<Long> catalogIds = new ArrayList<Long>();
        catalogIds.add(catalogId);
        while (!org.apache.commons.collections.CollectionUtils.isEmpty(uccCatalogDealPOS = this.uccMallCatalogDealMapper.selectByUpperCatIds(catalogIds, sysTenantId))) {
            catalogIds = uccCatalogDealPOS.stream().map(UccCatalogDealPO::getGuideCatalogId).collect(Collectors.toList());
            if (uccCatalogDealPOS.get(0).getCatalogLevel() != 3) continue;
            break;
        }
        List<Long> commodityTypeIds = this.uccMallCatRCommdTypeMapper.queryTypeByGuideCatalogIds(catalogIds, sysTenantId);
        return commodityTypeIds;
    }

    private Long getCatalogId(Long commodityTypeId, Long sysTenantId) {
        UccCommodityTypePo uccCommodityTypePo;
        Long catalogId = null;
        if (commodityTypeId != null && (uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(commodityTypeId, sysTenantId)) != null) {
            catalogId = uccCommodityTypePo.getCatalogId();
        }
        return catalogId;
    }

    private CommodityRecordVO dealReq(UccMallAgrGoodListQueryAbilityReqBO reqBO) {
        List<Long> commodityTypeIds = this.getCommodityTypeIds(reqBO.getCatalogId(), reqBO.getSysTenantId());
        if (reqBO.getCatalogId() != null && org.apache.commons.collections.CollectionUtils.isEmpty(commodityTypeIds)) {
            return null;
        }
        CommodityRecordVO commodityRecordVO = new CommodityRecordVO();
        if (reqBO.getAgreementId() != null) {
            commodityRecordVO.setAgreementId(String.valueOf(reqBO.getAgreementId()));
        }
        if (reqBO.getIsShowSpu().booleanValue()) {
            commodityRecordVO.setCommodityName(reqBO.getSkuName());
        } else {
            commodityRecordVO.setSkuName(reqBO.getSkuName());
        }
        commodityRecordVO.setSkuCode(reqBO.getSkuCode());
        commodityRecordVO.setBrandName(reqBO.getBrandName());
        commodityRecordVO.setSkuStatus(reqBO.getSkuStatus());
        commodityRecordVO.setSkuId(reqBO.getSkuId());
        commodityRecordVO.setSkuIds(reqBO.getSkuIds());
        commodityRecordVO.setShowPack(reqBO.getShowPack());
        commodityRecordVO.setVendorName(reqBO.getVendorName());
        commodityRecordVO.setModel(reqBO.getModel());
        commodityRecordVO.setSpec(reqBO.getSpec());
        commodityRecordVO.setFigure(reqBO.getFigure());
        commodityRecordVO.setManufacturer(reqBO.getManufacturer());
        commodityRecordVO.setMaterialCode(reqBO.getMaterialCode());
        commodityRecordVO.setCommodityTypeIds(commodityTypeIds);
        return commodityRecordVO;
    }

    private void getComPic(List<UccMallCommodityRecordBO> bos, Long sysTenantId) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(bos)) {
            List<Long> commodityIds;
            List<UccCommodityPicPo> uccCommodityPicPos;
            List<Long> skuIds = bos.stream().map(UccMallCommodityRecordBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPicPo> skuPicPoList = this.uccMallSkuPicMapper.qeurySkuPicBySkuId(skuIds, sysTenantId);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(skuPicPoList)) {
                for (UccMallCommodityRecordBO bo : bos) {
                    for (UccSkuPicPo each : skuPicPoList) {
                        if (!bo.getSkuId().equals(each.getSkuId()) || each.getCommodityPicType() != 1) continue;
                        bo.setSkuPicUrl(each.getSkuPicUrl());
                        bo.setPriPicUrl(each.getSkuPicUrl());
                    }
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccCommodityPicPos = this.uccMallCommodityPicMapper.queryBatchByCommdId(commodityIds = bos.stream().map(UccMallCommodityRecordBO::getCommodityId).collect(Collectors.toList()), null, sysTenantId))) {
                for (UccMallCommodityRecordBO bo : bos) {
                    for (UccCommodityPicPo uccCommodityPicPo : uccCommodityPicPos) {
                        if (!bo.getCommodityId().equals(uccCommodityPicPo.getCommodityId()) || uccCommodityPicPo.getCommodityPicType() != 1) continue;
                        bo.setSkuPicUrl(uccCommodityPicPo.getCommodityPicUrl());
                        if (!StringUtils.isEmpty((Object)bo.getPriPicUrl())) continue;
                        bo.setPriPicUrl(uccCommodityPicPo.getCommodityPicUrl());
                    }
                }
            }
        }
    }

    private void getBrandInfo(List<CommodityRecordPO> pos, Long sysTenantId) {
        List<UccMallBrandRelPO> uccMallBrandRelPOS;
        List<Long> brandIds;
        if (!(org.apache.commons.collections.CollectionUtils.isEmpty(pos) || org.apache.commons.collections.CollectionUtils.isEmpty(brandIds = pos.stream().filter(a -> a.getBrandId() != null).map(CommodityRecordPO::getBrandId).collect(Collectors.toList())) || org.apache.commons.collections.CollectionUtils.isEmpty(uccMallBrandRelPOS = this.uccMallBrandRelMapper.getRelByBrandList(brandIds, sysTenantId)))) {
            Map<Long, UccMallBrandRelPO> map = uccMallBrandRelPOS.stream().filter(a -> a.getBrandId() != null).collect(Collectors.toMap(a -> a.getBrandId(), b -> b, (oldKey, newKey) -> newKey));
            for (CommodityRecordPO commodityRecordPO : pos) {
                if (commodityRecordPO.getBrandId() == null || map.get(commodityRecordPO.getBrandId()) == null) continue;
                commodityRecordPO.setBrandId(map.get(commodityRecordPO.getBrandId()).getMallBrandId());
                commodityRecordPO.setBrandName(map.get(commodityRecordPO.getBrandId()).getMallBrandName());
            }
        }
    }
}

