/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallAvailableCommdQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallAvailableCommdBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallAvailableCommdQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallAvailableCommdQryAbilityRspBO;
import com.tydic.commodity.mall.atom.api.UccMallAvailableCommdQryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallAvailableCommdQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallAvailableCommdQryRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallAvailableCommdQryAbilityService"})
public class UccMallAvailableCommdQryAbilityServiceImpl
implements UccMallAvailableCommdQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallAvailableCommdQryAbilityServiceImpl.class);
    @Autowired
    private UccMallAvailableCommdQryAtomService uccMallAvailableCommdQryAtomService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallAvailableCommdQryAbilityServiceImpl.class);

    @PostMapping(value={"qryAvailableCommd"})
    public UccMallAvailableCommdQryAbilityRspBO qryAvailableCommd(@RequestBody UccMallAvailableCommdQryAbilityReqBO reqBO) {
        String supplierCode;
        Long supplierId;
        UccMallAvailableCommdQryAbilityRspBO rspBO = new UccMallAvailableCommdQryAbilityRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc(s);
            return rspBO;
        }
        try {
            SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId(), reqBO.getSysTenantId());
            if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                rspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
                return rspBO;
            }
            supplierId = supplierShopPo.getSupplierId();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code(), UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.message());
        }
        try {
            SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId, reqBO.getSysTenantId());
            if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                rspBO.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
                return rspBO;
            }
            supplierCode = supplierBusiPo.getSupplierCode();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code(), UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.message());
        }
        ArrayList<String> extSkuIds = new ArrayList<String>();
        try {
            for (Long skuId : reqBO.getSkuIds()) {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPo.setSkuId(skuId);
                uccSkuPo.setSysTenantId(reqBO.getSysTenantId());
                List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
                if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                    rspBO.setRespDesc("\u5355\u54c1\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00");
                    rspBO.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
                    return rspBO;
                }
                String extSkuId = uccSkuPoList.get(0).getExtSkuId();
                if (StringUtils.isEmpty((CharSequence)extSkuId)) {
                    rspBO.setRespDesc("\u5916\u90e8\u5355\u54c1ID\u4e3a\u7a7a");
                    rspBO.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
                    return rspBO;
                }
                extSkuIds.add(extSkuId);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        try {
            UccMallAvailableCommdQryReqBO uccMallsAvailableCommdQryReqBO = new UccMallAvailableCommdQryReqBO();
            uccMallsAvailableCommdQryReqBO.setSupplierCode(supplierCode);
            uccMallsAvailableCommdQryReqBO.setSkuIds(extSkuIds);
            uccMallsAvailableCommdQryReqBO.setSysTenantId(reqBO.getSysTenantId());
            UccMallAvailableCommdQryRspBO uccMallsAvailableCommdQryRspBO = this.uccMallAvailableCommdQryAtomService.qryAvailableCommd(uccMallsAvailableCommdQryReqBO);
            BeanUtils.copyProperties((Object)((Object)uccMallsAvailableCommdQryRspBO), (Object)rspBO);
            rspBO.setFailError(uccMallsAvailableCommdQryRspBO.getFailError());
            rspBO.setFailMark(uccMallsAvailableCommdQryRspBO.getFailMark());
            Iterator<UccMallAvailableCommdBO_busi> var1 = uccMallsAvailableCommdQryRspBO.getAvailableCommdInfos().iterator();
            ArrayList<UccMallAvailableCommdBO_busi> uccMallAvailableCommdBO_busis = new ArrayList<UccMallAvailableCommdBO_busi>();
            while (var1.hasNext()) {
                UccMallAvailableCommdBO_busi uccMallAvailableCommdBO_busi = var1.next();
                String skuId = this.extSkuToSku(uccMallAvailableCommdBO_busi.getSkuId(), reqBO.getSupplierShopId(), reqBO.getSysTenantId()).toString();
                uccMallAvailableCommdBO_busi.setSkuId(skuId);
                uccMallAvailableCommdBO_busis.add(uccMallAvailableCommdBO_busi);
            }
            rspBO.setAvailableCommdInfos(uccMallAvailableCommdBO_busis);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    public String judge(UccMallAvailableCommdQryAbilityReqBO reqBO) {
        String s = "";
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            s = "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getSupplierShopId() == null) {
            s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return s;
    }

    public Long extSkuToSku(String extSkuId, Long supplierShopId, Long sysTenantId) {
        if (StringUtils.isEmpty((CharSequence)extSkuId) || supplierShopId == null) {
            return null;
        }
        Long skuId = -1L;
        try {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSupplierShopId(supplierShopId);
            uccSkuPo.setExtSkuId(extSkuId);
            uccSkuPo.setSysTenantId(sysTenantId);
            List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
            if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                return skuId;
            }
            skuId = uccSkuPoList.get(0).getSkuId();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return skuId;
    }
}

