/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallCurrentMoqQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccCurrentMoqQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccCurrentMoqQryAbilityRspBO;
import com.tydic.commodity.mall.atom.api.UccMallCurrentMoqQryAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentMoqQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentMoqQryRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallCurrentMoqQryAbilityService"})
public class UccMallCurrentMoqQryAbilityServiceImpl
implements UccMallCurrentMoqQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallCurrentMoqQryAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    @Autowired
    private UccMallCurrentMoqQryAtomService uccMallCurrentMoqQryAtomService;

    @PostMapping(value={"qryCurrentMoq"})
    public UccCurrentMoqQryAbilityRspBO qryCurrentMoq(@RequestBody UccCurrentMoqQryAbilityReqBO reqBO) {
        String supplierCode;
        Long supplierId;
        UccCurrentMoqQryAbilityRspBO rspBO = new UccCurrentMoqQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String errorMsg = this.val(reqBO);
        if (!"".equals(errorMsg)) {
            rspBO.setRespDesc(errorMsg);
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            return rspBO;
        }
        try {
            SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId(), reqBO.getSysTenantId());
            if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                rspBO.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
                return rspBO;
            }
            supplierId = supplierShopPo.getSupplierId();
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code(), UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.message());
        }
        try {
            SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId, reqBO.getSysTenantId());
            if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                rspBO.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                rspBO.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
                return rspBO;
            }
            supplierCode = supplierBusiPo.getSupplierCode();
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code(), UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.message());
        }
        ArrayList<String> extSkuIds = new ArrayList<String>();
        try {
            for (String skuId : reqBO.getSkuIds()) {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPo.setSkuId(Long.parseLong(skuId));
                uccSkuPo.setSysTenantId(reqBO.getSysTenantId());
                List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
                if (uccSkuPoList == null || uccSkuPoList.size() != 1) {
                    rspBO.setRespDesc("\u5355\u54c1\u4e0d\u5b58\u5728\u6216\u4e0d\u552f\u4e00");
                    rspBO.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
                    return rspBO;
                }
                String extSkuId = uccSkuPoList.get(0).getExtSkuId();
                if (StringUtils.isEmpty((CharSequence)extSkuId)) {
                    rspBO.setRespDesc("\u5916\u90e8\u5355\u54c1ID\u4e3a\u7a7a");
                    rspBO.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
                    return rspBO;
                }
                extSkuIds.add(extSkuId);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        InterfaceCurrentMoqQryReqBO interfaceCurrentMoqQryReqBO = new InterfaceCurrentMoqQryReqBO();
        interfaceCurrentMoqQryReqBO.setSkuIds(extSkuIds);
        interfaceCurrentMoqQryReqBO.setSupplierCode(supplierCode);
        InterfaceCurrentMoqQryRspBO interfaceCurrentMoqQryRspBO = this.uccMallCurrentMoqQryAtomService.qryCurrentMoq(interfaceCurrentMoqQryReqBO);
        rspBO = (UccCurrentMoqQryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)interfaceCurrentMoqQryRspBO)), UccCurrentMoqQryAbilityRspBO.class);
        if (!ObjectUtil.isEmpty((Object)rspBO.getFailSkuIdList())) {
            rspBO.setFailSkuIdList(this.getEmallSkuIds(rspBO.getFailSkuIdList()));
        }
        return rspBO;
    }

    private String val(UccCurrentMoqQryAbilityReqBO reqBO) {
        String errorMsg = "";
        if (ObjectUtil.isEmpty((Object)reqBO.getSkuIds())) {
            errorMsg = "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSupplierShopId())) {
            errorMsg = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return errorMsg;
    }

    private List<String> getEmallSkuIds(List<String> failReturnList) {
        List<String> eMallSkuIds = new ArrayList<String>();
        if (ObjectUtil.isEmpty(failReturnList)) {
            return eMallSkuIds;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setFailList(failReturnList);
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        eMallSkuIds = uccSkuPoList.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getSkuId())).map(o -> String.valueOf(o.getSkuId())).collect(Collectors.toList());
        return eMallSkuIds;
    }
}

