/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.mall.ability.api.UccMallMaterialInfoQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallMaterialInfoQueryAbilityBo;
import com.tydic.commodity.mall.ability.bo.UccMallMaterialInfoQueryAbilityReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallMaterialInfoQueryAbilityRspBo;
import com.tydic.commodity.mall.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.mall.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.mall.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccEMdmMaterialPO;
import com.tydic.commodity.mall.po.UccMallEMdmCatalogPo;
import com.tydic.commodity.mall.po.UccMallEMdmMaterialPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallMaterialInfoQueryAbilityService"})
public class UccMallMaterialInfoQueryAbilityServiceImpl
implements UccMallMaterialInfoQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallMaterialInfoQueryAbilityServiceImpl.class);
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccMdmCatalogMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"getUccMaterialInfo"})
    public UccMallMaterialInfoQueryAbilityRspBo getUccMaterialInfo(@RequestBody UccMallMaterialInfoQueryAbilityReqBo reqBo) {
        UccMallMaterialInfoQueryAbilityRspBo rspBo = new UccMallMaterialInfoQueryAbilityRspBo();
        if (reqBo.getCatalogId() == null && reqBo.getCommodityTypeId() != null) {
            UccCommodityTypePo uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(reqBo.getCommodityTypeId(), reqBo.getSysTenantId());
            if (uccCommodityTypePo != null && uccCommodityTypePo.getCatalogId() != null) {
                reqBo.setCatalogId(uccCommodityTypePo.getCatalogId());
            } else {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                return rspBo;
            }
        }
        UccEMdmMaterialPO uccEMdmMaterialPo = new UccEMdmMaterialPO();
        uccEMdmMaterialPo.setCatalogId(reqBo.getCatalogId());
        uccEMdmMaterialPo.setCatalogName(reqBo.getCatalogName());
        uccEMdmMaterialPo.setMaterialName(reqBo.getMaterialName());
        uccEMdmMaterialPo.setMaterialId(reqBo.getMaterialId());
        uccEMdmMaterialPo.setQueryString(reqBo.getQueryString());
        uccEMdmMaterialPo.setFreezeFlag(reqBo.getFreezeFlag());
        uccEMdmMaterialPo.setMaterialCode(reqBo.getMaterialCode());
        uccEMdmMaterialPo.setCatalogCode(reqBo.getCatalogCode());
        uccEMdmMaterialPo.setCatalogId(reqBo.getCatalogId());
        uccEMdmMaterialPo.setMaterialName(reqBo.getMaterialName());
        uccEMdmMaterialPo.setBrandName(reqBo.getBrandName());
        uccEMdmMaterialPo.setSpec(reqBo.getSpec());
        uccEMdmMaterialPo.setModel(reqBo.getModel());
        uccEMdmMaterialPo.setSysTenantId(reqBo.getSysTenantId());
        ArrayList<UccMallMaterialInfoQueryAbilityBo> uccMaterialInfoQueryAbilityBos = new ArrayList<UccMallMaterialInfoQueryAbilityBo>();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List<UccMallEMdmMaterialPo> uccEMdmMaterialPos = this.uccEMdmMaterialMapper.queryList(page, uccEMdmMaterialPo);
        log.info("\u7269\u6599\u67e5\u8be2\u7ed3\u679c-->" + JSON.toJSONString(uccEMdmMaterialPos));
        if (!CollectionUtils.isEmpty(uccEMdmMaterialPos)) {
            Map<String, String> freezeFlagMap = this.uccDictionaryAtomService.queryBypCodeBackMap("FREEZE_FLAG", reqBo.getSysTenantId());
            for (UccMallEMdmMaterialPo uccEMdmMaterialPo1 : uccEMdmMaterialPos) {
                UccMallMaterialInfoQueryAbilityBo uccMaterialInfoQueryAbilityBo = new UccMallMaterialInfoQueryAbilityBo();
                BeanUtils.copyProperties((Object)uccEMdmMaterialPo1, (Object)uccMaterialInfoQueryAbilityBo);
                uccMaterialInfoQueryAbilityBo.setCatalogId(uccEMdmMaterialPo1.getCatalogId());
                uccMaterialInfoQueryAbilityBo.setMaterialId(uccEMdmMaterialPo1.getMaterialId().toString());
                uccMaterialInfoQueryAbilityBo.setMaterialName(uccEMdmMaterialPo1.getMaterialName());
                uccMaterialInfoQueryAbilityBo.setMaterialDesc(uccEMdmMaterialPo1.getLongDesc());
                uccMaterialInfoQueryAbilityBo.setMaterialModel(uccEMdmMaterialPo1.getModel());
                uccMaterialInfoQueryAbilityBo.setMaterialSpec(uccEMdmMaterialPo1.getSpec());
                uccMaterialInfoQueryAbilityBo.setUnit(uccEMdmMaterialPo1.getMeasure());
                uccMaterialInfoQueryAbilityBo.setMaterialCode(uccEMdmMaterialPo1.getMaterialCode());
                uccMaterialInfoQueryAbilityBo.setCatalogCode(uccEMdmMaterialPo1.getCatalogCode());
                uccMaterialInfoQueryAbilityBo.setBrandId(uccEMdmMaterialPo1.getBrandId());
                uccMaterialInfoQueryAbilityBo.setBrandName(uccEMdmMaterialPo1.getBrandName());
                uccMaterialInfoQueryAbilityBo.setMeasureId(uccEMdmMaterialPo1.getMeasureId());
                uccMaterialInfoQueryAbilityBo.setSpec(uccEMdmMaterialPo1.getSpec());
                uccMaterialInfoQueryAbilityBo.setModel(uccEMdmMaterialPo1.getModel());
                this.getAllName(uccMaterialInfoQueryAbilityBo);
                if (uccMaterialInfoQueryAbilityBo.getFreezeFlag() != null && !CollectionUtils.isEmpty(freezeFlagMap)) {
                    uccMaterialInfoQueryAbilityBo.setFreezeFlagDesc(freezeFlagMap.get(uccMaterialInfoQueryAbilityBo.getFreezeFlag().toString()));
                }
                uccMaterialInfoQueryAbilityBos.add(uccMaterialInfoQueryAbilityBo);
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uccMaterialInfoQueryAbilityBos);
        return rspBo;
    }

    private void getAllName(UccMallMaterialInfoQueryAbilityBo bo) {
        UccMallEMdmCatalogPo uccEMdmCatalogPO;
        if (null != bo && bo.getCatalogId() != null && (uccEMdmCatalogPO = this.uccMdmCatalogMapper.queryByCatId(bo.getCatalogId(), bo.getSysTenantId())) != null) {
            StringBuffer name = new StringBuffer(uccEMdmCatalogPO.getCatalogName());
            while (uccEMdmCatalogPO.getParentCatalogId() != null && uccEMdmCatalogPO.getParentCatalogId() != 0L && (uccEMdmCatalogPO = this.uccMdmCatalogMapper.queryByCatId(uccEMdmCatalogPO.getParentCatalogId(), bo.getSysTenantId())) != null) {
                name = new StringBuffer(uccEMdmCatalogPO.getCatalogName()).append("/").append(name);
            }
            bo.setCatalogNameAll(name.toString());
        }
    }
}

