/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallQryChannelLableAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallQryChannelLableAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQryChannelLableAbilityRspBO;
import com.tydic.commodity.mall.dao.UccMallChannelDealMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityLabelMapper;
import com.tydic.commodity.mall.dao.UccMallRelChannelPoolMapper;
import com.tydic.commodity.mall.dao.UccMallRelCommodityLabelPoolMapper;
import com.tydic.commodity.mall.po.UccChannelDealPO;
import com.tydic.commodity.mall.po.UccMallChannelPoolJoinPO;
import com.tydic.commodity.mall.po.UccMallCommodityLabelPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQryChannelLableAbilityService"})
public class UccMallQryChannelLableAbilityServiceImpl
implements UccMallQryChannelLableAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallQryChannelLableAbilityServiceImpl.class);
    @Autowired
    private UccMallChannelDealMapper uccMallChannelDealMapper;
    @Autowired
    private UccMallRelChannelPoolMapper cnncUccRelChannelPoolMapper;
    @Autowired
    private UccMallRelCommodityLabelPoolMapper cnncRelCommodityLabelPoolMapper;
    @Autowired
    private UccMallCommodityLabelMapper cnncCommodityLabelMapper;

    @PostMapping(value={"queryChannelLable"})
    public UccMallQryChannelLableAbilityRspBO queryChannelLable(@RequestBody UccMallQryChannelLableAbilityReqBO reqBO) {
        UccMallQryChannelLableAbilityRspBO rspBO = new UccMallQryChannelLableAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getChannelId() == null) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        UccChannelDealPO uccChannelPO = this.uccMallChannelDealMapper.selectByPrimaryKey(reqBO.getChannelId(), reqBO.getSysTenantId());
        if (uccChannelPO == null) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        List<UccMallChannelPoolJoinPO> channelPoolJoinPOS = this.cnncUccRelChannelPoolMapper.queryRelList(Arrays.asList(reqBO.getChannelId()), null, reqBO.getSysTenantId());
        if (CollectionUtils.isEmpty(channelPoolJoinPOS)) {
            rspBO.setHideLable(new ArrayList());
            rspBO.setShowLable(new ArrayList());
            return rspBO;
        }
        HashSet pools = new HashSet();
        channelPoolJoinPOS.stream().filter(s -> s.getPoolState() != 0).forEach(s -> pools.add(s.getPoolId()));
        if (!CollectionUtils.isEmpty(pools)) {
            List<UccMallCommodityLabelPo> show = this.cnncCommodityLabelMapper.selectLabel(1, new ArrayList<Long>(pools), reqBO.getSysTenantId());
            List<UccMallCommodityLabelPo> hide = this.cnncCommodityLabelMapper.selectLabel(0, new ArrayList<Long>(pools), reqBO.getSysTenantId());
            if (!CollectionUtils.isEmpty(show)) {
                HashSet showLabel = new HashSet();
                show.stream().forEach(s -> showLabel.add(s.getLabelName()));
                rspBO.setShowLable(new ArrayList(showLabel));
            }
            if (!CollectionUtils.isEmpty(hide)) {
                HashSet hideLabel = new HashSet();
                hide.stream().forEach(s -> hideLabel.add(s.getLabelName()));
                rspBO.setHideLable(new ArrayList(hideLabel));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

