/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.commodity.mall.ability.api.UccMallQryGiftInfoAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallGiftVO;
import com.tydic.commodity.mall.ability.bo.UccMallQryGiftInfoReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQryGiftInfoRspBO;
import com.tydic.commodity.mall.atom.api.InterfaceQryGiftFromEcommerceService;
import com.tydic.commodity.mall.atom.bo.InterfaceQryGiftFromEcommerceReqBo;
import com.tydic.commodity.mall.atom.bo.InterfaceQryGiftFromEcommerceRspBo;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQryGiftInfoAbilityService"})
public class UccMallQryGiftInfoAbilityServiceImpl
implements UccMallQryGiftInfoAbilityService {
    @Autowired
    private InterfaceQryGiftFromEcommerceService interfaceQryGiftFromEcommerceService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;

    @PostMapping(value={"qryGift"})
    public UccMallQryGiftInfoRspBO qryGift(@RequestBody UccMallQryGiftInfoReqBO reqBo) {
        UccMallQryGiftInfoRspBO rspBo = new UccMallQryGiftInfoRspBO();
        if (null == reqBo || null == reqBo.getSkuId() || null == reqBo.getSupplierShopId() || null == reqBo.getProvince() || null == reqBo.getCity() || null == reqBo.getCounty() || null == reqBo.getTown()) {
            rspBo.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u3001\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBo.getSkuId());
        uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
        uccSkuPo.setSysTenantId(reqBo.getSysTenantId());
        List<UccSkuPo> skuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty(skuPoList)) {
            rspBo.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
            return rspBo;
        }
        uccSkuPo = skuPoList.get(0);
        SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId(), reqBo.getSysTenantId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId, reqBo.getSysTenantId());
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        InterfaceQryGiftFromEcommerceReqBo qryGiftFromEcommerceReqBo = new InterfaceQryGiftFromEcommerceReqBo();
        qryGiftFromEcommerceReqBo.setSupplierId(supplierId);
        qryGiftFromEcommerceReqBo.setProvince(reqBo.getProvince());
        qryGiftFromEcommerceReqBo.setCity(reqBo.getCity());
        qryGiftFromEcommerceReqBo.setCounty(reqBo.getCounty());
        qryGiftFromEcommerceReqBo.setTown(reqBo.getTown());
        qryGiftFromEcommerceReqBo.setSupplierCode(supplierCode);
        qryGiftFromEcommerceReqBo.setSkuId(uccSkuPo.getExtSkuId());
        qryGiftFromEcommerceReqBo.setSysTenantId(reqBo.getSysTenantId());
        InterfaceQryGiftFromEcommerceRspBo qryGiftFromEcommerceRspBo = null;
        qryGiftFromEcommerceRspBo = this.interfaceQryGiftFromEcommerceService.qryGift(qryGiftFromEcommerceReqBo);
        if (!"0000".equals(qryGiftFromEcommerceRspBo.getRespCode())) {
            rspBo.setRespCode(qryGiftFromEcommerceRspBo.getRespCode());
            rspBo.setRespDesc(qryGiftFromEcommerceRspBo.getRespDesc());
            return rspBo;
        }
        rspBo.setMaxNum(qryGiftFromEcommerceRspBo.getMaxNum());
        rspBo.setMinNum(qryGiftFromEcommerceRspBo.getMinNum());
        rspBo.setPromoStartTime(qryGiftFromEcommerceRspBo.getPromoStartTime());
        rspBo.setPromoEndTime(qryGiftFromEcommerceRspBo.getPromoEndTime());
        rspBo.setGifts(JSONArray.parseArray((String)JSON.toJSONString(qryGiftFromEcommerceRspBo.getGifts()), UccMallGiftVO.class));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

