/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallQrySkuStateAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallQryListSkuStateReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQryListSkuStateRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateRspBO;
import com.tydic.commodity.mall.atom.api.InterfaceQrySkuStateService;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRsp;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRspBo;
import com.tydic.commodity.mall.constants.SkuStatusEnum;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPutCirMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.dao.UccSkuExpandMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccQrySkuStateInfoPO;
import com.tydic.commodity.mall.po.UccSkuExpandPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPutCirPo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQrySkuStateAbilityService"})
public class UccMallQrySkuStateAbilityServiceImpl
implements UccMallQrySkuStateAbilityService {
    @Autowired
    private InterfaceQrySkuStateService interfaceQrySkuStateService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    @Autowired
    private UccMallSkuPutCirMapper uccMallSkuPutCirMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;

    @PostMapping(value={"qrySkuState"})
    public UccMallQrySkuStateRspBO qrySkuState(@RequestBody UccMallQrySkuStateReqBO reqBo) {
        UccMallQrySkuStateRspBO rspBo = new UccMallQrySkuStateRspBO();
        if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getSkuIds()) || null == reqBo.getSupplierShopId()) {
            rspBo.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List<UccSkuPo> skuPoList = this.uccMallSkuMapper.batchQrySku(reqBo.getSkuIds(), reqBo.getSupplierShopId(), reqBo.getSysTenantId());
        if (CollectionUtils.isEmpty(skuPoList)) {
            rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
            return rspBo;
        }
        SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId(), reqBo.getSysTenantId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId, reqBo.getSysTenantId());
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        ArrayList<UccMallQrySkuStateBO> rows = new ArrayList<UccMallQrySkuStateBO>();
        List<UccSkuPo> onList = skuPoList.stream().filter(po -> po.getSkuStatus().equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus()) && po.getSkuSource() == 2).collect(Collectors.toList());
        skuPoList.removeAll(onList);
        if (!CollectionUtils.isEmpty(onList)) {
            InterfaceSkuStateRsp uccSkuStateRsp = null;
            try {
                List<String> extSkuIds = onList.stream().map(UccSkuPo::getExtSkuId).collect(Collectors.toList());
                InterfaceSkuStateReqBO uccSkuStateReqBo = new InterfaceSkuStateReqBO();
                uccSkuStateReqBo.setExtSkuIds(extSkuIds);
                uccSkuStateReqBo.setSupplierId(supplierId);
                uccSkuStateReqBo.setSupplierCode(supplierCode);
                uccSkuStateReqBo.setSysTenantId(reqBo.getSysTenantId());
                uccSkuStateRsp = this.interfaceQrySkuStateService.qrySkuStatus(uccSkuStateReqBo);
            }
            catch (Exception e) {
                rspBo = this.returnSuccess(rspBo, onList, skuPoList, true);
                rspBo.setFailError(e.getMessage());
                return rspBo;
            }
            if (!"0000".equals(uccSkuStateRsp.getRespCode())) {
                if (!ObjectUtil.isEmpty(uccSkuStateRsp.getFailSkuIdList())) {
                    rspBo = this.returnSuccess(rspBo, onList, skuPoList, false);
                    rspBo.setFailSkuIdList(this.getEmallSkuIds(uccSkuStateRsp.getFailSkuIdList()));
                } else {
                    rspBo = this.returnSuccess(rspBo, onList, skuPoList, true);
                }
                rspBo.setFailError(uccSkuStateRsp.getRespDesc());
                return rspBo;
            }
            rspBo.setFailSkuIdList(this.getEmallSkuIds(uccSkuStateRsp.getFailSkuIdList()));
            for (UccSkuPo uccSkuPo : onList) {
                for (InterfaceSkuStateRspBo skuState : uccSkuStateRsp.getSkuStates()) {
                    if (!uccSkuPo.getExtSkuId().equals(skuState.getSku())) continue;
                    UccMallQrySkuStateBO stateBO = new UccMallQrySkuStateBO();
                    stateBO.setSkuId(uccSkuPo.getSkuId());
                    stateBO.setStatus(skuState.getState().toString());
                    stateBO.setEstimatedTimeOfAvailability(skuState.getEstimatedTimeOfAvailability());
                    stateBO.setReasonFordelisting(skuState.getReasonFordelisting());
                    rows.add(stateBO);
                }
            }
        }
        ArrayList<Long> downSku = new ArrayList<Long>();
        for (UccSkuPo uccSkuPo : skuPoList) {
            UccMallQrySkuStateBO stateBO = new UccMallQrySkuStateBO();
            if (uccSkuPo.getSkuSource() != 2 && uccSkuPo.getSkuStatus() == 3) {
                stateBO.setSkuId(uccSkuPo.getSkuId());
                stateBO.setStatus("1");
            } else {
                if (uccSkuPo.getSkuSource() == 2 && uccSkuPo.getSkuStatus() == 7) {
                    downSku.add(uccSkuPo.getSkuId());
                }
                stateBO.setSkuId(uccSkuPo.getSkuId());
                stateBO.setStatus("2");
            }
            rows.add(stateBO);
        }
        if (!CollectionUtils.isEmpty(downSku)) {
            UccSkuPutCirPo putCirPo = new UccSkuPutCirPo();
            putCirPo.setState(1);
            List<UccSkuPutCirPo> uccSkuPutCirPos = this.uccMallSkuPutCirMapper.batchQryById(downSku, putCirPo);
            Map<Object, Object> putCirPoMap = new HashMap();
            if (!CollectionUtils.isEmpty(uccSkuPutCirPos)) {
                putCirPoMap = uccSkuPutCirPos.stream().collect(Collectors.toMap(UccSkuPutCirPo::getSkuId, Function.identity(), (oldValue, newValue) -> oldValue));
            }
            List<UccSkuExpandPo> skuExpandPos = this.uccSkuExpandMapper.querySkuExpandBySkus(downSku);
            Map<Object, Object> expandPoMap = new HashMap();
            if (!CollectionUtils.isEmpty(skuExpandPos)) {
                expandPoMap = skuExpandPos.stream().collect(Collectors.toMap(UccSkuExpandPo::getSkuId, Function.identity(), (oldValue, newValue) -> oldValue));
            }
            if (!expandPoMap.isEmpty() || !putCirPoMap.isEmpty()) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (UccMallQrySkuStateBO state : rows) {
                    if (putCirPoMap.containsKey(state.getSkuId()) && ((UccSkuPutCirPo)putCirPoMap.get(state.getSkuId())).getPreUpTime() != null) {
                        state.setEstimatedTimeOfAvailability(formatter.format(((UccSkuPutCirPo)putCirPoMap.get(state.getSkuId())).getPreUpTime()));
                    }
                    if (!expandPoMap.containsKey(state.getSkuId())) continue;
                    state.setReasonFordelisting(((UccSkuExpandPo)expandPoMap.get(state.getSkuId())).getExpand16());
                }
            }
        }
        rspBo.setRows(rows);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @PostMapping(value={"qryListSkuState"})
    public UccMallQryListSkuStateRspBO qryListSkuState(@RequestBody UccMallQryListSkuStateReqBO reqBo) {
        UccMallQryListSkuStateRspBO rspBo = new UccMallQryListSkuStateRspBO();
        if (null == reqBo || null == reqBo.getListInfo()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List listInfo = reqBo.getListInfo();
        if (null == listInfo || listInfo.size() == 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List poList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)listInfo), UccQrySkuStateInfoPO.class);
        List<UccSkuPo> skuPoList = this.uccMallSkuMapper.qerySkuStatusList(poList, reqBo.getSysTenantId());
        if (CollectionUtils.isEmpty(skuPoList)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
            return rspBo;
        }
        HashMap map = new HashMap();
        for (UccMallQrySkuStateInfoBO bo : listInfo) {
            ArrayList<UccSkuPo> newList = new ArrayList<UccSkuPo>();
            for (UccSkuPo po : skuPoList) {
                if (!bo.getSupplierShopId().equals(po.getSupplierShopId())) continue;
                newList.add(po);
            }
            map.put(bo.getSupplierShopId(), newList);
        }
        ArrayList<UccMallQrySkuStateBO> skuStateBOList = new ArrayList<UccMallQrySkuStateBO>();
        UccSkuPo uccSkuPo = null;
        for (Long key : map.keySet()) {
            List skuPoList1 = (List)map.get(key);
            Long supplierId = key;
            InterfaceSkuStateReqBO uccSkuStateReqBo = new InterfaceSkuStateReqBO();
            UccMallQrySkuStateBO skuStateBO = new UccMallQrySkuStateBO();
            ArrayList<String> extSkuIds = new ArrayList<String>();
            String supplierCode = null;
            Iterator iterator = skuPoList1.iterator();
            while (iterator.hasNext()) {
                UccSkuPo po;
                uccSkuPo = po = (UccSkuPo)iterator.next();
                if (po.getSkuStatus().equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())) {
                    SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(po.getSupplierShopId(), reqBo.getSysTenantId());
                    if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                        rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                        rspBo.setRespCode("8888");
                        return rspBo;
                    }
                    supplierId = supplierShopPo.getSupplierId();
                    SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId, reqBo.getSysTenantId());
                    if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                        rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                        rspBo.setRespCode("8888");
                        return rspBo;
                    }
                    supplierCode = supplierBusiPo.getSupplierCode();
                    if (po.getSkuSource() == 2) {
                        extSkuIds.add(uccSkuPo.getExtSkuId());
                        continue;
                    }
                    skuStateBO.setSkuId(po.getSkuId());
                    skuStateBO.setSupplierShopId(po.getSupplierShopId());
                    skuStateBO.setStatus("1");
                    skuStateBOList.add(skuStateBO);
                    continue;
                }
                skuStateBO.setSkuId(po.getSkuId());
                skuStateBO.setSupplierShopId(po.getSupplierShopId());
                skuStateBO.setStatus("2");
                skuStateBOList.add(skuStateBO);
            }
            if (CollectionUtils.isEmpty(extSkuIds)) continue;
            uccSkuStateReqBo.setExtSkuIds(extSkuIds);
            uccSkuStateReqBo.setSupplierId(supplierId);
            uccSkuStateReqBo.setSupplierCode(supplierCode);
            uccSkuStateReqBo.setSysTenantId(reqBo.getSysTenantId());
            InterfaceSkuStateRsp uccSkuStateRsp = this.interfaceQrySkuStateService.qrySkuStatus(uccSkuStateReqBo);
            if (!"0000".equals(uccSkuStateRsp.getRespCode())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(uccSkuStateRsp.getRespDesc());
                return rspBo;
            }
            List<InterfaceSkuStateRspBo> stateRspBoList = uccSkuStateRsp.getSkuStates();
            block4: for (InterfaceSkuStateRspBo bo : stateRspBoList) {
                for (UccSkuPo po : skuPoList) {
                    if (!bo.getSku().equals(po.getExtSkuId())) continue;
                    UccMallQrySkuStateBO skuStateBO2 = new UccMallQrySkuStateBO();
                    skuStateBO2.setSkuId(po.getSkuId());
                    skuStateBO2.setSupplierShopId(supplierId);
                    skuStateBO2.setStatus(bo.getState().toString());
                    skuStateBO2.setEstimatedTimeOfAvailability(bo.getEstimatedTimeOfAvailability());
                    skuStateBO2.setReasonFordelisting(bo.getReasonFordelisting());
                    skuStateBOList.add(skuStateBO2);
                    continue block4;
                }
            }
        }
        rspBo.setResult(skuStateBOList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccMallQrySkuStateRspBO returnSuccess(UccMallQrySkuStateRspBO rspBo, List<UccSkuPo> onList, List<UccSkuPo> skuPoList, Boolean mark) {
        UccMallQrySkuStateBO bo;
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        ArrayList<UccMallQrySkuStateBO> rows = new ArrayList<UccMallQrySkuStateBO>();
        ArrayList<String> failSkuIdList = new ArrayList<String>();
        for (UccSkuPo uccSkuPo : onList) {
            bo = new UccMallQrySkuStateBO();
            bo.setSkuId(uccSkuPo.getSkuId());
            bo.setStatus("2");
            rows.add(bo);
            failSkuIdList.add(String.valueOf(uccSkuPo.getSkuId()));
        }
        for (UccSkuPo uccSkuPo : skuPoList) {
            bo = new UccMallQrySkuStateBO();
            bo.setSkuId(uccSkuPo.getSkuId());
            bo.setStatus("2");
            rows.add(bo);
            failSkuIdList.add(String.valueOf(uccSkuPo.getSkuId()));
        }
        if (mark.booleanValue()) {
            rspBo.setFailSkuIdList(this.getEmallSkuIds(failSkuIdList));
        }
        rspBo.setRows(rows);
        rspBo.setFailMark(Integer.valueOf(1));
        return rspBo;
    }

    private List<String> getEmallSkuIds(List<String> failReturnList) {
        List<String> eMallSkuIds = new ArrayList<String>();
        if (ObjectUtil.isEmpty(failReturnList)) {
            return eMallSkuIds;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setFailList(failReturnList);
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        eMallSkuIds = uccSkuPoList.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getSkuId())).map(o -> String.valueOf(o.getSkuId())).collect(Collectors.toList());
        return eMallSkuIds;
    }
}

