/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallCurrentPriceQryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallRefreshSkuPriceTaskAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallEsCommodityBo;
import com.tydic.commodity.mall.ability.bo.UccMallRefreshSkuPriceTaskAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallRefreshSkuPriceTaskAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuListQryBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallRefreshSkuPriceTaskAbilityService"})
public class UccMallRefreshSkuPriceTaskAbilityServiceImpl
implements UccMallRefreshSkuPriceTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallRefreshSkuPriceTaskAbilityServiceImpl.class);
    @Autowired
    private MallEsConfig mallesConfig;
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private UccMallCurrentPriceQryAbilityService UccMallCurrentPriceQryAbilityService;

    @PostMapping(value={"refresh"})
    public UccMallRefreshSkuPriceTaskAbilityRspBO refresh(@RequestBody UccMallRefreshSkuPriceTaskAbilityReqBO reqBO) {
        UccMallRefreshSkuPriceTaskAbilityRspBO rspBo = new UccMallRefreshSkuPriceTaskAbilityRspBO();
        if (reqBO.getPools() == null) {
            rspBo.setRespCode("0000");
            return rspBo;
        }
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            this.refreshPrice(rspBo.getRows(), reqBO.getSysTenantId());
        }
        if (rspBo.getTotal() >= 2) {
            int total = rspBo.getTotal() + 1;
            for (int i = 2; i < total; ++i) {
                reqBO.setPageNo(i);
                queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
                result = this.searchInfo(queryString);
                rspBo = this.dealSearchData(result, reqBO);
                if (CollectionUtils.isEmpty((Collection)rspBo.getRows())) continue;
                this.refreshPrice(rspBo.getRows(), reqBO.getSysTenantId());
            }
        }
        rspBo.setRespCode("0000");
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.mallesConfig.getIndexName() + "/" + this.mallesConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccMallRefreshSkuPriceTaskAbilityReqBO reqBo) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBo.getPools() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuPoolIds", (Object)reqBo.getPools()));
        }
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (int)2));
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccMallRefreshSkuPriceTaskAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        return queryJson.toString();
    }

    private UccMallRefreshSkuPriceTaskAbilityRspBO dealSearchData(String result, UccMallRefreshSkuPriceTaskAbilityReqBO reqBo) {
        UccMallRefreshSkuPriceTaskAbilityRspBO rspBo = new UccMallRefreshSkuPriceTaskAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccMallEsCommodityBo> commodityModels = new ArrayList<UccMallEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccMallEsCommodityBo commodity = new UccMallEsCommodityBo();
                try {
                    commodity = (UccMallEsCommodityBo)JSON.toJavaObject((JSON)data, UccMallEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccMallRefreshSkuPriceTaskAbilityRspBO copyData(List<UccMallEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccMallRefreshSkuPriceTaskAbilityRspBO rspBo = new UccMallRefreshSkuPriceTaskAbilityRspBO();
        ArrayList<UccMallSkuListQryBO> uccSkuManagementListQryBOs = new ArrayList<UccMallSkuListQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccMallEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    UccMallSkuListQryBO uccSkuManagementListQryBO = new UccMallSkuListQryBO();
                    uccSkuManagementListQryBO.setCommodityId(Long.valueOf(cnncEsCommodityBo.getCommodity_id()));
                    uccSkuManagementListQryBO.setSkuId(Long.valueOf(cnncEsCommodityBo.getSku_id()));
                    uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
                    uccSkuManagementListQryBO.setSkuSource(Integer.valueOf(cnncEsCommodityBo.getSku_source()));
                    uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
                    uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
                    uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
                    uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void refreshPrice(List<UccMallSkuListQryBO> boList, Long sysTenantId) {
        Map<Long, List<UccMallSkuListQryBO>> supperliSku = boList.stream().collect(Collectors.groupingBy(UccMallSkuListQryBO::getSupplierShopId));
        for (Long supplierShopId : supperliSku.keySet()) {
            List skus = supperliSku.get(supplierShopId).stream().map(UccMallSkuListQryBO::getSkuId).collect(Collectors.toList());
            UccMallCurrentPriceQryReqBO uccMallCurrentPriceQryReqBO = new UccMallCurrentPriceQryReqBO();
            uccMallCurrentPriceQryReqBO.setSupplierShopId(supplierShopId);
            uccMallCurrentPriceQryReqBO.setSkuIds(skus);
            uccMallCurrentPriceQryReqBO.setSysTenantId(sysTenantId);
            try {
                this.UccMallCurrentPriceQryAbilityService.changeCommdCurrentPrice(uccMallCurrentPriceQryReqBO);
            }
            catch (Exception e) {
                log.error("\u4ef7\u683c\u5237\u65b0\u5931\u8d25\u4e86" + e.getMessage());
            }
        }
    }
}

