/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.mall.ability.api.UccMallSearchBarEsAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallOrderColumBo;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.mall.busi.api.UccMallSearchCommodityService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchOrderConfigBO;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.dao.UccMallSpuSpecMapper;
import com.tydic.commodity.mall.po.UccSpuSpecPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallSearchBarEsAbilityService"})
public class UccMallSearchBarEsAbilityServiceImpl
implements UccMallSearchBarEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchBarEsAbilityServiceImpl.class);
    @Autowired
    private UccMallSearchCommodityService uccMallSearchCommodityService;
    @Autowired
    private UccMallSpuSpecMapper uccMallSpuSpecMapper;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${HR.sysTenantId:305775845729763327}")
    private Long sysTenantIdHR;

    @PostMapping(value={"qryBySearchBar"})
    public UccMallSearchBarEsRspBO qryBySearchBar(@RequestBody UccMallSearchBarEsReqBO reqBO) {
        UccMallSearchEsRspBo uccMallSearchEsRspBo;
        List<Long> ignoeList;
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)reqBO.getOrgPath()) && !CollectionUtils.isEmpty(ignoeList = this.searchLimitGui(reqBO.getOrgPath()))) {
            reqBO.setIgnoreAgrList(ignoeList);
        }
        ArrayList<UccMallOrderColumBo> orderColum = new ArrayList<UccMallOrderColumBo>();
        Object obj = null;
        obj = reqBO.getSysTenantId() != null && !this.sysTenantIdHR.equals(reqBO.getSysTenantId()) ? this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG" + reqBO.getQueryChannelId() + "_" + reqBO.getSysTenantId()) : this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG" + reqBO.getQueryChannelId());
        if (obj == null) {
            obj = this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG1");
        }
        if (obj != null) {
            List<UccMallSearchOrderConfigBO> searchOrderConfigBoList = new ArrayList();
            try {
                searchOrderConfigBoList = obj instanceof String ? JSONObject.parseArray((String)((String)obj), UccMallSearchOrderConfigBO.class) : JSONObject.parseArray((String)JSONObject.toJSONString((Object)obj), UccMallSearchOrderConfigBO.class);
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a\u5546\u54c1\u6392\u5e8f\u8f6c\u6362\u5f02\u5e38" + JSONObject.toJSONString((Object)reqBO));
            }
            if (!CollectionUtils.isEmpty(searchOrderConfigBoList)) {
                searchOrderConfigBoList.sort(Comparator.comparing(UccMallSearchOrderConfigBO::getId));
                for (UccMallSearchOrderConfigBO each : searchOrderConfigBoList) {
                    if (each.getStatus() != 1L) continue;
                    UccMallOrderColumBo bo = new UccMallOrderColumBo();
                    bo.setOrderByColumn(each.getColName());
                    bo.setOrderType(Integer.valueOf(each.getType().intValue()));
                    orderColum.add(bo);
                }
                reqBO.setOrderColum(orderColum);
            }
        }
        String jsonStr1 = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccMallSearchEsReqBO uccMallSearchEsReqBO = (UccMallSearchEsReqBO)((Object)JSON.parseObject((String)jsonStr1, UccMallSearchEsReqBO.class));
        UccMallSearchBarEsRspBO uccMallSearchBarEsRspBO = new UccMallSearchBarEsRspBO();
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
            uccMallSearchEsReqBO.setSkuStatus(skuStatus);
        }
        if (null != reqBO.getCategoryId()) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(reqBO.getCategoryId());
            uccMallSearchEsReqBO.setCategoryIds(categoryIds);
        }
        if (reqBO.getSupplierShopId() != null) {
            ArrayList<Long> supplierShopIds = new ArrayList<Long>();
            supplierShopIds.add(reqBO.getSupplierShopId());
            uccMallSearchEsReqBO.setSupplierShopIds(supplierShopIds);
        }
        if (reqBO.getBrandId() != null) {
            ArrayList<Long> brandIds = new ArrayList<Long>();
            brandIds.add(reqBO.getBrandId());
            uccMallSearchEsReqBO.setBrandIds(brandIds);
        }
        if (reqBO.getTypeId() != null) {
            uccMallSearchEsReqBO.setTypeId(reqBO.getTypeId());
        }
        if (reqBO.getTypeName() != null) {
            uccMallSearchEsReqBO.setTypeName(reqBO.getTypeName());
        }
        if (log.isInfoEnabled()) {
            log.info("queryByMatch\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)((Object)uccMallSearchEsReqBO)));
        }
        if ((uccMallSearchEsRspBo = this.uccMallSearchCommodityService.queryByMatch(uccMallSearchEsReqBO)) == null) {
            log.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
            uccMallSearchBarEsRspBO.setRespCode("0000");
            uccMallSearchBarEsRspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            uccMallSearchBarEsRspBO.setPageNo(1);
            uccMallSearchBarEsRspBO.setTotal(0);
            uccMallSearchBarEsRspBO.setRecordsTotal(0);
            return uccMallSearchBarEsRspBO;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)uccMallSearchBarEsRspBO);
        List<UccMallCommodityRspBo> uccMallCommodityRspBos = uccMallSearchEsRspBo.getUccMallCommodityRspBos();
        List<UccMallSearchBarEsRspInfo> result = this.convertRspBo(uccMallCommodityRspBos);
        uccMallSearchBarEsRspBO.setResult(result);
        int size = reqBO.getPageSize();
        int no = reqBO.getPageNo();
        int totalPage = 0;
        int add = 0;
        Integer total = 0;
        totalPage = uccMallSearchEsRspBo.getTotal() / size;
        add = uccMallSearchEsRspBo.getTotal() % size == 0 ? 0 : 1;
        total = uccMallSearchEsRspBo.getTotal();
        uccMallSearchBarEsRspBO.setTotal(totalPage + add);
        uccMallSearchBarEsRspBO.setPageNo(no);
        if (uccMallSearchEsRspBo.getUccMallQueryParams() != null && uccMallSearchEsRspBo.getPropParams() != null) {
            uccMallSearchEsRspBo.getUccMallQueryParams().addAll(uccMallSearchEsRspBo.getPropParams());
        }
        uccMallSearchBarEsRspBO.setQueryParams(uccMallSearchEsRspBo.getUccMallQueryParams());
        uccMallSearchBarEsRspBO.setRecordsTotal(total.intValue());
        uccMallSearchBarEsRspBO.setRespCode("0000");
        uccMallSearchBarEsRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return uccMallSearchBarEsRspBO;
    }

    private List<UccMallSearchBarEsRspInfo> convertRspBo(List<UccMallCommodityRspBo> uccMallCommodityRspBos) {
        ArrayList<UccMallSearchBarEsRspInfo> uccMallSearchBarEsRspInfos = new ArrayList<UccMallSearchBarEsRspInfo>();
        if (uccMallCommodityRspBos != null && uccMallCommodityRspBos.size() > 0) {
            for (UccMallCommodityRspBo uccMallCommodityRspBo : uccMallCommodityRspBos) {
                UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo = new UccMallSearchBarEsRspInfo();
                uccMallSearchBarEsRspInfo.setCommodityId(Long.valueOf(uccMallCommodityRspBo.getCommodity_id()));
                uccMallSearchBarEsRspInfo.setSkuId(Long.valueOf(uccMallCommodityRspBo.getSku_id()));
                uccMallSearchBarEsRspInfo.setExtSkuId(uccMallCommodityRspBo.getExt_sku_id());
                uccMallSearchBarEsRspInfo.setPriPicUrl(uccMallCommodityRspBo.getPicture_url());
                uccMallSearchBarEsRspInfo.setLimitOrder(Integer.valueOf(uccMallCommodityRspBo.getLimit_order()));
                uccMallSearchBarEsRspInfo.setIsOverDiscount(Integer.valueOf(uccMallCommodityRspBo.getIs_over_discount()));
                uccMallSearchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getAgreement_price())));
                uccMallSearchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMarket_price())));
                uccMallSearchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getSale_price())));
                if (uccMallCommodityRspBo.getMember_price1() != null) {
                    uccMallSearchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price1())));
                }
                if (uccMallCommodityRspBo.getMember_price2() != null) {
                    uccMallSearchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price2())));
                }
                uccMallSearchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price3())));
                uccMallSearchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price4())));
                uccMallSearchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan(new BigDecimal(uccMallCommodityRspBo.getMember_price5())));
                uccMallSearchBarEsRspInfo.setCommentNumber(uccMallCommodityRspBo.getComment_number());
                uccMallSearchBarEsRspInfo.setMeasureName(uccMallCommodityRspBo.getMeasure_name());
                uccMallSearchBarEsRspInfo.setSkuName(uccMallCommodityRspBo.getSku_name());
                uccMallSearchBarEsRspInfo.setSupplierShopId(uccMallCommodityRspBo.getSupplier_shop_id());
                uccMallSearchBarEsRspInfo.setSupplierShopName(uccMallCommodityRspBo.getShop_name());
                uccMallSearchBarEsRspInfo.setSupplierId(String.valueOf(uccMallCommodityRspBo.getSupplier_id()));
                uccMallSearchBarEsRspInfo.setSupplierName(uccMallCommodityRspBo.getSupplier_name());
                uccMallSearchBarEsRspInfo.setSkuSource(Integer.valueOf(uccMallCommodityRspBo.getSku_source()));
                uccMallSearchBarEsRspInfo.setCommodityName(uccMallCommodityRspBo.getCommodity_name());
                uccMallSearchBarEsRspInfo.setCommdPicUrl(uccMallCommodityRspBo.getCommd_pic_url());
                if (uccMallCommodityRspBo.getEcommerce_sale() != null) {
                    uccMallSearchBarEsRspInfo.setEcommerceSale(Long.valueOf(uccMallCommodityRspBo.getEcommerce_sale().longValue()));
                }
                uccMallSearchBarEsRspInfo.setExtendProperties(uccMallCommodityRspBo.getExtendProperties());
                uccMallSearchBarEsRspInfo.setVendorName(uccMallCommodityRspBo.getVendor_name());
                uccMallSearchBarEsRspInfo.setAgreementId(Long.valueOf(uccMallCommodityRspBo.getAgreement_id()));
                uccMallSearchBarEsRspInfo.setHighLightSkuName(uccMallCommodityRspBo.getHighLightSkuName());
                uccMallSearchBarEsRspInfo.setHighLightCommodityName(uccMallCommodityRspBo.getHighLightCommodityName());
                uccMallSearchBarEsRspInfo.setChannelNames(uccMallCommodityRspBo.getChannel_Name());
                uccMallSearchBarEsRspInfo.setChannelIds(uccMallCommodityRspBo.getChannel_id());
                uccMallSearchBarEsRspInfo.setLabelIds(uccMallCommodityRspBo.getLabelIds());
                uccMallSearchBarEsRspInfo.setLabelNames(uccMallCommodityRspBo.getLabelNames());
                uccMallSearchBarEsRspInfo.setShowLabelIds(uccMallCommodityRspBo.getShowLabelIds());
                uccMallSearchBarEsRspInfo.setShowLabelNames(uccMallCommodityRspBo.getShowLabelNames());
                uccMallSearchBarEsRspInfo.setSalesUnitName(uccMallCommodityRspBo.getSales_unit_name());
                uccMallSearchBarEsRspInfo.setExtSpuId(uccMallCommodityRspBo.getExt_spu_id());
                uccMallSearchBarEsRspInfo.setMoq(uccMallCommodityRspBo.getMoq());
                uccMallSearchBarEsRspInfo.setHrAgreementType(uccMallCommodityRspBo.getHr_agreement_type());
                if (uccMallCommodityRspBo.getMincrement() == null) {
                    uccMallSearchBarEsRspInfo.setMincrement(new BigDecimal(1));
                } else {
                    uccMallSearchBarEsRspInfo.setMincrement(uccMallCommodityRspBo.getMincrement());
                }
                uccMallSearchBarEsRspInfo.setSwitchOn(uccMallCommodityRspBo.getSwitch_on());
                uccMallSearchBarEsRspInfo.setTypeId(uccMallCommodityRspBo.getType_id());
                uccMallSearchBarEsRspInfo.setVendorId(uccMallCommodityRspBo.getVendor_id());
                uccMallSearchBarEsRspInfos.add(uccMallSearchBarEsRspInfo);
            }
        }
        uccMallCommodityRspBos = null;
        return uccMallSearchBarEsRspInfos;
    }

    private void queryOtherProp(List<UccMallSearchBarEsRspInfo> rspInfos, Long sysTenantId) {
        if (rspInfos == null || rspInfos.size() == 0) {
            return;
        }
        HashedMap shopCommd = new HashedMap();
        for (UccMallSearchBarEsRspInfo each : rspInfos) {
            if (shopCommd.containsKey(each.getSupplierShopId())) {
                ((List)shopCommd.get(each.getSupplierShopId())).add(each.getCommodityId());
                continue;
            }
            ArrayList<Long> commoditys = new ArrayList<Long>();
            commoditys.add(each.getCommodityId());
            shopCommd.put(each.getSupplierShopId(), commoditys);
        }
        Iterator iterator = shopCommd.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            System.out.println(++i);
            Map.Entry data = iterator.next();
            List<UccSpuSpecPo> uccSpuSpecPoList = this.uccMallSpuSpecMapper.batchQueryLessSpecs((List)data.getValue(), ModelRuleConstant.PROP_GRP_TYPE_OTHER, (Long)data.getKey(), sysTenantId);
            if (uccSpuSpecPoList == null || uccSpuSpecPoList.size() == 0) continue;
            HashedMap specMap = new HashedMap();
            for (UccSpuSpecPo uccSpuSpecPo : uccSpuSpecPoList) {
                if (specMap.containsKey(uccSpuSpecPo.getCommodityId())) {
                    ((JSONObject)specMap.get(uccSpuSpecPo.getCommodityId())).put(uccSpuSpecPo.getPropShowName(), (Object)uccSpuSpecPo.getPropValue());
                    continue;
                }
                JSONObject specData = new JSONObject();
                specData.put(uccSpuSpecPo.getPropShowName(), (Object)uccSpuSpecPo.getPropValue());
                specMap.put(uccSpuSpecPo.getCommodityId(), specData);
            }
            for (UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo : rspInfos) {
                uccMallSearchBarEsRspInfo.setExtendProperties(JSONObject.toJSONString(specMap.get(uccMallSearchBarEsRspInfo.getCommodityId())));
            }
        }
        shopCommd = null;
    }

    public List<Long> searchLimitGui(String orgPath) {
        ArrayList<Long> igSkuList = new ArrayList<Long>();
        ArrayList whiteList = new ArrayList();
        if (StringUtils.isEmpty((Object)orgPath)) {
            return null;
        }
        String[] orgPathList = orgPath.split("-");
        HashedMap igListMap = new HashedMap();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orgPathList.length; ++i) {
            sb = new StringBuffer("UCC_ORG_AGR_WHITELIST_RESTRICTION");
            String sb1 = sb.append(orgPathList[i]).toString();
            Object object = this.cacheClient.get(sb1);
            if (object == null || !(object instanceof ArrayList)) continue;
            for (Object o : (List)object) {
                whiteList.add(Long.class.cast(o));
            }
        }
        Object object = this.cacheClient.get("UCC_ORG_AGR_EXCLUDE_RESTRICTION");
        if (object instanceof ArrayList) {
            for (Object o : (List)object) {
                igSkuList.add((Long)Long.class.cast(o));
            }
        }
        if (CollectionUtils.isEmpty(igSkuList) || CollectionUtils.isEmpty(whiteList)) {
            return igSkuList;
        }
        igSkuList.removeAll(whiteList);
        return igSkuList;
    }
}

