/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallSimilarSkuListAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuBO;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuListAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuListAbilityRspBO;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccMallSimilarSkuPO;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallSimilarSkuListAbilityService"})
public class UccMallSimilarSkuListAbilityServiceImpl
implements UccMallSimilarSkuListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSimilarSkuListAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper skuMapper;

    @PostMapping(value={"qrySimilarSkuList"})
    public UccMallSimilarSkuListAbilityRspBO qrySimilarSkuList(@RequestBody UccMallSimilarSkuListAbilityReqBO reqBO) {
        UccMallSimilarSkuListAbilityRspBO rspBo = new UccMallSimilarSkuListAbilityRspBO();
        String reqStr = JSONObject.toJSONString((Object)reqBO);
        try {
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("SIMILAR_SKU")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u540c\u6b3e\u5546\u54c1\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("SIMILAR_SKU") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u8c03\u7528\u540c\u6b3e\u5546\u54c1\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u5931\u8d25\uff01");
            }
            rspBo = this.resolveRsp(reqBO, returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u540c\u6b3e\u5546\u54c1\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u540c\u6b3e\u5546\u54c1\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBo;
    }

    private UccMallSimilarSkuListAbilityRspBO resolveRsp(UccMallSimilarSkuListAbilityReqBO reqBO, String returnString) {
        log.debug("\u8c03\u7528\u540c\u6b3e\u5546\u54c1\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        String key = "rspCode";
        UccMallSimilarSkuListAbilityRspBO rspBO = new UccMallSimilarSkuListAbilityRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (StringUtils.isEmpty((Object)jsonObject.getString(key))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u540c\u6b3e\u5546\u54c1\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u672a\u8fd4\u56de\u6267\u884c\u7ed3\u679c\u7f16\u7801!");
            return rspBO;
        }
        if ("0000".equals(jsonObject.getString(key))) {
            JSONArray linkedSkuIdsJson;
            ArrayList<Long> linkedSkuIds = new ArrayList<Long>();
            JSONObject vskuInfo = jsonObject.getJSONObject("data");
            if (null != vskuInfo && null != (linkedSkuIdsJson = vskuInfo.getJSONArray("linkedSkuIds")) && linkedSkuIdsJson.size() > 0) {
                for (Object object : linkedSkuIdsJson) {
                    Long skuId = Long.parseLong(object.toString());
                    if (reqBO.getSkuId().equals(skuId)) continue;
                    linkedSkuIds.add(Long.parseLong(object.toString()));
                }
                List<UccMallSimilarSkuPO> similarSkuPOList = this.skuMapper.qrySimilarSkuList((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize(), linkedSkuIds, reqBO.getOrderByColumn(), reqBO.getOrderType(), reqBO.getSysTenantId());
                ArrayList<UccMallSimilarSkuBO> similarSkuBOList = new ArrayList<UccMallSimilarSkuBO>();
                if (!CollectionUtils.isEmpty(similarSkuPOList)) {
                    for (UccMallSimilarSkuPO similarSkuPO : similarSkuPOList) {
                        UccMallSimilarSkuBO similarSkuBO = new UccMallSimilarSkuBO();
                        similarSkuBO = (UccMallSimilarSkuBO)JSONObject.parseObject((String)JSON.toJSONString((Object)similarSkuPO), UccMallSimilarSkuBO.class);
                        similarSkuBOList.add(similarSkuBO);
                    }
                }
                rspBO.setRows(similarSkuBOList);
                Integer total = this.skuMapper.qrySimilarSkuCount(linkedSkuIds, reqBO.getSysTenantId());
                rspBO.setTotal(total.intValue());
                rspBO.setRecordsTotal(total.intValue());
            }
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u540c\u6b3e\u5546\u54c1\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u5931\u8d25,\u9519\u8bef\u7801:" + jsonObject.getString(key));
            return rspBO;
        }
        ArrayList<Long> thisSkuId = new ArrayList<Long>();
        thisSkuId.add(reqBO.getSkuId());
        UccMallSimilarSkuPO thisSkuBo = this.skuMapper.qrySimilarSkuList((reqBO.getPageNo() - 1) * reqBO.getPageSize(), reqBO.getPageSize(), thisSkuId, reqBO.getOrderByColumn(), reqBO.getOrderType(), reqBO.getSysTenantId()).get(0);
        UccMallSimilarSkuBO skuBo = (UccMallSimilarSkuBO)JSONObject.parseObject((String)JSON.toJSONString((Object)thisSkuBo), UccMallSimilarSkuBO.class);
        rspBO.setThisSku(skuBo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

