/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.mall.ability.api.UccMallCurrentPriceQryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallSimilarSkuQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallCurrentPriceQryRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallJdPriceBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallNotJdPriceBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallSameStyleSkuQryBO;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSimilarSkuQryBO;
import com.tydic.commodity.mall.atom.api.UccMallSendHttpAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallGovernRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallSendHttpAtomReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallSendHttpAtomRspBO;
import com.tydic.commodity.mall.comb.api.UccMallSkuManagementListQryCombService;
import com.tydic.commodity.mall.comb.bo.UccMallSkuManagementListCombQryBO;
import com.tydic.commodity.mall.comb.bo.UccMallSkuManagementListQryCombReqBO;
import com.tydic.commodity.mall.comb.bo.UccMallSkuManagementListQryCombRspBO;
import com.tydic.commodity.mall.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccMallCatalogInfoPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.CrcQryCorporationListAbilityService;
import com.tydic.umc.general.ability.bo.CorPorationBO;
import com.tydic.umc.general.ability.bo.CrcQryCorporationListAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryCorporationListAbilityRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallSimilarSkuQryAbilityService"})
public class UccMallSimilarSkuQryAbilityServiceImpl
implements UccMallSimilarSkuQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSimilarSkuQryAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${QRY_GOVERN_SIMILAR_SKU_URL:http://10.200.192.9:8080/improxy/mdm_receive/iio/dataExchange/material/aggregationCommodity/075536}")
    private String qryGovernSimilarSkuUrl;
    @Value(value="${IS_TEST_DEBUG:false}")
    private Boolean isTestDebug;
    private Sequence sequenceUtil = Sequence.getInstance();
    @Autowired
    private UccMallSendHttpAtomService uccMallSendHttpAtomService;
    @Autowired
    private CrcQryCorporationListAbilityService crcQryCorporationListAbilityService;
    @Autowired
    private UccMallSkuManagementListQryCombService uccMallSkuManagementListQryCombService;
    @Autowired
    private UccMallCurrentPriceQryAbilityService uccMallCurrentPriceQryAbilityService;

    @PostMapping(value={"qrySimilarSku"})
    public UccMallSimilarSkuQryAbilityRspBO qrySimilarSku(@RequestBody UccMallSimilarSkuQryAbilityReqBO reqBO) {
        UccMallSimilarSkuQryAbilityRspBO rspBO = new UccMallSimilarSkuQryAbilityRspBO();
        rspBO.setRespCode("0000");
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBO.getSkuId());
        uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPo.setSysTenantId(reqBO.getSysTenantId());
        List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPos)) {
            return rspBO;
        }
        UccMallCatalogInfoPO uccMallCatalogInfoPO = this.uccEMdmCatalogMapper.queryByCommodityTypeId(uccSkuPos.get(0).getCommodityTypeId(), reqBO.getSysTenantId());
        if (uccMallCatalogInfoPO == null) {
            return rspBO;
        }
        JSONObject data = new JSONObject();
        data.put("skuId", (Object)uccSkuPos.get(0).getSkuId().toString());
        if (this.isTestDebug.booleanValue()) {
            data.put("categoryCode", (Object)"010106");
            data.put("skuId", (Object)"20854");
        }
        JSONObject reqData = new JSONObject();
        reqData.put("poolName", (Object)"HR_MDM");
        reqData.put("serialNo", (Object)this.sequenceUtil.nextId());
        reqData.put("data", (Object)data);
        UccMallSendHttpAtomReqBO sendHttpAtomReqBO = new UccMallSendHttpAtomReqBO();
        sendHttpAtomReqBO.setParams(JSONObject.toJSONString((Object)reqData));
        sendHttpAtomReqBO.setUrl(this.qryGovernSimilarSkuUrl);
        sendHttpAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
        log.info("\u4e00\u7269\u4e00\u7801\u540c\u6b3e\u5546\u54c1\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqData));
        UccMallSendHttpAtomRspBO uccSendHttpAtomRspBO = this.uccMallSendHttpAtomService.sendHttpRequst(sendHttpAtomReqBO);
        uccSendHttpAtomRspBO.setRespCode("0000");
        if ("0000".equals(uccSendHttpAtomRspBO.getRespCode())) {
            List<Long> skuList = new ArrayList<Long>();
            if (!StringUtils.isEmpty((Object)uccSendHttpAtomRspBO.getResult())) {
                List skuIdStrList;
                JSONObject reuslt;
                UccMallGovernRspBO governRspBO = (UccMallGovernRspBO)JSONObject.parseObject((String)uccSendHttpAtomRspBO.getResult(), UccMallGovernRspBO.class);
                if (!"0000".equals(governRspBO.getRespCode())) {
                    rspBO.setRespCode(governRspBO.getRespCode());
                    rspBO.setRespDesc(governRspBO.getRspDesc());
                }
                if ((reuslt = JSONObject.parseObject((String)governRspBO.getResult())) != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(skuIdStrList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)reuslt.get((Object)"skuIds")), String.class)))) {
                    for (Object each : skuIdStrList) {
                        if (Long.valueOf((String)each).compareTo(reqBO.getSkuId()) == 0) continue;
                        skuList.add(Long.valueOf((String)each));
                    }
                }
            }
            UccMallSkuManagementListQryCombReqBO uccSkuManagementListQryAbilityReqBO = new UccMallSkuManagementListQryCombReqBO();
            Map<Object, Object> skuMap = new HashMap();
            if (reqBO.getOrgId() != null && !org.apache.commons.collections.CollectionUtils.isEmpty(skuList)) {
                CrcQryCorporationListAbilityReqBO crcQryCorporationListAbilityReqBO = new CrcQryCorporationListAbilityReqBO();
                crcQryCorporationListAbilityReqBO.setLocalOrgId(reqBO.getOrgId());
                log.info("\u76f8\u4f3c\u5546\u54c1\u67e5\u8be2\uff0c\u4f1a\u5458\u67e5\u8be2\u6cd5\u4eba\u5355\u4f4d\u5165\u53c2crcQryCorporationListAbilityReqBO\uff1a" + JSONObject.toJSONString((Object)crcQryCorporationListAbilityReqBO));
                CrcQryCorporationListAbilityRspBO crcQryCorporationListAbilityRspBO = this.crcQryCorporationListAbilityService.qryCorporationList(crcQryCorporationListAbilityReqBO);
                log.info("\u76f8\u4f3c\u5546\u54c1\u67e5\u8be2\uff0c\u4f1a\u5458\u67e5\u8be2\u6cd5\u4eba\u5355\u4f4d\u51fa\u53c2crcQryCorporationListAbilityRspBO\uff1a" + JSONObject.toJSONString((Object)crcQryCorporationListAbilityRspBO));
                List<Long> valueList = crcQryCorporationListAbilityRspBO.getCorPorationBOList().stream().map(CorPorationBO::getCorporationId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(valueList)) {
                    uccSkuManagementListQryAbilityReqBO.setWhitelist(valueList);
                }
                if (!StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
                    reqBO.setOrgPath(reqBO.getOrgPath().replaceAll("^[*#]+|[*#]+$", "-"));
                    List<Long> orgIds = Arrays.asList(reqBO.getOrgPath().split("-")).stream().map(Long::valueOf).collect(Collectors.toList());
                    if (uccSkuManagementListQryAbilityReqBO.getWhitelist() == null) {
                        uccSkuManagementListQryAbilityReqBO.setWhitelist(orgIds);
                    } else {
                        uccSkuManagementListQryAbilityReqBO.getWhitelist().addAll(orgIds);
                    }
                }
                uccSkuManagementListQryAbilityReqBO.setIgnoreshopName(reqBO.getIngorVendor());
                uccSkuManagementListQryAbilityReqBO.setSkuStatus(Arrays.asList(3));
                uccSkuManagementListQryAbilityReqBO.setUserId(reqBO.getUserId());
                uccSkuManagementListQryAbilityReqBO.setExportSkuIds(skuList);
                uccSkuManagementListQryAbilityReqBO.setPageNo(reqBO.getPageNo());
                uccSkuManagementListQryAbilityReqBO.setPageSize(reqBO.getPageSize());
                uccSkuManagementListQryAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
                UccMallSkuManagementListQryCombRspBO combRspBO = this.uccMallSkuManagementListQryCombService.getSkuManagementListQry(uccSkuManagementListQryAbilityReqBO);
                if ("0000".equals(combRspBO.getRespCode()) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)combRspBO.getRows())) {
                    skuList = combRspBO.getRows().stream().map(UccMallSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
                    skuMap = combRspBO.getRows().stream().collect(Collectors.toMap(UccMallSkuManagementListCombQryBO::getSkuId, Function.identity()));
                    rspBO.setPageNo(combRspBO.getPageNo());
                    rspBO.setTotal(combRspBO.getTotal());
                    rspBO.setRecordsTotal(combRspBO.getRecordsTotal());
                } else {
                    rspBO.setRows(new ArrayList(0));
                    rspBO.setPageNo(reqBO.getPageNo());
                    rspBO.setTotal(0);
                    rspBO.setRecordsTotal(0);
                    return rspBO;
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(skuList)) {
                List<UccMallSameStyleSkuQryBO> skuQryBOS = this.uccMallSkuMapper.batchQrySkuBaseInfo(skuList, reqBO.getSysTenantId());
                if (reqBO.getSingle() == 1) {
                    skuQryBOS = new ArrayList(skuQryBOS.stream().collect(Collectors.toMap(UccMallSameStyleSkuQryBO::getSupplierShopId, Function.identity(), (p1, p2) -> p1.getPrice() < p2.getPrice() ? p1 : p2)).values());
                }
                for (Object each : skuQryBOS) {
                    if (!skuMap.containsKey(each.getSkuId())) continue;
                    each.setPriPicUrl(((UccMallSkuManagementListCombQryBO)skuMap.get(each.getSkuId())).getPicUrl());
                    each.setSoldNumber(((UccMallSkuManagementListCombQryBO)skuMap.get(each.getSkuId())).getSoldNumber());
                    each.setOnShelveTimeStr(((UccMallSkuManagementListCombQryBO)skuMap.get(each.getSkuId())).getOnShelveTimeStr());
                }
                List similarStyleSkuQryBOS = JSONObject.parseArray((String)JSONObject.toJSONString(skuQryBOS), UccMallSimilarSkuQryBO.class);
                rspBO.setRows(similarStyleSkuQryBOS);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)similarStyleSkuQryBOS)) {
                    similarStyleSkuQryBOS.stream().forEach(a -> a.setSalePrice(MoneyUtils.haoToYuan(a.getPrice())));
                    Map<Long, List<UccMallSimilarSkuQryBO>> groupBySupperId = similarStyleSkuQryBOS.stream().collect(Collectors.groupingBy(UccMallSimilarSkuQryBO::getSupplierShopId));
                    for (Long shopId : groupBySupperId.keySet()) {
                        UccMallCurrentPriceQryReqBO mallCurrentPriceQryReqBO = new UccMallCurrentPriceQryReqBO();
                        mallCurrentPriceQryReqBO.setSupplierShopId(shopId);
                        mallCurrentPriceQryReqBO.setSkuIds(groupBySupperId.get(shopId).stream().map(UccMallSimilarSkuQryBO::getSkuId).collect(Collectors.toList()));
                        mallCurrentPriceQryReqBO.setOrgId(reqBO.getOrgId());
                        mallCurrentPriceQryReqBO.setCompanyId(reqBO.getCompanyId());
                        mallCurrentPriceQryReqBO.setIsprofess("1");
                        mallCurrentPriceQryReqBO.setSysTenantId(reqBO.getSysTenantId());
                        UccMallCurrentPriceQryRspBO uccMallCurrentPriceQryRspBO = this.uccMallCurrentPriceQryAbilityService.changeCommdCurrentPrice(mallCurrentPriceQryReqBO);
                        if (!"0000".equals(uccMallCurrentPriceQryRspBO.getRespCode())) continue;
                        if (!CollectionUtils.isEmpty((Collection)uccMallCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo())) {
                            Map notJdPrice = uccMallCurrentPriceQryRspBO.getCommdPriceInfo().getNotJdPriceInfo().stream().collect(Collectors.toMap(UccMallNotJdPriceBO_busi::getSkuId, Function.identity()));
                            for (UccMallSimilarSkuQryBO price : groupBySupperId.get(shopId)) {
                                if (!notJdPrice.containsKey(price.getSkuId().toString())) continue;
                                price.setSalePrice(((UccMallNotJdPriceBO_busi)notJdPrice.get(price.getSkuId().toString())).getNewSalePrice());
                                price.setTradeMode(((UccMallNotJdPriceBO_busi)notJdPrice.get(price.getSkuId().toString())).getSettleMode());
                            }
                        }
                        if (CollectionUtils.isEmpty((Collection)uccMallCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos())) continue;
                        Map jdPrice = uccMallCurrentPriceQryRspBO.getCommdPriceInfo().getJdPriceInfos().stream().collect(Collectors.toMap(UccMallJdPriceBO_busi::getSkuId, Function.identity()));
                        for (UccMallSimilarSkuQryBO price : groupBySupperId.get(shopId)) {
                            if (!jdPrice.containsKey(price.getSkuId().toString())) continue;
                            price.setSalePrice(((UccMallJdPriceBO_busi)jdPrice.get(price.getSkuId().toString())).getNewSalePrice());
                            price.setTradeMode(((UccMallJdPriceBO_busi)jdPrice.get(price.getSkuId().toString())).getSettleMode());
                        }
                    }
                }
            }
        }
        return rspBO;
    }
}

