/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallSkuListQryAbilityService;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallEsCommodityBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuListQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuListQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuListQryBO;
import com.tydic.commodity.mall.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.mall.busi.api.UccMallReplacementPriceBusiService;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.constants.CommodityEnum;
import com.tydic.commodity.mall.constants.SkuEnum;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallSkuListQryAbilityService"})
public class UccMallSkuListQryAbilityServiceImpl
implements UccMallSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSkuListQryAbilityServiceImpl.class);
    @Autowired
    private MallEsConfig esConfig;
    @Autowired
    private MallElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccMallReplacementPriceBusiService cnncReplacementPriceBusiService;
    @Value(value="${xc_tenat_list:305775845729763327}")
    private String xcTenatList;

    @PostMapping(value={"getMallSkuListQry"})
    public UccMallSkuListQryAbilityRspBO getMallSkuListQry(@RequestBody UccMallSkuListQryAbilityReqBO reqBO) {
        UccMallSkuListQryAbilityRspBO rspBo = new UccMallSkuListQryAbilityRspBO();
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!(CollectionUtils.isEmpty((Collection)rspBo.getRows()) || reqBO.getMinSalesPrice() == null && reqBO.getMaxSalesPrice() == null || !"1".equals(reqBO.getIsprofess()) || reqBO.getCompanyId() == null && reqBO.getOrgId() == null)) {
            UccMallReplacementPriceReqBo cnncReplacementPriceBusiReqBo = new UccMallReplacementPriceReqBo();
            ReplacePriceInfoBO replacePriceInfoBO = null;
            ArrayList<ReplacePriceInfoBO> replacePriceInfoBOList = new ArrayList<ReplacePriceInfoBO>();
            for (UccMallSkuListQryBO each : rspBo.getRows()) {
                replacePriceInfoBO = new ReplacePriceInfoBO();
                replacePriceInfoBO.setCommodityTypeId(each.getCommodityTypeId());
                replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(each.getAgreementPrice())));
                replacePriceInfoBO.setSkuSource(each.getSkuSource());
                replacePriceInfoBO.setSupplierShopId(each.getSupplierShopId());
                replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(each.getSalePrice())));
                replacePriceInfoBO.setSkuId(each.getSkuId());
                replacePriceInfoBO.setCommodityId(each.getCommodityId());
                replacePriceInfoBO.setAgreementId(each.getAgreementId());
                if (StringUtils.isEmpty((Object)each.getVendorId())) continue;
                replacePriceInfoBO.setVendorId(each.getVendorId());
                replacePriceInfoBOList.add(replacePriceInfoBO);
            }
            cnncReplacementPriceBusiReqBo.setIsprofess(reqBO.getIsprofess());
            cnncReplacementPriceBusiReqBo.setCompanyId(reqBO.getCompanyId() == null || reqBO.getCompanyId() == 0L ? reqBO.getOrgId() : reqBO.getCompanyId());
            cnncReplacementPriceBusiReqBo.setReplacePriceInfo(replacePriceInfoBOList);
            cnncReplacementPriceBusiReqBo.setPsDiscountRate(reqBO.getPsDiscountRate());
            cnncReplacementPriceBusiReqBo.setSysTenantId(reqBO.getSysTenantId());
            cnncReplacementPriceBusiReqBo.setOrgPath(reqBO.getOrgPath());
            UccMallReplacementPriceRspBo cnncReplacementPriceBusiRspBo = this.cnncReplacementPriceBusiService.replacePrice(cnncReplacementPriceBusiReqBo);
            if ("0000".equals(cnncReplacementPriceBusiRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)cnncReplacementPriceBusiRspBo.getRows())) {
                Map<Long, ReplacePriceInfoBO> replacePriceMap = cnncReplacementPriceBusiRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, ReplacePriceInfoBO2 -> ReplacePriceInfoBO2));
                ArrayList<Long> skuIds = new ArrayList<Long>();
                for (UccMallSkuListQryBO each : rspBo.getRows()) {
                    if (!replacePriceMap.containsKey(each.getSkuId())) continue;
                    BigDecimal salePrice = MoneyUtils.haoToYuan(replacePriceMap.get(each.getSkuId()).getSalePrice());
                    if (reqBO.getMinSalesPrice() != null && reqBO.getMaxSalesPrice() == null) {
                        if (salePrice.compareTo(reqBO.getMinSalesPrice()) >= 0) continue;
                        skuIds.add(each.getSkuId());
                        continue;
                    }
                    if (reqBO.getMinSalesPrice() == null && reqBO.getMaxSalesPrice() != null) {
                        if (salePrice.compareTo(reqBO.getMaxSalesPrice()) <= 0) continue;
                        skuIds.add(each.getSkuId());
                        continue;
                    }
                    if (reqBO.getMinSalesPrice() == null || reqBO.getMaxSalesPrice() == null || salePrice.compareTo(reqBO.getMinSalesPrice()) >= 0 && salePrice.compareTo(reqBO.getMaxSalesPrice()) <= 0) continue;
                    skuIds.add(each.getSkuId());
                }
                rspBo.getRows().removeIf(e -> skuIds.contains(e.getSkuId()));
            }
        }
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccMallSkuListQryAbilityReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilderIn;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)reqBo.getKeyword())) {
            boolQueryBuilderIn = QueryBuilders.boolQuery();
            WildcardQueryBuilder wildcardQuery2 = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getKeyword() + "*"));
            boolQueryBuilderIn.should((QueryBuilder)wildcardQuery2);
            WildcardQueryBuilder wildcardQuery1 = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getKeyword() + "*"));
            boolQueryBuilderIn.should((QueryBuilder)wildcardQuery1);
            WildcardQueryBuilder wildcardQuery22 = QueryBuilders.wildcardQuery((String)"origin_brand_name", (String)("*" + reqBo.getKeyword() + "*"));
            boolQueryBuilderIn.should((QueryBuilder)wildcardQuery22);
            WildcardQueryBuilder wildcardQuery3 = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getKeyword() + "*"));
            boolQueryBuilderIn.should((QueryBuilder)wildcardQuery3);
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilderIn);
        }
        if (reqBo.getUserId() == null || reqBo.getUserId() != null && reqBo.getUserId() != 1L) {
            boolQueryBuilderIn = QueryBuilders.boolQuery();
            ExistsQueryBuilder sexQueryBuilder = QueryBuilders.existsQuery((String)"whitelist");
            BoolQueryBuilder boolQueryBuilderIn2 = QueryBuilders.boolQuery();
            boolQueryBuilderIn2.mustNot((QueryBuilder)sexQueryBuilder);
            boolQueryBuilderIn.should((QueryBuilder)boolQueryBuilderIn2);
            if (!CollectionUtils.isEmpty((Collection)reqBo.getWhitelist())) {
                boolQueryBuilderIn.should((QueryBuilder)QueryBuilders.termsQuery((String)"whitelist", (Collection)reqBo.getWhitelist()));
            } else {
                boolQueryBuilderIn.should((QueryBuilder)QueryBuilders.termsQuery((String)"whitelist", new ArrayList()));
            }
            if (reqBo.getUserId() != null && reqBo.getUserId() != 1L) {
                boolQueryBuilderIn.should((QueryBuilder)QueryBuilders.termQuery((String)"personWhite", (Object)reqBo.getUserId()));
            }
            if (reqBo.getOrgId() != null) {
                boolQueryBuilderIn.should((QueryBuilder)QueryBuilders.termQuery((String)"orgWhite", (Object)reqBo.getOrgId()));
            }
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilderIn);
        }
        if (reqBo.getUserId() != null && reqBo.getUserId() != 1L) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"personWhite", (Object)reqBo.getUserId()));
        }
        if (reqBo.getOrgId() != null) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"orgWhite", (Object)reqBo.getOrgId()));
        }
        if (!"1".equals(reqBo.getIsprofess())) {
            if (reqBo.getMinSalesPrice() != null) {
                RangeQueryBuilder discountDifferenceQbStar = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMinSalesPrice()));
                boolQueryBuilder.must((QueryBuilder)discountDifferenceQbStar);
            }
            if (reqBo.getMaxSalesPrice() != null) {
                RangeQueryBuilder discountDifferenceQbEnd = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMaxSalesPrice()));
                boolQueryBuilder.must((QueryBuilder)discountDifferenceQbEnd);
            }
        }
        if (reqBo.getMaterialId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_id", (Object)reqBo.getMaterialId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getLimitOrderList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"limit_order", (Collection)reqBo.getLimitOrderList()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id", (String)reqBo.getExtSkuId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_spu_id", (String)reqBo.getExtSkuId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"other_source_code", (String)reqBo.getOtherSourceCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_code", (String)reqBo.getCommodityCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_code", (String)reqBo.getSkuCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)reqBo.getSkuStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIgnoreAgreenSku())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"agreement_details_id", (Collection)reqBo.getIgnoreAgreenSku()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)reqBo.getSkuList()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)reqBo.getSkuIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIgnoreList())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)reqBo.getIgnoreList()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)(reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)(reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)(reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)(reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)(reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)(reqBo.getMaterialCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)(reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)(reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)(reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)(reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
        }
        if (maerketQb != null) {
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccMallSkuListQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSortWords())) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBo.getSortWords()).order(SortOrder.ASC);
            queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        return queryJson.toString();
    }

    private UccMallSkuListQryAbilityRspBO dealSearchData(String result, UccMallSkuListQryAbilityReqBO reqBo) {
        UccMallSkuListQryAbilityRspBO rspBo = new UccMallSkuListQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccMallEsCommodityBo> commodityModels = new ArrayList<UccMallEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccMallEsCommodityBo commodity = new UccMallEsCommodityBo();
                try {
                    commodity = (UccMallEsCommodityBo)JSON.toJavaObject((JSON)data, UccMallEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize(), reqBo.getSysTenantId());
        return rspBo;
    }

    private UccMallSkuListQryAbilityRspBO copyData(List<UccMallEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize, Long sysTenantId) {
        UccMallSkuListQryAbilityRspBO rspBo = new UccMallSkuListQryAbilityRspBO();
        ArrayList<UccMallSkuListQryBO> uccSkuManagementListQryBOs = new ArrayList<UccMallSkuListQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            if (!CollectionUtils.isEmpty(commodityModels)) {
                Map<String, String> spuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS.toString(), sysTenantId);
                Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(String.valueOf(SkuEnum.SKU_STATUS.toString()), sysTenantId);
                Map<String, String> skuApprovalStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(String.valueOf(SkuEnum.SKU_APPROVAL_STATUS.toString()), sysTenantId);
                Map<String, String> skuSourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap(String.valueOf(SkuEnum.SKU_SOURCE.toString()), sysTenantId);
                for (UccMallEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    UccMallSkuListQryBO uccSkuManagementListQryBO = new UccMallSkuListQryBO();
                    uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
                    uccSkuManagementListQryBO.setCommodityId(Long.valueOf(cnncEsCommodityBo.getCommodity_id()));
                    uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
                    uccSkuManagementListQryBO.setSkuId(Long.valueOf(cnncEsCommodityBo.getSku_id()));
                    uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
                    uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
                    uccSkuManagementListQryBO.setSkuSource(Integer.valueOf(cnncEsCommodityBo.getSku_source()));
                    uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
                    uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    uccSkuManagementListQryBO.setAgreementId(Long.valueOf(cnncEsCommodityBo.getAgreement_id()));
                    uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
                    if (cnncEsCommodityBo.getCommodity_status() != null && spuStatusMap.containsKey(cnncEsCommodityBo.getCommodity_status().toString())) {
                        uccSkuManagementListQryBO.setCommodityStatusDesc(spuStatusMap.get(cnncEsCommodityBo.getCommodity_status().toString()));
                    }
                    if (skuStatusMap.containsKey(String.valueOf(cnncEsCommodityBo.getSku_status()))) {
                        uccSkuManagementListQryBO.setSkuStatusDesc(skuStatusMap.get(String.valueOf(cnncEsCommodityBo.getSku_status())));
                    }
                    if (cnncEsCommodityBo.getSku_approval_status() != null && skuApprovalStatusMap.containsKey(cnncEsCommodityBo.getSku_approval_status().toString())) {
                        uccSkuManagementListQryBO.setApprovalStatusDesc(skuApprovalStatusMap.get(cnncEsCommodityBo.getSku_approval_status().toString()));
                    }
                    if (skuSourceMap.containsKey(String.valueOf(cnncEsCommodityBo.getSku_source()))) {
                        uccSkuManagementListQryBO.setSkuSourceDesc(skuSourceMap.get(String.valueOf(cnncEsCommodityBo.getSku_source())));
                    }
                    uccSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
                    uccSkuManagementListQryBO.setBrandId(Long.valueOf(cnncEsCommodityBo.getBrand_id()));
                    uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getBrand_name());
                    uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
                    uccSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
                    uccSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
                    uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
                    uccSkuManagementListQryBO.setSkuStatus(Integer.valueOf(cnncEsCommodityBo.getSku_status()));
                    uccSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
                    uccSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
                    uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
                    uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
                    uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
                    uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
                    uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
                    uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
                    if (StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
                    } else {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getCommd_pic_url());
                    }
                    uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
                    uccSkuManagementListQryBO.setTaxCode(cnncEsCommodityBo.getTaxCode());
                    uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
                    uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
                    uccSkuManagementListQryBO.setOtherSourceCode(cnncEsCommodityBo.getOther_source_code());
                    uccSkuManagementListQryBO.setOtherSourceName(cnncEsCommodityBo.getOther_source_code());
                    uccSkuManagementListQryBO.setCommodityExpand1(cnncEsCommodityBo.getCommodity_expand1());
                    uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
                    uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
                    uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
                    uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
                    uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
                    if (sysTenantId == null || !this.xcTenatList.contains(sysTenantId.toString())) {
                        uccSkuManagementListQryBO.setXcCategor("0");
                        uccSkuManagementListQryBO.setXcSku("0");
                    } else {
                        uccSkuManagementListQryBO.setXcCategor(cnncEsCommodityBo.getSkuExpand8());
                        uccSkuManagementListQryBO.setXcSku(cnncEsCommodityBo.getSkuExpand9());
                    }
                    if (cnncEsCommodityBo.getComment_number() != null) {
                        uccSkuManagementListQryBO.setTotalNum(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
                    } else {
                        uccSkuManagementListQryBO.setTotalNum(new BigDecimal("0"));
                    }
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

