/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallTaskUpdateCmsAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallTaskUpdateCmsAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallTaskUpdateCmsAbilityRspBO;
import com.tydic.commodity.mall.atom.api.UccMallSendHttpAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallSendHttpAtomReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallSendHttpAtomRspBO;
import com.tydic.commodity.mall.dao.CmsUpdateConfigMapper;
import com.tydic.commodity.mall.po.CmsUpdateConfigPO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallTaskUpdateCmsAbilityService"})
public class UccMallTaskUpdateCmsAbilityServiceImpl
implements UccMallTaskUpdateCmsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallTaskUpdateCmsAbilityServiceImpl.class);
    @Autowired
    private CmsUpdateConfigMapper cmsUpdateConfigMapper;
    @Value(value="${cms_get_requst_info:http://10.200.199.100/ms-mcms/cms/service/getChildColumnByCode.do}")
    private String cmsGetRequstInfo;
    @Autowired
    private UccMallSendHttpAtomService uccMallSendHttpAtomService;

    @PostMapping(value={"taskUpdateCms"})
    public UccMallTaskUpdateCmsAbilityRspBO taskUpdateCms(@RequestBody UccMallTaskUpdateCmsAbilityReqBO reqBO) {
        UccMallTaskUpdateCmsAbilityRspBO abilityRspBO = new UccMallTaskUpdateCmsAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        CmsUpdateConfigPO cmsUpdateConfigPO = new CmsUpdateConfigPO();
        cmsUpdateConfigPO.setSysTenantId(reqBO.getSysTenantId());
        cmsUpdateConfigPO.setId(reqBO.getId());
        cmsUpdateConfigPO.setStatus(1);
        List<CmsUpdateConfigPO> cmsUpdateConfigPOList = this.cmsUpdateConfigMapper.getList(cmsUpdateConfigPO);
        if (CollectionUtils.isEmpty(cmsUpdateConfigPOList)) {
            log.error("\u79df\u6237\uff1a" + reqBO.getSysTenantId() + "\u672a\u914d\u7f6e\u66f4\u65b0\u5185\u5bb9");
            return abilityRspBO;
        }
        for (CmsUpdateConfigPO config : cmsUpdateConfigPOList) {
            this.excute(config, reqBO);
        }
        return abilityRspBO;
    }

    private void excute(CmsUpdateConfigPO config, UccMallTaskUpdateCmsAbilityReqBO reqBO) {
        UccMallSendHttpAtomReqBO atomReqBO = new UccMallSendHttpAtomReqBO();
        atomReqBO.setSysTenantId(reqBO.getSysTenantId());
        atomReqBO.setUrl(this.cmsGetRequstInfo);
        JSONObject params = new JSONObject();
        params.put("columnGroup", (Object)reqBO.getSysTenantId());
        params.put("columnCode", (Object)config.getColumnCode());
        atomReqBO.setParams(JSONObject.toJSONString((Object)params));
        UccMallSendHttpAtomRspBO atomRspBO = this.uccMallSendHttpAtomService.sendHttpRequst(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            log.error("\u8c03\u7528CMS \u67e5\u8be2\u5f02\u5e38\uff1a" + atomRspBO.getRespDesc() + "|| \u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)atomReqBO));
            return;
        }
        if (StringUtils.isEmpty((Object)atomRspBO.getResult())) {
            return;
        }
        JSONObject reuslt = JSONObject.parseObject((String)atomRspBO.getResult());
        if (!"0".equals(reuslt.getString("code"))) {
            return;
        }
        if (reuslt.getJSONObject("data") == null) {
            return;
        }
        JSONArray array = reuslt.getJSONObject("data").getJSONArray("childColumnList");
        JSONArray respArray = new JSONArray();
        JSONObject respJSON = new JSONObject();
        respJSON.put("columnCode", (Object)config.getColumnCode());
        respJSON.put("columnId", (Object)reuslt.getJSONObject("data").getString("columnId"));
        respJSON.put("childColumnList", (Object)respArray);
        for (Object object : array) {
            JSONArray requestArray;
            JSONObject reqReuslt;
            Map<String, Object> requsetParam = this.buildRequestParams(config, (Map)JSON.parseObject((String)JSON.toJSONString(object), Map.class));
            JSONObject childColum = new JSONObject();
            childColum.put("columnId", JSONObject.parseObject((String)JSON.toJSONString(object)).get((Object)"columnId"));
            childColum.put("columnCode", JSONObject.parseObject((String)JSON.toJSONString(object)).get((Object)"columnCode"));
            JSONArray childArray = new JSONArray();
            childColum.put("articleList", (Object)childArray);
            respArray.add((Object)childColum);
            atomReqBO = new UccMallSendHttpAtomReqBO();
            atomReqBO.setUrl(config.getRequestUrl());
            atomReqBO.setParams(JSONObject.toJSONString(requsetParam));
            UccMallSendHttpAtomRspBO reqatomRspBO = this.uccMallSendHttpAtomService.sendHttpRequst(atomReqBO);
            if (!"0000".equals(reqatomRspBO.getRespCode())) {
                log.error("\u8c03\u7528\u53c2\u6570\u67e5\u8be2\u5f02\u5e38\uff1a" + atomRspBO.getRespDesc() + "|| \u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)atomReqBO));
                continue;
            }
            if (StringUtils.isEmpty((Object)reqatomRspBO.getResult()) || !"0".equals((reqReuslt = JSONObject.parseObject((String)reqatomRspBO.getResult())).getString("code")) || (requestArray = reqReuslt.getJSONObject("data").getJSONArray("result")) == null || requestArray.isEmpty()) continue;
            int i = 1;
            for (Object response : requestArray) {
                childArray.add(this.buildCallbackParams(config, response, i));
                ++i;
            }
        }
        atomReqBO = new UccMallSendHttpAtomReqBO();
        atomReqBO.setSysTenantId(reqBO.getSysTenantId());
        atomReqBO.setUrl(config.getResponseUrl());
        atomReqBO.setParams(JSONObject.toJSONString((Object)respJSON));
        UccMallSendHttpAtomRspBO respAtomRspBO = this.uccMallSendHttpAtomService.sendHttpRequst(atomReqBO);
        if (!"0000".equals(respAtomRspBO.getRespCode())) {
            log.error("\u8c03\u7528CMS \u67e5\u8be2\u66f4\u65b0\uff1a" + atomRspBO.getRespDesc() + "|| \u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)((Object)respAtomRspBO)));
            return;
        }
    }

    private Map<String, Object> buildRequestParams(CmsUpdateConfigPO config, Map<String, Object> inputParams) {
        try {
            Map paramTemplate = (Map)JSONObject.parseObject((String)config.getRequestParamTemplate(), Map.class);
            Map mappingRules = (Map)JSONObject.parseObject((String)config.getRequestMapping(), Map.class);
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : paramTemplate.entrySet()) {
                String strValue;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String && (strValue = (String)value).startsWith("${") && strValue.endsWith("}")) {
                    String fieldName = strValue.substring(2, strValue.length() - 1);
                    String mappedField = mappingRules.getOrDefault(fieldName, fieldName);
                    value = inputParams.get(mappedField);
                }
                result.put(key, value);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6784\u5efa\u8bf7\u6c42\u53c2\u6570\u5931\u8d25", e);
        }
    }

    private Map<String, Object> buildCallbackParams(CmsUpdateConfigPO config, Object responseData, int articleSort) {
        try {
            Map paramTemplate = (Map)JSONObject.parseObject((String)config.getResponseParamTemplate(), Map.class);
            Map mappingRules = (Map)JSONObject.parseObject((String)config.getResponseMapping(), Map.class);
            JSONObject respJson = JSON.parseObject((String)JSON.toJSONString((Object)responseData));
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : paramTemplate.entrySet()) {
                String strValue;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("articleSort".equals(key)) {
                    result.put("articleSort", articleSort);
                    continue;
                }
                if (value instanceof String && (strValue = (String)value).startsWith("${") && strValue.endsWith("}")) {
                    String fieldPath = strValue.substring(2, strValue.length() - 1);
                    String mappedPath = mappingRules.getOrDefault(fieldPath, fieldPath);
                    value = respJson.getObject(mappedPath, Object.class);
                }
                result.put(key, value);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6784\u5efa\u56de\u8c03\u53c2\u6570\u5931\u8d25", e);
        }
    }
}

