/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceCommdDetailsQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdDetailsQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdDetailsQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceESupermarketCommdBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdBookBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdCommdBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdVedioBO;
import com.tydic.commodity.mall.atom.bo.InterfaceNotJdCommdDetailsBO;
import com.tydic.commodity.mall.atom.bo.InterfaceParam_entity;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuExtDetailsBO;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uccCommdDetailsQryService")
public class InterfaceCommdDetailsQryServiceImpl
implements InterfaceCommdDetailsQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceCommdDetailsQryServiceImpl.class);
    @Value(value="${jd_imgPath}")
    private String jd_imgPath;
    @Value(value="${grainger_imgPath}")
    private String grainger_imgPath;
    @Value(value="${qst_imgPath}")
    private String qst_imgPath;
    @Value(value="${suning_imgPath}")
    private String suning_imgPath;
    @Value(value="${zkh_imgPath}")
    private String zkh_imgPath;
    @Value(value="${zkhhk_imgPath}")
    private String zkhhk_imgPath;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @Override
    public InterfaceCommdDetailsQryRspBO qryCommdDetails(InterfaceCommdDetailsQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_DETAIL_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_DETAIL_URL") + "]");
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            InterfaceCommdDetailsQryRspBO resolveRsp = this.resolveRsp(returnString, reqBO);
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            }
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            InterfaceCommdDetailsQryRspBO rspBO = new InterfaceCommdDetailsQryRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            rspBO.setResultMessage(e.getMessage());
            List<Object> failSkuIdList = new ArrayList();
            failSkuIdList = !"jd".equals(reqBO.getSupplierCode()) ? reqBO.getSkuIds() : Arrays.asList(reqBO.getSkuId());
            rspBO.setFailSkuIdList(failSkuIdList);
            return rspBO;
        }
    }

    private String initReqStr(InterfaceCommdDetailsQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        if (!"jd".equals(reqBO.getSupplierCode())) {
            if (!CollectionUtils.isEmpty(reqBO.getSkuIds())) {
                jsonObject.put("sku", reqBO.getSkuIds());
            } else {
                jsonObject.put("spu", (Object)reqBO.getSpuId());
            }
            jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
            jsonObject.put("isShow", (Object)false);
        } else {
            JSONArray sku = new JSONArray();
            sku.add((Object)reqBO.getSkuId());
            jsonObject.put("sku", (Object)sku);
            jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
            jsonObject.put("queryExts", (Object)"appintroduce,shouhou,isFactoryShip,isEnergySaving,contractSkuExt,ChinaCatalog,LowestBuy,isJDLogistics,isSelf,taxInfo,taxCode");
        }
        return jsonObject.toString();
    }

    private InterfaceCommdDetailsQryRspBO resolveRsp(String returnString, InterfaceCommdDetailsQryReqBO reqBO) {
        InterfaceCommdDetailsQryRspBO rspBO = new InterfaceCommdDetailsQryRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setResultMessage("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u5546\u54c1\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            InterfaceESupermarketCommdBO eSupermarketCommdBO = new InterfaceESupermarketCommdBO();
            if ("jd".equals(reqBO.getSupplierCode())) {
                JSONObject result = (JSONObject)rspJsonObject.get((Object)"result");
                JSONArray failList = rspJsonObject.getJSONArray("fail");
                if (result != null) {
                    String img;
                    String skuType = (String)result.get((Object)"skuType");
                    String str = JSONObject.toJSONString((Object)result);
                    if (null == skuType) {
                        InterfaceJdCommdBO jdCommdBO = (InterfaceJdCommdBO)JSONObject.parseObject((String)str, InterfaceJdCommdBO.class);
                        JSONArray category = result.getJSONArray("category");
                        ArrayList<String> categorys = new ArrayList<String>();
                        if (category != null && category.size() > 0) {
                            for (int i = 0; i < category.size(); ++i) {
                                categorys.add((String)category.get(i));
                            }
                        }
                        jdCommdBO.setCategory(categorys);
                        String imgPath = (String)result.get((Object)"imagePath");
                        imgPath = this.jd_imgPath + imgPath;
                        jdCommdBO.setImagePath(imgPath);
                        if (result.get((Object)"LowestBuy") != null) {
                            jdCommdBO.setMoq(String.valueOf(result.get((Object)"LowestBuy")));
                        }
                        eSupermarketCommdBO.setJdCommdInfo(jdCommdBO);
                    } else if ("book".equals(skuType)) {
                        InterfaceJdBookBO jdBookBO = (InterfaceJdBookBO)JSONObject.parseObject((String)str, InterfaceJdBookBO.class);
                        img = jdBookBO.getImage();
                        img = this.jd_imgPath + img;
                        jdBookBO.setImage(img);
                        if (result.get((Object)"LowestBuy") != null) {
                            jdBookBO.setMoq(String.valueOf(result.get((Object)"LowestBuy")));
                        }
                        eSupermarketCommdBO.setJdBookInfo(jdBookBO);
                    } else if ("vedio".equals(skuType)) {
                        InterfaceJdVedioBO jdVedioBO = (InterfaceJdVedioBO)JSONObject.parseObject((String)str, InterfaceJdVedioBO.class);
                        img = jdVedioBO.getImage();
                        img = img + this.jd_imgPath;
                        jdVedioBO.setImage(img);
                        if (result.get((Object)"LowestBuy") != null) {
                            jdVedioBO.setMoq(String.valueOf(result.get((Object)"LowestBuy")));
                        }
                        eSupermarketCommdBO.setJdVedioInfo(jdVedioBO);
                    }
                }
                ArrayList<String> failSkuIdList = new ArrayList<String>();
                if (null != failList && !failList.isEmpty()) {
                    for (int i = 0; i < failList.size(); ++i) {
                        JSONObject obj = (JSONObject)failList.get(i);
                        failSkuIdList.add(JSONObject.toJSONString((Object)obj));
                    }
                }
                rspBO.setFailSkuIdList(failSkuIdList);
            } else {
                String result = JSONObject.toJSONString((Object)rspJsonObject.get((Object)"result"));
                JSONArray failList = rspJsonObject.getJSONArray("fail");
                InterfaceNotJdCommdDetailsBO notJdCommdDetailsBO = (InterfaceNotJdCommdDetailsBO)JSONObject.parseObject((String)result, InterfaceNotJdCommdDetailsBO.class);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String category = JSONObject.toJSONString((Object)jsonObject.get((Object)"category"));
                List categoryList = JSONObject.parseArray((String)category, String.class);
                notJdCommdDetailsBO.setCategory(categoryList);
                String spuParam = JSONObject.toJSONString((Object)jsonObject.get((Object)"param"));
                List param_entities = JSONObject.parseArray((String)spuParam, InterfaceParam_entity.class);
                notJdCommdDetailsBO.setParam(param_entities);
                String prefix = "";
                if ("qst".equals(reqBO.getSupplierCode())) {
                    prefix = this.qst_imgPath;
                } else if ("suning".equals(reqBO.getSupplierCode())) {
                    prefix = this.suning_imgPath;
                } else if ("grainger".equals(reqBO.getSupplierCode())) {
                    prefix = this.grainger_imgPath;
                } else if ("zkh".equals(reqBO.getSupplierCode())) {
                    prefix = this.zkh_imgPath;
                } else if ("zkhhk".equals(reqBO.getSupplierCode())) {
                    prefix = this.zkhhk_imgPath;
                }
                notJdCommdDetailsBO.setImagePath(prefix + notJdCommdDetailsBO.getImagePath());
                if (!CollectionUtils.isEmpty(notJdCommdDetailsBO.getSkuGroup())) {
                    for (InterfaceSkuExtDetailsBO each : notJdCommdDetailsBO.getSkuGroup()) {
                        each.setImagePath(prefix + each.getImagePath());
                    }
                }
                eSupermarketCommdBO.setNotJdCommdDetails(notJdCommdDetailsBO);
                try {
                    notJdCommdDetailsBO.setDeliveryTime(notJdCommdDetailsBO.getSkuGroup().get(0).getDeliveryTime());
                }
                catch (Exception e) {
                    log.error("\u9884\u8ba1\u53d1\u8d27\u65e5\u53d6\u503c\u62a5\u9519---------------------");
                    e.printStackTrace();
                }
                ArrayList<String> failSkuIdList = new ArrayList<String>();
                if (null != failList && !failList.isEmpty()) {
                    for (int i = 0; i < failList.size(); ++i) {
                        JSONObject obj = (JSONObject)failList.get(i);
                        failSkuIdList.add(JSONObject.toJSONString((Object)obj));
                    }
                }
                rspBO.setFailSkuIdList(failSkuIdList);
            }
            rspBO.setResult(eSupermarketCommdBO);
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

