/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.InterfaceDeliveryTimeQryService;
import com.tydic.commodity.mall.atom.bo.InterfaceDeliveryTimeQueryReqBo;
import com.tydic.commodity.mall.atom.bo.InterfaceDeliveryTimeQueryRspBo;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InterfaceDeliveryTimeQueryServiceImpl
implements InterfaceDeliveryTimeQryService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceDeliveryTimeQueryServiceImpl.class);

    @Override
    public InterfaceDeliveryTimeQueryRspBo getPromiseTips(InterfaceDeliveryTimeQueryReqBo reqBo) {
        HttpRetBean httpRetBean;
        String reqEsbStr;
        InterfaceDeliveryTimeQueryRspBo rspBo = new InterfaceDeliveryTimeQueryRspBo();
        String reqJson = this.initReqStr(reqBo);
        try {
            reqEsbStr = ESBParamUtil.getEsbReqStr(reqJson, reqBo.getSupplierCode(), "BUSINESS_COMMODITY");
            log.info("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5165\u53c2\uff1a" + reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(reqBo.getUrl()), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setResultCode("8888");
            rspBo.setFailSkuIdList(Arrays.asList(reqBo.getSkuId()));
            rspBo.setResultMessage("\u67e5\u8be2\u5931\u8d25");
            return rspBo;
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25\uff1a" + reqEsbStr);
            rspBo.setResultCode("8888");
            rspBo.setFailSkuIdList(Arrays.asList(reqBo.getSkuId()));
            rspBo.setResultMessage("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25");
            return rspBo;
        }
        log.info("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((CharSequence)returnString)) {
            rspBo.setResultCode("8888");
            rspBo.setResultMessage("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            rspBo.setFailSkuIdList(Arrays.asList(reqBo.getSkuId()));
            return rspBo;
        }
        rspBo = this.resolveRsp(returnString);
        if (!rspBo.isSuccess()) {
            rspBo.setResultCode("8888");
            rspBo.setResultMessage(rspBo.getResultMessage());
            rspBo.setFailSkuIdList(Arrays.asList(reqBo.getSkuId()));
            return rspBo;
        }
        return rspBo;
    }

    private String initReqStr(InterfaceDeliveryTimeQueryReqBo reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuId", (Object)reqBO.getSkuId());
        jsonObject.put("num", (Object)reqBO.getNum());
        jsonObject.put("province", (Object)reqBO.getProvince());
        jsonObject.put("city", (Object)reqBO.getCity());
        jsonObject.put("county", (Object)reqBO.getCounty());
        jsonObject.put("town", (Object)reqBO.getTown());
        jsonObject.put("provinceName", (Object)reqBO.getProvinceName());
        jsonObject.put("cityName", (Object)reqBO.getCityName());
        jsonObject.put("countyName", (Object)reqBO.getCountyName());
        jsonObject.put("townName", (Object)reqBO.getTownName());
        return jsonObject.toString();
    }

    private InterfaceDeliveryTimeQueryRspBo resolveRsp(String returnString) {
        InterfaceDeliveryTimeQueryRspBo rspBo = new InterfaceDeliveryTimeQueryRspBo();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            if (rspJsonObject.get((Object)"success") instanceof String) {
                rspBo.setSuccess("true".equals(rspJsonObject.get((Object)"success")));
            } else {
                rspBo.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            }
            rspBo.setResultCode(String.valueOf(rspJsonObject.get((Object)"resultCode")));
            rspBo.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            rspBo.setResult((String)rspJsonObject.get((Object)"result"));
            JSONArray failList = rspJsonObject.getJSONArray("fail");
            ArrayList<String> failReturnList = new ArrayList<String>();
            if (null != failList && !failList.isEmpty()) {
                for (int i = 0; i < failList.size(); ++i) {
                    JSONObject obj = (JSONObject)failList.get(i);
                    failReturnList.add(JSONObject.toJSONString((Object)obj));
                }
            }
            rspBo.setFailSkuIdList(failReturnList);
            return rspBo;
        }
        catch (Exception var10) {
            log.error("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

