/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.atom.api.UccMallCurrentMoqQryAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentMoqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentMoqQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentMoqQryRspBO;
import com.tydic.commodity.mall.utils.ESBParamUtil;
import com.tydic.commodity.mall.utils.HSHttpHelper;
import com.tydic.commodity.mall.utils.HSNHttpHeader;
import com.tydic.commodity.mall.utils.HttpRetBean;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="UccMallCurrentMoqQryAtomService")
public class UccMallCurrentMoqQryAtomServiceImpl
implements UccMallCurrentMoqQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccMallCurrentMoqQryAtomServiceImpl.class);

    @Override
    public InterfaceCurrentMoqQryRspBO qryCurrentMoq(InterfaceCurrentMoqQryReqBO reqBO) {
        InterfaceCurrentMoqQryRspBO rspBO = new InterfaceCurrentMoqQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_MOQ_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_STOCK_URL") + "]");
                rspBO.setResultCode("8888");
                rspBO.setResultMessage("\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\uff1a" + httpRetBean.getStatus());
                rspBO.setFailSkuIdList(reqBO.getSkuIds());
                rspBO.setFailMark(1);
                rspBO.setFailError("\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\uff1a" + httpRetBean.getStatus());
                return rspBO;
            }
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (!StringUtils.isEmpty((Object)returnString)) {
                InterfaceCurrentMoqQryRspBO resolveRsp = this.resolveRsp(returnString, reqBO.getSkuIds());
                if (resolveRsp != null) {
                    log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
                }
                return resolveRsp;
            }
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            rspBO.setResultCode("8888");
            rspBO.setResultMessage("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            rspBO.setFailSkuIdList(reqBO.getSkuIds());
            rspBO.setFailMark(1);
            rspBO.setFailError("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        catch (IOException e) {
            log.info(e.getMessage());
            rspBO.setResultCode("8888");
            rspBO.setResultMessage("\u6700\u5c0f\u8d77\u8ba2\u91cf\u67e5\u8be2\u5931\u8d25");
            rspBO.setFailMark(1);
            rspBO.setFailError("\u6700\u5c0f\u8d77\u8ba2\u91cf\u67e5\u8be2\u5931\u8d25");
            rspBO.setFailSkuIdList(reqBO.getSkuIds());
        }
        catch (URISyntaxException e) {
            log.info(e.getMessage());
            rspBO.setResultCode("8888");
            rspBO.setResultMessage("\u6700\u5c0f\u8d77\u8ba2\u91cf\u67e5\u8be2\u5931\u8d25");
            rspBO.setFailMark(1);
            rspBO.setFailError("\u6700\u5c0f\u8d77\u8ba2\u91cf\u67e5\u8be2\u5931\u8d25");
            rspBO.setFailSkuIdList(reqBO.getSkuIds());
        }
        return rspBO;
    }

    private InterfaceCurrentMoqQryRspBO resolveRsp(String returnString, List<String> skus) {
        InterfaceCurrentMoqQryRspBO rspBO = new InterfaceCurrentMoqQryRspBO();
        ArrayList<InterfaceCurrentMoqBO> list = new ArrayList<InterfaceCurrentMoqBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode(rspJsonObject.get((Object)"resultCode").toString());
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    log.error("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u6700\u5c0f\u8d77\u8ba2\u91cf\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef:" + rspBO.getResultMessage());
                }
                rspBO.setFailSkuIdList(skus);
                rspBO.setResultCode("8888");
                rspBO.setFailMark(1);
                rspBO.setFailError(rspBO.getResultMessage());
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            JSONArray failList = rspJsonObject.getJSONArray("fail");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    InterfaceCurrentMoqBO jsonStringToJavaBean = (InterfaceCurrentMoqBO)JSON.parseObject((String)jsonStr, InterfaceCurrentMoqBO.class);
                    list.add(jsonStringToJavaBean);
                }
                rspBO.setResult(list);
            }
            ArrayList<String> failReturnList = new ArrayList<String>();
            if (null != failList && !failList.isEmpty()) {
                for (int i = 0; i < failList.size(); ++i) {
                    JSONObject obj = (JSONObject)failList.get(i);
                    failReturnList.add(JSONObject.toJSONString((Object)obj));
                }
            }
            rspBO.setFailSkuIdList(failReturnList);
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }

    private String initReqStr(InterfaceCurrentMoqQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sku", reqBO.getSkuIds());
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }
}

